/*
 * Decompiled with CFR 0.152.
 */
package utils;

import java.awt.Desktop;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.model.DataModel;
import javax.faces.model.ListDataModel;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;

public class ToExcel {
    private DataModel dataModelCabecera;
    private DataModel dataModelContenido;

    public DataModel getDataModelCabecera() {
        return this.dataModelCabecera;
    }

    public void setDataModelCabecera(DataModel dataModelCabecera) {
        this.dataModelCabecera = dataModelCabecera;
    }

    public DataModel getDataModelContenido() {
        return this.dataModelContenido;
    }

    public void setDataModelContenido(DataModel dataModelContenido) {
        this.dataModelContenido = dataModelContenido;
    }

    public void exportarExcel(List columns, List rows, String reportName) {
        this.setDataModelCabecera((DataModel)new ListDataModel(columns));
        this.setDataModelContenido((DataModel)new ListDataModel(rows));
        HSSFWorkbook hssfWorkbook = ToExcel.obtenerExcel(this.dataModelContenido, this.dataModelCabecera, "hola1");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(reportName + ".xls");
            hssfWorkbook.write((OutputStream)fileOutputStream);
            fileOutputStream.close();
            File file = new File(reportName + ".xls");
            Desktop.getDesktop().open(file);
        }
        catch (IOException e) {
            Logger.getLogger(ToExcel.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public static HSSFWorkbook obtenerExcel(DataModel contenidoCeldas, DataModel cabecerasCeldas, String nombreHoja) {
        HSSFWorkbook hssfWorkbook = new HSSFWorkbook();
        HSSFSheet hssfSheet = hssfWorkbook.createSheet(nombreHoja);
        int numeroFila = 0;
        int numeroColumna = 0;
        HSSFRow hssfRow = hssfSheet.createRow(numeroFila++);
        HSSFCellStyle hssfCellStyleCabecera = hssfWorkbook.createCellStyle();
        hssfCellStyleCabecera.setFillPattern((short)0);
        hssfCellStyleCabecera.setFillBackgroundColor(new HSSFColor.BLUE_GREY().getIndex());
        HSSFFont hssfFont = hssfWorkbook.createFont();
        hssfFont.setBoldweight((short)700);
        hssfFont.setColor(hssfFont.getColor());
        hssfCellStyleCabecera.setFont(hssfFont);
        HSSFCell hssfCell = null;
        List cabecerasExcel = (List)cabecerasCeldas.getWrappedData();
        for (int i = 0; i < cabecerasExcel.size(); ++i) {
            String columnaCabecera = (String)cabecerasExcel.get(i);
            hssfCell = hssfRow.createCell((short)numeroColumna++);
            hssfCell.setCellValue(columnaCabecera);
            hssfCell.setCellStyle(hssfCellStyleCabecera);
        }
        List contenidoExcel = (List)contenidoCeldas.getWrappedData();
        List fila = null;
        for (int i = 0; i < contenidoExcel.size(); ++i) {
            fila = (List)contenidoExcel.get(i);
            hssfRow = hssfSheet.createRow(numeroFila++);
            numeroColumna = 0;
            for (int x = 0; x < fila.size(); ++x) {
                Object valor = fila.get(x);
                hssfCell = hssfRow.createCell((short)numeroColumna++);
                hssfCell.setCellValue((String)valor);
            }
        }
        return hssfWorkbook;
    }
}

