/*
 * Decompiled with CFR 0.152.
 */
package modelo.version;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import modelo.version.VersionMD;
import utils.CONS;

public class DitoolBD {
    private Connection ct;

    public DitoolBD(String user, String pass) {
        try {
            Class.forName("org.postgresql.Driver");
            this.ct = DriverManager.getConnection(CONS.BD_URL, user, pass);
        }
        catch (ClassNotFoundException e) {
            System.out.println("No pudimos conectarnos DB. " + e.getMessage());
        }
        catch (SQLException ex) {
            System.out.println("No nos pudimos conectar. " + ex.getMessage());
        }
    }

    public PreparedStatement getPs(String nsql) {
        try {
            if (this.ct != null) {
                PreparedStatement ps = this.ct.prepareStatement(nsql);
                return ps;
            }
            return null;
        }
        catch (SQLException e) {
            System.out.println("No se pudo preparar el statement. " + e.getMessage());
            return null;
        }
    }

    public ResultSet sql(PreparedStatement ps) {
        try {
            ResultSet rs = ps.executeQuery();
            return rs;
        }
        catch (SQLException e) {
            System.out.println("No se pudo ejecutar el sql: " + e.getMessage());
            return null;
        }
    }

    public void cerrar(PreparedStatement ps) {
        try {
            if (ps != null) {
                ps.getConnection().close();
            }
        }
        catch (SQLException e) {
            System.out.println("No pudimos cerrar la conexion pls try again. " + e.getMessage());
        }
    }

    public VersionMD consultarUltimaVersion() {
        ResultSet rs;
        VersionMD v = null;
        String sql = "SELECT \nid_version, \nusu_username, \nversion,\nnombre, \nurl, \nnotas, \nfecha\nFROM public.\"Versiones\"\nWHERE version_activa = true\nORDER BY id_version DESC limit 1;";
        PreparedStatement ps = this.getPs(sql);
        if (ps != null && (rs = this.sql(ps)) != null) {
            try {
                v = new VersionMD();
                while (rs.next()) {
                    v.setId(rs.getInt(1));
                    v.setUsername(rs.getString(2));
                    v.setVersion(rs.getString(3));
                    v.setNombre(rs.getString(4));
                    v.setUrl(rs.getString(5));
                    v.setNotas(rs.getString(6));
                    v.setFecha(rs.getTimestamp(7).toLocalDateTime());
                }
            }
            catch (SQLException e) {
                System.out.println("No se pudo consultar la version: " + e.getMessage());
            }
        }
        this.cerrar(ps);
        return v;
    }
}

