/*
 * Decompiled with CFR 0.152.
 */
package modelo.validaciones;

public class Validar {
    public static boolean esLetras(String cadena) {
        return cadena.matches("[A-Za-z\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00d1\u00f1kK\\s\\/]+");
    }

    public static boolean esLetras2(String cadena) {
        return cadena.matches("[A-Za-z\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00d1\u00f1kK\\,\\s\\/]+");
    }

    public static boolean esLetras3(String cadena) {
        return cadena.matches("[A-Za-z\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00d1\u00f1kK\\.\\s\\/]+");
    }

    public static boolean esObservacion(String cadena) {
        return cadena.matches("[0-9A-Za-z\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\\.,\u00d3\u00da\u00d1\u00f1\\-\\s]+");
    }

    public static boolean esDireccion(String cadena) {
        return cadena.matches("[0-9A-Za-z\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\\.\u00d3\u00da\u00d1\u00f1/\\-\\s]+");
    }

    public static boolean esLetrasYNumeros(String cadena) {
        return cadena.matches("[0-9A-Za-z\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00d1\u00f1kK\\s]+||\\s");
    }

    public static boolean esLetrasYNumeros2(String cadena) {
        return cadena.matches("[0-9A-Za-z\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00d1\u00f1kK\\_0-9A-Za-z\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00d1\u00f1kK\\-0-9A-Za-z\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00d1\u00f1kK\\s]+");
    }

    public static boolean esNumeros(String cadena) {
        return cadena.matches("[0-9]+");
    }

    public static boolean esNumerosDecimales(String cadena) {
        return cadena.matches("[0-9\\.0-9]+");
    }

    public static boolean esTelefono(String cadena) {
        return cadena.matches("[0-9]{7,13}");
    }

    public static boolean esCelular(String cadena) {
        return cadena.matches("[0-9]{10,13}");
    }

    public static boolean esAnio(String cadena) {
        return cadena.matches("[0-9]{4}");
    }

    public static boolean esMes(String cadena) {
        if (cadena.matches("[0-9]{1,2}")) {
            int mes = Integer.parseInt(cadena);
            return mes > 0 && mes <= 12;
        }
        return false;
    }

    public static boolean esDia(String cadena) {
        if (cadena.matches("[0-9]{1,2}")) {
            int dia = Integer.parseInt(cadena);
            return dia > 0 && dia <= 31;
        }
        return false;
    }

    public static boolean esnoCedula(String cadena) {
        if (cadena.matches("[0-9]{10}")) {
            String codProv = cadena.substring(0, 2);
            if (Integer.parseInt(codProv) > 0 && Integer.parseInt(codProv) <= 30) {
                int sumPares = 0;
                int sumImpares = 0;
                char[] cedula = cadena.toCharArray();
                for (int i = 0; i < cedula.length - 1; ++i) {
                    if ((i + 1) % 2 == 0) {
                        sumPares += Integer.parseInt(cedula[i] + "");
                        continue;
                    }
                    int impar = Integer.parseInt(cedula[i] + "") * 2;
                    if (impar > 9) {
                        impar -= 9;
                    }
                    sumImpares += impar;
                }
                int total = sumPares + sumImpares;
                int decena = (Integer.parseInt((total + "").substring(0, 1)) + 1) * 10;
                int validador = decena - total;
                if (validador > 10) {
                    // empty if block
                }
                if (validador == 10) {
                    validador = 0;
                }
                return Integer.parseInt(cedula[9] + "") == validador;
            }
            return false;
        }
        return false;
    }

    public static boolean esCedula(String cedula) {
        boolean cedulaCorrecta = false;
        if (cedula.matches("[0-9]{10}")) {
            String codProv = cedula.substring(0, 2);
            if (Integer.parseInt(codProv) > 0 && Integer.parseInt(codProv) <= 30) {
                try {
                    if (cedula.length() == 10) {
                        int tercerDigito = Integer.parseInt(cedula.substring(2, 3));
                        if (tercerDigito < 6) {
                            int[] coefValCedula = new int[]{2, 1, 2, 1, 2, 1, 2, 1, 2};
                            int verificador = Integer.parseInt(cedula.substring(9, 10));
                            int suma = 0;
                            int digito = 0;
                            for (int i = 0; i < cedula.length() - 1; ++i) {
                                digito = Integer.parseInt(cedula.substring(i, i + 1)) * coefValCedula[i];
                                suma += digito % 10 + digito / 10;
                            }
                            cedulaCorrecta = suma % 10 == 0 && suma % 10 == verificador ? true : 10 - suma % 10 == verificador;
                        } else {
                            cedulaCorrecta = false;
                        }
                    } else {
                        cedulaCorrecta = false;
                    }
                }
                catch (NumberFormatException nfe) {
                    cedulaCorrecta = false;
                }
                catch (Exception err) {
                    System.out.println("Una excepcion ocurrio en el proceso de validadcion");
                    cedulaCorrecta = false;
                }
                if (!cedulaCorrecta) {
                    System.out.println("La C\u00e9dula ingresada es Incorrecta");
                }
                return cedulaCorrecta;
            }
            return false;
        }
        return false;
    }

    public static boolean esCorreo(String entrada) {
        return entrada.matches("[A-Za-z0-9\\.{1}\\_{1}\\-{1}]+@{1}[a-zA-Z]+\\.{1}+[a-zA-Z]+$");
    }

    public static boolean esCorreoAr(String entrada) {
        return entrada.matches("[A-Za-z0-9\\.{1}\\_{1}\\-{1}]+@{1}[a-zA-Z]+\\.{1}+[a-zA-Z]+\\.{1}+[a-zA-Z]+$");
    }

    public static boolean esNota(String entrada) {
        return entrada.matches("[0-9]{1,2}+\\.+[0-9]{1,2}") || entrada.matches("[0-9]{1,3}");
    }

    public static boolean esNumCasa(String entrada) {
        return entrada.matches("[0-9]{1,4}+-+[0-9]{1,4}");
    }

    public static boolean esNumeCasaLetras(String entrada) {
        return entrada.matches("[A-Za-z]{1}+/+[A-Za-z]{1}");
    }

    public static boolean esNumeCasaSoloNumeros(String entrada) {
        return entrada.matches("[0-9]{1,4}+");
    }

    public static boolean esCarnetConadis(String entrada) {
        return entrada.matches("[0-9]{1,2}+\\.+[0-9]{1,6}");
    }

    public static boolean esHora(String entrada) {
        return entrada.matches("[0-9]{1,2}+:+[0-9]{1,2}");
    }

    public static boolean esUrlZip(String entrada) {
        return entrada.matches("https://+[-a-zA-Z0-9+&@#/%?=~_|!:,.;]+[a-zA-Z0-9]+\\.zip+") || entrada.matches("https://+[-a-zA-Z0-9+&@#/%?=~_|!:,.;]+\\.zip+") || entrada.matches("http://+[-a-zA-Z0-9+&@#/%?=~_|!:,.;]+\\.zip+");
    }

    public static boolean esLetrasSimple(String entrada) {
        return entrada.matches("[a-zA-Z0-9\\.\\-\\_]+");
    }

    public static boolean esVersion(String entrada) {
        return entrada.matches("[0-9]{1,3}+\\.+[0-9]{1,2}") || entrada.matches("[0-9]{1}+\\.+[0-9]{1,2}+\\.+[0-9]{1,2}");
    }

    public static boolean esDescripcion(String entrada) {
        return entrada.matches("[A-Za-z\u00e1\u00e9\u00ed\u00f3\u00fa\u00c1\u00c9\u00cd\u00d3\u00da\u00d1\u00f1kK\\,\\s\\/\\:\\.\\-0-9]+");
    }
}

