/*
 * Decompiled with CFR 0.152.
 */
package modelo.validaciones;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;
import modelo.validaciones.Validar;

public class TxtVCedula
extends KeyAdapter {
    private final JTextField txt;
    private final JLabel lbl;
    private String ingreso;
    private boolean validarCedula = true;

    public TxtVCedula(JTextField txt) {
        this.txt = txt;
        this.lbl = null;
    }

    public TxtVCedula(JTextField txt, JLabel lbl) {
        this.txt = txt;
        this.lbl = lbl;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.validarCedula) {
            this.ingreso = this.txt.getText().trim();
            if (e.getKeyCode() != 10 && e.getKeyCode() != 127 && this.ingreso.length() > 0) {
                this.txt.setSize(this.txt.getWidth(), 20);
                this.txt.setPreferredSize(new Dimension(this.txt.getWidth(), 20));
                if (!Validar.esCedula(this.ingreso)) {
                    this.txt.setBorder(BorderFactory.createLineBorder(new Color(204, 0, 0)));
                    if (this.lbl != null) {
                        this.lbl.setVisible(true);
                    }
                } else {
                    this.txt.setBorder(BorderFactory.createLineBorder(new Color(153, 153, 153)));
                    if (this.lbl != null) {
                        this.lbl.setVisible(false);
                    }
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        if (this.validarCedula) {
            char car = e.getKeyChar();
            if (car < '0' || car > '9') {
                e.consume();
            }
            if (this.ingreso != null && this.ingreso.length() >= 10) {
                e.consume();
            }
        }
    }

    public void desactivarValidacion() {
        this.validarCedula = false;
    }

    public void activarValidacion() {
        this.validarCedula = true;
    }

    public boolean isValidarCedula() {
        return this.validarCedula;
    }
}

