/*
 * Decompiled with CFR 0.152.
 */
package modelo.usuario;

import controlador.Libraries.ImgLib;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import modelo.ConnDBPool;
import modelo.persona.PersonaMD;
import modelo.silabo.NEWSilaboBD;
import modelo.usuario.UsuarioMD;

public final class UsuarioBD
extends UsuarioMD {
    private static UsuarioBD INSTANCE = null;
    private final ConnDBPool pool = new ConnDBPool();
    private Connection conn;
    private ResultSet rs;

    public static UsuarioBD single() {
        if (INSTANCE == null) {
            INSTANCE = new UsuarioBD();
        }
        return INSTANCE;
    }

    public UsuarioBD() {
    }

    public UsuarioBD(UsuarioMD obj) {
        this.setUsername(obj.getUsername());
        this.setPassword(obj.getPassword());
        this.setEstado(obj.isEstado());
        this.setPersona(obj.getPersona());
        this.setIsSuperUser(obj.isIsSuperUser());
    }

    public Map<String, Object> insertar(UsuarioMD usuario) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        String INSERT = "INSERT INTO \"Usuarios\" \n (usu_username, usu_password, id_persona, usu_is_superuser)\n VALUES (?, set_byte( MD5( ? ) :: bytea, 4, 64 ), ?, ? );\n";
        parametros.put(1, usuario.getUsername());
        parametros.put(2, usuario.getPassword());
        parametros.put(3, usuario.getPersona().getIdPersona());
        parametros.put(4, usuario.isIsSuperUser());
        SQLException error = this.pool.ejecutar(INSERT, parametros);
        context.put("value", error == null);
        context.put("error", error);
        return context;
    }

    public List<UsuarioMD> selectAll() {
        String SELECT = "SELECT\n    \"Usuarios\".usu_username,\n    \"Usuarios\".usu_password,\n    \"Usuarios\".usu_estado,\n    \"Usuarios\".id_persona,\n    \"Usuarios\".usu_is_superuser,\n    \"Personas\".persona_identificacion,\n    \"Personas\".persona_primer_apellido,\n    \"Personas\".persona_segundo_apellido,\n    \"Personas\".persona_primer_nombre,\n    \"Personas\".persona_segundo_nombre\n   FROM (\"Usuarios\"\n     JOIN \"Personas\" ON ((\"Usuarios\".id_persona = \"Personas\".id_persona)))\nWHERE\n\"Usuarios\".usu_estado IS TRUE \nORDER BY usu_username";
        return this.selectSimple(SELECT, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UsuarioMD> selectSimple(String QUERY, Map<Integer, Object> parametros) {
        ArrayList<UsuarioMD> lista = new ArrayList<UsuarioMD>();
        try {
            this.conn = this.pool.getConnection();
            this.rs = this.pool.ejecutarQuery(QUERY, this.conn, parametros);
            while (this.rs.next()) {
                UsuarioMD usuario = new UsuarioMD();
                usuario.setUsername(this.rs.getString("usu_username"));
                usuario.setEstado(this.rs.getBoolean("usu_estado"));
                usuario.setPassword(this.rs.getString("usu_password"));
                usuario.setIsSuperUser(this.rs.getBoolean("usu_is_superuser"));
                PersonaMD persona = new PersonaMD();
                persona.setIdPersona(this.rs.getInt("id_persona"));
                persona.setIdentificacion(this.rs.getString("persona_identificacion"));
                persona.setPrimerApellido(this.rs.getString("persona_primer_apellido"));
                persona.setSegundoApellido(this.rs.getString("persona_segundo_apellido"));
                persona.setPrimerNombre(this.rs.getString("persona_primer_nombre"));
                persona.setSegundoNombre(this.rs.getString("persona_segundo_nombre"));
                usuario.setPersona(persona);
                lista.add(usuario);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(UsuarioBD.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            this.pool.close(this.conn);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsuarioBD selectWhereUsernamePassword() {
        String SELECT = "SELECT\n\"Usuarios\".id_persona,\n\"Personas\".persona_identificacion,\n\"Personas\".persona_primer_apellido,\n\"Personas\".persona_segundo_apellido,\n\"Personas\".persona_primer_nombre,\n\"Personas\".persona_segundo_nombre,\n\"Personas\".persona_foto,\n\"Usuarios\".usu_is_superuser\nFROM\n\"Usuarios\"\nINNER JOIN \"Personas\" ON \"Usuarios\".id_persona = \"Personas\".id_persona\nWHERE\n\"Usuarios\".usu_username = ? AND\n\"Usuarios\".usu_password = set_byte( MD5( ? ) :: bytea, 4, 64 ) AND\n\"Usuarios\".usu_estado IS TRUE;";
        UsuarioBD usuario = null;
        try {
            HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
            parametros.put(1, this.getUsername());
            parametros.put(2, this.getPassword());
            this.conn = this.pool.getConnection();
            this.rs = this.pool.ejecutarQuery(SELECT, this.conn, parametros);
            while (this.rs.next()) {
                usuario = new UsuarioBD();
                usuario.setUsername(this.getUsername());
                usuario.setIsSuperUser(this.rs.getBoolean("usu_is_superuser"));
                PersonaMD persona = new PersonaMD();
                persona.setIdPersona(this.rs.getInt("id_persona"));
                persona.setIdentificacion(this.rs.getString("persona_identificacion"));
                persona.setPrimerApellido(this.rs.getString("persona_primer_apellido"));
                persona.setSegundoApellido(this.rs.getString("persona_segundo_apellido"));
                persona.setPrimerNombre(this.rs.getString("persona_primer_nombre"));
                persona.setSegundoNombre(this.rs.getString("persona_segundo_nombre"));
                persona.setFoto(ImgLib.byteToImage(this.rs.getBytes("persona_foto")));
                usuario.setPersona(persona);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(NEWSilaboBD.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            this.pool.closeStmt().close(this.rs).close(this.conn);
        }
        return usuario;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UsuarioBD selectWhereUsername() {
        String SELECT = "SELECT\n\"Usuarios\".id_persona,\n\"Personas\".persona_identificacion,\n\"Personas\".persona_primer_apellido,\n\"Personas\".persona_segundo_apellido,\n\"Personas\".persona_primer_nombre,\n\"Personas\".persona_segundo_nombre,\n\"Personas\".persona_foto,\n\"Usuarios\".usu_is_superuser\nFROM\n\"Usuarios\"\nINNER JOIN \"Personas\" ON \"Usuarios\".id_persona = \"Personas\".id_persona\nWHERE\n\"Usuarios\".usu_username = ? AND\n\"Usuarios\".usu_estado IS TRUE;";
        UsuarioBD usuario = null;
        try {
            HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
            parametros.put(1, this.getUsername());
            this.conn = this.pool.getConnection();
            this.rs = this.pool.ejecutarQuery(SELECT, this.conn, parametros);
            while (this.rs.next()) {
                usuario = new UsuarioBD();
                usuario.setUsername(this.getUsername());
                usuario.setIsSuperUser(this.rs.getBoolean("usu_is_superuser"));
                PersonaMD persona = new PersonaMD();
                persona.setIdPersona(this.rs.getInt("id_persona"));
                persona.setIdentificacion(this.rs.getString("persona_identificacion"));
                persona.setPrimerApellido(this.rs.getString("persona_primer_apellido"));
                persona.setSegundoApellido(this.rs.getString("persona_segundo_apellido"));
                persona.setPrimerNombre(this.rs.getString("persona_primer_nombre"));
                persona.setSegundoNombre(this.rs.getString("persona_segundo_nombre"));
                persona.setFoto(ImgLib.byteToImage(this.rs.getBytes("persona_foto")));
                usuario.setPersona(persona);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(NEWSilaboBD.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            this.pool.closeStmt().close(this.rs).close(this.conn);
        }
        return usuario;
    }

    public List<UsuarioMD> SelectAllWhereEstadoIsFalse() {
        String SELECT = "SELECT \"Usuarios\".id_usuario,\n    \"Usuarios\".usu_username,\n    \"Usuarios\".usu_password,\n    \"Usuarios\".usu_estado,\n    \"Usuarios\".id_persona,\n    \"Personas\".persona_identificacion,\n    \"Personas\".persona_primer_apellido,\n    \"Personas\".persona_segundo_apellido,\n    \"Personas\".persona_primer_nombre,\n    \"Personas\".persona_segundo_nombre,\n    \"Personas\".persona_foto\n   FROM (\"Usuarios\"\n     JOIN \"Personas\" ON ((\"Usuarios\".id_persona = \"Personas\".id_persona)))WHERE\n\"Usuarios\".usu_estado IS FALSE;";
        return this.selectSimple(SELECT, null);
    }

    public boolean editar(UsuarioMD usuario, String Pk) {
        String UPDATE = "UPDATE  \"Usuarios\" \n SET \nusu_username = ? ,\nusu_password = set_byte( MD5( ? )::bytea, 4,64),\nid_persona = ? ,\nusu_is_superuser = ? \n WHERE \n usu_username = ?;\n";
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, usuario.getUsername());
        parametros.put(2, usuario.getPassword());
        parametros.put(3, usuario.getPersona().getIdPersona());
        parametros.put(4, new Boolean(usuario.isIsSuperUser()));
        parametros.put(5, Pk);
        System.out.println("---->" + this.isIsSuperUser());
        System.out.println(parametros);
        return this.pool.ejecutar(UPDATE, parametros) == null;
    }

    public boolean cambiarEstado(String Pk, boolean estado) {
        String DELETE = "UPDATE \"Usuarios\" \n SET \n usu_estado = ?\n WHERE \n usu_username = ? ;\n";
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, estado);
        parametros.put(2, Pk);
        return this.pool.ejecutar(DELETE, parametros) == null;
    }
}

