/*
 * Decompiled with CFR 0.152.
 */
package modelo.usuario;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import modelo.usuario.HistorialUsuarioMD;
import utils.CONBD;
import utils.M;

public class HistorialUsuarioBD
extends CONBD {
    private String sql;
    private static HistorialUsuarioBD HUBD;

    public static HistorialUsuarioBD single() {
        if (HUBD == null) {
            HUBD = new HistorialUsuarioBD();
        }
        return HUBD;
    }

    public String getSql() {
        return this.sql;
    }

    public ArrayList<HistorialUsuarioMD> buscar(String aguja) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, \nhistorial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE usu_username ILIKE '%" + aguja + "%' OR\nhistorial_tipo_accion ILIKE '%" + aguja + "%' OR\nhistorial_nombre_tabla ILIKE '%" + aguja + "%' OR \nusu_username || ' ' || historial_tipo_accion ILIKE '%" + aguja + "%' OR\nusu_username || ' ' || historial_nombre_tabla ILIKE '%" + aguja + "%';;\t\t\t\t\t\t\t\t\t\t\t\t\t;";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialHoy() {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE date_part('year', historial_fecha) = date_part('year', now())\nAND date_part('month', historial_fecha) = date_part('month', now())\nAND date_part('day', historial_fecha) = date_part('day', now());\t\t\t\t\t\t\t\t\t\t\t\t\t;";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialUser(String username) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE usu_username = '" + username + "';";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialTbl(String tabla) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE historial_nombre_tabla = '" + tabla + "';";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialTblAccion(String tabla, String accion) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE historial_nombre_tabla = '" + tabla + "' AND \nhistorial_tipo_accion = '" + accion + "';";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialTblAccionPoFecha(String tabla, String accion, String fecha) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE historial_nombre_tabla = '" + tabla + "' AND \nhistorial_tipo_accion = '" + accion + "' AND \nhistorial_fecha::date = TO_DATE('" + fecha + "', 'DD/MM/YYYY');";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialTblAccionEntreFecha(String tabla, String accion, String fecha, String fechaFin) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE historial_nombre_tabla = '" + tabla + "' AND \nhistorial_tipo_accion = '" + accion + "' AND \nhistorial_fecha::date >= TO_DATE('" + fecha + "', 'DD/MM/YYYY') AND \nhistorial_fecha::date <= TO_DATE('" + fechaFin + "', 'DD/MM/YYYY');";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialAccion(String accion) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE historial_tipo_accion = '" + accion + "';";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialAccionPorFecha(String accion, String fecha) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE historial_tipo_accion = '" + accion + "' AND \nhistorial_fecha::date = TO_DATE('" + fecha + "', 'DD/MM/YYYY');";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialAccionEntreFechas(String accion, String fechaIni, String fechaFin) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE historial_tipo_accion = '" + accion + "' AND \nhistorial_fecha::date >= TO_DATE('" + fechaIni + "', 'DD/MM/YYYY') AND \nhistorial_fecha::date <= TO_DATE('" + fechaFin + "', 'DD/MM/YYYY');";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialFecha(String fecha) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE historial_fecha::date = TO_DATE('" + fecha + "', 'DD/MM/YYYY');";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialEntreFechas(String fechaIni, String fechaFin) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE historial_fecha::date >= TO_DATE('" + fechaIni + "', 'DD/MM/YYYY') AND\nhistorial_fecha::date <= TO_DATE('" + fechaFin + "', 'DD/MM/YYYY');";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialUserPorFecha(String username, String fecha) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE historial_fecha::date = TO_DATE('" + fecha + "', 'DD/MM/YYYY') AND \nusu_username = '" + username + "' ;";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialUserTabla(String username, String tabla) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE usu_username = '" + username + "' AND \nhistorial_nombre_tabla = '" + tabla + "';";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialUserTablaPorFecha(String username, String tabla, String fecha) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE usu_username = '" + username + "' AND \nhistorial_nombre_tabla = '" + tabla + "' AND \nhistorial_fecha::date = TO_DATE('" + fecha + "', 'DD/MM/YYYY');";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialUserTablaEntreFechas(String username, String tabla, String fechaIni, String fechaFin) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE usu_username = '" + username + "' AND \nhistorial_nombre_tabla = '" + tabla + "' AND \nhistorial_fecha::date >= TO_DATE('" + fechaIni + "', 'DD/MM/YYYY') AND \nhistorial_fecha::date <= TO_DATE('" + fechaFin + "', 'DD/MM/YYYY');";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialUserAccion(String username, String accion) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE usu_username = '" + username + "' AND \nhistorial_tipo_accion = '" + accion + "';";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialUserAccionPorFecha(String username, String accion, String fecha) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE usu_username = '" + username + "' AND \nhistorial_tipo_accion = '" + accion + "' AND \nhistorial_fecha::date = TO_DATE('" + fecha + "', 'DD/MM/YYYY');";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialUserAccionEntreFechas(String username, String accion, String fechaIni, String fechaFin) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE usu_username = '" + username + "' AND \nhistorial_tipo_accion = '" + accion + "' AND \nhistorial_fecha::date >= TO_DATE('" + fechaIni + "', 'DD/MM/YYYY') AND \nhistorial_fecha::date <= TO_DATE('" + fechaFin + "', 'DD/MM/YYYY');";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialUserEntreFechas(String username, String fechaIni, String fechaFin) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE historial_fecha::date >= TO_DATE('" + fechaIni + "', 'DD/MM/YYYY') AND\nhistorial_fecha::date <= TO_DATE('" + fechaFin + "', 'DD/MM/YYYY') AND \nusu_username = '" + username + "' ;";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialUserTablaAccion(String username, String tabla, String accion) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE usu_username = '" + username + "' AND \nhistorial_nombre_tabla = '" + tabla + "' AND \nhistorial_tipo_accion = '" + accion + "' ;";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialUserTablaAccionPorFecha(String username, String tabla, String accion, String fecha) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE usu_username = '" + username + "' AND \nhistorial_nombre_tabla = '" + tabla + "' AND \nhistorial_tipo_accion = '" + accion + "' AND \nhistorial_fecha::date = TO_DATE('" + fecha + "', 'DD/MM/YYYY');";
        return this.consultarTbl(this.sql);
    }

    public ArrayList<HistorialUsuarioMD> cargarHistorialUserTablaAccionEntreFechas(String username, String tabla, String accion, String fechaIni, String fechaFin) {
        this.sql = "SELECT id_historial_user, usu_username, historial_fecha, historial_tipo_accion, historial_nombre_tabla, historial_pk_tabla\nFROM public.\"HistorialUsuarios\"\nWHERE usu_username = '" + username + "' AND \nhistorial_nombre_tabla = '" + tabla + "' AND \nhistorial_tipo_accion = '" + accion + "' AND \nhistorial_fecha::date >= TO_DATE('" + fechaIni + "', 'DD/MM/YYYY') AND \nhistorial_fecha::date <= TO_DATE('" + fechaFin + "', 'DD/MM/YYYY');";
        return this.consultarTbl(this.sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<HistorialUsuarioMD> consultarTbl(String sql) {
        ArrayList<HistorialUsuarioMD> historial = new ArrayList<HistorialUsuarioMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                HistorialUsuarioMD h = new HistorialUsuarioMD();
                h.setId(rs.getInt("id_historial_user"));
                h.setNombreTbl(rs.getString("historial_nombre_tabla"));
                h.setFechaAccion(rs.getTimestamp("historial_fecha").toLocalDateTime());
                h.setPkTbl(rs.getInt("historial_pk_tabla"));
                h.setTipoAccion(rs.getString("historial_tipo_accion"));
                h.setUsername(rs.getString("usu_username"));
                historial.add(h);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar historial. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return historial;
    }

    public ArrayList<String> cargarAcciones() {
        this.sql = "SELECT DISTINCT historial_tipo_accion\nFROM public.\"HistorialUsuarios\";";
        return this.cargarClm(this.sql);
    }

    public ArrayList<String> cargarTablas() {
        this.sql = "SELECT DISTINCT historial_nombre_tabla\nFROM public.\"HistorialUsuarios\";";
        return this.cargarClm(this.sql);
    }

    public ArrayList<String> cargarUsuarios() {
        this.sql = "SELECT DISTINCT usu_username\nFROM public.\"HistorialUsuarios\";";
        return this.cargarClm(this.sql);
    }

    public ArrayList<String> cargarFechas() {
        this.sql = "SELECT DISTINCT \ndate_part('day', historial_fecha) || '/' ||\ndate_part('month', historial_fecha) || '/' ||\ndate_part('year', historial_fecha)\nFROM public.\"HistorialUsuarios\"\nORDER BY 1 DESC;";
        return this.cargarClm(this.sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> cargarClm(String sql) {
        ArrayList<String> acciones = new ArrayList<String>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String a = rs.getString(1);
                acciones.add(a);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar historial. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return acciones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String buscarObservacion(int idHistorial) {
        this.sql = "SELECT hitorial_observacion\nFROM public.\"HistorialUsuarios\" \nWHERE id_historial_user = " + idHistorial + ";";
        String a = "";
        PreparedStatement ps = CON.getPSPOOL(this.sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                a = rs.getString("hitorial_observacion");
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar historial. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return a;
    }

    public void registroMarca(String usuario, String docente) {
        this.sql = "INSERT INTO public.\"HistorialUsuarios\"(\n\t\tusu_username, historial_fecha, historial_tipo_accion,\n\t  historial_nombre_tabla, historial_pk_tabla,historial_ip)\n\tVALUES('" + usuario + "', now(), 'CONSULTA MARCACION " + docente + "','2023-01-01 2023-01-01',0,inet_client_addr());";
        Connection conn = CON.getConnection();
        CON.ejecutar(this.sql, conn, null);
    }
}

