/*
 * Decompiled with CFR 0.152.
 */
package modelo.tipoDeNota;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import modelo.ConnDBPool;
import modelo.carrera.CarreraMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.tipoDeNota.TipoDeNotaMD;

public class TipoDeNotaBD
extends TipoDeNotaMD {
    private ConnDBPool pool = new ConnDBPool();
    private Connection conn;
    private ResultSet rs;

    public TipoDeNotaBD(int idTipoNota, String nombre, double valorMinimo, double valorMaximo, LocalDate fechaCreacion, boolean estado, PeriodoLectivoMD periodoLectivo) {
        super(idTipoNota, nombre, valorMinimo, valorMaximo, fechaCreacion, estado, periodoLectivo);
    }

    public TipoDeNotaBD() {
    }

    public TipoDeNotaBD(TipoDeNotaMD obj) {
        this.setId(obj.getId());
        this.setNombre(obj.getNombre());
        this.setValorMinimo(obj.getValorMinimo());
        this.setValorMaximo(obj.getValorMaximo());
        this.setFechaCreacion(obj.getFechaCreacion());
        this.setEstado(obj.isEstado());
        this.setPeriodoLectivo(obj.getPeriodoLectivo());
    }

    public boolean insertar() {
        String INSERT = "INSERT INTO  \"TipoDeNota\"  \n( tipo_nota_nombre, tipo_nota_valor_minimo, tipo_nota_valor_maximo, id_prd_lectivo )\nVALUES (?,?,?,?)";
        this.conn = this.pool.getConnection();
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, this.getNombre());
        parametros.put(2, this.getValorMinimo());
        parametros.put(3, this.getValorMaximo());
        parametros.put(4, this.getPeriodoLectivo().getID());
        return this.pool.ejecutar(INSERT, this.conn, parametros) == null;
    }

    public List<TipoDeNotaBD> selectAllWhereEstadoIs(boolean estado) {
        String SELECT = "SELECT\n\"TipoDeNota\".id_tipo_nota,\n\"TipoDeNota\".tipo_nota_nombre,\n\"TipoDeNota\".tipo_nota_valor_minimo,\n\"TipoDeNota\".tipo_nota_valor_maximo,\n\"TipoDeNota\".tipo_nota_fecha_creacion,\n\"TipoDeNota\".id_prd_lectivo,\n\"PeriodoLectivo\".id_carrera,\n\"Carreras\".carrera_nombre,\n\"Carreras\".carrera_modalidad,\n\"PeriodoLectivo\".prd_lectivo_nombre\nFROM\n\"TipoDeNota\"\nINNER JOIN \"PeriodoLectivo\" ON \"TipoDeNota\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\nINNER JOIN \"Carreras\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera\nWHERE\n\"TipoDeNota\".tipo_nota_estado IS " + estado;
        return this.SelectSimple(SELECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<TipoDeNotaBD> SelectSimple(String QUERY) {
        ArrayList<TipoDeNotaBD> Lista = new ArrayList<TipoDeNotaBD>();
        this.conn = this.pool.getConnection();
        this.rs = this.pool.ejecutarQuery(QUERY, this.conn, null);
        try {
            while (this.rs.next()) {
                TipoDeNotaBD tipoNota = new TipoDeNotaBD();
                tipoNota.setId(this.rs.getInt("id_tipo_nota"));
                tipoNota.setNombre(this.rs.getString("tipo_nota_nombre"));
                tipoNota.setValorMinimo(this.rs.getDouble("tipo_nota_valor_minimo"));
                tipoNota.setValorMaximo(this.rs.getDouble("tipo_nota_valor_maximo"));
                tipoNota.setFechaCreacion(this.rs.getDate("tipo_nota_fecha_creacion").toLocalDate());
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(this.rs.getInt("id_prd_lectivo"));
                periodo.setNombre(this.rs.getString("prd_lectivo_nombre"));
                CarreraMD carrera = new CarreraMD();
                carrera.setId(this.rs.getInt("id_carrera"));
                carrera.setNombre(this.rs.getString("carrera_nombre"));
                carrera.setModalidad(this.rs.getString("carrera_modalidad"));
                periodo.setCarrera(carrera);
                tipoNota.setPeriodoLectivo(periodo);
                Lista.add(tipoNota);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(TipoDeNotaBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.pool.closeStmt().close(this.rs).close(this.conn);
        }
        return Lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TipoDeNotaBD> selectWhere(int idPeriodo) {
        String SELECT = "SELECT\n\"TipoDeNota\".id_tipo_nota,\n\"TipoDeNota\".tipo_nota_nombre,\n\"TipoDeNota\".tipo_nota_valor_minimo,\n\"TipoDeNota\".tipo_nota_valor_maximo\nFROM\n\"TipoDeNota\"\nWHERE \n\"TipoDeNota\".id_prd_lectivo = ?";
        ArrayList<TipoDeNotaBD> lista = new ArrayList<TipoDeNotaBD>();
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, idPeriodo);
        this.conn = this.pool.getConnection();
        this.rs = this.pool.ejecutarQuery(SELECT, this.conn, parametros);
        PeriodoLectivoMD periodo = new PeriodoLectivoMD();
        periodo.setID(idPeriodo);
        try {
            while (this.rs.next()) {
                TipoDeNotaBD tipo = new TipoDeNotaBD();
                tipo.setId(this.rs.getInt("id_tipo_nota"));
                tipo.setNombre(this.rs.getString("tipo_nota_nombre"));
                tipo.setValorMinimo(this.rs.getDouble("tipo_nota_valor_minimo"));
                tipo.setValorMaximo(this.rs.getDouble("tipo_nota_valor_maximo"));
                tipo.setPeriodoLectivo(periodo);
                lista.add(tipo);
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            this.pool.closeStmt().close(this.rs).close(this.conn);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> selectNombreWhere(int idPeriodo) {
        String SELECT = "SELECT\n\"TipoDeNota\".tipo_nota_nombre\nFROM\n\"TipoDeNota\"\nWHERE\nid_prd_lectivo = ?";
        ArrayList<String> lista = new ArrayList<String>();
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, idPeriodo);
        this.conn = this.pool.getConnection();
        this.rs = this.pool.ejecutarQuery(SELECT, this.conn, parametros);
        try {
            while (this.rs.next()) {
                lista.add(this.rs.getString("tipo_nota_nombre"));
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            this.pool.closeStmt().close(this.rs).close(this.conn);
        }
        return lista;
    }

    public boolean editar(int Pk) {
        String UPDATE = "UPDATE \"TipoDeNota\" \nSET \n\ttipo_nota_nombre = '" + this.getNombre() + "',\n\ttipo_nota_valor_minimo = " + this.getValorMinimo() + ",\n\ttipo_nota_valor_maximo = " + this.getValorMaximo() + ",\n\tid_prd_lectivo = " + this.getPeriodoLectivo().getID() + "\nWHERE\n\tid_tipo_nota = " + Pk;
        this.conn = this.pool.getConnection();
        return this.pool.ejecutar(UPDATE, this.conn, null) == null;
    }
}

