/*
 * Decompiled with CFR 0.152.
 */
package modelo.silabo;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import modelo.materia.MateriaMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.PersonaMD;
import modelo.referenciasSilabo.ReferenciaSilaboMD;
import modelo.unidadSilabo.UnidadSilaboMD;

public class SilaboMD {
    public static int PENDIENTE = 0;
    public static int APROBADO = 1;
    public static int REVISAR = 2;
    private Integer ID = 0;
    private MateriaMD materia;
    private int estado;
    private PeriodoLectivoMD periodo;
    private LocalDate fechaGeneracion;
    private LocalDateTime fechaActualizacion;
    private List<UnidadSilaboMD> unidades;
    private List<ReferenciaSilaboMD> referencias;
    private boolean editando;
    private PersonaMD editadoPor;
    private LocalDateTime ultimaEdicion;
    private String sustentobb;
    private String sustentobc;

    public SilaboMD() {
        this.materia = new MateriaMD();
        this.periodo = new PeriodoLectivoMD();
    }

    public SilaboMD(MateriaMD idMateria, PeriodoLectivoMD idPeriodoLectivo) {
        this.materia = idMateria;
        this.periodo = idPeriodoLectivo;
    }

    public Integer getID() {
        return this.ID;
    }

    public void setID(Integer ID) {
        this.ID = ID;
    }

    public MateriaMD getMateria() {
        return this.materia;
    }

    public void setMateria(MateriaMD idMateria) {
        this.materia = idMateria;
    }

    public int getEstado() {
        return this.estado;
    }

    public void setEstado(int estadoSilabo) {
        this.estado = estadoSilabo;
    }

    public PeriodoLectivoMD getPeriodo() {
        return this.periodo;
    }

    public void setPeriodo(PeriodoLectivoMD periodo) {
        this.periodo = periodo;
    }

    public List<UnidadSilaboMD> getUnidades() {
        return this.unidades;
    }

    public void setUnidades(List<UnidadSilaboMD> unidades) {
        this.unidades = unidades;
    }

    public List<ReferenciaSilaboMD> getReferencias() {
        return this.referencias;
    }

    public void setReferencias(List<ReferenciaSilaboMD> referencias) {
        this.referencias = referencias;
    }

    public LocalDate getFechaGeneracion() {
        return this.fechaGeneracion;
    }

    public void setFechaGeneracion(LocalDate fechaGeneracion) {
        this.fechaGeneracion = fechaGeneracion;
    }

    public LocalDateTime getFechaActualizacion() {
        return this.fechaActualizacion;
    }

    public void setFechaActualizacion(LocalDateTime fechaActualizacion) {
        this.fechaActualizacion = fechaActualizacion;
    }

    public static String getEstadoStr(int estado) {
        switch (estado) {
            case 0: {
                return "PENDIENTE";
            }
            case 1: {
                return "APROBADO";
            }
            case 2: {
                return "REVISAR";
            }
        }
        return null;
    }

    public static Integer getEstadoInt(String estado) {
        switch (estado) {
            case "PENDIENTE": {
                return 0;
            }
            case "APROBADO": {
                return 1;
            }
            case "REVISAR": {
                return 2;
            }
        }
        return null;
    }

    public boolean isEditando() {
        return this.editando;
    }

    public void setEditando(boolean editando) {
        this.editando = editando;
    }

    public PersonaMD getEditadoPor() {
        return this.editadoPor;
    }

    public void setEditadoPor(PersonaMD editadoPor) {
        this.editadoPor = editadoPor;
    }

    public LocalDateTime getUltimaEdicion() {
        return this.ultimaEdicion;
    }

    public void setUltimaEdicion(LocalDateTime ultimaEdicion) {
        this.ultimaEdicion = ultimaEdicion;
    }

    public String nombrePeriodoMateria() {
        return this.periodo.getNombre() + " " + this.materia.getNombre();
    }

    public String getSustentobb() {
        return this.sustentobb;
    }

    public void setSustentobb(String sustentobb) {
        this.sustentobb = sustentobb;
    }

    public String getSustentobc() {
        return this.sustentobc;
    }

    public void setSustentobc(String sustentobc) {
        this.sustentobc = sustentobc;
    }

    public String toString() {
        return "SilaboMD{ID=" + this.ID + ", materia=" + this.materia + ", estado=" + this.estado + ", periodo=" + this.periodo + ", fechaGeneracion=" + this.fechaGeneracion + ", fechaActualizacion=" + this.fechaActualizacion + ", unidades=" + this.unidades + ", referencias=" + this.referencias + ", editando=" + this.editando + ",sustentobc=" + this.sustentobc + ",sustentobb=" + this.sustentobb + ", editadoPor=" + this.editadoPor + ", ultimaEdicion=" + this.ultimaEdicion + '}';
    }
}

