/*
 * Decompiled with CFR 0.152.
 */
package modelo.silabo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import modelo.ConnDBPool;
import modelo.carrera.CarreraMD;
import modelo.materia.MateriaMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.PersonaMD;
import modelo.silabo.NEWUnidadSilaboBD;
import modelo.silabo.SilaboBD;
import modelo.silabo.SilaboMD;
import modelo.silabo.mbd.ISilaboBD;
import modelo.unidadSilabo.UnidadSilaboMD;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JasperViewer;
import utils.CONS;

public class NEWSilaboBD
implements ISilaboBD {
    private static final ConnDBPool CON = ConnDBPool.single();
    private static NEWSilaboBD SBD;
    private static final String INSERT = "INSERT INTO public.\"Silabo\"( id_materia, id_prd_lectivo, fecha_silabo ) VALUES (?, ?, now());";
    private static final String FROM_SILABO = "SELECT DISTINCT id_silabo, s.id_materia, m.materia_nombre, m.materia_horas_docencia, m.materia_horas_practicas, m.materia_horas_auto_estudio, estado_silabo, pr.id_prd_lectivo, pr.prd_lectivo_fecha_inicio, pr.prd_lectivo_fecha_fin, pr.prd_lectivo_nombre, pr.prd_lectivo_fecha_fin_clases, s.sustentobb, s.sustentobc FROM \"Silabo\" AS s\nJOIN \"Materias\" AS m ON s.id_materia=m.id_materia\nJOIN \"PeriodoLectivo\" AS pr ON pr.id_prd_lectivo=s.id_prd_lectivo\nJOIN \"Carreras\" AS crr ON crr.id_carrera = m.id_carrera\nJOIN \"Cursos\" AS cr ON cr.id_materia=m.id_materia\nJOIN \"Docentes\" AS d ON d.id_docente= cr.id_docente\nJOIN \"Personas\" AS p ON d.id_persona=p.id_persona  WHERE ";

    public static NEWSilaboBD single() {
        if (SBD == null) {
            SBD = new NEWSilaboBD();
        }
        return SBD;
    }

    @Override
    public int guardar(SilaboMD s) {
        PreparedStatement ps = CON.getPSID(INSERT);
        try {
            ps.setInt(1, s.getMateria().getId());
            ps.setInt(2, s.getPeriodo().getID());
            return CON.getIDGenerado(ps);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al guardar el silabo, \n" + e.getMessage() + e.getMessage(), "Error guardar", 0);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SilaboMD getByCarreraPersonaPeriodo(String nombreCarrera, int idPersona, String nombrePeriodo) {
        SilaboMD s = null;
        String sql = "SELECT DISTINCT id_silabo, s.id_materia, m.materia_nombre, m.materia_horas_docencia, m.materia_horas_practicas, m.materia_horas_auto_estudio, estado_silabo, pr.id_prd_lectivo, pr.prd_lectivo_fecha_inicio, pr.prd_lectivo_fecha_fin, pr.prd_lectivo_nombre, pr.prd_lectivo_fecha_fin_clases, s.sustentobb, s.sustentobc FROM \"Silabo\" AS s\nJOIN \"Materias\" AS m ON s.id_materia=m.id_materia\nJOIN \"PeriodoLectivo\" AS pr ON pr.id_prd_lectivo=s.id_prd_lectivo\nJOIN \"Carreras\" AS crr ON crr.id_carrera = m.id_carrera\nJOIN \"Cursos\" AS cr ON cr.id_materia=m.id_materia\nJOIN \"Docentes\" AS d ON d.id_docente= cr.id_docente\nJOIN \"Personas\" AS p ON d.id_persona=p.id_persona  WHERE  crr.carrera_nombre = ?  AND p.id_persona = ?  AND prd_lectivo_nombre = ? ;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setString(1, nombreCarrera);
            ps.setInt(2, idPersona);
            ps.setString(3, nombrePeriodo);
            ResultSet res = ps.executeQuery();
            s = this.getOneForFrm(res);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar un unico silabo. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SilaboMD> getByCarreraPersona(String nombreCarrera, int idPersona) {
        ArrayList<SilaboMD> SS = new ArrayList();
        String sql = "SELECT DISTINCT id_silabo, s.id_materia, m.materia_nombre, m.materia_horas_docencia, m.materia_horas_practicas, m.materia_horas_auto_estudio, estado_silabo, pr.id_prd_lectivo, pr.prd_lectivo_fecha_inicio, pr.prd_lectivo_fecha_fin, pr.prd_lectivo_nombre, pr.prd_lectivo_fecha_fin_clases, s.sustentobb, s.sustentobc FROM \"Silabo\" AS s\nJOIN \"Materias\" AS m ON s.id_materia=m.id_materia\nJOIN \"PeriodoLectivo\" AS pr ON pr.id_prd_lectivo=s.id_prd_lectivo\nJOIN \"Carreras\" AS crr ON crr.id_carrera = m.id_carrera\nJOIN \"Cursos\" AS cr ON cr.id_materia=m.id_materia\nJOIN \"Docentes\" AS d ON d.id_docente= cr.id_docente\nJOIN \"Personas\" AS p ON d.id_persona=p.id_persona  WHERE WHERE crr.carrera_nombre = ? AND p.id_persona = ?;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setString(1, nombreCarrera);
            ps.setInt(2, idPersona);
            ResultSet res = ps.executeQuery();
            SS = this.getForFrm(res);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return SS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SilaboMD> getAnterioresByMateriaPersona(int idPersona, int idMateria) {
        ArrayList<SilaboMD> SS = new ArrayList();
        String sql = "SELECT DISTINCT id_silabo, s.id_materia, m.materia_nombre, m.materia_horas_docencia, m.materia_horas_practicas, m.materia_horas_auto_estudio, estado_silabo, pr.id_prd_lectivo, pr.prd_lectivo_fecha_inicio, pr.prd_lectivo_fecha_fin, pr.prd_lectivo_nombre, pr.prd_lectivo_fecha_fin_clases, s.sustentobb, s.sustentobc FROM \"Silabo\" AS s\nJOIN \"Materias\" AS m ON s.id_materia=m.id_materia\nJOIN \"PeriodoLectivo\" AS pr ON pr.id_prd_lectivo=s.id_prd_lectivo\nJOIN \"Carreras\" AS crr ON crr.id_carrera = m.id_carrera\nJOIN \"Cursos\" AS cr ON cr.id_materia=m.id_materia\nJOIN \"Docentes\" AS d ON d.id_docente= cr.id_docente\nJOIN \"Personas\" AS p ON d.id_persona=p.id_persona  WHERE WHERE m.id_materia = ? AND p.id_persona = ?;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idMateria);
            ps.setInt(2, idPersona);
            ResultSet res = ps.executeQuery();
            SS = this.getForFrm(res);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return SS;
    }

    @Override
    public void setEstado(int idSilabo, int estado) {
        String sql = "UPDATE public.\"Silabo\"  SET estado_silabo = ? WHERE id_silabo = ?;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setInt(1, estado);
            ps.setInt(2, idSilabo);
            CON.noSQLPOOL(ps);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al cambiar el estado del silabo. " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SilaboMD getSilaboById(int idSilabo) {
        SilaboMD s = null;
        String sql = "SELECT DISTINCT id_silabo, s.id_materia, m.materia_nombre, m.materia_horas_docencia, m.materia_horas_practicas, m.materia_horas_auto_estudio, estado_silabo, pr.id_prd_lectivo, pr.prd_lectivo_fecha_inicio, pr.prd_lectivo_fecha_fin, pr.prd_lectivo_nombre, pr.prd_lectivo_fecha_fin_clases, s.sustentobb, s.sustentobc FROM \"Silabo\" AS s\nJOIN \"Materias\" AS m ON s.id_materia=m.id_materia\nJOIN \"PeriodoLectivo\" AS pr ON pr.id_prd_lectivo=s.id_prd_lectivo\nJOIN \"Carreras\" AS crr ON crr.id_carrera = m.id_carrera\nJOIN \"Cursos\" AS cr ON cr.id_materia=m.id_materia\nJOIN \"Docentes\" AS d ON d.id_docente= cr.id_docente\nJOIN \"Personas\" AS p ON d.id_persona=p.id_persona  WHERE  s.id_silabo = ? ;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idSilabo);
            ResultSet res = ps.executeQuery();
            s = this.getOneForFrm(res);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar para editar " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return s;
    }

    @Override
    public void guardarPDFAnalitico(int idSilabo, FileInputStream fis, File f) {
        String sql = "UPDATE public.\"Silabo\"  SET documento_analitico = ?  WHERE id_silabo = ?;";
    }

    @Override
    public void guardarPDFSilabo(int idSilabo, FileInputStream fis, File f) {
        String sql = "UPDATE public.\"Silabo\"  SET documento_silabo = ?  WHERE id_silabo = ?;";
    }

    private List<SilaboMD> getForFrm(ResultSet res) {
        ArrayList<SilaboMD> SS = new ArrayList<SilaboMD>();
        if (res != null) {
            try {
                while (res.next()) {
                    SilaboMD s = new SilaboMD();
                    s.setID(res.getInt(1));
                    s.getMateria().setId(res.getInt(2));
                    s.getMateria().setNombre(res.getString(3));
                    s.getMateria().setHorasDocencia(res.getInt(4));
                    s.getMateria().setHorasPracticas(res.getInt(5));
                    s.getMateria().setHorasAutoEstudio(res.getInt(6));
                    s.setEstado(res.getInt(7));
                    s.getPeriodo().setID(res.getInt(8));
                    s.getPeriodo().setFechaInicio(res.getDate(9).toLocalDate());
                    s.getPeriodo().setFechaFin(res.getDate(10).toLocalDate());
                    s.getPeriodo().setNombre(res.getString(11));
                    SS.add(s);
                }
            }
            catch (SQLException e) {
                JOptionPane.showMessageDialog(null, "Error al mapear la respuesta de silabo. " + e.getMessage());
            }
        }
        return SS;
    }

    private SilaboMD getOneForFrm(ResultSet res) {
        SilaboMD s = null;
        if (res != null) {
            try {
                while (res.next()) {
                    s = new SilaboMD();
                    s.setID(res.getInt(1));
                    s.getMateria().setId(res.getInt(2));
                    s.getMateria().setNombre(res.getString(3));
                    s.getMateria().setHorasDocencia(res.getInt(4));
                    s.getMateria().setHorasPracticas(res.getInt(5));
                    s.getMateria().setHorasAutoEstudio(res.getInt(6));
                    s.setEstado(res.getInt(7));
                    s.getPeriodo().setID(res.getInt(8));
                    s.getPeriodo().setFechaInicio(res.getDate(9).toLocalDate());
                    s.getPeriodo().setFechaFin(res.getDate(10).toLocalDate());
                    s.getPeriodo().setNombre(res.getString(11));
                    s.setSustentobb(res.getString("sustentobb"));
                    s.setSustentobc(res.getString("sustentobc"));
                    if (res.getDate(12) == null) continue;
                    s.getPeriodo().setFechaFinClases(res.getDate(12).toLocalDate());
                }
            }
            catch (SQLException e) {
                JOptionPane.showMessageDialog(null, "Error al obtener un silabo. " + e.getMessage());
            }
        }
        return s;
    }

    private void guardarPDF(String sql, int idSilabo, FileInputStream fis, File f) {
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setBinaryStream(1, (InputStream)fis, (int)f.length());
            ps.setInt(2, idSilabo);
            CON.noSQLPOOL(ps);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SilaboMD> getSilaboRef(int idPeriodo, int idMateria) {
        String SELECT = "WITH mi_carrera AS ( \n    SELECT \n        \"Carreras\".id_carrera\n    FROM \n        \"PeriodoLectivo\" \n        INNER JOIN \"Carreras\" ON \"Carreras\".id_carrera = \"PeriodoLectivo\".id_carrera \n    WHERE \n        \"PeriodoLectivo\".id_prd_lectivo = " + idPeriodo + " \n) SELECT\n    \"Silabo\".id_silabo,\n    \"PeriodoLectivo\".id_prd_lectivo,\n    \"PeriodoLectivo\".prd_lectivo_nombre \nFROM\n\t\"Silabo\"\n\tINNER JOIN \"PeriodoLectivo\" ON \"Silabo\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\tINNER JOIN mi_carrera ON mi_carrera.id_carrera = \"PeriodoLectivo\".id_carrera \nWHERE\n\t\"PeriodoLectivo\".id_carrera = mi_carrera.id_carrera \n\tAND \"Silabo\".id_materia = " + idMateria + " \n\tAND \"Silabo\".id_prd_lectivo <> " + idPeriodo + "\nORDER BY\n\t\"PeriodoLectivo\".prd_lectivo_fecha_inicio DESC ";
        ArrayList<SilaboMD> silabosRef = new ArrayList<SilaboMD>();
        ResultSet rs = CON.ejecutarQuery(SELECT, null);
        try {
            while (rs.next()) {
                SilaboMD silabo = new SilaboMD();
                silabo.setID(rs.getInt("id_silabo"));
                PeriodoLectivoMD periodo = new PeriodoLectivoMD().setID(rs.getInt("id_prd_lectivo")).setNombre(rs.getString("prd_lectivo_nombre"));
                silabo.setPeriodo(periodo);
                silabosRef.add(silabo);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWSilaboBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return silabosRef;
    }

    private static void existeCarpeta(File pdf, JasperPrint jasPDF, SilaboMD silabo) {
        File carpeta = new File("pdfs/");
        if (!carpeta.exists() && carpeta.mkdir()) {
            JOptionPane.showMessageDialog(null, "Creamos la carpeta pdfs en la que\nse guardaran los documentos.");
        }
        try {
            FileOutputStream output = new FileOutputStream(pdf);
            JasperExportManager.exportReportToPdfStream((JasperPrint)jasPDF, (OutputStream)output);
        }
        catch (FileNotFoundException | JRException e) {
            JOptionPane.showMessageDialog(null, "Error guardar PDF: " + e);
        }
    }

    public static void imprimirProgramaAnalitico(SilaboMD silabo) {
        try (Connection conn = CON.getConnection();){
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)NEWSilaboBD.class.getResource("/vista/silabos/reportes/silabo_duales/primera_pag.jasper"));
            HashMap<String, Integer> parametro = new HashMap<String, Integer>();
            parametro.put("parameter1", silabo.getMateria().getId());
            parametro.put("id_silabo", silabo.getID());
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)jr, parametro, (Connection)conn);
            JasperViewer pv = new JasperViewer(jp, false);
            pv.setVisible(true);
            pv.setTitle("Silabo Duales");
            File pdf = new File("pdfs/SD-" + silabo.getMateria().getNombre() + "-" + LocalDate.now() + ".pdf");
            NEWSilaboBD.existeCarpeta(pdf, jp, silabo);
        }
        catch (SQLException | JRException e) {
            JOptionPane.showMessageDialog(null, "Error: " + e);
        }
    }

    public static void imprimirProgramaAnaliticoConSemanas(SilaboMD silabo, int semanas) {
        try (Connection conn = CON.getConnection();){
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)NEWSilaboBD.class.getResource("/vista/silabos/reportes/silabo_duales/primera_pag_param_semanas.jasper"));
            HashMap<String, Integer> parametro = new HashMap<String, Integer>();
            parametro.put("parameter1", silabo.getMateria().getId());
            parametro.put("id_silabo", silabo.getID());
            parametro.put("num_semanas", semanas);
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)jr, parametro, (Connection)conn);
            JasperViewer pv = new JasperViewer(jp, false);
            pv.setVisible(true);
            pv.setTitle("Silabos Duales | Semanas");
            File pdf = new File("pdfs/SD-" + silabo.getMateria().getNombre() + "-" + LocalDate.now() + ".pdf");
            NEWSilaboBD.existeCarpeta(pdf, jp, silabo);
        }
        catch (SQLException | JRException e) {
            JOptionPane.showMessageDialog(null, "Error: " + e);
        }
    }

    public static void imprimirSilabo(SilaboMD silabo, String modalidad, int semanas, String codigoCarrera) {
        String silaboReport = "";
        try (Connection conn = CON.getConnection();){
            silaboReport = "/vista/silabos/reportes/silabo3/primera_pag.jasper";
            System.out.println(codigoCarrera);
            if (codigoCarrera.equalsIgnoreCase("TAIPT")) {
                silaboReport = "/vista/silabos/reportes/silabo2/primera_pag.jasper";
            }
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)NEWSilaboBD.class.getResource(silaboReport));
            HashMap<String, Integer> parametro = new HashMap<String, Integer>();
            parametro.put("parameter1", silabo.getMateria().getId());
            parametro.put("id_silabo", silabo.getID());
            parametro.put("semanas", semanas);
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)jr, parametro, (Connection)conn);
            JasperViewer pv = new JasperViewer(jp, false);
            pv.setVisible(true);
            pv.setTitle("S\u00edlabo");
            File pdf = new File("pdfs/ST-" + silabo.getMateria().getNombre() + "-" + LocalDate.now() + ".pdf");
            NEWSilaboBD.existeCarpeta(pdf, jp, silabo);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error reporte: " + e);
        }
    }

    public static void imprimirSilaboANTES(SilaboMD silabo) {
        try (Connection conn = CON.getConnection();){
            String silaboReport = "/vista/silabos/reportes/silabo3/primera_pag.jasper";
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)NEWSilaboBD.class.getResource(silaboReport));
            HashMap<String, Integer> parametro = new HashMap<String, Integer>();
            parametro.put("parameter1", silabo.getMateria().getId());
            parametro.put("id_silabo", silabo.getID());
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)jr, parametro, (Connection)conn);
            JasperViewer pv = new JasperViewer(jp, false);
            pv.setVisible(true);
            pv.setTitle("S\u00edlabo");
            File pdf = new File("pdfs/ST-" + silabo.getMateria().getNombre() + "-" + LocalDate.now() + ".pdf");
            NEWSilaboBD.existeCarpeta(pdf, jp, silabo);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error reporte: " + e);
        }
    }

    public static boolean eliminar(SilaboMD silabo) {
        String DELETE = "DELETE FROM public.\"Silabo\"\n\tWHERE id_silabo=" + silabo.getID();
        return CON.ejecutar(DELETE, null) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SilaboMD> findBy(String cedulaDocente, int idPeriodo) {
        String SELECT = "WITH mis_periodos_materias AS (\n\tSELECT DISTINCT\n\t\t\"Cursos\".id_prd_lectivo,\n\t\t\"Cursos\".id_materia \n\tFROM\n\t\t\"Cursos\"\n\t\tINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente\n\tWHERE\n\t\t\"Docentes\".docente_codigo = '" + cedulaDocente + "' \n\t\tAND \"Cursos\".id_prd_lectivo = " + idPeriodo + " \n\t) SELECT\n\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\"PeriodoLectivo\".id_prd_lectivo,\n\t\"Materias\".id_materia,\n\t\"Materias\".materia_nombre,\n\t\"Silabo\".fecha_silabo,\n\t\"Silabo\".estado_silabo,\n\t\"Silabo\".id_silabo,\n\t\"Carreras\".carrera_modalidad, \n\t\"Carreras\".carrera_codigo, \n\t\"Carreras\".carrera_semanas \nFROM\n\t\"Silabo\"\n\tINNER JOIN \"PeriodoLectivo\" ON \"Silabo\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\tINNER JOIN \"Materias\" ON \"Silabo\".id_materia = \"Materias\".id_materia\n\tINNER JOIN \"Carreras\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera\n\tINNER JOIN mis_periodos_materias ON \"PeriodoLectivo\".id_prd_lectivo = mis_periodos_materias.id_prd_lectivo \n\tAND \"Materias\".id_materia = mis_periodos_materias.id_materia \nORDER BY\n\t\"PeriodoLectivo\".id_prd_lectivo DESC,\n\t\"Materias\".materia_nombre ASC";
        ArrayList<SilaboMD> silabos = new ArrayList<SilaboMD>();
        ResultSet rs = CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                SilaboMD silabo = new SilaboMD();
                silabo.setID(rs.getInt("id_silabo"));
                silabo.setEstado(rs.getInt("estado_silabo"));
                CarreraMD carrera = new CarreraMD();
                carrera.setModalidad(rs.getString("carrera_modalidad"));
                carrera.setNumSemanas(Integer.parseInt(rs.getString("carrera_semanas")));
                carrera.setCodigo(rs.getString("carrera_codigo"));
                silabo.setPeriodo(new PeriodoLectivoMD().setID(rs.getInt("id_prd_lectivo")).setNombre(rs.getString("prd_lectivo_nombre")).setCarrera(carrera));
                silabo.setMateria(new MateriaMD().setId(rs.getInt("id_materia")).setNombre(rs.getString("materia_nombre")));
                try {
                    silabo.setFechaGeneracion(rs.getDate("fecha_silabo").toLocalDate());
                }
                catch (NullPointerException e) {
                    Logger.getLogger(NEWSilaboBD.class.getName()).log(Level.SEVERE, null, "NOT TIENE FECHA DE GENERACION: " + silabo.getID() + " " + silabo.getPeriodo().getNombre() + " " + silabo.getMateria().getNombre());
                }
                silabos.add(silabo);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SilaboBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return silabos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInformacion(SilaboMD silabo) {
        String SELECT = "SELECT \n    DISTINCT ON ( \"Personas\".persona_identificacion ) \"Cursos\".id_docente,\n\t(   \n        \"Personas\".persona_identificacion || '  |  ' || \n\t    \"Personas\".persona_primer_apellido || ' ' ||\n\t    \"Personas\".persona_primer_nombre\n    ) as docente,\n\t(\n\t    SELECT \n            string_agg ( \"Cursos\".curso_nombre, ', ' ) \n        FROM \n            \"Cursos\" \n\t    WHERE\n\t\t    \"Cursos\".id_prd_lectivo = " + silabo.getPeriodo().getID() + " \n            AND \"Cursos\".id_materia = " + silabo.getMateria().getId() + " \n            AND \"Docentes\".id_docente = id_docente \n\t) as cursos\nFROM\n\t\"Cursos\"\n\tINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente\n\tINNER JOIN \"Personas\" ON \"Docentes\".id_persona = \"Personas\".id_persona \nWHERE\n\t\"Cursos\".id_prd_lectivo = " + silabo.getPeriodo().getID() + " \n\tAND \"Cursos\".id_materia = " + silabo.getMateria().getId() + "";
        String informacion = "         Periodo Lectivo:\n             " + silabo.getPeriodo().getNombre() + "\n\n         Materia:\n             " + silabo.getMateria().getNombre() + "\n\n         Docentes:\n";
        ResultSet rs = CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                informacion = informacion + "             " + rs.getString("docente") + "\n             Cursos: " + rs.getString("cursos") + "\n\n";
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWSilaboBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return informacion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validarHorasSilaboMateria(int idSilabo) {
        String SELECT = "SELECT\n(materia_horas_docencia = horas_docencia_unidad AND\nmateria_horas_practicas = horas_practica_unidad AND\nmateria_horas_auto_estudio = horas_autonomo_unidad) AS verificacion\nFROM\n\n (\n  SELECT\n  materia_horas_docencia,\n  materia_horas_practicas,\n  materia_horas_auto_estudio, (\n    SELECT SUM(horas_docencia_unidad)\n    FROM public.\"UnidadSilabo\"\n    WHERE id_silabo = s.id_silabo\n  ) AS horas_docencia_unidad, (\n    SELECT SUM(horas_practica_unidad)\n    FROM public.\"UnidadSilabo\"\n    WHERE id_silabo = s.id_silabo\n  ) AS horas_practica_unidad, (\n    SELECT SUM(horas_autonomo_unidad)\n    FROM public.\"UnidadSilabo\"\n    WHERE id_silabo = s.id_silabo\n  )AS horas_autonomo_unidad\n  FROM public.\"Silabo\" s\n  JOIN public.\"Materias\" m ON s.id_materia = m.id_materia\n  WHERE s.id_silabo = " + idSilabo + "\n) AS horas ";
        ResultSet rs = CON.ejecutarQuery(SELECT);
        boolean verificacion = false;
        try {
            while (rs.next()) {
                verificacion = rs.getBoolean("verificacion");
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWSilaboBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return verificacion;
    }

    public boolean ediantoSilabo(int idSilabo, boolean estado) {
        String UPDATE = "UPDATE \"Silabo\" \nSET editando = " + estado + ",\neditado_por = '" + CONS.USUARIO.getPersona().getIdPersona() + "' \nWHERE\n\tid_silabo = " + idSilabo + ";";
        return CON.ejecutar(UPDATE) == null;
    }

    public boolean guardaSustentos(int idSilabo, String bb, String bc) {
        String UPDATE = "UPDATE \"Silabo\" \nSET sustentobb = '" + bb + "',sustentobc = '" + bc + "',\neditado_por = '" + CONS.USUARIO.getPersona().getIdPersona() + "' \nWHERE\n\tid_silabo = " + idSilabo + ";";
        return CON.ejecutar(UPDATE) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SilaboMD getDisponibilidad(SilaboMD silabo) {
        String SELECT = "SELECT\n\t\"Silabo\".id_silabo,\n\t\"Silabo\".editando,\n\t( SELECT \"Personas\".persona_identificacion \n\t\t\tFROM \"Personas\" WHERE id_persona = \"Silabo\".editado_por ) AS persona_identificacion,\n\t( SELECT \"Personas\".persona_primer_apellido \n\t\t\tFROM \"Personas\" WHERE id_persona = \"Silabo\".editado_por ) AS persona_primer_apellido,\n\t( SELECT \"Personas\".persona_primer_nombre \n\t\tFROM \"Personas\" WHERE id_persona = \"Silabo\".editado_por ) AS persona_primer_nombre \nFROM\n\t\"Silabo\" \nWHERE\n\t\"Silabo\".id_silabo =" + silabo.getID() + "";
        ResultSet rs = CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                silabo.setEditando(rs.getBoolean("editando"));
                PersonaMD persona = new PersonaMD();
                persona.setIdentificacion(rs.getString("persona_identificacion"));
                persona.setPrimerApellido(rs.getString("persona_primer_apellido"));
                persona.setPrimerNombre(rs.getString("persona_primer_nombre"));
                silabo.setEditadoPor(persona);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWSilaboBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return silabo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SilaboMD getSilaboBy(MateriaMD materia, PeriodoLectivoMD periodo) {
        String SELECT = "SELECT\n\t\"Silabo\".id_silabo,\n\t\"Silabo\".id_materia,\n\t\"Silabo\".id_prd_lectivo,\n\t\"Materias\".materia_nombre,\n\t\"Materias\".materia_horas_docencia,\n\t\"Materias\".materia_horas_practicas,\n\t\"Materias\".materia_horas_auto_estudio,\n\t\"Silabo\".estado_silabo,\n\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\"PeriodoLectivo\".prd_lectivo_fecha_inicio,\n\t\"PeriodoLectivo\".prd_lectivo_fecha_fin \nFROM\n\t\"Silabo\"\n\tINNER JOIN \"Materias\" ON \"Silabo\".id_materia = \"Materias\".id_materia\n\tINNER JOIN \"PeriodoLectivo\" ON \"Silabo\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo \nWHERE\n\t\"PeriodoLectivo\".id_prd_lectivo = " + periodo.getID() + " \n\tAND \"Materias\".id_materia = " + materia.getId() + "";
        SilaboMD silabo = null;
        ResultSet rs = CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                silabo = new SilaboMD();
                silabo.setID(rs.getInt("id_silabo"));
                materia.setHorasDocencia(rs.getInt("materia_horas_docencia"));
                materia.setHorasPracticas(rs.getInt("materia_horas_practicas"));
                materia.setHorasAutoEstudio(rs.getInt("materia_horas_auto_estudio"));
                periodo.setFechaFin(rs.getDate("prd_lectivo_fecha_fin").toLocalDate());
                periodo.setFechaInicio(rs.getDate("prd_lectivo_fecha_inicio").toLocalDate());
                silabo.setMateria(materia);
                silabo.setPeriodo(periodo);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWSilaboBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return silabo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SilaboMD> getSilabosPeriodo(int idPeriodo) {
        String SELECT = "SELECT\n\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\"PeriodoLectivo\".id_prd_lectivo,\n\t\"Materias\".id_materia,\n\t\"Materias\".materia_nombre,\n\t\"Silabo\".fecha_silabo,\n\t\"Silabo\".estado_silabo,\n\t\"Silabo\".id_silabo,\n\t\"Carreras\".carrera_modalidad, \n\t\"Carreras\".carrera_semanas \nFROM\n\t\"Silabo\"\n\tINNER JOIN \"PeriodoLectivo\" ON \"Silabo\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\tINNER JOIN \"Materias\" ON \"Silabo\".id_materia = \"Materias\".id_materia\n\tINNER JOIN \"Carreras\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera \nWHERE\n\t\"PeriodoLectivo\".id_prd_lectivo =  " + idPeriodo + "\nORDER BY\n\t\"PeriodoLectivo\".id_prd_lectivo DESC,\n\t\"Materias\".materia_nombre ASC";
        ArrayList<SilaboMD> silabos = new ArrayList<SilaboMD>();
        ResultSet rs = CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                SilaboMD silabo = new SilaboMD();
                silabo.setID(rs.getInt("id_silabo"));
                silabo.setEstado(rs.getInt("estado_silabo"));
                CarreraMD carrera = new CarreraMD();
                carrera.setModalidad(rs.getString("carrera_modalidad"));
                carrera.setNumSemanas(Integer.parseInt(rs.getString("carrera_semanas")));
                silabo.setPeriodo(new PeriodoLectivoMD().setID(rs.getInt("id_prd_lectivo")).setNombre(rs.getString("prd_lectivo_nombre")).setCarrera(carrera));
                silabo.setMateria(new MateriaMD().setId(rs.getInt("id_materia")).setNombre(rs.getString("materia_nombre")));
                try {
                    silabo.setFechaGeneracion(rs.getDate("fecha_silabo").toLocalDate());
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                silabos.add(silabo);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SilaboBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return silabos;
    }

    public static boolean editarEstado(SilaboMD silabo) {
        String UPDATE = "UPDATE \"Silabo\" \nSET estado_silabo = " + silabo.getEstado() + " \nWHERE\n\tid_silabo = " + silabo.getID() + "";
        return CON.ejecutar(UPDATE) == null;
    }

    public void setFechaEdicion(int idSilabo) {
        String sql = "UPDATE public.\"Silabo\"\nSET utima_edicion_bd= now()\n WHERE id_silabo=?;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idSilabo);
            CON.noSQLPOOL(ps);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<SilaboMD> getMisSilabosConUnidadesBy(String cedulaDocente) {
        String SELECT = "WITH mis_periodos_materias AS (\n\tSELECT DISTINCT\n\t\t\"Cursos\".id_prd_lectivo,\n\t\t\"Cursos\".id_materia,\n\t\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\t\"Materias\".materia_nombre, \n             \"PeriodoLectivo\".prd_lectivo_fecha_inicio\n\tFROM\n\t\t\"Cursos\"\n\t\tINNER JOIN \"Docentes\" ON \"Docentes\".id_docente = \"Cursos\".id_docente\n\t\tINNER JOIN \"PeriodoLectivo\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\t\tINNER JOIN \"Materias\" ON \"Cursos\".id_materia = \"Materias\".id_materia \n\tWHERE\n\t\t\"Docentes\".docente_codigo = '" + cedulaDocente + "' \n\t) SELECT\n\t\"Silabo\".id_silabo,\n\t\"Silabo\".id_prd_lectivo,\n\t\"Silabo\".id_materia,\n\tmis_periodos_materias.prd_lectivo_nombre,\n\tmis_periodos_materias.materia_nombre, \n\tmis_periodos_materias.prd_lectivo_fecha_inicio \nFROM\n\t\"Silabo\"\n\tINNER JOIN mis_periodos_materias ON \"Silabo\".id_prd_lectivo = mis_periodos_materias.id_prd_lectivo \n\tAND \"Silabo\".id_materia = mis_periodos_materias.id_materia\nORDER BY \n     mis_periodos_materias.prd_lectivo_fecha_inicio DESC";
        ResultSet rs = CON.ejecutarQuery(SELECT);
        ArrayList<SilaboMD> misSilabos = new ArrayList<SilaboMD>();
        try {
            while (rs.next()) {
                SilaboMD silabo = new SilaboMD();
                silabo.setID(rs.getInt("id_silabo"));
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(rs.getInt("id_prd_lectivo")).setNombre(rs.getString("prd_lectivo_nombre"));
                silabo.setPeriodo(periodo);
                MateriaMD materia = new MateriaMD();
                materia.setId(rs.getInt("id_materia"));
                materia.setNombre(rs.getString("materia_nombre"));
                silabo.setMateria(materia);
                List<UnidadSilaboMD> unidades = NEWUnidadSilaboBD.single().getSimpleBySilabo(silabo.getID());
                silabo.setUnidades(unidades);
                misSilabos.add(silabo);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWSilaboBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return misSilabos;
    }

    public static SilaboMD mapper(ResultSet rs) {
        SilaboMD silabo = new SilaboMD();
        try {
            Integer ID = rs.getInt("id_silabo");
            if (ID != null) {
                silabo.setID(ID);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWSilaboBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        return silabo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<SilaboMD> getMisSilabosby(String cedulaDocente) {
        String SELECT = "WITH mis_periodos_materias AS (\n\tSELECT DISTINCT\n\t\t\"Cursos\".id_prd_lectivo,\n\t\t\"Cursos\".id_materia,\n\t\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\t\"Materias\".materia_nombre, \n             \"PeriodoLectivo\".prd_lectivo_fecha_inicio\n\tFROM\n\t\t\"Cursos\"\n\t\tINNER JOIN \"Docentes\" ON \"Docentes\".id_docente = \"Cursos\".id_docente\n\t\tINNER JOIN \"PeriodoLectivo\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\t\tINNER JOIN \"Materias\" ON \"Cursos\".id_materia = \"Materias\".id_materia \n\tWHERE\n\t\t\"Docentes\".docente_codigo = '" + cedulaDocente + "' \n\t) SELECT\n\t\"Silabo\".id_silabo,\n\t\"Silabo\".id_prd_lectivo,\n\t\"Silabo\".id_materia,\n\tmis_periodos_materias.prd_lectivo_nombre,\n\tmis_periodos_materias.materia_nombre, \n\tmis_periodos_materias.prd_lectivo_fecha_inicio \nFROM\n\t\"Silabo\"\n\tINNER JOIN mis_periodos_materias ON \"Silabo\".id_prd_lectivo = mis_periodos_materias.id_prd_lectivo \n\tAND \"Silabo\".id_materia = mis_periodos_materias.id_materia\nORDER BY \n     mis_periodos_materias.prd_lectivo_fecha_inicio DESC";
        ResultSet rs = CON.ejecutarQuery(SELECT);
        ArrayList<SilaboMD> misSilabos = new ArrayList<SilaboMD>();
        try {
            while (rs.next()) {
                SilaboMD silabo = new SilaboMD();
                silabo.setID(rs.getInt("id_silabo"));
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(rs.getInt("id_prd_lectivo")).setNombre(rs.getString("prd_lectivo_nombre"));
                silabo.setPeriodo(periodo);
                MateriaMD materia = new MateriaMD();
                materia.setId(rs.getInt("id_materia"));
                materia.setNombre(rs.getString("materia_nombre"));
                silabo.setMateria(materia);
                misSilabos.add(silabo);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWSilaboBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return misSilabos;
    }

    public static void imprimirProgramaFocalizada(SilaboMD silabo) {
        try (Connection conn = CON.getConnection();){
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)NEWSilaboBD.class.getResource("/vista/silabos/reportes/silabo_duales/primera_pag_focalizado.jasper"));
            HashMap<String, Integer> parametro = new HashMap<String, Integer>();
            parametro.put("parameter1", silabo.getMateria().getId());
            parametro.put("id_silabo", silabo.getID());
            JasperPrint jp = JasperFillManager.fillReport((JasperReport)jr, parametro, (Connection)conn);
            JasperViewer pv = new JasperViewer(jp, false);
            pv.setVisible(true);
            pv.setTitle("Silabo Duales");
            File pdf = new File("pdfs/SD-" + silabo.getMateria().getNombre() + "-" + LocalDate.now() + ".pdf");
            NEWSilaboBD.existeCarpeta(pdf, jp, silabo);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Error: " + e);
        }
    }
}

