/*
 * Decompiled with CFR 0.152.
 */
package modelo.silabo;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import modelo.ConnDBPool;
import modelo.carrera.CarreraMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.silabo.mbd.IPeriodoLectivoBD;

public class NEWPeriodoLectivoBD
implements IPeriodoLectivoBD {
    private static final ConnDBPool CON = ConnDBPool.single();
    private static NEWPeriodoLectivoBD PBD;

    public static NEWPeriodoLectivoBD single() {
        if (PBD == null) {
            PBD = new NEWPeriodoLectivoBD();
        }
        return PBD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PeriodoLectivoMD> getByCarrera(int idCarrera) {
        String sql = "SELECT p.id_prd_lectivo, p.prd_lectivo_nombre, p.prd_lectivo_fecha_inicio, p.prd_lectivo_fecha_fin FROM \"PeriodoLectivo\" AS p\nJOIN \"Carreras\" AS c ON c.id_carrera = p.id_carrera WHERE c.id_carrera=?  AND  p.prd_lectivo_fecha_inicio >= '2018-11-12' ORDER BY p.id_prd_lectivo DESC";
        ArrayList<PeriodoLectivoMD> PS = new ArrayList<PeriodoLectivoMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idCarrera);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                p.setID(res.getInt(1));
                p.setNombre(res.getString(2));
                p.setFechaInicio(res.getDate(3).toLocalDate());
                p.setFechaFin(res.getDate(4).toLocalDate());
                PS.add(p);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar periodo lectivo por ID carrera. \n" + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return PS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PeriodoLectivoMD> getByCarrera(String nombre) {
        String sql = "";
        ArrayList<PeriodoLectivoMD> PS = new ArrayList<PeriodoLectivoMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setString(1, nombre);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                p.setID(res.getInt(1));
                p.setNombre(res.getString(2));
                p.setFechaFin(res.getDate(3).toLocalDate());
                PS.add(p);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar periodo lectivo por carrera. \n" + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return PS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeriodoLectivoMD getUltimoPorPeriodo(int idPeriodo) {
        String sql = "SELECT pr.id_prd_lectivo, pr.prd_lectivo_fecha_inicio, pr.prd_lectivo_fecha_fin, pr.prd_lectivo_fecha_fin_clases, pr.prd_lectivo_nombre FROM public.\"PeriodoLectivo\" pr WHERE id_carrera IN ( SELECT id_carrera FROM public.\"PeriodoLectivo\" WHERE id_prd_lectivo = ? ) ORDER BY prd_lectivo_fecha_fin DESC LIMIT 1;";
        PeriodoLectivoMD pl = null;
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idPeriodo);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                pl = new PeriodoLectivoMD();
                pl.setID(res.getInt(1));
                pl.setFechaInicio(res.getDate(2).toLocalDate());
                pl.setFechaFin(res.getDate(3).toLocalDate());
                pl.setFechaFinClases(res.getDate(4).toLocalDate());
                pl.setNombre(res.getString(5));
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consulta un periodo. \n" + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return pl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeriodoLectivoMD getUltimoPeriodoBy(int idCarrera) {
        String SELECT = "SELECT\n\t\"PeriodoLectivo\".id_prd_lectivo,\n\t\"PeriodoLectivo\".id_carrera, \n\t\"PeriodoLectivo\".prd_lectivo_fecha_inicio, \n\t\"PeriodoLectivo\".prd_lectivo_fecha_fin, \n\t\"PeriodoLectivo\".prd_lectivo_nombre, \n     \"PeriodoLectivo\".prd_lectivo_fecha_fin_clases \nFROM\n\t\"PeriodoLectivo\" \nWHERE\n\t\"PeriodoLectivo\".id_carrera = " + idCarrera + " \nORDER BY\n\t\"PeriodoLectivo\".prd_lectivo_fecha_inicio DESC \n\tLIMIT 1";
        PeriodoLectivoMD periodo = null;
        ResultSet rs = CON.ejecutarQuery(SELECT, null);
        try {
            while (rs.next()) {
                periodo = new PeriodoLectivoMD();
                periodo.setID(rs.getInt("id_prd_lectivo")).setNombre(rs.getString("prd_lectivo_nombre")).setFechaInicio(rs.getDate("prd_lectivo_fecha_inicio").toLocalDate()).setFechaFin(rs.getDate("prd_lectivo_fecha_fin").toLocalDate());
                Date fechaFinClases = rs.getDate("prd_lectivo_fecha_fin_clases");
                if (fechaFinClases != null) {
                    periodo.setFechaFinClases(fechaFinClases.toLocalDate());
                }
                CarreraMD carrera = new CarreraMD();
                carrera.setId(rs.getInt("id_carrera"));
                periodo.setCarrera(carrera);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWPeriodoLectivoBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return periodo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PeriodoLectivoMD> getMisPeriodosBy(int idPersona) {
        String SELECT = "SELECT DISTINCT\n\t\"PeriodoLectivo\".id_prd_lectivo,\n\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\"PeriodoLectivo\".prd_lectivo_fecha_inicio,\n\t\"PeriodoLectivo\".id_carrera\nFROM\n\t\"PeriodoLectivo\"\n\tINNER JOIN \"Cursos\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\tINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente \nWHERE\n\t\"Docentes\".id_persona = " + idPersona + "\n\tORDER BY \"PeriodoLectivo\".prd_lectivo_fecha_inicio DESC";
        ResultSet rs = CON.ejecutarQuery(SELECT);
        ArrayList<PeriodoLectivoMD> lista = new ArrayList<PeriodoLectivoMD>();
        try {
            while (rs.next()) {
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(rs.getInt("id_prd_lectivo"));
                periodo.setNombre(rs.getString("prd_lectivo_nombre"));
                CarreraMD carrera = new CarreraMD();
                carrera.setId(rs.getInt("id_carrera"));
                periodo.setCarrera(carrera);
                lista.add(periodo);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWPeriodoLectivoBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PeriodoLectivoMD> getMisPeriodosBy(int idPersona, boolean estado) {
        String SELECT = "SELECT DISTINCT\n\t\"PeriodoLectivo\".id_prd_lectivo,\n\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\"PeriodoLectivo\".prd_lectivo_fecha_inicio,\n\t\"PeriodoLectivo\".id_carrera\nFROM\n\t\"PeriodoLectivo\"\n\tINNER JOIN \"Cursos\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\tINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente \nWHERE\n\t\"Docentes\".id_persona = " + idPersona + "\n     AND prd_lectivo_activo = " + estado + "      AND prd_lectivo_estado = " + estado + " \n\tORDER BY \"PeriodoLectivo\".prd_lectivo_fecha_inicio DESC";
        ResultSet rs = CON.ejecutarQuery(SELECT);
        ArrayList<PeriodoLectivoMD> lista = new ArrayList<PeriodoLectivoMD>();
        try {
            while (rs.next()) {
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(rs.getInt("id_prd_lectivo"));
                periodo.setNombre(rs.getString("prd_lectivo_nombre"));
                CarreraMD carrera = new CarreraMD();
                carrera.setId(rs.getInt("id_carrera"));
                periodo.setCarrera(carrera);
                lista.add(periodo);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWPeriodoLectivoBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PeriodoLectivoMD> getPeriodosCoordinador(int idPersona) {
        String SELECT = "SELECT\n\t\"PeriodoLectivo\".id_prd_lectivo,\n\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\"PeriodoLectivo\".prd_lectivo_fecha_inicio \nFROM\n\t\"PeriodoLectivo\"\n\tINNER JOIN \"Carreras\" ON \"Carreras\".id_carrera = \"PeriodoLectivo\".id_carrera\n\tINNER JOIN \"Docentes\" ON \"Docentes\".id_docente = \"Carreras\".id_docente_coordinador \nWHERE\n\t\"Docentes\".id_persona = " + idPersona + " \nORDER BY\n\t\"PeriodoLectivo\".prd_lectivo_fecha_inicio DESC";
        ResultSet rs = CON.ejecutarQuery(SELECT);
        ArrayList<PeriodoLectivoMD> periodos = new ArrayList<PeriodoLectivoMD>();
        try {
            while (rs.next()) {
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(rs.getInt("id_prd_lectivo"));
                periodo.setNombre(rs.getString("prd_lectivo_nombre"));
                periodos.add(periodo);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWPeriodoLectivoBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return periodos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<PeriodoLectivoMD> selectAllDEV() {
        String SELECT = "SELECT\n\t\"PeriodoLectivo\".id_prd_lectivo,\n\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\"PeriodoLectivo\".prd_lectivo_fecha_inicio \nFROM\n\t\"PeriodoLectivo\" \nWHERE\n\t\"PeriodoLectivo\".prd_lectivo_activo IS TRUE\nORDER BY\n\t\"PeriodoLectivo\".prd_lectivo_fecha_inicio DESC\n";
        ArrayList<PeriodoLectivoMD> periodos = new ArrayList<PeriodoLectivoMD>();
        ResultSet rs = CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(rs.getInt("id_prd_lectivo"));
                periodo.setNombre(rs.getString("prd_lectivo_nombre"));
                periodos.add(periodo);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWPeriodoLectivoBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return periodos;
    }
}

