/*
 * Decompiled with CFR 0.152.
 */
package modelo.silabo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import modelo.ConnDBPool;
import modelo.materia.MateriaMD;
import modelo.silabo.mbd.IMateriaBD;

public class NEWMateriaBD
implements IMateriaBD {
    private final ConnDBPool CON = ConnDBPool.single();
    private static NEWMateriaBD MBD;

    public static NEWMateriaBD single() {
        if (MBD == null) {
            MBD = new NEWMateriaBD();
        }
        return MBD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MateriaMD> getByUsernameCarreraPeriodoSinSilabo(String username, int idPeriodo, int idCarrera) {
        String sql = "SELECT DISTINCT  m.id_materia,  m.materia_nombre,  m.materia_horas_docencia,  m.materia_horas_practicas,  m.materia_horas_auto_estudio\nFROM \"Materias\" AS m JOIN \"Cursos\" AS crs ON m.id_materia=crs.id_materia\nJOIN \"Docentes\" AS d ON d.id_docente=crs.id_docente\nJOIN \"Personas\" AS p ON p.id_persona=d.id_persona\nJOIN \"Usuarios\" AS u ON u.id_persona=p.id_persona\nJOIN \"Carreras\" AS crr ON crr.id_carrera = m.id_carrera\nJOIN \"PeriodoLectivo\" AS pr ON pr.id_prd_lectivo=crs.id_prd_lectivo\nWHERE usu_username=? AND crr.id_carrera=? AND crs.id_prd_lectivo=? EXCEPT SELECT DISTINCT \nm.id_materia, m.materia_nombre, m.materia_horas_docencia, m.materia_horas_practicas, m.materia_horas_auto_estudio\nFROM \"Materias\" AS m\nJOIN \"Cursos\" AS crs ON m.id_materia=crs.id_materia\nJOIN \"Docentes\" AS d ON d.id_docente=crs.id_docente\nJOIN \"Personas\" AS p ON p.id_persona=d.id_persona\nJOIN \"Usuarios\" AS u ON u.id_persona=p.id_persona\nJOIN \"Carreras\" AS crr ON crr.id_carrera = m.id_carrera\nJOIN \"PeriodoLectivo\" AS pr ON pr.id_prd_lectivo=crs.id_prd_lectivo\nJOIN \"Silabo\" AS s ON s.id_materia = m.id_materia\nWHERE usu_username=? AND crr.id_carrera=? AND s.id_prd_lectivo=?";
        ArrayList<MateriaMD> MS = new ArrayList<MateriaMD>();
        PreparedStatement ps = this.CON.getPSPOOL(sql);
        try {
            ps.setString(1, username);
            ps.setInt(2, idCarrera);
            ps.setInt(3, idPeriodo);
            ps.setString(4, username);
            ps.setInt(5, idCarrera);
            ps.setInt(6, idPeriodo);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                MateriaMD m = new MateriaMD();
                m.setId(res.getInt(1));
                m.setNombre(res.getString(2));
                m.setHorasDocencia(res.getInt(3));
                m.setHorasPracticas(res.getInt(4));
                m.setHorasAutoEstudio(res.getInt(5));
                MS.add(m);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar materias. " + e.getMessage());
        }
        finally {
            this.CON.cerrarCONPS(ps);
        }
        return MS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MateriaMD> getByCarreraPersonaPeriodo(String carreraNombre, int idPersona, String periodoNombre) {
        String sql = "SELECT DISTINCT id_silabo,\nm.materia_nombre\nFROM \"Silabo\" AS s\nJOIN \"Materias\" AS m ON s.id_materia=m.id_materia\nJOIN \"PeriodoLectivo\" AS pr ON pr.id_prd_lectivo=s.id_prd_lectivo\nJOIN \"Carreras\" AS crr ON crr.id_carrera = m.id_carrera\nJOIN \"Cursos\" AS cr ON cr.id_materia=m.id_materia\nJOIN \"Docentes\" AS d ON d.id_docente= cr.id_docente\nJOIN \"Personas\" AS p ON d.id_persona=p.id_persona\nWHERE crr.carrera_nombre=?\nAND p.id_persona=? AND pr.prd_lectivo_nombre=? AND cr.id_prd_lectivo=s.id_prd_lectivo";
        ArrayList<MateriaMD> MS = new ArrayList<MateriaMD>();
        PreparedStatement ps = this.CON.getPSPOOL(sql);
        try {
            ps.setString(1, carreraNombre);
            ps.setInt(2, idPersona);
            ps.setString(3, periodoNombre);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                MateriaMD m = new MateriaMD();
                m.setNombre(res.getString(2));
                MS.add(m);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar materias. " + e.getMessage());
        }
        finally {
            this.CON.cerrarCONPS(ps);
        }
        return MS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MateriaMD> getMateriasSinSilabo(String cedulaDocente, int idPeriodo) {
        String SELECT = "WITH mis_materias AS (\n\tSELECT\n\t\t\"Materias\".id_materia,\n\t\t\"Materias\".materia_nombre \nFROM\n\t\"Cursos\"\n\tINNER JOIN \"Materias\" ON \"Materias\".id_materia = \"Cursos\".id_materia\n\tINNER JOIN \"Docentes\" ON \"Docentes\".id_docente = \"Cursos\".id_docente\nWHERE\n\t\t\"Docentes\".docente_codigo = '" + cedulaDocente + "' \n\t\tAND \"Cursos\".id_prd_lectivo = " + idPeriodo + "\n\t) \nSELECT DISTINCT\n\tmis_materias.id_materia,\n\tmis_materias.materia_nombre \nFROM\n\tmis_materias \nWHERE\n\tmis_materias.id_materia NOT IN (\n\tSELECT DISTINCT\n\t\t\"Silabo\".id_materia \n\tFROM\n\t\t\"Silabo\"\n\t\tINNER JOIN mis_materias ON \"Silabo\".id_materia = mis_materias.id_materia \n\tAND \"Silabo\".id_prd_lectivo = ( \n        SELECT \n            id_prd_lectivo \n        FROM \n            \"PeriodoLectivo\"\n        WHERE \n            id_prd_lectivo = " + idPeriodo + " \n        ORDER BY prd_lectivo_fecha_inicio DESC \n        LIMIT 1 \n    ) \n);;";
        ResultSet rs = this.CON.ejecutarQuery(SELECT);
        ArrayList<MateriaMD> materias = new ArrayList<MateriaMD>();
        try {
            while (rs.next()) {
                MateriaMD materia = new MateriaMD();
                materia.setId(rs.getInt("id_materia"));
                materia.setNombre(rs.getString("materia_nombre"));
                materias.add(materia);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWMateriaBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.CON.close(rs);
        }
        return materias;
    }
}

