/*
 * Decompiled with CFR 0.152.
 */
package modelo.silabo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import modelo.ConnDBPool;
import modelo.carrera.CarreraMD;
import modelo.curso.CursoMD;
import modelo.materia.MateriaMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.DocenteMD;
import modelo.silabo.CursoMDS;
import modelo.silabo.SilaboMD;
import modelo.silabo.mbd.ICursoBD;
import utils.CONS;

public class NEWCursoBD
implements ICursoBD {
    private final ConnDBPool CON = ConnDBPool.single();
    private static NEWCursoBD CBD;

    public static NEWCursoBD single() {
        if (CBD == null) {
            CBD = new NEWCursoBD();
        }
        return CBD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CursoMD> getDocentePeriodoMateria(String nombreMateria, int idDocente, int idPeriodo) {
        String sql = "SELECT DISTINCT c.id_curso,c.curso_nombre FROM public.\"Cursos\" c JOIN public.\"Docentes\" d ON c.id_docente = d.id_docente JOIN public.\"Personas\" p ON d.id_persona = p.id_persona JOIN public.\"Materias\" m on c.id_materia = m.id_materia\nWHERE p.id_persona=? AND c.id_prd_lectivo = ? AND m.materia_nombre=?";
        PreparedStatement ps = this.CON.getPSPOOL(sql);
        ArrayList<CursoMD> CS = new ArrayList<CursoMD>();
        try {
            ps.setInt(1, idDocente);
            ps.setInt(2, idPeriodo);
            ps.setString(3, nombreMateria);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                CursoMD cur = new CursoMD();
                cur.setId(res.getInt(1));
                cur.setNombre(res.getString(2));
                CS.add(cur);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar cursos por periodo . " + e.getMessage());
        }
        finally {
            this.CON.cerrarCONPS(ps);
        }
        return CS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumeroAlumnos(int idCurso) {
        int num = 0;
        String sql = "SELECT count(id_alumno) FROM public.\"AlumnoCurso\" WHERE id_curso = ?;";
        PreparedStatement ps = this.CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idCurso);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                num = res.getInt(1);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar numero de alumnos. " + e.getMessage());
        }
        finally {
            this.CON.cerrarCONPS(ps);
        }
        return num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CursoMDS> getByCurso(int idCurso) {
        String sql = "";
        ArrayList<CursoMDS> CS = new ArrayList<CursoMDS>();
        PreparedStatement ps = this.CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idCurso);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                CursoMDS c = new CursoMDS();
                c.getId_carrera().setNombre(res.getString(1));
                c.getId_materia().setNombre(res.getString(2));
                c.getId_materia().setCodigo(res.getString(3));
                c.setCurso_nombre(res.getString(4));
                c.getId_persona().setPrimerNombre(res.getString(5));
                c.getId_persona().setPrimerApellido(res.getString(6));
                CS.add(c);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar curso para silabo. " + e.getMessage());
        }
        finally {
            this.CON.cerrarCONPS(ps);
        }
        return CS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CursoMD> getFaltantesSeguimientoEval(SilaboMD silabo, int idUnidad) {
        String SELECT = "WITH mis_cursos AS (\n\tSELECT\n\t\t\"Cursos\".id_curso,\n\t\t\"Cursos\".curso_nombre \n\tFROM\n\t\t\"Cursos\"\n\t\tINNER JOIN \"Docentes\" ON \"Docentes\".id_docente = \"Cursos\".id_docente \n\tWHERE\n\t\t\"Docentes\".docente_codigo = '" + CONS.USUARIO.getPersona().getIdentificacion() + "' \n\t\tAND \"Cursos\".id_prd_lectivo = " + silabo.getPeriodo().getID() + " \n\t\tAND \"Cursos\".id_materia = " + silabo.getMateria().getId() + " \n\t) \nSELECT\n    mis_cursos.id_curso,\n    mis_cursos.curso_nombre\nFROM\n    mis_cursos \nWHERE\n    mis_cursos.id_curso NOT IN ( \n        SELECT DISTINCT \n            \"SeguimientoEvaluacion\".id_curso \n        FROM \n            \"SeguimientoEvaluacion\" \n            INNER JOIN mis_cursos ON mis_cursos.id_curso = \"SeguimientoEvaluacion\".id_curso \n            INNER JOIN \"EvaluacionSilabo\" ON \"EvaluacionSilabo\".id_evaluacion =  \"SeguimientoEvaluacion\".id_evaluacion\t\n        WHERE\n            \"EvaluacionSilabo\".id_unidad = " + idUnidad + "\n    )";
        System.out.println(SELECT);
        ArrayList<CursoMD> lista = new ArrayList<CursoMD>();
        ResultSet rs = this.CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                CursoMD curso = new CursoMD();
                curso.setId(rs.getInt("id_curso"));
                curso.setNombre(rs.getString("curso_nombre"));
                lista.add(curso);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWCursoBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.CON.close(rs);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CursoMD> getDeReferenciaSeguimientoEval(int idUnidad) {
        String SELECT = "SELECT DISTINCT\n\t\"Cursos\".id_curso,\n\t\"Cursos\".curso_nombre \nFROM\n\t\"SeguimientoEvaluacion\"\n\tINNER JOIN \"EvaluacionSilabo\" ON \"EvaluacionSilabo\".id_evaluacion = \"SeguimientoEvaluacion\".id_evaluacion\n\tINNER JOIN \"Cursos\" ON \"Cursos\".id_curso = \"SeguimientoEvaluacion\".id_curso \nWHERE\n\tid_unidad = " + idUnidad + "";
        ArrayList<CursoMD> lista = new ArrayList<CursoMD>();
        ResultSet rs = this.CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                CursoMD curso = new CursoMD();
                curso.setId(rs.getInt("id_curso"));
                curso.setNombre(rs.getString("curso_nombre"));
                lista.add(curso);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWCursoBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.CON.close(rs);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CursoMD> getMisCursosBy(String cedulaDocente, int idPeriodo, int idMateria) {
        String SELECT = "SELECT\n\t\"Cursos\".id_curso,\n\t\"Cursos\".curso_nombre \nFROM\n\t\"Cursos\"\n\tINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente \nWHERE\n\t\"Docentes\".docente_codigo = '" + cedulaDocente + "' \n\tAND \"Cursos\".id_prd_lectivo = " + idPeriodo + " \n\tAND \"Cursos\".id_materia = " + idMateria + "";
        ArrayList<CursoMD> lista = new ArrayList<CursoMD>();
        ResultSet rs = this.CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                CursoMD curso = new CursoMD();
                curso.setId(rs.getInt("id_curso"));
                curso.setNombre(rs.getString("curso_nombre"));
                lista.add(curso);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWCursoBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.CON.close(rs);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CursoMD> getCursosMateriasBy(String periodo, int idPersona) {
        String SELECT = "SELECT\n     \"Cursos\".curso_nombre,\n     \"Cursos\".id_curso,\n     \"Materias\".id_materia,\n     \"Materias\".materia_nombre,\n     \"Materias\".materia_codigo,\n     \"PeriodoLectivo\".id_prd_lectivo,\n     \"PeriodoLectivo\".prd_lectivo_nombre,\n     \"Personas\".persona_identificacion,\n     \"Personas\".persona_primer_apellido,\n     \"Personas\".persona_segundo_apellido,\n     \"Personas\".persona_primer_nombre,\n     \"Personas\".persona_segundo_nombre,\n     \"PeriodoLectivo\".id_prd_lectivo,\n     \"Carreras\".carrera_nombre,\n     \"Carreras\".id_carrera\nFROM\n     \"Cursos\"\n     INNER JOIN \"Materias\" ON \"Cursos\".id_materia = \"Materias\".id_materia\n     INNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente\n     INNER JOIN \"PeriodoLectivo\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n     INNER JOIN \"Personas\" ON \"Docentes\".id_persona = \"Personas\".id_persona\n     INNER JOIN \"Carreras\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera\nWHERE\n\t\"PeriodoLectivo\".prd_lectivo_nombre = '" + periodo + "' \n\tAND \"Docentes\".id_persona = " + idPersona + "\nORDER BY \"Cursos\".curso_nombre, \"Materias\".materia_nombre";
        ArrayList<CursoMD> cursos = new ArrayList<CursoMD>();
        ResultSet rs = this.CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                MateriaMD materiaMD = new MateriaMD();
                materiaMD.setId(rs.getInt("id_materia"));
                materiaMD.setNombre(rs.getString("materia_nombre"));
                materiaMD.setCodigo(rs.getString("materia_codigo"));
                DocenteMD docenteMD = new DocenteMD();
                docenteMD.setIdentificacion(rs.getString("persona_identificacion"));
                docenteMD.setPrimerNombre(rs.getString("persona_primer_nombre"));
                docenteMD.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                docenteMD.setPrimerApellido(rs.getString("persona_primer_apellido"));
                docenteMD.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                CarreraMD carreraMD = new CarreraMD();
                carreraMD.setId(rs.getInt("id_carrera"));
                carreraMD.setNombre(rs.getString("carrera_nombre"));
                PeriodoLectivoMD periodoLectivoMD = new PeriodoLectivoMD();
                periodoLectivoMD.setID(rs.getInt("id_prd_lectivo"));
                periodoLectivoMD.setNombre(rs.getString("prd_lectivo_nombre"));
                periodoLectivoMD.setCarrera(carreraMD);
                CursoMD cursoMD = new CursoMD();
                cursoMD.setId(rs.getInt("id_curso"));
                cursoMD.setNombre(rs.getString("curso_nombre"));
                cursoMD.setMateria(materiaMD);
                cursoMD.setDocente(docenteMD);
                cursoMD.setPeriodo(periodoLectivoMD);
                cursos.add(cursoMD);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(NEWCursoBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.CON.close(rs);
        }
        return cursos;
    }
}

