/*
 * Decompiled with CFR 0.152.
 */
package modelo.silabo;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.ConnDBPool;
import modelo.carrera.CarreraMD;
import modelo.silabo.mbd.ICarreraBD;

public class NEWCarreraBD
implements ICarreraBD {
    private final ConnDBPool CON = ConnDBPool.single();
    private static NEWCarreraBD CBD;

    public static NEWCarreraBD single() {
        if (CBD == null) {
            CBD = new NEWCarreraBD();
        }
        return CBD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CarreraMD> getByUsername(String username) {
        String sql = "SELECT DISTINCT crr.id_carrera, crr.carrera_nombre FROM \"Materias\" AS m JOIN \"Cursos\" AS crs ON m.id_materia=crs.id_materia\nJOIN \"Docentes\" AS d ON d.id_docente=crs.id_docente\nJOIN \"Personas\" AS p ON p.id_persona=d.id_persona\nJOIN \"Usuarios\" AS u ON u.id_persona=p.id_persona\nJOIN \"Carreras\" AS crr ON crr.id_carrera = m.id_carrera\nJOIN \"PeriodoLectivo\" AS pr ON pr.id_carrera=crr.id_carrera\nWHERE usu_username=? ";
        ArrayList<CarreraMD> CS = new ArrayList<CarreraMD>();
        PreparedStatement ps = this.CON.getPSPOOL(sql);
        try {
            ps.setString(1, username);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                CarreraMD c = new CarreraMD();
                c.setId(res.getInt(1));
                c.setNombre(res.getString(2));
                CS.add(c);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "No consultamos carreras por username. \n" + e.getMessage(), "Error al consultar", 0);
        }
        finally {
            this.CON.cerrarCONPS(ps);
        }
        return CS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getModalidadByCurso(int idCurso) {
        String sql = "SELECT carrera_modalidad\nFROM \"Carreras\"\nWHERE id_carrera = (\n  SELECT id_carrera\n  FROM \"PeriodoLectivo\"\n  WHERE id_prd_lectivo = (\n    SELECT id_prd_lectivo FROM \"Cursos\"\n    WHERE id_curso = ?\n  )\n);";
        String m = "";
        PreparedStatement ps = this.CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idCurso);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                m = res.getString(1);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "No modalidad por curso. \n" + e.getMessage(), "Error al consultar", 0);
        }
        finally {
            this.CON.cerrarCONPS(ps);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CarreraMD getByCoordinador(String username) {
        String sql = "SELECT c.id_carrera, c.carrera_nombre FROM \"Carreras\" c JOIN \"Docentes\" d ON c.id_docente_coordinador=d.id_docente\nJOIN \"Personas\" p ON p.id_persona=d.id_persona\nJOIN \"Usuarios\" u ON u.id_persona=p.id_persona\nWHERE u.usu_username = ?;";
        CarreraMD c = null;
        PreparedStatement ps = this.CON.getPSPOOL(sql);
        try {
            ps.setString(1, username);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                c = new CarreraMD();
                c.setId(res.getInt(1));
                c.setNombre(res.getString(2));
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "No obtuvimos al coordinador.\n" + e.getMessage(), "Error al consultar", 0);
        }
        finally {
            this.CON.cerrarCONPS(ps);
        }
        return c;
    }
}

