/*
 * Decompiled with CFR 0.152.
 */
package modelo.seguimientoSilabo;

import controlador.Libraries.Middlewares;
import java.time.LocalDateTime;
import modelo.curso.CursoMD;
import modelo.evaluacionSilabo.EvaluacionSilaboMD;

public class SeguimientoEvaluacionMD {
    private Integer ID;
    private Integer formato;
    private String observacion;
    private LocalDateTime fechaEdicion;
    private LocalDateTime fechaCreacion;
    private CursoMD curso;
    private EvaluacionSilaboMD evaluacion;
    public static Integer FISICO = 0;
    public static Integer DIGITAL = 1;

    public Integer getID() {
        return this.ID;
    }

    public void setID(Integer ID) {
        this.ID = ID;
    }

    public Integer getFormato() {
        return this.formato;
    }

    public void setFormato(Integer formato) {
        this.formato = formato;
    }

    public String getObservacion() {
        return this.observacion;
    }

    public void setObservacion(String observacion) {
        this.observacion = observacion;
    }

    public LocalDateTime getFechaEdicion() {
        return this.fechaEdicion;
    }

    public void setFechaEdicion(LocalDateTime fechaEdicion) {
        this.fechaEdicion = fechaEdicion;
    }

    public LocalDateTime getFechaCreacion() {
        return this.fechaCreacion;
    }

    public void setFechaCreacion(LocalDateTime fechaCreacion) {
        this.fechaCreacion = fechaCreacion;
    }

    public CursoMD getCurso() {
        return this.curso;
    }

    public void setCurso(CursoMD curso) {
        this.curso = curso;
    }

    public EvaluacionSilaboMD getEvaluacion() {
        return this.evaluacion;
    }

    public String getTxtAreaDescripcion() {
        return "        DESCRIPCI\u00d3N     \n-UNIDAD " + this.evaluacion.getIdUnidad().getNumeroUnidad() + "\n     " + this.evaluacion.getIdUnidad().getTituloUnidad() + "\n\nCURSO:\n     " + this.curso.getNombre() + "\n\nEVALUACI\u00d3N:\n -Indicador:\n    " + this.evaluacion.getIndicador() + "\n -Instrumento:\n    " + this.evaluacion.getInstrumento() + "\n -Valoraci\u00f3n:\n    " + this.evaluacion.getValoracion() + "\n\nGESTI\u00d3N ACADEMICA:\n -Formato:\n    " + SeguimientoEvaluacionMD.formatoToString(this.formato) + "\n -Observaciones:\n    " + this.observacion + "\n\n -Fecha de Creaci\u00f3n:\n    " + Middlewares.simpleDateFormat(this.fechaCreacion) + "\n -Ultima Edici\u00f3n:\n    " + Middlewares.simpleDateFormat(this.fechaEdicion) + "";
    }

    public void setEvaluacion(EvaluacionSilaboMD evaluacion) {
        this.evaluacion = evaluacion;
    }

    public static String formatoToString(Integer formato) {
        if (formato.equals(FISICO)) {
            return "F\u00cdSICO";
        }
        if (formato.equals(DIGITAL)) {
            return "DIGITAL";
        }
        return "";
    }

    public static int formatoToInt(String formato) {
        if (formato.equalsIgnoreCase("F\u00cdSICO")) {
            return 0;
        }
        if (formato.equalsIgnoreCase("DIGITAL")) {
            return 1;
        }
        return 1;
    }

    public String getNombreCmb() {
        return this.ID + "| " + this.evaluacion.getInstrumento();
    }

    public String toString() {
        return "SeguimientoEvaluacionMD{ID=" + this.ID + ", formato=" + this.formato + ", observacion=" + this.observacion + ", fechaEdicion=" + this.fechaEdicion + ", fechaCreacion=" + this.fechaCreacion + ", curso=" + this.curso + ", evaluacion=" + this.evaluacion + '}';
    }
}

