/*
 * Decompiled with CFR 0.152.
 */
package modelo.seguimientoSilabo;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import modelo.ConnDBPool;
import modelo.curso.CursoMD;
import modelo.evaluacionSilabo.EvaluacionSilaboMD;
import modelo.seguimientoSilabo.SeguimientoEvaluacionMD;
import modelo.tipoActividad.TipoActividadMD;
import modelo.unidadSilabo.UnidadSilaboMD;

public class SeguimientoEvaluacionBD {
    private final ConnDBPool CON = ConnDBPool.single();
    private static SeguimientoEvaluacionBD THIS;

    private SeguimientoEvaluacionBD() {
    }

    public static SeguimientoEvaluacionBD sigle() {
        if (THIS == null) {
            THIS = new SeguimientoEvaluacionBD();
        }
        return THIS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SeguimientoEvaluacionMD insert(SeguimientoEvaluacionMD object) {
        String INSERT = "INSERT INTO \"SeguimientoEvaluacion\" ( \"id_curso\", \"id_evaluacion\", \"formato\", \"observacion\" )\nVALUES\n\t(          " + object.getCurso().getId() + ",  \n         " + object.getEvaluacion().getIdEvaluacion() + ",  \n         " + object.getFormato() + ",  \n         '" + object.getObservacion() + "'   \n     )       \n RETURNING \"id\";";
        ResultSet rs = this.CON.ejecutarQuery(INSERT);
        try {
            while (rs.next()) {
                object.setID(rs.getInt("id"));
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SeguimientoEvaluacionBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.CON.close(rs);
        }
        return object;
    }

    public boolean copiarSeguimientos(int idCurso, int idUnidad, int idCursoRef) {
        String CALL = "CALL \"copiar_seguimientos_eval\" ( " + idCurso + "," + idUnidad + " , " + idCursoRef + ");";
        return this.CON.ejecutar(CALL) != null;
    }

    public boolean crearSeguimientos(int idUnidad, int idCurso) {
        String CALL = "CALL \"crear_seguimienntos_evaluaciones\"(" + idUnidad + " ," + idCurso + ")";
        return this.CON.ejecutar(CALL) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SeguimientoEvaluacionMD> getSeguimientosBy(int idCurso, int idUnidad) {
        String SELECT = "SELECT\n\t\"SeguimientoEvaluacion\".\"id\",\n\t\"SeguimientoEvaluacion\".formato,\n\t\"SeguimientoEvaluacion\".observacion,\n\t\"SeguimientoEvaluacion\".feha_creacion,\n\t\"SeguimientoEvaluacion\".fecha_edicion,\n\t\"SeguimientoEvaluacion\".id_evaluacion,\n\t\"EvaluacionSilabo\".indicador,\n\t\"EvaluacionSilabo\".instrumento,\n\t\"EvaluacionSilabo\".valoracion,\n\t\"Cursos\".id_curso,\n\t\"Cursos\".curso_nombre,\n\t\"UnidadSilabo\".id_unidad,\n\t\"UnidadSilabo\".numero_unidad,\n\t\"UnidadSilabo\".titulo_unidad, \n\t\"TipoActividad\".nombre_tipo_actividad,\n\t\"TipoActividad\".nombre_subtipo_actividad \nFROM\n\t\"SeguimientoEvaluacion\"\n\tINNER JOIN \"EvaluacionSilabo\" ON \"SeguimientoEvaluacion\".id_evaluacion = \"EvaluacionSilabo\".id_evaluacion\n\tINNER JOIN \"Cursos\" ON \"SeguimientoEvaluacion\".id_curso = \"Cursos\".id_curso\n\tINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente\n\tINNER JOIN \"UnidadSilabo\" ON \"EvaluacionSilabo\".id_unidad = \"UnidadSilabo\".id_unidad \n\tINNER JOIN \"TipoActividad\" ON \"TipoActividad\".id_tipo_actividad = \"EvaluacionSilabo\".id_tipo_actividad\nWHERE\n\t\"Cursos\".id_curso = " + idCurso + "\n     AND \"UnidadSilabo\".id_unidad = " + idUnidad + "";
        ArrayList<SeguimientoEvaluacionMD> lista = new ArrayList<SeguimientoEvaluacionMD>();
        ResultSet rs = this.CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                SeguimientoEvaluacionMD seguimiento = new SeguimientoEvaluacionMD();
                seguimiento.setID(rs.getInt("id"));
                seguimiento.setFormato(rs.getInt("formato"));
                seguimiento.setObservacion(rs.getString("observacion"));
                seguimiento.setFechaCreacion(rs.getTimestamp("feha_creacion").toLocalDateTime());
                seguimiento.setFechaEdicion(rs.getTimestamp("fecha_edicion").toLocalDateTime());
                CursoMD curso = new CursoMD();
                curso.setId(rs.getInt("id_curso"));
                curso.setNombre(rs.getString("curso_nombre"));
                seguimiento.setCurso(curso);
                EvaluacionSilaboMD evaluacion = new EvaluacionSilaboMD();
                evaluacion.setIdEvaluacion(rs.getInt("id_evaluacion"));
                evaluacion.setInstrumento(rs.getString("instrumento"));
                evaluacion.setIndicador(rs.getString("indicador"));
                evaluacion.setValoracion(rs.getDouble("valoracion"));
                UnidadSilaboMD unidad = new UnidadSilaboMD();
                unidad.setId(rs.getInt("id_unidad"));
                unidad.setNumeroUnidad(rs.getInt("numero_unidad"));
                unidad.setTituloUnidad(rs.getString("titulo_unidad"));
                TipoActividadMD tipo = new TipoActividadMD();
                tipo.setNombreTipoActividad(rs.getString("nombre_tipo_actividad"));
                tipo.setNombreSubtipoActividad(rs.getString("nombre_subtipo_actividad"));
                evaluacion.setIdTipoActividad(tipo);
                evaluacion.setIdUnidad(unidad);
                seguimiento.setEvaluacion(evaluacion);
                lista.add(seguimiento);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(SeguimientoEvaluacionBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            this.CON.close(rs);
        }
        return lista;
    }

    public boolean editar(SeguimientoEvaluacionMD seguimiento) {
        String UPDATE = "UPDATE \"SeguimientoEvaluacion\" \nSET \n     \"formato\" = " + seguimiento.getFormato() + ",\n     \"observacion\" = '" + seguimiento.getObservacion() + "', \n     \"fecha_edicion\" = '" + Timestamp.valueOf(LocalDateTime.now()) + "'WHERE\n\t\"id\" = " + seguimiento.getID() + "";
        return this.CON.ejecutar(UPDATE) == null;
    }
}

