/*
 * Decompiled with CFR 0.152.
 */
package modelo.persona;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.alumno.MallaAlumnoMD;
import modelo.materia.MateriaMD;
import modelo.persona.AlumnoMD;
import modelo.persona.PersonaMD;
import modelo.persona.ProfesionMD;
import modelo.persona.SectorEconomicoMD;
import utils.CONBD;
import utils.M;

public class AlumnoBD
extends CONBD {
    private static AlumnoBD ABD;

    public static AlumnoBD single() {
        if (ABD == null) {
            ABD = new AlumnoBD();
        }
        return ABD;
    }

    public boolean guardarAlumno(AlumnoMD a, SectorEconomicoMD s) {
        String nsql = "INSERT INTO public.\"Alumnos\"(\nid_persona, id_sec_economico, alumno_codigo, alumno_tipo_colegio, alumno_tipo_bachillerato, alumno_anio_graduacion, alumno_educacion_superior, alumno_titulo_superior, alumno_nivel_academico, alumno_pension, alumno_ocupacion, alumno_trabaja, alumno_nivel_formacion_padre, alumno_nivel_formacion_madre, alumno_nombre_contacto_emergencia, alumno_parentesco_contacto, alumno_numero_contacto, alumno_activo) VALUES ( " + a.getIdPersona() + ", " + s.getId_SecEconomico() + ", '" + a.getIdentificacion() + "', '" + a.getTipo_Colegio() + "', '" + a.getTipo_Bachillerato() + "', '" + a.getAnio_graduacion() + "', " + a.isEducacion_Superior() + ", '" + a.getTitulo_Superior() + "', null, " + a.isPension() + ", '" + a.getOcupacion() + "', " + a.isTrabaja() + ", '" + a.getFormacion_Padre() + "', '" + a.getFormacion_Madre() + "',  '" + a.getNom_Contacto() + "', '" + a.getParentesco_Contacto() + "', '" + a.getContacto_Emergencia() + "', true );";
        return CON.executeNoSQL(nsql);
    }

    public boolean guardarTitulo(ProfesionMD p) {
        String nsql = "INSERT INTO public.\"Profesiones\"( titulo_nombre, titulo_abrev, titulo_institucion, titulo_estado)  VALUES ( '" + p.getTitulo_nombre() + "', '" + p.getTitulo_abreviatura() + "', '" + p.getTitulo_institucion() + "',  true);";
        return CON.executeNoSQL(nsql);
    }

    public boolean guardarTituloAuxiliar(ProfesionMD p, int id) {
        String nsql = "INSERT INTO public.\"PersonaProfesiones\"(\n\t id_persona, id_titulo, persona_profesion_observacion)\n\tVALUES ( " + id + ", " + p.getId_Titulo() + ", '" + p.getTitulo_observacion() + "');";
        return CON.executeNoSQL(nsql);
    }

    public boolean editarAlumno(AlumnoMD a, int aguja) {
        String nsql = "UPDATE public.\"Alumnos\" SET\n id_sec_economico = " + a.getSectorEconomico().getId_SecEconomico() + ", alumno_tipo_colegio = '" + a.getTipo_Colegio() + "', alumno_tipo_bachillerato = '" + a.getTipo_Bachillerato() + "', alumno_anio_graduacion = '" + a.getAnio_graduacion() + "', alumno_educacion_superior = " + a.isEducacion_Superior() + ", alumno_titulo_superior = '" + a.getTitulo_Superior() + "', alumno_nivel_academico = null, alumno_pension = " + a.isPension() + ", alumno_ocupacion = '" + a.getOcupacion() + "', alumno_trabaja = " + a.isTrabaja() + ", alumno_nivel_formacion_padre = '" + a.getFormacion_Padre() + "', alumno_nivel_formacion_madre = '" + a.getFormacion_Madre() + "', alumno_nombre_contacto_emergencia = '" + a.getNom_Contacto() + "', alumno_parentesco_contacto = '" + a.getParentesco_Contacto() + "', alumno_numero_contacto = '" + a.getContacto_Emergencia() + "'  WHERE id_persona = " + aguja + ";";
        return CON.executeNoSQL(nsql);
    }

    public boolean eliminarAlumno(AlumnoMD a, int aguja) {
        String nsql = "UPDATE public.\"Alumnos\" SET\n alumno_activo = false, alumno_observacion = '" + a.getObservacion() + "' WHERE id_persona = " + aguja + ";";
        return CON.executeNoSQL(nsql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfesionMD idProfesion(String nombre) {
        String sql = "SELECT id_titulo FROM public.\"Profesiones\" WHERE titulo_nombre LIKE '" + nombre + "';";
        PreparedStatement ps = CON.getPSPOOL(sql);
        ProfesionMD p = new ProfesionMD();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                p.setId_Titulo(rs.getInt("id_titulo"));
            }
            ProfesionMD profesionMD = p;
            return profesionMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No consultamos profesion. " + ex.getMessage());
            ProfesionMD profesionMD = null;
            return profesionMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfesionMD existeProfesion(int idPersona) {
        String sql = "SELECT id_titulo FROM public.\"PersonaProfesiones\" WHERE id_persona = " + idPersona + ";";
        PreparedStatement ps = CON.getPSPOOL(sql);
        ProfesionMD p = new ProfesionMD();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                p.setId_Titulo(rs.getInt("id_titulo"));
            }
            ProfesionMD profesionMD = p;
            return profesionMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No consultamos profesion. " + ex.getMessage());
            ProfesionMD profesionMD = null;
            return profesionMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProfesionMD capturarProfesiones(int id_persona) {
        String sql = "SELECT p.titulo_nombre, p.titulo_abrev FROM public.\"Profesiones\" p JOIN public.\"PersonaProfesiones\" a USING(id_titulo) WHERE a.id_persona = " + id_persona + ";";
        PreparedStatement ps = CON.getPSPOOL(sql);
        ProfesionMD p = new ProfesionMD();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                p.setTitulo_nombre(rs.getString("titulo_nombre"));
                p.setTitulo_abreviatura(rs.getString("titulo_abrev"));
            }
            ProfesionMD profesionMD = p;
            return profesionMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No consultamos profesion. " + ex.getMessage());
            ProfesionMD profesionMD = null;
            return profesionMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AlumnoMD> llenarTabla() {
        ArrayList<AlumnoMD> lista = new ArrayList<AlumnoMD>();
        String sql = "SELECT p.id_persona, p.persona_identificacion, p.persona_primer_nombre, p.persona_segundo_nombre, p.persona_primer_apellido, p.persona_segundo_apellido, p.persona_correo FROM public.\"Personas\" p JOIN public.\"Alumnos\" a USING(id_persona) WHERE a.alumno_activo = 'true' AND p.persona_activa = 'true' ORDER BY p.persona_primer_apellido ASC;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AlumnoMD m = new AlumnoMD();
                m.setIdPersona(rs.getInt("id_persona"));
                m.setIdentificacion(rs.getString("persona_identificacion"));
                m.setPrimerNombre(rs.getString("persona_primer_nombre"));
                m.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                m.setPrimerApellido(rs.getString("persona_primer_apellido"));
                m.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                m.setCorreo(rs.getString("persona_correo"));
                lista.add(m);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("Error al consultar para tabla alumnos: " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersonaMD> capturarPersona(String aguja) {
        ArrayList<PersonaMD> lista = new ArrayList<PersonaMD>();
        String sql = "SELECT p.id_persona, p.persona_identificacion, p.persona_primer_nombre, p.persona_segundo_nombre, p.persona_primer_apellido, p.persona_segundo_apellido, p.persona_correo FROM public.\"Personas\" p JOIN public.\"Alumnos\" a USING(id_persona) WHERE (p.persona_identificacion LIKE '%" + aguja + "%' OR  p.persona_primer_nombre LIKE '%" + aguja + "%' OR p.persona_segundo_nombre LIKE '%" + aguja + "%' OR p.persona_primer_apellido LIKE '%" + aguja + "%' OR p.persona_segundo_apellido LIKE '%" + aguja + "%' OR p.persona_correo LIKE '%" + aguja + "%') AND p.persona_activa = true AND a.alumno_activo = true;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PersonaMD m = new PersonaMD();
                m.setIdPersona(rs.getInt("id_persona"));
                m.setIdentificacion(rs.getString("persona_identificacion"));
                m.setPrimerNombre(rs.getString("persona_primer_nombre"));
                m.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                m.setPrimerApellido(rs.getString("persona_primer_apellido"));
                m.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                m.setCorreo(rs.getString("persona_correo"));
                lista.add(m);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("Error al consultar para tabla alumnos: " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersonaMD filtrarPersona(String aguja) {
        String sql = "SELECT id_persona, persona_identificacion, persona_primer_nombre, persona_segundo_nombre, persona_primer_apellido, persona_segundo_apellido FROM public.\"Personas\" WHERE persona_identificacion LIKE '%" + aguja + "%' AND persona_activa = true;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        PersonaMD m = new PersonaMD();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                m.setIdPersona(rs.getInt("id_persona"));
                m.setIdentificacion(rs.getString("persona_identificacion"));
                m.setPrimerNombre(rs.getString("persona_primer_nombre"));
                m.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                m.setPrimerApellido(rs.getString("persona_primer_apellido"));
                m.setSegundoApellido(rs.getString("persona_segundo_apellido"));
            }
            PersonaMD personaMD = m;
            return personaMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos realizar la consulta. " + ex.getMessage());
            PersonaMD personaMD = null;
            return personaMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PersonaMD> llenarEliminados() {
        String nsql = "SELECT p.id_persona, p.persona_identificacion, p.persona_primer_nombre, p.persona_segundo_nombre, p.persona_primer_apellido, p.persona_segundo_apellido, p.persona_correo FROM public.\"Personas\" p JOIN public.\"Alumnos\" USING(id_persona) WHERE persona_activa = 'false';";
        ArrayList<PersonaMD> lista = new ArrayList<PersonaMD>();
        PreparedStatement ps = CON.getPSPOOL(nsql);
        PersonaMD m = new PersonaMD();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                m.setIdPersona(rs.getInt("id_persona"));
                m.setIdentificacion(rs.getString("persona_identificacion"));
                m.setPrimerNombre(rs.getString("persona_primer_nombre"));
                m.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                m.setPrimerApellido(rs.getString("persona_primer_apellido"));
                m.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                lista.add(m);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos realizar la consulta. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlumnoMD buscarPersona(int aguja) {
        String sql = "SELECT p.id_persona, p.persona_identificacion, p.persona_primer_nombre, p.persona_segundo_nombre, p.persona_primer_apellido, p.persona_segundo_apellido, a.id_alumno, a.id_sec_economico, a.alumno_tipo_colegio, a.alumno_tipo_bachillerato, a.alumno_anio_graduacion, a.alumno_educacion_superior, a.alumno_titulo_superior, a.alumno_nivel_academico, a.alumno_pension, a.alumno_ocupacion, a.alumno_trabaja, a.alumno_nivel_formacion_padre, a.alumno_nivel_formacion_madre, a.alumno_numero_contacto, a.alumno_nombre_contacto_emergencia, a.alumno_parentesco_contacto FROM public.\"Personas\" p JOIN public.\"Alumnos\" a USING(id_persona) WHERE a.id_persona = " + aguja + " AND a.alumno_activo = true AND p.persona_activa = true;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            AlumnoMD a = new AlumnoMD();
            while (rs.next()) {
                SectorEconomicoMD sector = new SectorEconomicoMD();
                a.setIdPersona(rs.getInt("id_persona"));
                a.setIdentificacion(rs.getString("persona_identificacion"));
                a.setPrimerNombre(rs.getString("persona_primer_nombre"));
                a.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                a.setPrimerApellido(rs.getString("persona_primer_apellido"));
                a.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                Integer numero = rs.getInt("id_alumno");
                if (numero == 0) {
                    a.setId_Alumno(0);
                } else {
                    a.setId_Alumno(numero);
                }
                numero = rs.getInt("id_sec_economico");
                if (numero == 0) {
                    sector.setId_SecEconomico(0);
                    a.setSectorEconomico(sector);
                } else {
                    sector.setId_SecEconomico(numero);
                    a.setSectorEconomico(sector);
                }
                String palabra = rs.getString("alumno_tipo_colegio");
                if (palabra == null) {
                    a.setTipo_Colegio("|SELECCIONE|");
                } else {
                    a.setTipo_Colegio(rs.getString("alumno_tipo_colegio"));
                }
                palabra = rs.getString("alumno_tipo_bachillerato");
                if (palabra == null) {
                    a.setTipo_Bachillerato("|SELECCIONE|");
                } else {
                    a.setTipo_Bachillerato(palabra);
                }
                palabra = rs.getString("alumno_anio_graduacion");
                if (palabra == null) {
                    a.setAnio_graduacion("1980");
                } else {
                    a.setAnio_graduacion(palabra);
                }
                palabra = String.valueOf(rs.getBoolean("alumno_educacion_superior"));
                if (palabra == null) {
                    a.setEducacion_Superior(false);
                } else {
                    a.setEducacion_Superior(rs.getBoolean("alumno_educacion_superior"));
                }
                palabra = rs.getString("alumno_titulo_superior");
                if (palabra == null) {
                    a.setTitulo_Superior(null);
                } else {
                    a.setTitulo_Superior(palabra);
                }
                palabra = rs.getString("alumno_nivel_academico");
                if (palabra == null) {
                    a.setNivel_Academico("|SELECCIONE|");
                } else {
                    a.setNivel_Academico(palabra);
                }
                palabra = String.valueOf(rs.getBoolean("alumno_pension"));
                if (palabra == null) {
                    a.setPension(false);
                } else {
                    a.setPension(rs.getBoolean("alumno_pension"));
                }
                palabra = rs.getString("alumno_ocupacion");
                if (palabra == null) {
                    a.setOcupacion(null);
                } else {
                    a.setOcupacion(palabra);
                }
                palabra = String.valueOf(rs.getBoolean("alumno_trabaja"));
                if (palabra == null) {
                    a.setTrabaja(false);
                } else {
                    a.setTrabaja(rs.getBoolean("alumno_trabaja"));
                }
                palabra = rs.getString("alumno_nivel_formacion_padre");
                if (palabra == null) {
                    a.setFormacion_Padre("|SELECCIONE|");
                } else {
                    a.setFormacion_Padre(palabra);
                }
                palabra = rs.getString("alumno_nivel_formacion_madre");
                if (palabra == null) {
                    a.setFormacion_Madre("|SELECCIONE|");
                } else {
                    a.setFormacion_Madre(palabra);
                }
                palabra = rs.getString("alumno_numero_contacto");
                if (palabra == null) {
                    a.setContacto_Emergencia(null);
                } else {
                    a.setContacto_Emergencia(palabra);
                }
                palabra = rs.getString("alumno_parentesco_contacto");
                if (palabra == null) {
                    a.setParentesco_Contacto("|SELECCIONE|");
                } else {
                    a.setParentesco_Contacto(palabra);
                }
                palabra = rs.getString("alumno_nombre_contacto_emergencia");
                if (palabra == null) {
                    a.setNom_Contacto(null);
                    continue;
                }
                a.setNom_Contacto(palabra);
            }
            AlumnoMD alumnoMD = a;
            return alumnoMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar. " + ex.getMessage());
            AlumnoMD alumnoMD = null;
            return alumnoMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AlumnoMD buscarPersonaxCedula(String cedula) {
        String sql = "SELECT p.id_persona, p.persona_identificacion, p.persona_primer_nombre, p.persona_segundo_nombre, p.persona_primer_apellido, p.persona_segundo_apellido, a.id_alumno, a.id_sec_economico, a.alumno_tipo_colegio, a.alumno_tipo_bachillerato, a.alumno_anio_graduacion, a.alumno_educacion_superior, a.alumno_titulo_superior, a.alumno_nivel_academico, a.alumno_pension, a.alumno_ocupacion, a.alumno_trabaja, a.alumno_nivel_formacion_padre, a.alumno_nivel_formacion_madre, a.alumno_numero_contacto, a.alumno_nombre_contacto_emergencia, a.alumno_parentesco_contacto FROM public.\"Personas\" p JOIN public.\"Alumnos\" a USING(id_persona) WHERE p.persona_identificacion LIKE '" + cedula + "' AND a.alumno_activo = true AND p.persona_activa = true;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            AlumnoMD a = new AlumnoMD();
            while (rs.next()) {
                SectorEconomicoMD sector = new SectorEconomicoMD();
                a.setIdPersona(rs.getInt("id_persona"));
                a.setIdentificacion(rs.getString("persona_identificacion"));
                a.setPrimerNombre(rs.getString("persona_primer_nombre"));
                a.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                a.setPrimerApellido(rs.getString("persona_primer_apellido"));
                a.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                a.setId_Alumno(rs.getInt("id_alumno"));
                System.out.println("Aguja: " + a.getId_Alumno());
                if (rs.wasNull()) {
                    sector.setId_SecEconomico(0);
                    a.setSectorEconomico(sector);
                } else {
                    sector.setId_SecEconomico(rs.getInt("id_sec_economico"));
                    a.setSectorEconomico(sector);
                }
                if (rs.wasNull()) {
                    a.setTipo_Colegio("|SELECCIONE|");
                } else {
                    a.setTipo_Colegio(rs.getString("alumno_tipo_colegio"));
                }
                if (rs.wasNull()) {
                    a.setTipo_Bachillerato("|SELECCIONE|");
                } else {
                    a.setTipo_Bachillerato(rs.getString("alumno_tipo_bachillerato"));
                }
                if (rs.wasNull()) {
                    a.setAnio_graduacion("1980");
                } else {
                    a.setAnio_graduacion(rs.getString("alumno_anio_graduacion"));
                }
                if (rs.wasNull()) {
                    a.setEducacion_Superior(false);
                } else {
                    a.setEducacion_Superior(rs.getBoolean("alumno_educacion_superior"));
                }
                if (rs.wasNull()) {
                    a.setTitulo_Superior(null);
                } else {
                    a.setTitulo_Superior(rs.getString("alumno_titulo_superior"));
                }
                if (rs.wasNull()) {
                    a.setNivel_Academico("|SELECCIONE|");
                } else {
                    a.setNivel_Academico(rs.getString("alumno_nivel_academico"));
                }
                if (rs.wasNull()) {
                    a.setPension(false);
                } else {
                    a.setPension(rs.getBoolean("alumno_pension"));
                }
                if (rs.wasNull()) {
                    a.setOcupacion(null);
                } else {
                    a.setOcupacion(rs.getString("alumno_ocupacion"));
                }
                if (rs.wasNull()) {
                    a.setTrabaja(false);
                } else {
                    a.setTrabaja(rs.getBoolean("alumno_trabaja"));
                }
                if (rs.wasNull()) {
                    a.setFormacion_Padre("|SELECCIONE|");
                } else {
                    a.setFormacion_Padre(rs.getString("alumno_nivel_formacion_padre"));
                }
                if (rs.wasNull()) {
                    a.setFormacion_Madre("|SELECCIONE|");
                } else {
                    a.setFormacion_Madre(rs.getString("alumno_nivel_formacion_madre"));
                }
                if (rs.wasNull()) {
                    a.setContacto_Emergencia(null);
                } else {
                    a.setContacto_Emergencia(rs.getString("alumno_numero_contacto"));
                }
                if (rs.wasNull()) {
                    a.setParentesco_Contacto("|SELECCIONE|");
                } else {
                    a.setParentesco_Contacto(rs.getString("alumno_parentesco_contacto"));
                }
                if (rs.wasNull()) {
                    a.setNom_Contacto(null);
                    continue;
                }
                a.setNom_Contacto(rs.getString("alumno_nombre_contacto_emergencia"));
            }
            AlumnoMD alumnoMD = a;
            return alumnoMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar. " + ex.getMessage());
            AlumnoMD alumnoMD = null;
            return alumnoMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AlumnoMD> filtrarRetirados() {
        String nsql = "SELECT DISTINCT p.id_persona, p.persona_identificacion, p.persona_primer_nombre, p.persona_segundo_nombre, p.persona_primer_apellido, p.persona_segundo_apellido, p.persona_correo, a.id_alumno FROM ((public.\"Personas\" p JOIN public.\"Alumnos\" a USING(id_persona)) JOIN public.\"AlumnosCarrera\" c USING(id_alumno)) JOIN public.\"MallaAlumno\" m USING(id_almn_carrera) WHERE malla_almn_estado LIKE 'A' AND a.alumno_activo = 'true' AND p.persona_activa = 'true' ORDER BY p.persona_primer_apellido ASC;";
        PreparedStatement ps = CON.getPSPOOL(nsql);
        ArrayList<AlumnoMD> lista = new ArrayList<AlumnoMD>();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AlumnoMD m = new AlumnoMD();
                m.setIdPersona(rs.getInt("id_persona"));
                m.setIdentificacion(rs.getString("persona_identificacion"));
                m.setPrimerNombre(rs.getString("persona_primer_nombre"));
                m.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                m.setPrimerApellido(rs.getString("persona_primer_apellido"));
                m.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                m.setCorreo(rs.getString("persona_correo"));
                m.setId_Alumno(rs.getInt("id_alumno"));
                lista.add(m);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar alumnos retirados. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MallaAlumnoMD> consultarMaterias(int ID) {
        ArrayList<MallaAlumnoMD> lista = new ArrayList<MallaAlumnoMD>();
        String sql = "SELECT m.materia_nombre, d.malla_almn_estado FROM ((public.\"Alumnos\" a JOIN public.\"AlumnosCarrera\" c USING(id_alumno)) JOIN public.\"MallaAlumno\" d USING(id_almn_carrera)) JOIN public.\"Materias\" m USING(id_materia) WHERE a.id_persona = " + ID + " AND malla_almn_estado LIKE 'A';";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                MallaAlumnoMD m = new MallaAlumnoMD();
                MateriaMD mat = new MateriaMD();
                mat.setNombre(rs.getString("materia_nombre"));
                m.setMateria(mat);
                m.setEstado(rs.getString("malla_almn_estado"));
                lista.add(m);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No se pudieron consultar materias. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    public ArrayList<AlumnoMD> cargarAlumnos() {
        String sql = "SELECT id_alumno, id_persona\n\tFROM public.\"Alumnos\" WHERE alumno_activo = 'true';";
        return this.consultarAlumnos(sql);
    }

    public ArrayList<AlumnoMD> buscarAlumnos(String aguja) {
        String sql = "SELECT id_alumno, a.id_persona, \npersona_primer_nombre, persona_segundo_nombre,\npersona_primer_apellido, persona_segundo_apellido,\npersona_celular, persona_correo, persona_identificacion\nFROM public.\"Alumnos\" a, public.\"Personas\" p \nWHERE p.id_persona = a.id_persona AND (\n\tpersona_primer_nombre || ' ' || persona_segundo_nombre || ' ' ||\n\tpersona_primer_apellido || ' ' || persona_segundo_apellido ILIKE '%" + aguja + "%' OR      persona_primer_nombre || ' ' || persona_primer_apellido ILIKE '%" + aguja + "%' OR \n\tpersona_identificacion ILIKE '%" + aguja + "%') AND persona_activa = true;";
        return this.consultarAlumnos(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<AlumnoMD> consultarAlumnos(String sql) {
        ArrayList<AlumnoMD> almns = new ArrayList<AlumnoMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    AlumnoMD al = new AlumnoMD();
                    al.setId_Alumno(rs.getInt("id_alumno"));
                    al.setIdPersona(rs.getInt("id_persona"));
                    al.setPrimerNombre(rs.getString("persona_primer_nombre"));
                    al.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                    al.setPrimerApellido(rs.getString("persona_primer_apellido"));
                    al.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                    al.setIdentificacion(rs.getString("persona_identificacion"));
                    almns.add(al);
                }
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No se pudieron consultar alumnos. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return almns;
    }

    public List<List<String>> getAllTable() {
        return this.mapearForTable(this.getBaseQueryTBL(""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> mapearForTable(String sql) {
        PreparedStatement ps = CON.getPSPOOL(sql);
        ArrayList<List<String>> alumnos = new ArrayList<List<String>>();
        try {
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                ArrayList<String> cols = new ArrayList<String>();
                cols.add(res.getInt(1) + "");
                cols.add(res.getString(2));
                cols.add(res.getString(3));
                cols.add(res.getString(4) == null ? "" : res.getString(4));
                cols.add(res.getString(5) == null ? "" : res.getString(5));
                cols.add(res.getString(6) == null ? "" : res.getString(6));
                cols.add(res.getString(7) == null ? "" : res.getString(7));
                cols.add(res.getString(8) == null ? "" : res.getString(8));
                alumnos.add(cols);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "No consultamos alumnos para tabla.\n" + e.getMessage(), "Error al consultar", 0);
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return alumnos;
    }

    private String getBaseQueryTBL(String where) {
        return "SELECT\np.id_persona,\np.persona_identificacion,\np.persona_primer_nombre || ' ' ||\np.persona_segundo_nombre AS nombres,\np.persona_primer_apellido || ' ' ||\np.persona_segundo_apellido AS apellidos,\np.persona_correo,\np.persona_celular, (\n  SELECT carrera_nombre\n  FROM public.\"AlumnosCarrera\" ac\n  JOIN public.\"Carreras\" c USING(id_carrera)\n  WHERE ac.id_alumno = a.id_alumno\n  ORDER BY id_carrera DESC\n  LIMIT 1\n) AS carrera, (\n  SELECT curso_nombre\n  FROM public.\"AlumnoCurso\" ac\n  JOIN public.\"Cursos\" c USING(id_curso)\n  WHERE ac.id_alumno = a.id_alumno\n  ORDER BY curso_nombre DESC\n  LIMIT 1\n) AS curso\nFROM public.\"Personas\" p\nJOIN public.\"Alumnos\" a USING(id_persona)\nWHERE a.alumno_activo = 'true'\nAND p.persona_activa = 'true' " + where + " ORDER BY p.persona_primer_apellido,\np.persona_segundo_apellido;";
    }
}

