/*
 * Decompiled with CFR 0.152.
 */
package modelo.periodolectivo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import modelo.ConnDBPool;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.DocenteMD;
import utils.CONBD;
import utils.M;

public class PeriodoLectivoBD
extends CONBD {
    private CarreraBD car;
    private CarreraMD carrera;
    private final ConnDBPool pool = new ConnDBPool();
    private Connection conn;
    private ResultSet rst;
    private static PeriodoLectivoBD PLBD;

    public static PeriodoLectivoBD single() {
        if (PLBD == null) {
            PLBD = new PeriodoLectivoBD();
        }
        return PLBD;
    }

    public boolean guardarPeriodo(PeriodoLectivoMD p, CarreraMD c) {
        String nsql = "INSERT INTO public.\"PeriodoLectivo\"(\nid_carrera, prd_lectivo_nombre, prd_lectivo_fecha_inicio, prd_lectivo_fecha_fin, prd_lectivo_observacion, prd_lectivo_activo, prd_lectivo_estado,prd_lectivo_fecha_fin_clases,prd_lectivo_coordinador ) VALUES( " + c.getId() + ", '" + p.getNombre().toUpperCase() + "" + this.formatoPeriodoNew(p.getFechaInicio(), p.getNumPeriodo()) + "', '" + p.getFechaInicio() + "', '" + p.getFechaFin() + "', '" + p.getObservacion().toUpperCase() + "', true, true, '" + p.getFechaFinClases() + "', " + p.getDocente().getIdDocente() + ");";
        return CON.executeNoSQL(nsql);
    }

    public boolean editarPeriodo(PeriodoLectivoMD p, CarreraMD c) {
        String nsql = "UPDATE public.\"PeriodoLectivo\" SET  id_carrera = " + c.getId() + ", prd_lectivo_nombre = '" + p.getNombre() + "',prd_lectivo_fecha_inicio = '" + p.getFechaInicio() + "', prd_lectivo_fecha_fin = '" + p.getFechaFin() + "', prd_lectivo_observacion = '" + p.getObservacion() + "', prd_lectivo_fecha_fin_clases = '" + p.getFechaFinClases() + "', prd_lectivo_coordinador = " + p.getDocente().getIdDocente() + "WHERE id_prd_lectivo = " + p.getID() + ";";
        return CON.executeNoSQL(nsql);
    }

    public boolean eliminarPeriodo(PeriodoLectivoMD p) {
        String nsql = "UPDATE public.\"PeriodoLectivo\" SET prd_lectivo_activo = false WHERE id_prd_lectivo = " + p.getID() + ";";
        return CON.executeNoSQL(nsql);
    }

    public boolean cerrarPeriodo(PeriodoLectivoMD p) {
        String nsql = "UPDATE public.\"PeriodoLectivo\" SET prd_lectivo_estado = false WHERE id_prd_lectivo = " + p.getID() + ";";
        return CON.executeNoSQL(nsql);
    }

    public boolean abrirPeriodo(int id) {
        String nsql = "UPDATE public.\"PeriodoLectivo\" SET  prd_lectivo_estado = trueWHERE id_prd_lectivo = " + id + ";";
        return CON.executeNoSQL(nsql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeriodoLectivoMD> llenarPeriodosxCarreras(int idCarrera) {
        String sql = "SELECT  p.id_prd_lectivo, c.id_carrera, p.prd_lectivo_nombre, p.prd_lectivo_fecha_inicio, p.prd_lectivo_fecha_fin, p.prd_lectivo_estado, c.carrera_nombre,persona_primer_nombre,persona_primer_apellido FROM public.\"PeriodoLectivo\" p JOIN public.\"Carreras\" c USING(id_carrera) JOIN public.\"Docentes\" d ON d.id_docente = p.prd_lectivo_coordinador JOIN public.\"Personas\" pr ON pr.id_persona = d.id_persona WHERE c.id_carrera = " + idCarrera + ";";
        PreparedStatement ps = CON.getPSPOOL(sql);
        ArrayList<PeriodoLectivoMD> lista = new ArrayList<PeriodoLectivoMD>();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                p.setID(rs.getInt("id_prd_lectivo"));
                this.carrera = new CarreraMD();
                this.carrera.setId(rs.getInt("id_carrera"));
                this.carrera.setNombre(rs.getString("carrera_nombre"));
                p.setCarrera(this.carrera);
                p.setNombre(rs.getString("prd_lectivo_nombre"));
                p.setFechaInicio(rs.getDate("prd_lectivo_fecha_inicio").toLocalDate());
                p.setFechaFin(rs.getDate("prd_lectivo_fecha_fin").toLocalDate());
                p.setEstado(rs.getBoolean("prd_lectivo_estado"));
                DocenteMD d = new DocenteMD();
                d.setPrimerNombre(rs.getString("persona_primer_nombre"));
                d.setPrimerApellido(rs.getString("persona_primer_apellido"));
                p.setDocente(d);
                lista.add(p);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar el periodo: " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeriodoLectivoMD> periodoDocente(int aguja) {
        String sql = "SELECT DISTINCT p.prd_lectivo_nombre, p.id_prd_lectivo FROM ( public.\"PeriodoLectivo\" p JOIN public.\"Cursos\" c USING(id_prd_lectivo) ) JOIN public.\"Docentes\" d USING(id_docente) WHERE d.id_docente = " + aguja + " AND p.prd_lectivo_activo = true;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        ArrayList<PeriodoLectivoMD> lista = new ArrayList<PeriodoLectivoMD>();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                p.setNombre(rs.getString("prd_lectivo_nombre"));
                lista.add(p);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar el periodo: " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CarreraMD> capturarCarrera() {
        ArrayList<CarreraMD> lista = new ArrayList<CarreraMD>();
        String sql = "SELECT id_carrera, carrera_nombre, carrera_codigo FROM public.\"Carreras\" WHERE carrera_activo = true;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CarreraMD a = new CarreraMD();
                a.setId(rs.getInt("id_carrera"));
                a.setNombre(rs.getString("carrera_nombre"));
                a.setCodigo(rs.getString("carrera_codigo"));
                lista.add(a);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar el carrera: " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CarreraMD capturarIdCarrera(String aguja) {
        String sql = "SELECT id_carrera FROM public.\"Carreras\" WHERE carrera_nombre LIKE '%" + aguja + "%';";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            CarreraMD c = new CarreraMD();
            while (rs.next()) {
                c.setId(rs.getInt("id_carrera"));
            }
            CarreraMD carreraMD = c;
            return carreraMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar el id de la carrera: " + ex.getMessage());
            CarreraMD carreraMD = null;
            return carreraMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CarreraMD capturarNomCarrera(int aguja) {
        String sql = "SELECT carrera_nombre FROM public.\"Carreras\" WHERE id_carrera = " + aguja + ";";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            CarreraMD c = new CarreraMD();
            while (rs.next()) {
                c.setNombre(rs.getString("carrera_nombre"));
            }
            CarreraMD carreraMD = c;
            return carreraMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar el nombre de la carrera: " + ex.getMessage());
            CarreraMD carreraMD = null;
            return carreraMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeriodoLectivoMD> llenarTabla() {
        ArrayList<PeriodoLectivoMD> lista = new ArrayList<PeriodoLectivoMD>();
        String sql = "SELECT id_prd_lectivo, id_carrera, prd_lectivo_nombre, prd_lectivo_fecha_inicio, prd_lectivo_fecha_fin FROM public.\"PeriodoLectivo\" WHERE prd_lectivo_activo = true";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PeriodoLectivoMD m = new PeriodoLectivoMD();
                this.carrera = new CarreraMD();
                m.setID(rs.getInt("id_prd_lectivo"));
                this.carrera.setId(rs.getInt("id_carrera"));
                m.setNombre(rs.getString("prd_lectivo_nombre"));
                m.setFechaInicio(rs.getDate("prd_lectivo_fecha_inicio").toLocalDate());
                m.setFechaFin(rs.getDate("prd_lectivo_fecha_fin").toLocalDate());
                m.setCarrera(this.carrera);
                lista.add(m);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar para llenar la tabla: " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeriodoLectivoMD> capturarPeriodos(String aguja) {
        ArrayList<PeriodoLectivoMD> lista = new ArrayList<PeriodoLectivoMD>();
        String sql = "SELECT id_prd_lectivo, pl.id_carrera, prd_lectivo_nombre, prd_lectivo_fecha_inicio, \nprd_lectivo_fecha_fin, carrera_nombre, carrera_codigo, prd_lectivo_estado, p.persona_primer_nombre, p.persona_primer_apellido FROM public.\"PeriodoLectivo\" pl, public.\"Carreras\" c, public.\"Docentes\" d, public.\"Personas\" p WHERE c.id_carrera = pl.id_carrera AND d.id_docente = pl.prd_lectivo_coordinador AND p.id_persona = d.id_persona AND prd_lectivo_activo = true AND( \tprd_lectivo_nombre ILIKE '%" + aguja + "%' OR\n\tcarrera_nombre ILIKE '%" + aguja + "%' OR\n\tcarrera_codigo ILIKE '%" + aguja + "%')\nORDER BY prd_lectivo_fecha_inicio DESC;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                p.setID(rs.getInt("id_prd_lectivo"));
                this.carrera = new CarreraMD();
                this.carrera.setId(rs.getInt("id_carrera"));
                this.carrera.setCodigo(rs.getString("carrera_codigo"));
                this.carrera.setNombre(rs.getString("carrera_nombre"));
                p.setCarrera(this.carrera);
                p.setNombre(rs.getString("prd_lectivo_nombre"));
                p.setFechaInicio(rs.getDate("prd_lectivo_fecha_inicio").toLocalDate());
                p.setFechaFin(rs.getDate("prd_lectivo_fecha_fin").toLocalDate());
                p.setEstado(rs.getBoolean("prd_lectivo_estado"));
                DocenteMD d = new DocenteMD();
                d.setPrimerNombre(rs.getString("persona_primer_nombre"));
                d.setPrimerApellido(rs.getString("persona_primer_apellido"));
                p.setDocente(d);
                lista.add(p);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar para llenar la tabla: " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeriodoLectivoMD capturarPerLectivo(int ID) {
        String sql = "SELECT p.id_prd_lectivo, p.id_carrera, p.prd_lectivo_nombre, p.prd_lectivo_fecha_inicio, p.prd_lectivo_fecha_fin, p.prd_lectivo_observacion, c.carrera_nombre, p.prd_lectivo_estado,p.prd_lectivo_fecha_fin_clases, d.id_docente, pr.persona_identificacion FROM public.\"PeriodoLectivo\" p JOIN public.\"Carreras\" c USING(id_carrera) JOIN public.\"Docentes\" d ON p.prd_lectivo_coordinador = d.id_docente JOIN public.\"Personas\" pr ON pr.id_persona = d.id_persona WHERE p.id_prd_lectivo = " + ID + " AND prd_lectivo_activo = true;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            PeriodoLectivoMD m = new PeriodoLectivoMD();
            this.carrera = new CarreraMD();
            while (rs.next()) {
                m.setID(rs.getInt("id_prd_lectivo"));
                m.setNombre(rs.getString("prd_lectivo_nombre"));
                m.setFechaInicio(rs.getDate("prd_lectivo_fecha_inicio").toLocalDate());
                m.setFechaFin(rs.getDate("prd_lectivo_fecha_fin").toLocalDate());
                m.setObservacion(rs.getString("prd_lectivo_observacion"));
                this.carrera.setId(rs.getInt("id_carrera"));
                this.carrera.setNombre(rs.getString("carrera_nombre"));
                m.setEstado(rs.getBoolean("prd_lectivo_estado"));
                m.setCarrera(this.carrera);
                if (rs.getDate("prd_lectivo_fecha_fin_clases") != null) {
                    m.setFechaFinClases(rs.getDate("prd_lectivo_fecha_fin_clases").toLocalDate());
                }
                DocenteMD d = new DocenteMD();
                d.setIdDocente(rs.getInt("id_docente"));
                d.setIdentificacion(rs.getString("persona_identificacion"));
                m.setDocente(d);
            }
            PeriodoLectivoMD periodoLectivoMD = m;
            return periodoLectivoMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar para llenar la tabla: " + ex.getMessage());
            PeriodoLectivoMD periodoLectivoMD = null;
            return periodoLectivoMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PeriodoLectivoMD> cargarPeriodos() {
        ArrayList<PeriodoLectivoMD> lista = new ArrayList<PeriodoLectivoMD>();
        String sql = "SELECT id_prd_lectivo, pl.id_carrera, prd_lectivo_nombre, prd_lectivo_fecha_inicio, prd_lectivo_fecha_fin, carrera_nombre, carrera_codigo, prd_lectivo_estado,p.persona_primer_nombre, p.persona_primer_apellido FROM public.\"PeriodoLectivo\" pl, public.\"Carreras\" c, public.\"Docentes\" d, public.\"Personas\" p WHERE c.id_carrera = pl.id_carrera AND d.id_docente = pl.prd_lectivo_coordinador AND p.id_persona = d.id_persona AND prd_lectivo_activo = true AND carrera_activo = true ORDER BY prd_lectivo_fecha_inicio DESC;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                p.setID(rs.getInt("id_prd_lectivo"));
                this.carrera = new CarreraMD();
                this.carrera.setId(rs.getInt("id_carrera"));
                this.carrera.setCodigo(rs.getString("carrera_codigo"));
                this.carrera.setNombre(rs.getString("carrera_nombre"));
                p.setCarrera(this.carrera);
                p.setNombre(rs.getString("prd_lectivo_nombre"));
                p.setFechaInicio(rs.getDate("prd_lectivo_fecha_inicio").toLocalDate());
                p.setFechaFin(rs.getDate("prd_lectivo_fecha_fin").toLocalDate());
                p.setEstado(rs.getBoolean("prd_lectivo_estado"));
                DocenteMD d = new DocenteMD();
                d.setPrimerNombre(rs.getString("persona_primer_nombre"));
                d.setPrimerApellido(rs.getString("persona_primer_apellido"));
                p.setDocente(d);
                lista.add(p);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar para llenar la tabla: " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeriodoLectivoMD buscarPerido(int idPeriodo) {
        PeriodoLectivoMD p = new PeriodoLectivoMD();
        String sql = "SELECT id_prd_lectivo, id_carrera, prd_lectivo_nombre, prd_lectivo_fecha_inicio, prd_lectivo_fecha_fin  FROM public.\"PeriodoLectivo\" WHERE prd_lectivo_activo = true AND id_prd_lectivo = " + idPeriodo + ";";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                p.setID(rs.getInt("id_prd_lectivo"));
                this.carrera = this.car.buscar(rs.getInt("id_carrera"));
                p.setCarrera(this.carrera);
                p.setNombre(rs.getString("prd_lectivo_nombre"));
                p.setFechaInicio(rs.getDate("prd_lectivo_fecha_inicio").toLocalDate());
                p.setFechaFin(rs.getDate("prd_lectivo_fecha_fin").toLocalDate());
            }
            PeriodoLectivoMD periodoLectivoMD = p;
            return periodoLectivoMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar para llenar la tabla: " + ex.getMessage());
            PeriodoLectivoMD periodoLectivoMD = null;
            return periodoLectivoMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    public ArrayList<PeriodoLectivoMD> cargarPrdParaCmbVtn() {
        String sql = "SELECT id_prd_lectivo, id_carrera, prd_lectivo_nombre\nFROM public.\"PeriodoLectivo\"\nORDER BY prd_lectivo_fecha_inicio DESC;";
        return this.consultarParaCmb(sql);
    }

    public ArrayList<PeriodoLectivoMD> cargarPrdParaCmbFrm() {
        String sql = "SELECT id_prd_lectivo, id_carrera, prd_lectivo_nombre\nFROM public.\"PeriodoLectivo\"\nORDER BY prd_lectivo_fecha_inicio DESC;";
        return this.consultarParaCmb(sql);
    }

    public List<PeriodoLectivoMD> cargarPeriodoEspecial() {
        String sql = "SELECT id_prd_lectivo, pl.id_carrera, prd_lectivo_nombre FROM public.\"PeriodoLectivo\" pl JOIN public.\"Carreras\" c ON c.id_carrera = pl.id_carrera WHERE prd_lectivo_activo = true AND prd_lectivo_estado = true AND carrera_modalidad = 'ESPECIAL' ORDER BY prd_lectivo_fecha_inicio DESC;";
        return this.consultarParaCmb(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<PeriodoLectivoMD> consultarParaCmb(String sql) {
        ArrayList<PeriodoLectivoMD> prds = new ArrayList<PeriodoLectivoMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                p.setID(rs.getInt("id_prd_lectivo"));
                this.carrera = new CarreraMD();
                this.carrera.setId(rs.getInt("id_carrera"));
                p.setCarrera(this.carrera);
                p.setNombre(rs.getString("prd_lectivo_nombre"));
                prds.add(p);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar para combo: " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return prds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeriodoLectivoMD capturarIdPeriodo(String nombrePer) {
        PeriodoLectivoMD p = new PeriodoLectivoMD();
        String sql = "SELECT id_prd_lectivo FROM public.\"PeriodoLectivo\" WHERE prd_lectivo_activo = true AND prd_lectivo_nombre LIKE '" + nombrePer + "';";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                p.setID(rs.getInt("id_prd_lectivo"));
            }
            PeriodoLectivoMD periodoLectivoMD = p;
            return periodoLectivoMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar para combo: " + ex.getMessage());
            PeriodoLectivoMD periodoLectivoMD = null;
            return periodoLectivoMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeriodoLectivoMD buscarPeriodo(String nombrePer) {
        PeriodoLectivoMD p = new PeriodoLectivoMD();
        String sql = "SELECT id_prd_lectivo, id_carrera, prd_lectivo_nombre, prd_lectivo_fecha_inicio, prd_lectivo_fecha_fin FROM public.\"PeriodoLectivo\" WHERE prd_lectivo_activo = true AND prd_lectivo_nombre LIKE '" + nombrePer + "';";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                p.setID(rs.getInt("id_prd_lectivo"));
                this.carrera = this.car.buscar(rs.getInt("id_carrera"));
                p.setCarrera(this.carrera);
                p.setNombre(rs.getString("prd_lectivo_nombre"));
                p.setFechaInicio(rs.getDate("prd_lectivo_fecha_inicio").toLocalDate());
                p.setFechaFin(rs.getDate("prd_lectivo_fecha_fin").toLocalDate());
            }
            PeriodoLectivoMD periodoLectivoMD = p;
            return periodoLectivoMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar para combo: " + ex.getMessage());
            PeriodoLectivoMD periodoLectivoMD = null;
            return periodoLectivoMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    public String formatoPeriodoNew(LocalDate fecha, String periodo) {
        return fecha.getYear() + " - " + periodo;
    }

    public String Meses(LocalDate fecha) {
        String nueva_Fecha = "";
        String nuevo_Mes = "";
        switch (fecha.getMonth().toString()) {
            case "JANUARY": {
                nuevo_Mes = "ENERO";
                break;
            }
            case "FEBRUARY": {
                nuevo_Mes = "FEBRERO";
                break;
            }
            case "MARCH": {
                nuevo_Mes = "MARZO";
                break;
            }
            case "APRIL": {
                nuevo_Mes = "ABRIL";
                break;
            }
            case "MAY": {
                nuevo_Mes = "MAYO";
                break;
            }
            case "JUNE": {
                nuevo_Mes = "JUNIO";
                break;
            }
            case "JULY": {
                nuevo_Mes = "JULIO";
                break;
            }
            case "AUGUST": {
                nuevo_Mes = "AGOSTO";
                break;
            }
            case "SEPTEMBER": {
                nuevo_Mes = "SEPTIEMBRE";
                break;
            }
            case "OCTOBER": {
                nuevo_Mes = "OCTUBRE";
                break;
            }
            case "NOVEMBER": {
                nuevo_Mes = "NOVIEMBRE";
                break;
            }
            case "DECEMBER": {
                nuevo_Mes = "DICIEMBRE";
            }
        }
        nueva_Fecha = nuevo_Mes + "/" + fecha.getYear();
        return nueva_Fecha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String alumnosMatriculados(int ID) {
        String sql = "SELECT COUNT(*) AS numeroAlumnos FROM (  public.\"Carreras\" c  JOIN public.\"AlumnosCarrera\" a  USING(id_carrera)) JOIN public.\"MallaAlumno\" m USING(id_almn_carrera) WHERE c.id_carrera = " + ID + " AND m.malla_almn_estado LIKE 'M';";
        PreparedStatement ps = CON.getPSPOOL(sql);
        String count = "";
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                count = String.valueOf(rs.getInt("numeroAlumnos"));
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No pudimos consultar numero de alumnos: " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalDate buscarFechaInicioPrd(int idPrd) {
        LocalDate fi = null;
        String sql = "SELECT prd_lectivo_fecha_inicio \nFROM public.\"PeriodoLectivo\"\nWHERE id_prd_lectivo = " + idPrd + ";";
        this.conn = this.pool.getConnection();
        this.rst = this.pool.ejecutarQuery(sql, this.conn, null);
        try {
            while (this.rst.next()) {
                fi = this.rst.getDate("prd_lectivo_fecha_inicio").toLocalDate();
            }
            LocalDate localDate = fi;
            return localDate;
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            this.pool.close(this.conn);
        }
        return fi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeriodoLectivoMD> selectPeriodoWhere(int idDocente) {
        String SELECT = "SELECT DISTINCT\n\"PeriodoLectivo\".id_prd_lectivo,\n\"PeriodoLectivo\".prd_lectivo_nombre,\n\"PeriodoLectivo\".id_carrera,\n\"Carreras\".carrera_nombre,\n\"Carreras\".carrera_modalidad,\n\"PeriodoLectivo\".prd_lectivo_estado,\n\"PeriodoLectivo\".prd_lectivo_activo,\n\"PeriodoLectivo\".prd_lectivo_fecha_inicio,\n\"PeriodoLectivo\".prd_lectivo_fecha_fin\nFROM\n\"PeriodoLectivo\"\nINNER JOIN \"Carreras\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera\nINNER JOIN \"Cursos\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\nINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente\nWHERE\n \"Docentes\".id_docente = ? \n AND prd_lectivo_activo = true \n AND prd_lectivo_estado = true \nORDER BY \"PeriodoLectivo\".prd_lectivo_fecha_inicio DESC";
        ArrayList<PeriodoLectivoMD> lista = new ArrayList<PeriodoLectivoMD>();
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, idDocente);
        this.conn = this.pool.getConnection();
        this.rst = this.pool.ejecutarQuery(SELECT, this.conn, parametros);
        try {
            while (this.rst.next()) {
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(this.rst.getInt("id_prd_lectivo"));
                periodo.setNombre(this.rst.getString("prd_lectivo_nombre"));
                CarreraMD c = new CarreraMD();
                c.setId(this.rst.getInt("id_carrera"));
                c.setNombre(this.rst.getString("carrera_nombre"));
                c.setModalidad(this.rst.getString("carrera_modalidad"));
                periodo.setCarrera(c);
                periodo.setEstado(this.rst.getBoolean("prd_lectivo_estado"));
                periodo.setActivo(this.rst.getBoolean("prd_lectivo_activo"));
                periodo.setFechaInicio(this.rst.getDate("prd_lectivo_fecha_inicio").toLocalDate());
                periodo.setFechaFin(this.rst.getDate("prd_lectivo_fecha_fin").toLocalDate());
                lista.add(periodo);
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            this.pool.closeStmt().close(this.rst).close(this.conn);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeriodoLectivoMD> selectPeriodoWhere(String cedulaDocente) {
        String SELECT = "SELECT DISTINCT\n\"PeriodoLectivo\".id_prd_lectivo,\n\"PeriodoLectivo\".prd_lectivo_nombre,\n\"PeriodoLectivo\".id_carrera,\n\"Carreras\".carrera_nombre,\n\"Carreras\".carrera_modalidad,\n\"PeriodoLectivo\".prd_lectivo_estado,\n\"PeriodoLectivo\".prd_lectivo_activo,\n\"PeriodoLectivo\".prd_lectivo_fecha_inicio,\n\"PeriodoLectivo\".prd_lectivo_fecha_fin\nFROM\n\"PeriodoLectivo\"\nINNER JOIN \"Carreras\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera\nINNER JOIN \"Cursos\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\nINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente\nWHERE\n \"Docentes\".docente_codigo = ?  AND prd_lectivo_activo = true  AND prd_lectivo_estado = true \nORDER BY prd_lectivo_fecha_inicio DESC";
        ArrayList<PeriodoLectivoMD> lista = new ArrayList<PeriodoLectivoMD>();
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, cedulaDocente);
        this.conn = this.pool.getConnection();
        this.rst = this.pool.ejecutarQuery(SELECT, this.conn, parametros);
        try {
            while (this.rst.next()) {
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(this.rst.getInt("id_prd_lectivo"));
                periodo.setNombre(this.rst.getString("prd_lectivo_nombre"));
                CarreraMD c = new CarreraMD();
                c.setId(this.rst.getInt("id_carrera"));
                c.setNombre(this.rst.getString("carrera_nombre"));
                c.setModalidad(this.rst.getString("carrera_modalidad"));
                periodo.setCarrera(c);
                periodo.setEstado(this.rst.getBoolean("prd_lectivo_estado"));
                periodo.setActivo(this.rst.getBoolean("prd_lectivo_activo"));
                periodo.setFechaInicio(this.rst.getDate("prd_lectivo_fecha_inicio").toLocalDate());
                periodo.setFechaFin(this.rst.getDate("prd_lectivo_fecha_fin").toLocalDate());
                lista.add(periodo);
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            this.pool.closeStmt().close(this.rst).close(this.conn);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeriodoLectivoMD> selectIdNombreAll() {
        String SELECT = "SELECT id_prd_lectivo, prd_lectivo_nombre FROM \"PeriodoLectivo\" \nORDER BY prd_lectivo_fecha_inicio DESC";
        ArrayList<PeriodoLectivoMD> lista = new ArrayList<PeriodoLectivoMD>();
        this.conn = this.pool.getConnection();
        this.rst = this.pool.ejecutarQuery(SELECT, this.conn, null);
        try {
            while (this.rst.next()) {
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(this.rst.getInt("id_prd_lectivo"));
                periodo.setNombre(this.rst.getString("prd_lectivo_nombre"));
                lista.add(periodo);
            }
        }
        catch (NullPointerException | SQLException e) {
            if (e instanceof SQLException) {
                System.out.println(e.getMessage());
            }
        }
        finally {
            this.pool.closeStmt().close(this.rst).close(this.conn);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PeriodoLectivoMD> selectPeriodosFaltantes() {
        String SELECT = "SELECT DISTINCT\n\tp1.id_prd_lectivo,\n\tp1.id_carrera,\n\tp1.prd_lectivo_nombre,\n\t\"Carreras\".carrera_nombre,\n\t\"Carreras\".carrera_modalidad \nFROM\n\"PeriodoLectivo\" p1\n\tINNER JOIN \"Carreras\" ON p1.id_carrera = \"Carreras\".id_carrera \nWHERE\n\t7 != (\n\tSELECT\n\t\t\"count\" ( * ) \n\tFROM\n\t\t\"TipoDeNota\" AS t2\n\t\tINNER JOIN \"PeriodoLectivo\" ON t2.id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\t\tINNER JOIN \"Carreras\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera \n\tWHERE\n\t\tt2.id_prd_lectivo = p1.id_prd_lectivo \n\t\tAND ( \"Carreras\".carrera_modalidad ='PRESENCIAL' OR \"Carreras\".carrera_modalidad ='TRADICIONAL' ) \n\t) \n\tAND 12 != (\n\tSELECT\n\t\t\"count\" ( * ) \n\tFROM\n\t\t\"TipoDeNota\" AS t2\n\t\tINNER JOIN \"PeriodoLectivo\" ON t2.id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\t\tINNER JOIN \"Carreras\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera \n\tWHERE\n\t\tt2.id_prd_lectivo = p1.id_prd_lectivo \n\tAND ( \"Carreras\".carrera_modalidad ='DUAL' OR \"Carreras\".carrera_modalidad ='DUAL FOCALIZADA' ) \n\t)\n\t\n";
        System.out.println(SELECT);
        HashMap<String, PeriodoLectivoMD> map = new HashMap<String, PeriodoLectivoMD>();
        this.conn = this.pool.getConnection();
        this.rst = this.pool.ejecutarQuery(SELECT, this.conn, null);
        try {
            while (this.rst.next()) {
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(this.rst.getInt("id_prd_lectivo"));
                periodo.setNombre(this.rst.getString("prd_lectivo_nombre"));
                CarreraMD c = new CarreraMD();
                c.setId(this.rst.getInt("id_carrera"));
                c.setNombre(this.rst.getString("carrera_nombre"));
                c.setModalidad(this.rst.getString("carrera_modalidad"));
                periodo.setCarrera(c);
                String key = this.rst.getString("prd_lectivo_nombre");
                map.put(key, periodo);
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            this.pool.closeStmt().close(this.rst).close(this.conn);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, PeriodoLectivoMD> selectWhere(String nombrePeriodo) {
        String SELECT = "SELECT DISTINCT\n\t\"PeriodoLectivo\".id_prd_lectivo,\n\t\"PeriodoLectivo\".id_carrera,\n\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\"Carreras\".carrera_nombre,\n\t\"Carreras\".carrera_modalidad \nFROM\n\t\"PeriodoLectivo\" \n\tINNER JOIN \"Carreras\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera \nWHERE\n\t\"PeriodoLectivo\".prd_lectivo_nombre = ?";
        HashMap<String, PeriodoLectivoMD> map = new HashMap<String, PeriodoLectivoMD>();
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, nombrePeriodo);
        this.conn = this.pool.getConnection();
        this.rst = this.pool.ejecutarQuery(SELECT, this.conn, parametros);
        try {
            while (this.rst.next()) {
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setID(this.rst.getInt("id_prd_lectivo"));
                periodo.setNombre(this.rst.getString("prd_lectivo_nombre"));
                CarreraMD carreraMap = new CarreraMD();
                carreraMap.setId(this.rst.getInt("id_carrera"));
                carreraMap.setNombre(this.rst.getString("carrera_nombre"));
                carreraMap.setModalidad(this.rst.getString("carrera_modalidad"));
                periodo.setCarrera(carreraMap);
                String key = this.rst.getString("prd_lectivo_nombre");
                map.put(key, periodo);
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            this.pool.closeStmt().close(this.rst).close(this.conn);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeriodoLectivoMD> buscarNumSemanas(int idDocente, int idPrd) {
        String SELECT = "SELECT DISTINCT\n \"Docentes\".id_docente,\n \"PeriodoLectivo\".prd_lectivo_nombre,\n (prd_lectivo_fecha_fin - prd_lectivo_fecha_inicio)/7 AS semanas\n FROM\n \"Carreras\"\n INNER JOIN \"PeriodoLectivo\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera\n INNER JOIN \"Cursos\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n INNER JOIN \"Docentes\" ON \"Docentes\".id_docente = \"Cursos\".id_docente\n INNER JOIN \"Materias\" ON \"Materias\".id_carrera = \"Carreras\".id_carrera\n INNER JOIN \"SesionClase\" ON \"SesionClase\".id_curso = \"Cursos\".id_curso\n WHERE\n \"Cursos\".id_docente = " + idDocente + " AND\n \"PeriodoLectivo\".id_prd_lectivo = " + idPrd + "";
        ArrayList<PeriodoLectivoMD> semana = new ArrayList<PeriodoLectivoMD>();
        this.conn = this.pool.getConnection();
        this.rst = this.pool.ejecutarQuery(SELECT, this.conn, null);
        System.out.println("Query: \n" + SELECT);
        try {
            while (this.rst.next()) {
                PeriodoLectivoMD periodo = new PeriodoLectivoMD();
                periodo.setNombre(this.rst.getString("prd_lectivo_nombre"));
                System.out.println("Semanas " + this.rst.getInt(3));
                periodo.setNumSemanas(this.rst.getInt(3));
                semana.add(periodo);
            }
        }
        catch (NullPointerException | SQLException e) {
            if (e instanceof SQLException) {
                System.out.println(e.getMessage());
            }
        }
        finally {
            this.pool.closeStmt();
            this.pool.close(this.rst);
            this.pool.close(this.conn);
        }
        return semana;
    }
}

