/*
 * Decompiled with CFR 0.152.
 */
package modelo.pagos;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.alumno.MallaAlumnoMD;
import modelo.materia.MateriaMD;
import utils.CONBD;

public class UtilComprobanteBD
extends CONBD {
    private static UtilComprobanteBD UCBD;

    public static UtilComprobanteBD single() {
        if (UCBD == null) {
            UCBD = new UtilComprobanteBD();
        }
        return UCBD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MallaAlumnoMD> getByAlumno(int idAlumno) {
        String sql = "SELECT\nid_malla_alumno,\nmalla_almn_num_matricula,\nmateria_nombre,\nmateria_codigo\nFROM public.\"MallaAlumno\" ma\nJOIN public.\"Materias\" m\nON ma.id_materia = m.id_materia\nWHERE id_almn_carrera IN (\n  SELECT id_almn_carrera\n  FROM public.\"AlumnosCarrera\"\n  WHERE id_alumno = ?\n) AND (\n  malla_almn_num_matricula > 1 OR (\n    malla_almn_estado = 'R'\n    AND malla_almn_num_matricula = 1\n  )\n) AND malla_almn_pago_pendiente = true ORDER BY materia_ciclo;";
        ArrayList<MallaAlumnoMD> ms = new ArrayList<MallaAlumnoMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idAlumno);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                MallaAlumnoMD ma = new MallaAlumnoMD();
                ma.setId(res.getInt(1));
                ma.setMallaNumMatricula(res.getInt(2));
                MateriaMD m = new MateriaMD();
                m.setNombre(res.getString(3));
                m.setCodigo(res.getString(4));
                ma.setMateria(m);
                ms.add(ma);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al mapear materia con pago pendiente.\n" + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return ms;
    }
}

