/*
 * Decompiled with CFR 0.152.
 */
package modelo.pagos;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.alumno.MallaAlumnoMD;
import modelo.materia.MateriaMD;
import modelo.pagos.PagoMateriaMD;
import utils.CONBD;

public class PagoMateriaBD
extends CONBD {
    private static PagoMateriaBD PMBD;
    private static final String INSERT = "INSERT INTO pago.\"PagoMateria\"(\nid_comprobante,\nid_malla_alumno,\npago_materia,\npago_numero_matricula)\nVALUES (?, ?, ?, ?);";
    private static final String UPDATE = "UPDATE pago.\"PagoMateria\"\nSET pago_materia=?,\npago_numero_matricula=?\nWHERE id_pago_materia=?; ";

    public static PagoMateriaBD single() {
        if (PMBD == null) {
            PMBD = new PagoMateriaBD();
        }
        return PMBD;
    }

    public int guardar(PagoMateriaMD pm) {
        PreparedStatement ps = CON.getPSID(INSERT);
        try {
            ps.setInt(1, pm.getComprobante().getId());
            ps.setInt(2, pm.getMallaAlumno().getId());
            ps.setDouble(3, pm.getPago());
            ps.setInt(4, pm.getNumMatricula());
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al guardar el pago. " + e.getMessage());
        }
        return CON.getIDGenerado(ps);
    }

    public int editar(PagoMateriaMD pm) {
        PreparedStatement ps = CON.getPSID(UPDATE);
        try {
            ps.setDouble(1, pm.getPago());
            ps.setInt(2, pm.getNumMatricula());
            ps.setInt(3, pm.getId());
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al editar el pago. " + e.getMessage());
        }
        return CON.getIDGenerado(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PagoMateriaMD> getByComprobante(int idComprobante) {
        String sql = "SELECT\nid_pago_materia,\npm.id_malla_alumno,\npago_materia,\npago_numero_matricula,\nmateria_nombre\nFROM pago.\"PagoMateria\" pm\nJOIN public.\"MallaAlumno\" ma\nON ma.id_malla_alumno = pm.id_malla_alumno\nJOIN public.\"Materias\" m\nON m.id_materia = ma.id_materia\nWHERE id_comprobante = ?;";
        ArrayList<PagoMateriaMD> pms = new ArrayList<PagoMateriaMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idComprobante);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                PagoMateriaMD pm = new PagoMateriaMD();
                pm.setId(res.getInt(1));
                MallaAlumnoMD ma = new MallaAlumnoMD();
                ma.setId(res.getInt(2));
                pm.setPago(res.getDouble(3));
                pm.setNumMatricula(res.getInt(4));
                MateriaMD m = new MateriaMD();
                m.setNombre(res.getString(5));
                ma.setMateria(m);
                pm.setMallaAlumno(ma);
                pms.add(pm);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error consultar pagos de materias por comprobante. \n" + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return pms;
    }
}

