/*
 * Decompiled with CFR 0.152.
 */
package modelo.notas;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import modelo.ConnDBPool;
import modelo.alumno.AlumnoCursoMD;
import modelo.notas.NotasMD;
import modelo.tipoDeNota.TipoDeNotaMD;

public class NotasBD
extends NotasMD {
    private final ConnDBPool pool = new ConnDBPool();
    private Connection conn;
    private ResultSet rs;
    private boolean ejecutar = false;

    public NotasBD(int idNota, double notaValor, AlumnoCursoMD alumnoCurso, TipoDeNotaMD tipoDeNota) {
        super(idNota, notaValor, alumnoCurso, tipoDeNota);
    }

    public NotasBD() {
    }

    public List<NotasBD> selectWhere(AlumnoCursoMD alumnnoCurso) {
        String SELECT = "SELECT\n\"Notas\".id_nota,\n\"Notas\".nota_valor,\n\"Notas\".id_tipo_nota,\n\"TipoDeNota\".tipo_nota_nombre\nFROM\n\"Notas\"\nINNER JOIN \"TipoDeNota\" ON \"Notas\".id_tipo_nota = \"TipoDeNota\".id_tipo_nota\nWHERE\n\"Notas\".id_almn_curso = ?\nORDER BY \"Notas\".nota_valor ASC";
        ArrayList<NotasBD> lista = new ArrayList<NotasBD>();
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, alumnnoCurso.getId());
        try (Connection conn = this.pool.getConnection();){
            this.rs = this.pool.ejecutarQuery(SELECT, conn, parametros);
            while (this.rs.next()) {
                NotasBD nota = new NotasBD();
                nota.setIdNota(this.rs.getInt("id_nota"));
                nota.setNotaValor(this.rs.getDouble("nota_valor"));
                TipoDeNotaMD tipoDeNota = new TipoDeNotaMD();
                tipoDeNota.setNombre(this.rs.getString("tipo_nota_nombre"));
                nota.setTipoDeNota(tipoDeNota);
                lista.add(nota);
            }
        }
        catch (SQLException e) {
            Logger.getLogger(NotasBD.class.getName()).log(Level.SEVERE, null, e);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return lista;
    }

    public synchronized boolean editar() {
        new Thread(() -> {
            String UPDATE = "UPDATE \"Notas\" \nSET nota_valor = " + this.getNotaValor() + " \nWHERE \n\"Notas\".id_nota = " + this.getIdNota();
            this.conn = this.pool.getConnection();
            this.ejecutar = this.pool.ejecutar(UPDATE, this.conn, null) == null;
        }).start();
        return this.ejecutar;
    }
}

