/*
 * Decompiled with CFR 0.152.
 */
package modelo.materia;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import modelo.ConnDBPool;
import modelo.carrera.CarreraMD;
import modelo.curso.CursoMD;
import modelo.materia.EjeFormacionMD;
import modelo.materia.MateriaMD;
import utils.CONBD;
import utils.M;

public class MateriaBD
extends CONBD {
    private String sqlg;
    private String sqlm;
    private final ConnDBPool POOL = new ConnDBPool();
    private Connection conn;
    private ResultSet rst;
    private static MateriaBD MBD;

    public static MateriaBD single() {
        if (MBD == null) {
            MBD = new MateriaBD();
        }
        return MBD;
    }

    public boolean insertarMateria_ANTERIOR(MateriaMD m) {
        String nsql = "INSERT INTO public.\"Materias\"( id_carrera, id_eje, materia_codigo, materia_nombre, materia_ciclo, materia_creditos, materia_tipo, materia_categoria, materia_tipo_acreditacion, materia_horas_docencia, materia_horas_practicas, materia_horas_auto_estudio, materia_horas_presencial, materia_total_horas, materia_activa, materia_objetivo, materia_descripcion, materia_objetivo_especifico, materia_organizacion_curricular, materia_campo_formacion, materia_nucleo) VALUES( " + m.getCarrera().getId() + ", " + m.getEje().getId() + ", '" + m.getCodigo() + "', '" + m.getNombre() + "', " + m.getCiclo() + ", " + m.getCreditos() + ", '" + m.getTipo() + "', '" + m.getCategoria() + "', '" + m.getTipoAcreditacion() + "', " + m.getHorasDocencia() + ", " + m.getHorasPracticas() + ", " + m.getHorasAutoEstudio() + ", " + m.getHorasPresenciales() + ", " + m.getTotalHoras() + ", true, '" + m.getObjetivo() + "', '" + m.getDescripcion() + "', '" + m.getObjetivoespecifico() + "', '" + m.getOrganizacioncurricular() + "', '" + m.getMateriacampoformacion() + "', '" + m.isMateriaNucleo() + "');";
        return CON.executeNoSQL(nsql);
    }

    public boolean editarMateria_ANTERIOR(MateriaMD m) {
        String nsql = "UPDATE public.\"Materias\" SET  id_carrera = " + m.getCarrera().getId() + ", id_eje = " + m.getEje().getId() + ", materia_codigo = '" + m.getCodigo() + "', materia_nombre = '" + m.getNombre() + "', materia_ciclo = " + m.getCiclo() + ", materia_creditos = " + m.getCreditos() + ", materia_tipo = '" + m.getTipo() + "', materia_categoria = '" + m.getCategoria() + "', materia_tipo_acreditacion = '" + m.getTipoAcreditacion() + "', materia_horas_docencia = " + m.getHorasDocencia() + ", materia_horas_practicas = " + m.getHorasPracticas() + ", materia_horas_auto_estudio = " + m.getHorasAutoEstudio() + ", materia_horas_presencial = " + m.getHorasPresenciales() + ", materia_total_horas = " + m.getTotalHoras() + ", materia_objetivo = '" + m.getObjetivo() + "', materia_descripcion = '" + m.getDescripcion() + "', materia_objetivo_especifico = '" + m.getObjetivoespecifico() + "', materia_organizacion_curricular = '" + m.getOrganizacioncurricular() + "', materia_campo_formacion = '" + m.getMateriacampoformacion() + "', materia_nucleo = '" + m.isMateriaNucleo() + "'  WHERE id_materia = " + m.getId() + ";";
        return CON.executeNoSQL(nsql);
    }

    public boolean insertarMateria(MateriaMD m) {
        String nsql = "INSERT INTO public.\"Materias\"( id_carrera, id_eje, materia_codigo, materia_nombre, materia_ciclo, materia_creditos, materia_tipo, materia_categoria, materia_tipo_acreditacion, materia_horas_docencia, materia_horas_practicas, materia_horas_auto_estudio, materia_horas_presencial, materia_total_horas, materia_activa, materia_objetivo, materia_descripcion, materia_objetivo_especifico, materia_organizacion_curricular, materia_campo_formacion, materia_nucleo, materia_modalidad, materia_itinerario, materia_area_academica, materia_horas_tutoria, materia_perfil_egreso, materia_evaluacion, materia_app, materia_estrategias, materia_recursos) VALUES( " + m.getCarrera().getId() + ", " + m.getEje().getId() + ", '" + m.getCodigo() + "', '" + m.getNombre() + "', " + m.getCiclo() + ", " + m.getCreditos() + ", '" + m.getTipo() + "', '" + m.getCategoria() + "', '" + m.getTipoAcreditacion() + "', " + m.getHorasDocencia() + ", " + m.getHorasPracticas() + ", " + m.getHorasAutoEstudio() + ", " + m.getHorasPresenciales() + ", " + m.getTotalHoras() + ", true, '" + m.getObjetivo() + "', '" + m.getDescripcion() + "', '" + m.getObjetivoespecifico() + "', '" + m.getOrganizacioncurricular() + "', '" + m.getMateriacampoformacion() + "', '" + m.isMateriaNucleo() + "','" + m.getModalidad() + "','" + m.getItinerario() + "','" + m.getAreaAcademica() + "'," + m.getHorasTutoria() + ",'" + m.getPerfilEgreso() + "','" + m.getEvaluacion() + "','" + m.getActividadesPracticasProgramadas() + "','" + m.getEstrategiasMetodologicas() + "','" + m.getRecursosDidacticos() + "');";
        return CON.executeNoSQL(nsql);
    }

    public boolean editarMateria(MateriaMD m) {
        String nsql = "UPDATE public.\"Materias\" SET  id_carrera = " + m.getCarrera().getId() + ", id_eje = " + m.getEje().getId() + ", materia_codigo = '" + m.getCodigo() + "', materia_nombre = '" + m.getNombre() + "', materia_ciclo = " + m.getCiclo() + ", materia_creditos = " + m.getCreditos() + ", materia_tipo = '" + m.getTipo() + "', materia_categoria = '" + m.getCategoria() + "', materia_tipo_acreditacion = '" + m.getTipoAcreditacion() + "', materia_horas_docencia = " + m.getHorasDocencia() + ", materia_horas_practicas = " + m.getHorasPracticas() + ", materia_horas_auto_estudio = " + m.getHorasAutoEstudio() + ", materia_horas_presencial = " + m.getHorasPresenciales() + ", materia_total_horas = " + m.getTotalHoras() + ", materia_objetivo = '" + m.getObjetivo() + "', materia_descripcion = '" + m.getDescripcion() + "', materia_objetivo_especifico = '" + m.getObjetivoespecifico() + "', materia_organizacion_curricular = '" + m.getOrganizacioncurricular() + "', materia_campo_formacion = '" + m.getMateriacampoformacion() + "', materia_nucleo = '" + m.isMateriaNucleo() + "', materia_modalidad = '" + m.getModalidad() + "', materia_itinerario = '" + m.getItinerario() + "', materia_area_academica = '" + m.getAreaAcademica() + "', materia_horas_tutoria =" + m.getHorasTutoria() + ", materia_perfil_egreso = '" + m.getPerfilEgreso() + "', materia_evaluacion = '" + m.getEvaluacion() + "', materia_app = '" + m.getActividadesPracticasProgramadas() + "', materia_estrategias = '" + m.getEstrategiasMetodologicas() + "', materia_recursos = '" + m.getRecursosDidacticos() + "' WHERE id_materia = " + m.getId() + ";";
        return CON.executeNoSQL(nsql);
    }

    public boolean elminarMateria(int aguja) {
        String nsql = "UPDATE public.\"Materias\" SET\n materia_activa = 'false' WHERE id_materia = " + aguja + ";";
        return CON.executeNoSQL(nsql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CarreraMD> cargarCarreras() {
        String sql = "SELECT carrera_nombre FROM public.\"Carreras\" WHERE carrera_activo = true;";
        ArrayList<CarreraMD> lista = new ArrayList<CarreraMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CarreraMD c = new CarreraMD();
                c.setNombre(rs.getString("carrera_nombre"));
                lista.add(c);
            }
        }
        catch (SQLException ex) {
            System.out.println("No se pudieron consultar alumnos");
            System.out.println(ex.getMessage());
            M.errorMsg("No consultamos carreras. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EjeFormacionMD> cargarEjes(int aguja) {
        String sql = "SELECT eje_nombre FROM public.\"EjesFormacion\" WHERE id_carrera = " + aguja + " AND eje_estado = true;";
        ArrayList<EjeFormacionMD> lista = new ArrayList<EjeFormacionMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                EjeFormacionMD eje = new EjeFormacionMD();
                eje.setNombre(rs.getString("eje_nombre"));
                lista.add(eje);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultaron ejes. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CarreraMD filtrarIdCarrera(String nombre, int id) {
        String sql = "SELECT id_carrera, carrera_nombre FROM public.\"Carreras\" WHERE carrera_nombre LIKE '" + nombre + "' OR id_carrera = " + id + " AND carrera_activo = true;";
        CarreraMD carrera = new CarreraMD();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                carrera.setId(rs.getInt("id_carrera"));
                carrera.setNombre(rs.getString("carrera_nombre"));
            }
            CarreraMD carreraMD = carrera;
            return carreraMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultaron carrera. " + ex.getMessage());
            CarreraMD carreraMD = null;
            return carreraMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EjeFormacionMD filtrarIdEje(String nombre, int id) {
        String sql = "SELECT id_eje, eje_nombre FROM public.\"EjesFormacion\" WHERE eje_nombre LIKE '" + nombre + "' OR id_eje = " + id + ";";
        PreparedStatement ps = CON.getPSPOOL(sql);
        EjeFormacionMD eje = new EjeFormacionMD();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                eje.setId(rs.getInt("id_eje"));
                eje.setNombre(rs.getString("eje_nombre"));
            }
            EjeFormacionMD ejeFormacionMD = eje;
            return ejeFormacionMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultaron eje por ID. " + ex.getMessage());
            EjeFormacionMD ejeFormacionMD = null;
            return ejeFormacionMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MateriaMD capturarIDMaterias(String nombre, int carrera) {
        String sql = "SELECT id_materia FROM public.\"Materias\" WHERE materia_nombre LIKE '" + nombre + "' AND id_carrera = " + carrera + " AND materia_activa = true;";
        MateriaMD m = new MateriaMD();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                m.setId(rs.getInt("id_materia"));
            }
            MateriaMD materiaMD = m;
            return materiaMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultaron materias. " + ex.getMessage());
            MateriaMD materiaMD = null;
            return materiaMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    public ArrayList<MateriaMD> cargarMaterias() {
        this.sqlg = "SELECT id_materia, materia_codigo, materia_nombre, materia_ciclo, materia_horas_docencia, materia_horas_practicas, materia_horas_auto_estudio, materia_horas_presencial, materia_total_horas, m.id_carrera\nFROM public.\"Materias\" m \nWHERE materia_activa = 'true'ORDER BY materia_ciclo;";
        return this.consultarMateriasParaTabla(this.sqlg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MateriaMD buscarMateria(String materia) {
        String sql = "SELECT id_materia FROM public.\"Materias\" WHERE materia_nombre LIKE '%" + materia + "%';";
        PreparedStatement ps = CON.getPSPOOL(sql);
        MateriaMD m = new MateriaMD();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                m.setId(rs.getInt("id_materia"));
            }
            MateriaMD materiaMD = m;
            return materiaMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultaron materias para tabla. " + ex.getMessage());
            MateriaMD materiaMD = null;
            return materiaMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MateriaMD> cargarMateriaPorCarreraFrm(int idcarrera) {
        this.sqlg = "SELECT id_materia, materia_codigo, materia_nombre, materia_ciclo, m.id_carrera, materia_nucleo FROM public.\"Materias\" m WHERE materia_activa = 'true' AND m.id_carrera= " + idcarrera + " AND materia_activa = true;";
        ArrayList<MateriaMD> lista = new ArrayList<MateriaMD>();
        PreparedStatement ps = CON.getPSPOOL(this.sqlg);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                CarreraMD cr = new CarreraMD();
                cr.setId(idcarrera);
                m.setCarrera(cr);
                m.setMateriaNucleo(rs.getBoolean("materia_nucleo"));
                lista.add(m);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultaron materias para formulario. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    public ArrayList<MateriaMD> cargarMateriaPorCarrera(int idcarrera) {
        this.sqlg = "SELECT id_materia, materia_codigo, materia_nombre, materia_ciclo, materia_horas_docencia, materia_horas_practicas, materia_horas_auto_estudio, materia_horas_presencial, materia_total_horas, m.id_carrera\nFROM public.\"Materias\" m, public.\"Carreras\" c \nWHERE materia_activa = 'true' AND m.id_carrera= " + idcarrera + " AND c.id_carrera = m.id_carrera AND carrera_activo = true;";
        return this.consultarMateriasParaTabla(this.sqlg);
    }

    public ArrayList<MateriaMD> cargarMateriaPorCarreraCiclo(int idcarrera, int ciclo) {
        this.sqlg = "SELECT id_materia, materia_codigo, materia_nombre, materia_ciclo, materia_horas_docencia, materia_horas_practicas, materia_horas_auto_estudio, materia_horas_presencial, materia_total_horas, m.id_carrera\nFROM public.\"Materias\" m, public.\"Carreras\" c \nWHERE materia_activa = 'true' AND m.id_carrera= " + idcarrera + " AND materia_ciclo = " + ciclo + " \nAND c.id_carrera = m.id_carrera AND carrera_activo = true;";
        return this.consultarMateriasParaTabla(this.sqlg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MateriaMD> buscarMateriaPorCarreraCiclo(int idcarrera, int ciclo) {
        String sql = "SELECT id_materia, materia_codigo, materia_nombre \nFROM public.\"Materias\" WHERE materia_activa = 'true'AND id_carrera= " + idcarrera + " AND materia_ciclo = " + ciclo + ";";
        ArrayList<MateriaMD> lista = new ArrayList<MateriaMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                m.setCodigo(rs.getString("materia_codigo"));
                m.setNombre(rs.getString("materia_nombre"));
                lista.add(m);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultaron materias para formulario. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> cargarCiclosCarrera(int idCarrera) {
        ArrayList<Integer> ciclos = new ArrayList<Integer>();
        String sql = "SELECT DISTINCT materia_ciclo FROM public.\"Materias\"  WHERE id_carrera = " + idCarrera + " ORDER BY materia_ciclo; ";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ciclos.add(rs.getInt("materia_ciclo"));
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultaron ciclos por carrera. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return ciclos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MateriaMD buscarMateriaInfo(int idmateria) {
        MateriaMD m = new MateriaMD();
        String sql = "SELECT id_materia, m.id_carrera, materia_codigo, materia_nombre, carrera_nombre FROM public.\"Materias\" m, public.\"Carreras\" c WHERE id_materia = " + idmateria + " AND c.id_carrera = m.id_carrera;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                m.setId(rs.getInt("id_materia"));
                m.setCodigo(rs.getString("materia_codigo"));
                m.setNombre(rs.getString("materia_nombre"));
                CarreraMD cr = new CarreraMD();
                cr.setId(rs.getInt("id_carrera"));
                cr.setNombre(rs.getString("carrera_nombre"));
                m.setCarrera(cr);
            }
            MateriaMD materiaMD = m;
            return materiaMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultar materia info. " + ex.getMessage());
            MateriaMD materiaMD = null;
            return materiaMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MateriaMD buscarMateria(int idmateria) {
        MateriaMD m = new MateriaMD();
        String sql = "SELECT id_materia, id_carrera, id_eje, materia_codigo, materia_nombre, materia_ciclo, materia_creditos, materia_tipo, materia_categoria, materia_tipo_acreditacion, materia_horas_docencia, materia_horas_practicas, materia_horas_auto_estudio, materia_horas_presencial, materia_total_horas, materia_activa, materia_objetivo,materia_descripcion,materia_modalidad, materia_itinerario, materia_area_academica, materia_horas_tutoria, materia_perfil_egreso, materia_evaluacion, materia_app, materia_estrategias, materia_recursos,materia_objetivo_especifico,materia_organizacion_curricular,materia_campo_formacion, materia_nucleo\nFROM public.\"Materias\" WHERE materia_activa = 'true' AND id_materia= " + idmateria + ";";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                m = this.obtenerMateria(rs);
            }
            MateriaMD materiaMD = m;
            return materiaMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultar materia por id. " + ex.getMessage());
            MateriaMD materiaMD = null;
            return materiaMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MateriaMD buscarMateriaxCodigo(String codigo) {
        MateriaMD m = new MateriaMD();
        String sql = "SELECT id_materia, id_carrera, id_eje, materia_codigo, materia_nombre, materia_ciclo, materia_creditos, materia_tipo, materia_categoria, materia_tipo_acreditacion, materia_horas_docencia, materia_horas_practicas, materia_horas_auto_estudio, materia_horas_presencial, materia_total_horas, materia_activa, materia_objetivo,materia_descripcion,materia_modalidad, materia_itinerario, materia_area_academica, materia_horas_tutoria, materia_perfil_egreso, materia_evaluacion, materia_app, materia_estrategias, materia_recursos,materia_objetivo_especifico,materia_organizacion_curricular,materia_campo_formacion, materia_nucleo\nFROM public.\"Materias\" WHERE materia_activa = 'true' AND materia_codigo LIKE '" + codigo + "';";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                m = this.obtenerMateria(rs);
            }
            MateriaMD materiaMD = m;
            return materiaMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultar materia por codigo. " + ex.getMessage());
            MateriaMD materiaMD = null;
            return materiaMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MateriaMD buscarMateriaPorReferencia(int idmateria) {
        MateriaMD m = new MateriaMD();
        String sql = "SELECT id_materia, id_carrera, materia_nombre, materia_ciclo FROM public.\"Materias\" WHERE materia_activa = 'true' AND id_materia= " + idmateria + ";";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                m.setId(rs.getInt("id_materia"));
                m.setNombre(rs.getString("materia_nombre"));
                m.setCiclo(rs.getInt("materia_ciclo"));
            }
            MateriaMD materiaMD = m;
            return materiaMD;
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultar materia por referencia. " + ex.getMessage());
            MateriaMD materiaMD = null;
            return materiaMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    public ArrayList<MateriaMD> cargarMaterias(String aguja) {
        this.sqlg = "SELECT id_materia, materia_codigo, materia_nombre, materia_ciclo, materia_horas_docencia, materia_horas_practicas, materia_horas_auto_estudio, materia_horas_presencial, materia_total_horas, m.id_carrera\nFROM public.\"Materias\" m, public.\"Carreras\" c\nWHERE materia_activa = 'true' AND (materia_codigo ILIKE '%" + aguja + "%' OR materia_nombre ILIKE '%" + aguja + "%') \nAND c.id_carrera = m.id_carrera AND carrera_activo = true;";
        return this.consultarMateriasParaTabla(this.sqlg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<MateriaMD> consultarMateriasParaTabla(String sql) {
        ArrayList<MateriaMD> lista = new ArrayList<MateriaMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                CarreraMD cr = new CarreraMD();
                cr.setId(rs.getInt("id_carrera"));
                m.setCarrera(cr);
                m.setCodigo(rs.getString("materia_codigo"));
                m.setNombre(rs.getString("materia_nombre"));
                m.setCiclo(rs.getInt("materia_ciclo"));
                m.setHorasDocencia(rs.getInt("materia_horas_docencia"));
                m.setHorasPracticas(rs.getInt("materia_horas_practicas"));
                m.setHorasPresenciales(rs.getInt("materia_horas_presencial"));
                m.setHorasAutoEstudio(rs.getInt("materia_horas_auto_estudio"));
                m.setTotalHoras(rs.getInt("materia_total_horas"));
                lista.add(m);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultar materia para tabla. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<MateriaMD> cargarMateriasCarreraCmb(int idCarrera) {
        String sql = "SELECT id_materia, materia_codigo, materia_nombre \nFROM public.\"Materias\" m \nWHERE materia_activa = 'true' AND m.id_carrera= " + idCarrera + ";";
        ArrayList<MateriaMD> lista = new ArrayList<MateriaMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                m.setCodigo(rs.getString("materia_codigo"));
                m.setNombre(rs.getString("materia_nombre"));
                lista.add(m);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultar materia para combo. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    public MateriaMD obtenerMateria(ResultSet rs) {
        MateriaMD m = new MateriaMD();
        try {
            m.setId(rs.getInt("id_materia"));
            CarreraMD carrera = new CarreraMD();
            carrera.setId(rs.getInt("id_carrera"));
            m.setCarrera(carrera);
            EjeFormacionMD eje = new EjeFormacionMD();
            eje.setId(rs.getInt("id_eje"));
            m.setEje(eje);
            m.setCodigo(rs.getString("materia_codigo"));
            m.setNombre(rs.getString("materia_nombre"));
            Integer numero = rs.getInt("materia_ciclo");
            if (numero == 0) {
                m.setCiclo(0);
            } else {
                m.setCiclo(numero);
            }
            m.setCreditos(rs.getString("materia_creditos"));
            String palabra = rs.getString("materia_tipo");
            if (palabra == null) {
                m.setTipo('A');
            } else {
                m.setTipo(palabra.charAt(0));
            }
            palabra = rs.getString("materia_categoria");
            if (palabra == null) {
                m.setCategoria("SELECCIONE");
            } else {
                m.setCategoria(palabra);
            }
            palabra = rs.getString("materia_tipo_acreditacion");
            if (palabra == null) {
                m.setTipoAcreditacion('A');
            } else {
                m.setTipoAcreditacion(rs.getString("materia_tipo_acreditacion").charAt(0));
            }
            numero = rs.getInt("materia_horas_docencia");
            if (numero == 0) {
                m.setHorasDocencia(0);
            } else {
                m.setHorasDocencia(rs.getInt("materia_horas_docencia"));
            }
            numero = rs.getInt("materia_horas_practicas");
            if (numero == 0) {
                m.setHorasPracticas(0);
            } else {
                m.setHorasPracticas(rs.getInt("materia_horas_practicas"));
            }
            numero = rs.getInt("materia_horas_presencial");
            if (numero == 0) {
                m.setHorasPresenciales(0);
            } else {
                m.setHorasPresenciales(rs.getInt("materia_horas_presencial"));
            }
            numero = rs.getInt("materia_horas_auto_estudio");
            if (numero == 0) {
                m.setHorasAutoEstudio(0);
            } else {
                m.setHorasAutoEstudio(rs.getInt("materia_horas_auto_estudio"));
            }
            numero = rs.getInt("materia_total_horas");
            if (numero == 0) {
                m.setTotalHoras(0);
            } else {
                m.setTotalHoras(rs.getInt("materia_total_horas"));
            }
            palabra = rs.getString("materia_objetivo");
            if (palabra == null) {
                m.setObjetivo(palabra);
            } else {
                m.setObjetivo(rs.getString("materia_objetivo"));
            }
            palabra = rs.getString("materia_descripcion");
            if (palabra == null) {
                m.setDescripcion(null);
            } else {
                m.setDescripcion(rs.getString("materia_descripcion"));
            }
            palabra = rs.getString("materia_objetivo_especifico");
            if (palabra == null) {
                m.setObjetivoespecifico(null);
            } else {
                m.setObjetivoespecifico(palabra);
            }
            palabra = rs.getString("materia_organizacion_curricular");
            if (palabra == null) {
                m.setOrganizacioncurricular("SELECCIONE");
            } else {
                m.setOrganizacioncurricular(palabra);
            }
            palabra = rs.getString("materia_campo_formacion");
            if (palabra == null) {
                m.setMateriacampoformacion("SELECCIONE");
            } else {
                m.setMateriacampoformacion(palabra);
            }
            m.setMateriaNucleo(rs.getBoolean("materia_nucleo"));
            palabra = rs.getString("materia_modalidad");
            if (palabra == null) {
                m.setModalidad("SELECCIONE");
            } else {
                m.setModalidad(palabra);
            }
            m.setItinerario(rs.getString("materia_itinerario"));
            palabra = rs.getString("materia_area_academica");
            if (palabra == null) {
                m.setAreaAcademica("SELECCIONE");
            } else {
                m.setAreaAcademica(palabra);
            }
            m.setPerfilEgreso(rs.getString("materia_perfil_egreso"));
            m.setEvaluacion(rs.getString("materia_evaluacion"));
            m.setHorasTutoria(rs.getInt("materia_horas_tutoria"));
            m.setActividadesPracticasProgramadas(rs.getString("materia_app"));
            m.setEstrategiasMetodologicas(rs.getString("materia_estrategias"));
            m.setRecursosDidacticos(rs.getString("materia_recursos"));
            return m;
        }
        catch (SQLException e) {
            System.out.println("No se pudo obtener la materia");
            System.out.println(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MateriaMD> selectWhere(CursoMD curso) {
        String SELECT = "SELECT\n\"Materias\".materia_nombre,\n\"Materias\".id_materia,\n\"Materias\".materia_horas_presencial\nFROM\n\"Cursos\"\nINNER JOIN \"Materias\" ON \"Cursos\".id_materia = \"Materias\".id_materia\nWHERE\n\"Cursos\".id_docente = ? AND\n\"Cursos\".id_prd_lectivo = ?AND \n\"Cursos\".curso_nombre = ?";
        System.out.println(SELECT);
        ArrayList<MateriaMD> lista = new ArrayList<MateriaMD>();
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, curso.getDocente().getIdDocente());
        parametros.put(2, curso.getPeriodo().getID());
        parametros.put(3, curso.getNombre());
        this.conn = this.POOL.getConnection();
        this.rst = this.POOL.ejecutarQuery(SELECT, this.conn, parametros);
        try {
            while (this.rst.next()) {
                MateriaMD materia = new MateriaMD();
                materia.setId(this.rst.getInt("id_materia"));
                materia.setNombre(this.rst.getString("materia_nombre"));
                materia.setHorasPresenciales(this.rst.getInt("materia_horas_presencial"));
                lista.add(materia);
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            this.POOL.closeStmt().close(this.rst).close(this.conn);
        }
        return lista;
    }

    public String getSql() {
        return this.sqlg;
    }

    public String getSqlm(int idmateria) {
        String sqlm = "SELECT id_materia, id_carrera, id_eje, materia_codigo, materia_nombre, materia_ciclo, materia_creditos, materia_tipo, materia_categoria, materia_tipo_acreditacion, materia_horas_docencia, materia_horas_practicas, materia_horas_auto_estudio, materia_horas_presencial, materia_total_horas, materia_activa, materia_objetivo,materia_descripcion,materia_objetivo_especifico,materia_organizacion_curricular,materia_campo_formacion, materia_nucleo\nFROM public.\"Materias\" WHERE materia_activa = 'true' AND id_materia= " + idmateria + ";";
        sqlm = "SELECT ma.id_materia,ma.materia_objetivo,ma.materia_objetivo_especifico,ma.materia_estrategias,ma.materia_recursos,ma.materia_nombre, ma.materia_horas_docencia, ma.materia_horas_practicas,ma.materia_evaluacion,ma.materia_codigo, ma.materia_horas_auto_estudio, ma.materia_horas_presencial,ma.materia_perfil_egreso,ma.materia_app,ma.materia_ciclo,materia_creditos, ma.materia_total_horas,ca.carrera_modalidad as materia_modalidad,ma.materia_itinerario,ma.materia_area_academica,ma.materia_horas_tutoria,case when ma.materia_ciclo = 1 then 'PRIMERO' when ma.materia_ciclo = 2 then 'SEGUNDO' when ma.materia_ciclo = 3 then 'TERCERO' when ma.materia_ciclo = 4 then 'CUARTO' when ma.materia_ciclo = 5 then 'QUINTO' when ma.materia_ciclo = 6 then 'SEXTO' when ma.materia_ciclo = 7 then 'SEPTIMO'  end as nivel, (select concat(docente_abreviatura,' ',p.persona_primer_nombre,' ',p.persona_primer_apellido) from \"Docentes\" join \"Personas\" p on \"Docentes\".id_persona = p.id_persona join \"Carreras\" C on \"Docentes\".id_docente = C.id_docente_coordinador where C.id_carrera=ca.id_carrera) as director, (select id_silabo from \"Silabo\"  where id_materia=" + idmateria + " order by id_silabo desc limit 1) as id_silabo,(select array_agg(concat(resultados_aprendizaje_unidad,'+')) from \"UnidadSilabo\" where id_silabo in (select id_silabo from \"Silabo\"  where id_materia=" + idmateria + " order by id_silabo desc limit 1)) as resultado_aprendizaje,(select sustentobb from \"Silabo\"  where id_materia=" + idmateria + " order by id_silabo desc limit 1) as sustentobb,(select sustentobc from \"Silabo\"  where id_materia=" + idmateria + " order by id_silabo desc limit 1) as sustentobc,ma.materia_objetivo_especifico,ma.materia_organizacion_curricular,ma.materia_campo_formacion, ma.materia_nucleo,(select array_agg(materia_nombre) from \"MateriaRequisitos\" mr join \"Materias\" mt on mr.id_materia_requisito=mt.id_materia where mr.id_materia=" + idmateria + " and mr.tipo_requisito='P' ) as prerequisitos, (select array_agg(materia_nombre) from \"MateriaRequisitos\" mr join \"Materias\" mt on mr.id_materia_requisito=mt.id_materia where mr.id_materia=" + idmateria + " and mr.tipo_requisito='C' ) as correquisitos, ca.carrera_nombre FROM \"Materias\" ma join \"Carreras\" ca on ma.id_carrera=ca.id_carrera WHERE materia_activa = 'true' AND id_materia=" + idmateria + ";";
        return sqlm;
    }

    public ArrayList<MateriaMD> getMateriasParaCorequisito(int idMateria) {
        String sql = "SELECT id_materia,  materia_nombre \nFROM public.\"Materias\" m \nWHERE materia_activa = 'true' AND m.id_carrera = (  SELECT id_carrera FROM public.\"Materias\"  WHERE id_materia = " + idMateria + ") AND materia_ciclo = ( SELECT materia_ciclo FROM public.\"Materias\"  WHERE id_materia = " + idMateria + ")AND materia_activa = true;";
        return this.getParaRequisitos(sql);
    }

    public ArrayList<MateriaMD> getMateriasParaPrequisitos(int idMateria) {
        String sql = "SELECT id_materia,  materia_nombre \nFROM public.\"Materias\" m \nWHERE materia_activa = 'true' AND m.id_carrera = (  SELECT id_carrera FROM public.\"Materias\"  WHERE id_materia = " + idMateria + ") AND materia_ciclo < ( SELECT materia_ciclo FROM public.\"Materias\"  WHERE id_materia = " + idMateria + ")AND materia_activa = true;";
        return this.getParaRequisitos(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<MateriaMD> getParaRequisitos(String sql) {
        ArrayList<MateriaMD> lista = new ArrayList<MateriaMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                m.setNombre(rs.getString("materia_nombre"));
                lista.add(m);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No se consultar materia para combo. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }
}

