/*
 * Decompiled with CFR 0.152.
 */
package modelo.materia;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import modelo.ConnDBPool;
import modelo.materia.AreaMD;
import utils.CONBD;
import utils.M;

public class AreaBD
extends CONBD {
    private final ConnDBPool POOL = new ConnDBPool();
    private Connection conn;
    private ResultSet rst;
    private static AreaBD ABD;

    public static AreaBD single() {
        if (ABD == null) {
            ABD = new AreaBD();
        }
        return ABD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertarArea(AreaMD area) {
        String sql = "INSERT INTO areas (id_carrera, area_nombre, area_descripcion_corta) VALUES (?, ?, ?)";
        try {
            this.conn = this.POOL.getConnection();
            PreparedStatement ps = this.conn.prepareStatement(sql);
            ps.setInt(1, area.getIdCarrera());
            ps.setString(2, area.getNombreArea());
            ps.setString(3, area.getDescripcionCorta());
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo insertar el \u00e1rea: " + e.getMessage());
        }
        finally {
            this.POOL.close(this.conn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editarArea(AreaMD area) {
        String sql = "UPDATE areas SET id_carrera = ?, area_nombre = ?, area_descripcion_corta = ? WHERE id_area = ?";
        try {
            this.conn = this.POOL.getConnection();
            PreparedStatement ps = this.conn.prepareStatement(sql);
            ps.setInt(1, area.getIdCarrera());
            ps.setString(2, area.getNombreArea());
            ps.setString(3, area.getDescripcionCorta());
            ps.setInt(4, area.getIdArea());
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo editar el \u00e1rea: " + e.getMessage());
        }
        finally {
            this.POOL.close(this.conn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean eliminarArea(int idArea) {
        String sql = "DELETE FROM areas WHERE id_area = ?";
        try {
            this.conn = this.POOL.getConnection();
            PreparedStatement ps = this.conn.prepareStatement(sql);
            ps.setInt(1, idArea);
            boolean bl = ps.executeUpdate() > 0;
            return bl;
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo eliminar el \u00e1rea: " + e.getMessage());
        }
        finally {
            this.POOL.close(this.conn);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AreaMD> obtenerAreasPorCarrera(int carrera) {
        String sql = "SELECT * FROM areas WHERE id_carrera = ?";
        ArrayList<AreaMD> areas = new ArrayList<AreaMD>();
        try {
            this.conn = this.POOL.getConnection();
            PreparedStatement ps = this.conn.prepareStatement(sql);
            ps.setInt(1, carrera);
            this.rst = ps.executeQuery();
            while (this.rst.next()) {
                AreaMD area = new AreaMD();
                area.setIdArea(this.rst.getInt("id_area"));
                area.setIdCarrera(this.rst.getInt("id_carrera"));
                area.setNombreArea(this.rst.getString("area_nombre"));
                area.setDescripcionCorta(this.rst.getString("area_descripcion_corta"));
                areas.add(area);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo obtener las \u00e1reas: " + e.getMessage());
        }
        finally {
            this.POOL.close(this.conn);
        }
        return areas;
    }
}

