/*
 * Decompiled with CFR 0.152.
 */
package modelo.fichas;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import modelo.ConnDBPool;
import modelo.fichas.FichaSaludMD;
import modelo.persona.PersonaMD;

public class FichaSaludBD
extends FichaSaludMD {
    private final ConnDBPool pool = new ConnDBPool();
    private Connection conn;
    private ResultSet rs;

    public List<FichaSaludMD> getFichas() {
        String SELECT = "SELECT\n\"FichaSalud\".\"id\",\n\"FichaSalud\".estado_revision,\n\"FichaSalud\".estado_envio,\n\"Personas\".persona_identificacion,\n\"Personas\".persona_primer_apellido,\n\"Personas\".persona_segundo_apellido,\n\"Personas\".persona_primer_nombre,\n\"Personas\".persona_segundo_nombre,\n\"FichaSalud\".ingreso_fin_extend,\n\"FichaSalud\".ingreso_inicio_extend\nFROM\n\"FichaSalud\"\nINNER JOIN \"Personas\" ON \"FichaSalud\".persona_id = \"Personas\".id_persona";
        ArrayList<FichaSaludMD> lista = new ArrayList<FichaSaludMD>();
        try {
            this.conn = this.pool.getConnection();
            this.rs = this.pool.ejecutarQuery(SELECT, this.conn, null);
            while (this.rs.next()) {
                Date fechaFin;
                FichaSaludMD ficha = new FichaSaludMD();
                ficha.setId(this.rs.getInt("id"));
                ficha.setEstadoRevision(this.rs.getBoolean("estado_revision"));
                ficha.setEstadoEnvio(this.rs.getBoolean("estado_envio"));
                PersonaMD persona = new PersonaMD();
                persona.setIdentificacion(this.rs.getString("persona_identificacion"));
                persona.setPrimerApellido(this.rs.getString("persona_primer_apellido"));
                persona.setSegundoNombre(this.rs.getString("persona_segundo_apellido"));
                persona.setPrimerNombre(this.rs.getString("persona_primer_nombre"));
                persona.setSegundoNombre(this.rs.getString("persona_segundo_nombre"));
                ficha.setPersona(persona);
                Date fechaInicio = this.rs.getDate("ingreso_fin_extend");
                if (fechaInicio != null) {
                    ficha.setIngresoFinExtend(fechaInicio.toLocalDate());
                }
                if ((fechaFin = this.rs.getDate("ingreso_inicio_extend")) != null) {
                    ficha.setIngresoInicioExtend(fechaFin.toLocalDate());
                }
                lista.add(ficha);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(FichaSaludBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        return lista;
    }
}

