/*
 * Decompiled with CFR 0.152.
 */
package modelo.estrategiasAprendizaje;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.estrategiasAprendizaje.EstrategiasAprendizajeMD;
import modelo.estrategiasAprendizaje.IEstrategiaAprendizajeBD;
import utils.CONBD;

public class NEWEstrategiaAprendizajeBD
extends CONBD
implements IEstrategiaAprendizajeBD {
    private static NEWEstrategiaAprendizajeBD EBD;

    public static NEWEstrategiaAprendizajeBD single() {
        if (EBD == null) {
            EBD = new NEWEstrategiaAprendizajeBD();
        }
        return EBD;
    }

    @Override
    public int guardar(EstrategiasAprendizajeMD estrategia) {
        String sql = "INSERT INTO public.\"EstrategiasAprendizaje\"( descripcion_estrategia) VALUES (?);";
        PreparedStatement ps = CON.getPSID(sql);
        try {
            ps.setString(1, estrategia.getDescripcionEstrategia());
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al guardar una estrategia.\n" + e.getMessage(), "Error al guardar", 0);
        }
        return CON.getIDGenerado(ps);
    }

    @Override
    public List<EstrategiasAprendizajeMD> getAll() {
        String sql = "SELECT DISTINCT id_estrategia, descripcion_estrategia FROM public.\"EstrategiasAprendizaje\" ORDER BY descripcion_estrategia;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        return this.getByPS(ps);
    }

    @Override
    public List<EstrategiasAprendizajeMD> getByDescripcion(String descripcion) {
        String sql = "SELECT DSITINCT id_estrategia, descripcion_estrategia FROM public.\"EstrategiasAprendizaje\" WHERE descripcion_estrategia ILIKE ? ORDER BY descripcion_estrategia;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setString(2, "%" + descripcion + "%");
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al preparar la consulta por descripcion. \n" + e.getMessage(), "Error al consultar", 0);
        }
        return this.getByPS(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EstrategiasAprendizajeMD> getByPS(PreparedStatement ps) {
        ArrayList<EstrategiasAprendizajeMD> ES = new ArrayList<EstrategiasAprendizajeMD>();
        try {
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                EstrategiasAprendizajeMD e = new EstrategiasAprendizajeMD();
                e.setIdEstrategia(res.getInt(1));
                e.setDescripcionEstrategia(res.getString(2));
                ES.add(e);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al mapear los datos en el modelo.\n" + e.getMessage(), "Error al consultar", 0);
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return ES;
    }
}

