/*
 * Decompiled with CFR 0.152.
 */
package modelo.curso;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalTime;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import modelo.ConnDBPool;
import modelo.curso.CursoMD;
import modelo.curso.SesionClaseMD;
import modelo.materia.MateriaMD;
import modelo.persona.DocenteMD;
import utils.CONBD;
import utils.M;

public class SesionClaseBD
extends CONBD {
    private final ConnDBPool pool = new ConnDBPool();
    private ResultSet rst;
    private Connection conn;
    private String sql;
    private String nsql;
    private static SesionClaseBD SCBD;

    public static SesionClaseBD single() {
        if (SCBD == null) {
            SCBD = new SesionClaseBD();
        }
        return SCBD;
    }

    public void ingresar(SesionClaseMD sc) {
        this.nsql = "INSERT INTO public.\"SesionClase\"(\nid_curso, dia_sesion, hora_inicio_sesion, hora_fin_sesion)\nVALUES (" + sc.getCurso().getId() + ", " + sc.getDia() + ", '" + sc.getHoraIni() + "', '" + sc.getHoraFin() + "');";
        if (CON.executeNoSQL(this.nsql)) {
            JOptionPane.showMessageDialog(null, "Se guardo correctamente el horario.");
        } else {
            JOptionPane.showMessageDialog(null, "No se pudo guardar el horario correctamente.");
        }
    }

    public String obtenerInsert(SesionClaseMD sc) {
        this.nsql = "INSERT INTO public.\"SesionClase\"(\nid_curso, dia_sesion, hora_inicio_sesion, hora_fin_sesion)\nVALUES (" + sc.getCurso().getId() + ", " + sc.getDia() + ", '" + sc.getHoraIni() + "', '" + sc.getHoraFin() + "');";
        return this.nsql;
    }

    public void ingresarHorarios(String nsql) {
        if (CON.executeNoSQL(nsql)) {
            JOptionPane.showMessageDialog(null, "Se guardo correctamente el horario.");
        } else {
            JOptionPane.showMessageDialog(null, "No se pudo guardar el horario correctamente.");
        }
    }

    public void editar(SesionClaseMD sc) {
        this.nsql = "UPDATE public.\"SesionClase\"\nSET dia_sesion=" + sc.getDia() + ", hora_inicio_sesion='" + sc.getHoraIni() + "', hora_fin_sesion='" + sc.getHoraFin() + "' WHERE id_sesion=" + sc.getId() + ";";
        if (CON.executeNoSQL(this.sql)) {
            JOptionPane.showMessageDialog(null, "Se edito correctamente el horario.");
        } else {
            JOptionPane.showMessageDialog(null, "No se pudo editar correctamente el horario.");
        }
    }

    public void eliminar(int idSesion) {
        this.nsql = "DELETE FROM public.\"SesionClase\"\nWHERE id_sesion= " + idSesion + ";";
        if (CON.executeNoSQL(this.nsql)) {
            JOptionPane.showMessageDialog(null, "Se elimino correctamente el horario.");
        } else {
            JOptionPane.showMessageDialog(null, "No se pudo eliminar correctamente el horario.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SesionClaseMD buscarSesion(int idSesion) {
        SesionClaseMD s = new SesionClaseMD();
        this.sql = "SELECT id_sesion, id_curso, dia_sesion, hora_inicio_sesion, hora_fin_sesion FROM public.\"SesionClase\" WHERE id_sesion = " + idSesion + ";";
        PreparedStatement ps = CON.getPSPOOL(this.sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CursoMD c = new CursoMD();
                s.setId(rs.getInt("id_sesion"));
                c.setId(rs.getInt("id_curso"));
                s.setCurso(c);
                s.setDia(rs.getInt("dia_sesion"));
                s.setHoraFin(rs.getTime("hora_fin_sesion").toLocalTime());
                s.setHoraIni(rs.getTime("hora_inicio_sesion").toLocalTime());
            }
            SesionClaseMD sesionClaseMD = s;
            return sesionClaseMD;
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar sesion " + e.getMessage());
            SesionClaseMD sesionClaseMD = null;
            return sesionClaseMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SesionClaseMD existeSesion(int idCurso, int dia, LocalTime horaIni, LocalTime horaFin) {
        SesionClaseMD s = new SesionClaseMD();
        this.sql = "SELECT id_sesion, id_curso, dia_sesion, hora_inicio_sesion, hora_fin_sesion FROM public.\"SesionClase\" \nWHERE dia_sesion = " + dia + " AND id_curso = " + idCurso + " \nAND hora_inicio_sesion = '" + horaIni.toString() + "' AND hora_fin_sesion = '" + horaFin.toString() + "';";
        PreparedStatement ps = CON.getPSPOOL(this.sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CursoMD c = new CursoMD();
                s.setId(rs.getInt("id_sesion"));
                c.setId(rs.getInt("id_curso"));
                s.setCurso(c);
                s.setDia(rs.getInt("dia_sesion"));
                s.setHoraFin(rs.getTime("hora_fin_sesion").toLocalTime());
                s.setHoraIni(rs.getTime("hora_inicio_sesion").toLocalTime());
            }
            SesionClaseMD sesionClaseMD = s;
            return sesionClaseMD;
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar sesion " + e.getMessage());
            SesionClaseMD sesionClaseMD = null;
            return sesionClaseMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SesionClaseMD> cargarHorarioCursoPorDia(int idCurso, int dia) {
        this.sql = "SELECT id_sesion, dia_sesion, hora_inicio_sesion, hora_fin_sesion \n\tFROM public.\"SesionClase\" \n\tWHERE id_curso = " + idCurso + " \n\tAND dia_sesion = " + dia + " ;";
        ArrayList<SesionClaseMD> sesiones = new ArrayList<SesionClaseMD>();
        PreparedStatement ps = CON.getPSPOOL(this.sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                SesionClaseMD s = new SesionClaseMD();
                s.setDia(rs.getInt("dia_sesion"));
                s.setHoraFin(rs.getTime("hora_fin_sesion").toLocalTime());
                s.setHoraIni(rs.getTime("hora_inicio_sesion").toLocalTime());
                s.setId(rs.getInt("id_sesion"));
                sesiones.add(s);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar sesion " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return sesiones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SesionClaseMD> cargarHorarioCurso(CursoMD curso) {
        this.sql = "SELECT id_sesion, dia_sesion, hora_inicio_sesion, hora_fin_sesion FROM public.\"SesionClase\"  WHERE id_curso = " + curso.getId() + " ORDER BY dia_sesion;";
        ArrayList<SesionClaseMD> sesiones = new ArrayList<SesionClaseMD>();
        PreparedStatement ps = CON.getPSPOOL(this.sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                SesionClaseMD s = new SesionClaseMD();
                s.setCurso(curso);
                s.setDia(rs.getInt("dia_sesion"));
                s.setHoraFin(rs.getTime("hora_fin_sesion").toLocalTime());
                s.setHoraIni(rs.getTime("hora_inicio_sesion").toLocalTime());
                s.setId(rs.getInt("id_sesion"));
                sesiones.add(s);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar sesion " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return sesiones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SesionClaseMD> cargarHorarioCursoPorDia(String nombreCurso, int dia, int idPrdLectivo) {
        this.sql = "SELECT id_sesion, sc.id_curso, \nhora_inicio_sesion, hora_fin_sesion, \nmateria_nombre, materia_codigo, \npersona_primer_nombre, persona_primer_apellido, \ndocente_abreviatura\nFROM public.\"SesionClase\" sc, public.\"Cursos\" c,\npublic.\"Materias\" m, public.\"Docentes\" d, \npublic.\"Personas\" p\nWHERE sc.id_curso IN (\n\tSELECT id_curso\n\tFROM public.\"Cursos\"\n\tWHERE id_prd_lectivo = " + idPrdLectivo + "  AND \n\tcurso_nombre = '" + nombreCurso + "'\n) AND dia_sesion = " + dia + " AND\nc.id_curso = sc.id_curso AND \nd.id_docente = c.id_docente AND\np.id_persona = d.id_persona AND \nm.id_materia = c.id_materia\nORDER BY hora_inicio_sesion";
        ArrayList<SesionClaseMD> sesiones = new ArrayList<SesionClaseMD>();
        PreparedStatement ps = CON.getPSPOOL(this.sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                SesionClaseMD s = new SesionClaseMD();
                s.setId(rs.getInt("id_sesion"));
                s.setHoraFin(rs.getTime("hora_fin_sesion").toLocalTime());
                s.setHoraIni(rs.getTime("hora_inicio_sesion").toLocalTime());
                CursoMD c = new CursoMD();
                c.setId(rs.getInt("id_curso"));
                MateriaMD m = new MateriaMD();
                m.setNombre(rs.getString("materia_nombre"));
                m.setCodigo(rs.getString("materia_codigo"));
                DocenteMD d = new DocenteMD();
                d.setPrimerNombre(rs.getString("persona_primer_nombre"));
                d.setPrimerApellido(rs.getString("persona_primer_apellido"));
                c.setDocente(d);
                c.setMateria(m);
                s.setCurso(c);
                sesiones.add(s);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar sesion " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return sesiones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SesionClaseMD> cargarHorarioCurso(String nombreCurso, int idPrdLectivo) {
        this.sql = "SELECT id_sesion, dia_sesion, hora_inicio_sesion, hora_fin_sesion, id_curso \n\tFROM public.\"SesionClase\" \n\tWHERE id_curso IN (\n\tSELECT id_curso\n\tFROM public.\"Cursos\"\n\tWHERE id_prd_lectivo = " + idPrdLectivo + "  AND \n\tcurso_nombre = '" + nombreCurso + "');";
        ArrayList<SesionClaseMD> sesiones = new ArrayList<SesionClaseMD>();
        PreparedStatement ps = CON.getPSPOOL(this.sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                SesionClaseMD s = new SesionClaseMD();
                CursoMD c = new CursoMD();
                c.setId(rs.getInt("id_curso"));
                s.setCurso(c);
                s.setDia(rs.getInt("dia_sesion"));
                s.setHoraFin(rs.getTime("hora_fin_sesion").toLocalTime());
                s.setHoraIni(rs.getTime("hora_inicio_sesion").toLocalTime());
                s.setId(rs.getInt("id_sesion"));
                sesiones.add(s);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar sesion " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return sesiones;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<SesionClaseMD> cargarDiasClase(String nombreCurso, int idPrdLectivo, int idDocente, String materiaNombre) {
        this.sql = "SELECT\n\t\"SesionClase\".dia_sesion \nFROM\n\tpublic.\"SesionClase\"\n\tINNER JOIN public.\"Cursos\" ON public.\"Cursos\".id_curso = public.\"SesionClase\".id_curso\n\tINNER JOIN public.\"Docentes\" ON public.\"Docentes\".id_docente = public.\"Cursos\".id_docente\n\tINNER JOIN public.\"PeriodoLectivo\" ON public.\"Cursos\".id_prd_lectivo = public.\"PeriodoLectivo\".id_prd_lectivo\n\tINNER JOIN public.\"Carreras\" ON public.\"Carreras\".id_carrera = public.\"PeriodoLectivo\".id_carrera\n\tINNER JOIN public.\"Materias\" ON public.\"Materias\".id_carrera = public.\"Carreras\".id_carrera \nWHERE\n\tpublic.\"Cursos\".id_docente = " + idDocente + " \n\tAND public.\"Cursos\".curso_nombre = '" + nombreCurso + "' \n\tAND public.\"PeriodoLectivo\".id_prd_lectivo = " + idPrdLectivo + " \n\tAND public.\"Materias\".materia_nombre = '" + materiaNombre + "' \nGROUP BY\n\t\"SesionClase\".dia_sesion;";
        ArrayList<SesionClaseMD> diasClase = new ArrayList<SesionClaseMD>();
        this.conn = this.pool.getConnection();
        this.rst = this.pool.ejecutarQuery(this.sql, this.conn, null);
        try {
            Object s;
            while (this.rst.next()) {
                s = new SesionClaseMD();
                ((SesionClaseMD)s).setDia(this.rst.getInt("dia_sesion"));
                ((SesionClaseMD)s).setNumeroDias(this.rst.getInt(1));
                diasClase.add((SesionClaseMD)s);
            }
            s = diasClase;
            return s;
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            this.pool.close(this.conn);
        }
        return diasClase;
    }
}

