/*
 * Decompiled with CFR 0.152.
 */
package modelo.curso;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.ConnDBPool;
import modelo.alumno.AlumnoCursoMD;
import modelo.curso.CursoMD;
import modelo.jornada.JornadaMD;
import modelo.materia.MateriaMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.AlumnoMD;
import modelo.persona.DocenteMD;
import utils.CONBD;
import utils.M;

public class CursoBD
extends CONBD {
    private final ConnDBPool POOL = new ConnDBPool();
    private Connection conn;
    private ResultSet rst;
    private static CursoBD CBD;

    public static CursoBD single() {
        if (CBD == null) {
            CBD = new CursoBD();
        }
        return CBD;
    }

    public void guardarCurso(CursoMD c) {
        String nsql = "INSERT INTO public.\"Cursos\"(\nid_materia, id_prd_lectivo, id_docente, id_jornada, curso_nombre, curso_capacidad, curso_ciclo,curso_paralelo)\nVALUES (" + c.getMateria().getId() + ", " + c.getPeriodo().getID() + ", " + c.getDocente().getIdDocente() + ", " + c.getJornada().getId() + ", '" + c.getNombre() + "', " + c.getCapacidad() + ", " + c.getCiclo() + ", '" + c.getParalelo() + "');";
        if (CON.executeNoSQL(nsql)) {
            JOptionPane.showMessageDialog(null, "Se guardo correctamente el curso " + c.getNombre());
        }
    }

    public void editarCurso(CursoMD c) {
        String nsql = "UPDATE public.\"Cursos\"\nSET id_materia=" + c.getMateria().getId() + ",  id_prd_lectivo=" + c.getPeriodo().getID() + ", id_docente= " + c.getDocente().getIdDocente() + ", id_jornada=" + c.getJornada().getId() + ", curso_nombre='" + c.getNombre() + "', curso_capacidad=" + c.getCapacidad() + ", curso_ciclo=" + c.getCiclo() + ", curso_paralelo= '" + c.getParalelo() + "' WHERE id_curso = " + c.getId() + ";";
        if (CON.executeNoSQL(nsql)) {
            JOptionPane.showMessageDialog(null, "Se edito correctamente el curso " + c.getNombre());
        } else {
            JOptionPane.showMessageDialog(null, "No se pudo editar el curso " + c.getNombre());
        }
    }

    public void eliminarCurso(int idCurso) {
        String nsql = "UPDATE public.\"Cursos\" SET curso_activo = false WHERE id_curso = " + idCurso + ";";
        if (CON.executeNoSQL(nsql)) {
            JOptionPane.showMessageDialog(null, "Se elimino correctamente. ");
        } else {
            JOptionPane.showMessageDialog(null, "No se pudo eliminar correctamente, \ncompruebe su conexion a internet.");
        }
    }

    public void activarCurso(int idCurso) {
        String nsql = "UPDATE public.\"Cursos\" SET curso_activo = true WHERE id_curso = " + idCurso + ";";
        if (CON.executeNoSQL(nsql)) {
            JOptionPane.showMessageDialog(null, "Se activo correctamente. ");
        } else {
            JOptionPane.showMessageDialog(null, "No se pudo activar,compruebe su conexion a internet.");
        }
    }

    public boolean nuevoCurso(CursoMD c) {
        String nsql = "INSERT INTO public.\"Cursos\"(\n\tid_materia, id_prd_lectivo, id_docente, id_jornada, \n\tcurso_nombre, curso_capacidad, curso_ciclo,\n\tcurso_paralelo, curso_activo)\n\tVALUES (" + c.getMateria().getId() + ", " + c.getPeriodo().getID() + ", " + c.getDocente().getIdDocente() + ", " + c.getJornada().getId() + ", '" + c.getNombre() + "', " + c.getCapacidad() + ", " + c.getCiclo() + ", '" + c.getParalelo() + "', true);";
        return CON.executeNoSQL(nsql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> consultaCursos() {
        String sql = "SELECT id_materia\nFROM public.\"Cursos\"\nGROUP BY id_materia, id_prd_lectivo, curso_nombre\nHAVING count(*) > 1";
        ArrayList<Integer> lista = new ArrayList<Integer>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                lista.add(rs.getInt("id_materia"));
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No se pudieron consultar alumnos. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AlumnoCursoMD> extraerAlumnosCurso(int curso) {
        String sql = "SELECT id_almn_curso, id_alumno, id_curso, almn_curso_asistencia, almn_curso_nota_final, almn_curso_num_faltas WHERE id_curso = " + curso + ";";
        PreparedStatement ps = CON.getPSPOOL(sql);
        ArrayList<AlumnoCursoMD> lista = new ArrayList<AlumnoCursoMD>();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AlumnoCursoMD c = new AlumnoCursoMD();
                c.setId(rs.getInt("id_almn_curso"));
                AlumnoMD a = new AlumnoMD();
                a.setId_Alumno(rs.getInt("id_alumno"));
                CursoMD cur = new CursoMD();
                cur.setId(rs.getInt("id_curso"));
                c.setAsistencia(rs.getString("almn_curso_asistencia"));
                c.setNotaFinal(rs.getDouble("almn_curso_nota_final"));
                c.setNumFalta(rs.getInt("almn_curso_num_faltas"));
                c.setAlumno(a);
                c.setCurso(cur);
                lista.add(c);
            }
        }
        catch (SQLException ex) {
            M.errorMsg("No se pudieron consultar alumnos. " + ex.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    public boolean nuevoAlumnoCurso(AlumnoCursoMD a, int curso) {
        String nsql = "INSERT INTO public.\"AlumnoCurso\"(\nid_alumno, id_curso, almn_curso_asistencia, almn_curso_nota_final, almn_curso_estado, almn_curso_num_faltas, almn_curso_fecha_registro, almn_curso_activo) VALUES (" + a.getAlumno().getId_Alumno() + ", " + curso + ", " + a.getAsistencia() + ", " + a.getNotaFinal() + ", true, '" + a.getNumFalta() + "', now(), true);";
        return CON.executeNoSQL(nsql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursoMD atraparCurso(int materia, int periodo, int docente, String curso) {
        String sql = "SELECT id_curso, id_materia, id_prd_lectivo, id_docente, id_jornada, curso_nombre, curso_capacidad, curso_ciclo, curso_paralelo, curso_activo FROM public.\"Cursos\" WHERE id_materia = " + materia + " AND id_prd_lectivo = " + periodo + " AND id_docente = " + docente + " AND curso_nombre LIKE '" + curso + "';";
        PreparedStatement ps = CON.getPSPOOL(sql);
        CursoMD c = new CursoMD();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                c.setId(rs.getInt("id_curso"));
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                c.setMateria(m);
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                p.setID(rs.getInt("id_prd_lectivo"));
                c.setPeriodo(p);
                DocenteMD d = new DocenteMD();
                d.setIdDocente(rs.getInt("id_docente"));
                c.setDocente(d);
                JornadaMD j = new JornadaMD();
                j.setId(rs.getInt("id_jornada"));
                c.setJornada(j);
                c.setNombre(rs.getString("curso_nombre"));
                c.setCapacidad(rs.getInt("curso_capacidad"));
                c.setCiclo(rs.getInt("curso_ciclo"));
                c.setParalelo(rs.getString("curso_paralelo"));
                c.setActivo(rs.getBoolean("curso_activo"));
            }
            CursoMD cursoMD = c;
            return cursoMD;
        }
        catch (SQLException e) {
            M.errorMsg("No pudimos consultar cursos. " + e.getMessage());
            CursoMD cursoMD = null;
            return cursoMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numAlumnos(int idCurso) {
        int num = 0;
        String sql = "SELECT count(id_curso) FROM public.\"AlumnoCurso\" WHERE id_curso =" + idCurso + "AND almn_curso_activo = true;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                num = rs.getInt(1);
            }
            ps.getConnection().close();
        }
        catch (SQLException e) {
            M.errorMsg("No pudimos consultar cursos. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return num;
    }

    public ArrayList<CursoMD> cargarCursos() {
        String sql = "SELECT  (SELECT count(*)\n  FROM public.\"AlumnoCurso\"\n  WHERE id_curso = c.id_curso   AND almn_curso_activo = true),\nid_curso, materia_nombre, \npersona_primer_nombre, persona_primer_apellido, persona_identificacion, \ncurso_nombre, curso_capacidad, curso_ciclo, \nc.id_prd_lectivo, c.id_materia, c.id_docente, \nprd_lectivo_nombre \nFROM public.\"Cursos\" c, public.\"Materias\" m, \npublic.\"Docentes\" d, public.\"Personas\" p, \npublic.\"PeriodoLectivo\" pl \nWHERE m.id_materia = c.id_materia AND \nd.id_docente = c.id_docente AND \np.id_persona = d.id_persona AND persona_activa = true AND\ndocente_activo = true AND \npl.id_prd_lectivo = c.id_prd_lectivo AND \nprd_lectivo_activo = true AND curso_activo = true;";
        return this.consultarCursos(sql);
    }

    public ArrayList<CursoMD> cargarCursosEliminados() {
        String sql = "SELECT  (SELECT count(*)\n  FROM public.\"AlumnoCurso\"\n  WHERE id_curso = c.id_curso AND almn_curso_activo = true),\nid_curso, materia_nombre, \npersona_primer_nombre, persona_primer_apellido, persona_identificacion, \ncurso_nombre, curso_capacidad, curso_ciclo, \nc.id_prd_lectivo, c.id_materia, c.id_docente, \nprd_lectivo_nombre \nFROM public.\"Cursos\" c, public.\"Materias\" m, \npublic.\"Docentes\" d, public.\"Personas\" p, \npublic.\"PeriodoLectivo\" pl \nWHERE m.id_materia = c.id_materia AND \nd.id_docente = c.id_docente AND \np.id_persona = d.id_persona AND persona_activa = true AND\ndocente_activo = true AND \npl.id_prd_lectivo = c.id_prd_lectivo AND \nprd_lectivo_activo = true AND curso_activo = false;";
        return this.consultarCursos(sql);
    }

    public ArrayList<CursoMD> cargarCursosPorPeriodo(int idPrdLectivo) {
        String sql = "SELECT  (SELECT count(*)\n  FROM public.\"AlumnoCurso\"\n  WHERE id_curso = c.id_curso AND almn_curso_activo = true),\nid_curso, materia_nombre, \npersona_primer_nombre, persona_primer_apellido, persona_identificacion, \ncurso_nombre, curso_capacidad, curso_ciclo, \nc.id_prd_lectivo, c.id_materia, c.id_docente, prd_lectivo_nombre\nFROM public.\"Cursos\" c, public.\"Materias\" m, \npublic.\"Docentes\" d, public.\"Personas\" p, \npublic.\"PeriodoLectivo\" pl \nWHERE m.id_materia = c.id_materia AND \nd.id_docente = c.id_docente AND \np.id_persona = d.id_persona \nAND C.id_prd_lectivo = " + idPrdLectivo + " AND \npl.id_prd_lectivo = c.id_prd_lectivo AND \nprd_lectivo_activo = true AND curso_activo = true;";
        return this.consultarCursos(sql);
    }

    public ArrayList<CursoMD> cargarCursosPorNombre(String nombre) {
        String sql = "SELECT  (SELECT count(*)\n  FROM public.\"AlumnoCurso\"\n  WHERE id_curso = c.id_curso AND almn_curso_activo = true),\nid_curso, materia_nombre, \npersona_primer_nombre, persona_primer_apellido, persona_identificacion, \ncurso_nombre, curso_capacidad, curso_ciclo, \nc.id_prd_lectivo, c.id_materia, c.id_docente, \nprd_lectivo_nombre \nFROM public.\"Cursos\" c, public.\"Materias\" m, \npublic.\"Docentes\" d, public.\"Personas\" p, \npublic.\"PeriodoLectivo\" pl \nWHERE m.id_materia = c.id_materia AND \nd.id_docente = c.id_docente AND \np.id_persona = d.id_persona \nAND curso_nombre = '" + nombre + "' AND \n pl.id_prd_lectivo = c.id_prd_lectivo AND curso_activo = true;";
        return this.consultarCursos(sql);
    }

    public ArrayList<CursoMD> cargarCursosPorNombreYPrdLectivo(String nombre, int idPrdLectivo) {
        String sql = "SELECT  (SELECT count(*)\n  FROM public.\"AlumnoCurso\"\n  WHERE id_curso = c.id_curso AND almn_curso_activo = true),\nid_curso, materia_nombre, \npersona_primer_nombre, persona_primer_apellido,persona_identificacion, \ncurso_nombre, curso_capacidad, curso_ciclo, \nc.id_prd_lectivo, c.id_materia, c.id_docente, \nprd_lectivo_nombre \nFROM public.\"Cursos\" c, public.\"Materias\" m, \npublic.\"Docentes\" d, public.\"Personas\" p, \npublic.\"PeriodoLectivo\" pl \nWHERE m.id_materia = c.id_materia AND \nd.id_docente = c.id_docente AND \np.id_persona = d.id_persona \nAND curso_nombre = '" + nombre + "' AND \nc.id_prd_lectivo = " + idPrdLectivo + " AND \npl.id_prd_lectivo = c.id_prd_lectivo AND \nprd_lectivo_activo = true AND curso_activo = true;";
        return this.consultarCursos(sql);
    }

    public ArrayList<CursoMD> buscarCursos(String aguja) {
        String sql = "SELECT  (SELECT count(*)\n  FROM public.\"AlumnoCurso\"\n  WHERE id_curso = c.id_curso AND almn_curso_activo = true),\nid_curso, materia_nombre, \npersona_primer_nombre, persona_primer_apellido, \npersona_identificacion, \ncurso_nombre, curso_capacidad, curso_ciclo, \nc.id_prd_lectivo, c.id_materia, c.id_docente, \nprd_lectivo_nombre \nFROM public.\"Cursos\" c, public.\"Materias\" m, \npublic.\"Docentes\" d, public.\"Personas\" p, \npublic.\"PeriodoLectivo\" pl \nWHERE m.id_materia = c.id_materia AND \nd.id_docente = c.id_docente AND \np.id_persona = d.id_persona AND \npl.id_prd_lectivo = c.id_prd_lectivo AND\n(materia_nombre ILIKE '%" + aguja + "%' OR \npersona_primer_nombre || ' ' || persona_segundo_nombre || ' ' || persona_primer_apellido || ' ' || persona_segundo_apellido ILIKE '%" + aguja + "%'\nOR persona_identificacion ILIKE '%" + aguja + "%') AND \npersona_activa = true AND docente_activo = true AND curso_activo = true;";
        return this.consultarCursos(sql);
    }

    public ArrayList<CursoMD> buscarCursosPorNombreYPrdLectivo(String nombre, int idPrdLectivo, int idAlumno) {
        String sql = "SELECT id_curso, c.id_materia, materia_nombre, curso_capacidad, curso_ciclo, ( SELECT count(*)   FROM public.\"AlumnoCurso\"   WHERE id_curso = c.id_curso   AND almn_curso_activo = true ), curso_nombre FROM public.\"Cursos\" c, public.\"Materias\" m WHERE curso_nombre = '" + nombre + "'  AND m.id_materia = c.id_materia  AND id_prd_lectivo = " + idPrdLectivo + " AND curso_activo = true  AND c.id_materia NOT IN (  SELECT cr.id_materia   FROM public.\"AlumnoCurso\" acr   JOIN public.\"Cursos\" cr   ON acr.id_curso = cr.id_curso   WHERE id_alumno = " + idAlumno + "   AND cr.id_prd_lectivo = " + idPrdLectivo + "  );";
        System.out.println("Consulta: " + sql);
        return this.getCursosCmb(sql, nombre);
    }

    public ArrayList<CursoMD> buscarCursosPorNombreYPrdLectivo(String nombre, int idPrdLectivo) {
        String sql = "SELECT id_curso, c.id_materia, materia_nombre, curso_capacidad, curso_ciclo, ( SELECT count(*)   FROM public.\"AlumnoCurso\"   WHERE id_curso = c.id_curso   AND almn_curso_activo = true ), curso_nombre FROM public.\"Cursos\" c, public.\"Materias\" m WHERE curso_nombre = '" + nombre + "'  AND m.id_materia = c.id_materia  AND id_prd_lectivo = " + idPrdLectivo + " AND curso_activo = true; ";
        return this.getCursosCmb(sql, nombre);
    }

    public ArrayList<CursoMD> buscarCursosPorPeriodoAlumno(int idPrdLectivo, int idAlumno) {
        String sql = "SELECT id_curso, c.id_materia, materia_nombre, curso_capacidad, curso_ciclo, ( SELECT count(*)   FROM public.\"AlumnoCurso\"   WHERE id_curso = c.id_curso   AND almn_curso_activo = true ), curso_nombre FROM public.\"Cursos\" c, public.\"Materias\" m WHERE m.id_materia = c.id_materia  AND id_prd_lectivo = " + idPrdLectivo + " AND curso_activo = true  AND m.id_materia NOT IN (  SELECT cr.id_materia   FROM public.\"AlumnoCurso\" acr   JOIN public.\"Cursos\" cr   ON acr.id_curso = cr.id_curso   WHERE acr.id_alumno = " + idAlumno + "   AND almn_curso_nota_final >= 70  ) AND m.id_materia NOT IN (  SELECT cr.id_materia   FROM public.\"AlumnoCurso\" acr   JOIN public.\"Cursos\" cr   ON acr.id_curso = cr.id_curso   WHERE acr.id_alumno = " + idAlumno + "   AND cr.id_prd_lectivo = " + idPrdLectivo + " ) ";
        return this.getCursosCmb(sql, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<CursoMD> getCursosCmb(String sql, String nombre) {
        ArrayList<CursoMD> cursos = new ArrayList<CursoMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CursoMD c = new CursoMD();
                c.setId(rs.getInt("id_curso"));
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                m.setNombre(rs.getString("materia_nombre"));
                c.setMateria(m);
                c.setCapacidad(rs.getInt("curso_capacidad"));
                c.setCiclo(rs.getInt("curso_ciclo"));
                c.setNombre(rs.getString("curso_nombre"));
                c.setNumMatriculados(rs.getInt(6));
                cursos.add(c);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar cursos." + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return cursos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursoMD extraerId(String nombre) {
        String sql = "SELECT id_curso FROM public.\"Cursos\" WHERE curso_nombre LIKE '" + nombre + "';";
        CursoMD c = new CursoMD();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                c.setId(rs.getInt("id_curso"));
            }
            ps.getConnection().close();
            CursoMD cursoMD = c;
            return cursoMD;
        }
        catch (SQLException e) {
            M.errorMsg("Error al consultar cursos." + e.getMessage());
            CursoMD cursoMD = null;
            return cursoMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CursoMD> buscarCursosPorAlumno(String cedula, String nomCurso) {
        String sql = "SELECT id_curso, c.id_materia, c.id_docente, materia_nombre,\npersona_primer_nombre, persona_segundo_nombre, persona_primer_apellido, \npersona_segundo_apellido\nFROM public.\"Cursos\" c, public.\"Materias\" m, public.\"Docentes\" d, \npublic.\"Personas\" p\nWHERE curso_nombre = '" + nomCurso + "' AND \nid_curso IN (\n\tSELECT id_curso \n\tFROM public.\"AlumnoCurso\" ac, public.\"Alumnos\" a,\n\tpublic.\"Personas\" p \n\tWHERE persona_identificacion = '" + cedula + "' AND\n\ta.id_persona = p.id_persona AND \n\tac.id_alumno = a.id_alumno) AND\nm.id_materia = c.id_materia AND\nd.id_docente = c.id_docente AND\np.id_persona = d.id_persona AND curso_activo = true ;";
        ArrayList<CursoMD> cursos = new ArrayList<CursoMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CursoMD c = new CursoMD();
                c.setId(rs.getInt("id_curso"));
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                m.setNombre(rs.getString("materia_nombre"));
                c.setMateria(m);
                DocenteMD dc = new DocenteMD();
                dc.setIdDocente(rs.getInt("id_docente"));
                dc.setPrimerNombre(rs.getString("persona_primer_nombre"));
                dc.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                dc.setPrimerApellido(rs.getString("persona_primer_apellido"));
                dc.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                c.setDocente(dc);
                cursos.add(c);
            }
        }
        catch (SQLException e) {
            M.errorMsg("Error al consultar cursos." + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return cursos;
    }

    public ArrayList<String> cargarNombreCursos() {
        String sql = "SELECT DISTINCT curso_nombre\nFROM public.\"Cursos\" \nWHERE curso_activo = true \nORDER BY curso_nombre ;";
        return this.consultarNombreCursos(sql);
    }

    public ArrayList<String> cargarNombreCursosPorPeriodo(int idPrdLectivo) {
        String sql = "SELECT DISTINCT curso_nombre\nFROM public.\"Cursos\" WHERE id_prd_lectivo = " + idPrdLectivo + " AND  curso_activo = true \nORDER BY curso_nombre;";
        return this.consultarNombreCursos(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> cargarCiclosPorPeriodo(int idPrdLectivo) {
        String sql = "SELECT DISTINCT curso_ciclo FROM public.\"Cursos\" WHERE id_prd_lectivo = " + idPrdLectivo + " AND  curso_activo = true ORDER BY curso_ciclo;";
        ArrayList<Integer> ciclos = new ArrayList<Integer>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ciclos.add(rs.getInt(1));
            }
        }
        catch (SQLException e) {
            M.errorMsg("Error al consultar cursos." + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return ciclos;
    }

    public ArrayList<String> cargarNombreCursosPorPeriodoCiclo(int idPrdLectivo, int ciclo) {
        String sql = "SELECT DISTINCT curso_nombre\nFROM public.\"Cursos\" WHERE id_prd_lectivo = " + idPrdLectivo + " AND curso_ciclo = " + ciclo + " AND curso_activo = true\nORDER BY curso_nombre;";
        return this.consultarNombreCursos(sql);
    }

    public ArrayList<String> cargarNombreCursosPorPeriodo(int idPrdLectivo, int cicloReprobado, int cicloCursado) {
        String sql = "SELECT DISTINCT curso_nombre, curso_ciclo\nFROM public.\"Cursos\" WHERE id_prd_lectivo = " + idPrdLectivo + " AND curso_ciclo >= " + cicloReprobado + " AND curso_ciclo <= " + (cicloCursado + 1) + " AND curso_activo = true ORDER BY curso_ciclo;";
        return this.consultarNombreCursos(sql);
    }

    public CursoMD buscarCurso(int idCurso) {
        String sql = "SELECT id_curso, id_materia, id_prd_lectivo, id_docente, id_jornada, \ncurso_nombre, curso_capacidad, curso_ciclo, curso_paralelo\n\tFROM public.\"Cursos\" WHERE \"Cursos\".id_curso = " + idCurso + "  AND curso_activo = true ;";
        return this.consultarCurso(sql);
    }

    public CursoMD existeMateriaCursoJornada(int idMateria, int ciclo, int idJornada, int idPrdLectivo, String paralelo) {
        String sql = "SELECT id_curso, id_materia, id_prd_lectivo, id_docente, id_jornada, \ncurso_nombre, curso_capacidad, curso_ciclo, curso_paralelo\n\tFROM public.\"Cursos\"  WHERE id_materia = " + idMateria + " AND  curso_ciclo = " + ciclo + " AND  id_jornada = " + idJornada + " AND id_prd_lectivo = " + idPrdLectivo + " AND curso_paralelo = '" + paralelo + "';";
        return this.consultarCurso(sql);
    }

    public CursoMD existeDocenteMateria(int idMateria, int idDocente, int idJornada, int idPrdLectivo, int ciclo, String paralelo) {
        String sql = "SELECT id_curso, id_materia, id_prd_lectivo, id_docente, id_jornada, \ncurso_nombre, curso_capacidad, curso_ciclo, curso_paralelo\nFROM public.\"Cursos\" WHERE id_materia = " + idMateria + " AND  id_docente = " + idDocente + " AND  id_jornada = " + idJornada + " AND id_prd_lectivo = " + idPrdLectivo + " AND curso_ciclo = " + ciclo + " AND curso_paralelo = '" + paralelo + "' ;";
        return this.consultarCurso(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<CursoMD> consultarCursos(String sql) {
        ArrayList<CursoMD> cursos = new ArrayList<CursoMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CursoMD c = this.obtenerCursoParaTbl(rs);
                if (c == null) continue;
                cursos.add(c);
            }
        }
        catch (SQLException e) {
            M.errorMsg("Error al consultar cursos." + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return cursos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<String> consultarNombreCursos(String sql) {
        ArrayList<String> nombres = new ArrayList<String>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String nombre = rs.getString("curso_nombre");
                nombres.add(nombre);
            }
        }
        catch (SQLException e) {
            M.errorMsg("Error al consultar cursos." + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return nombres;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CursoMD consultarCurso(String sql) {
        CursoMD c = null;
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                c = new CursoMD();
                c.setId(rs.getInt("id_curso"));
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                c.setMateria(m);
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                p.setID(rs.getInt("id_prd_lectivo"));
                c.setPeriodo(p);
                DocenteMD d = new DocenteMD();
                d.setIdDocente(rs.getInt("id_docente"));
                c.setDocente(d);
                JornadaMD j = new JornadaMD();
                j.setId(rs.getInt("id_jornada"));
                c.setJornada(j);
                c.setNombre(rs.getString("curso_nombre"));
                c.setCapacidad(rs.getInt("curso_capacidad"));
                c.setCiclo(rs.getInt("curso_ciclo"));
                c.setParalelo(rs.getString("curso_paralelo"));
            }
            CursoMD cursoMD = c;
            return cursoMD;
        }
        catch (SQLException e) {
            M.errorMsg("Error al consultar cursos." + e.getMessage());
            CursoMD cursoMD = null;
            return cursoMD;
        }
        finally {
            CON.cerrarCONPS(ps);
        }
    }

    private CursoMD obtenerCursoParaTbl(ResultSet rs) {
        CursoMD c = new CursoMD();
        try {
            c.setId(rs.getInt("id_curso"));
            MateriaMD m = new MateriaMD();
            m.setId(rs.getInt("id_materia"));
            m.setNombre(rs.getString("materia_nombre"));
            c.setMateria(m);
            PeriodoLectivoMD p = new PeriodoLectivoMD();
            p.setID(rs.getInt("id_prd_lectivo"));
            p.setNombre(rs.getString("prd_lectivo_nombre"));
            c.setPeriodo(p);
            DocenteMD d = new DocenteMD();
            d.setIdDocente(rs.getInt("id_docente"));
            d.setPrimerNombre(rs.getString("persona_primer_nombre"));
            d.setPrimerApellido(rs.getString("persona_primer_apellido"));
            d.setIdentificacion(rs.getString("persona_identificacion"));
            c.setDocente(d);
            c.setNombre(rs.getString("curso_nombre"));
            c.setCapacidad(rs.getInt("curso_capacidad"));
            c.setCiclo(rs.getInt("curso_ciclo"));
            c.setNumMatriculados(rs.getInt(1));
            return c;
        }
        catch (SQLException e) {
            System.out.println("No pudimos obtener curso");
            System.out.println(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> selectCicloWhere(int idDocente, int idPeriodoLectivo) {
        String SELECT = "SELECT DISTINCT\n\"Cursos\".curso_nombre\nFROM\n\"Cursos\"\nWHERE\n\"Cursos\".id_docente = ?\nAND\n\"Cursos\".id_prd_lectivo = ?";
        ArrayList<String> lista = new ArrayList<String>();
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, idDocente);
        parametros.put(2, idPeriodoLectivo);
        this.conn = this.POOL.getConnection();
        this.rst = this.POOL.ejecutarQuery(SELECT, this.conn, parametros);
        try {
            while (this.rst.next()) {
                lista.add(this.rst.getString("curso_nombre"));
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            this.POOL.closeStmt().close(this.rst).close(this.conn);
        }
        return lista;
    }
}

