/*
 * Decompiled with CFR 0.152.
 */
package modelo.carrera;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import modelo.ConnDBPool;
import modelo.carrera.CarreraMD;
import modelo.persona.DocenteMD;
import utils.CONBD;
import utils.CONS;
import utils.M;

public class CarreraBD
extends CONBD {
    private final ConnDBPool pool = new ConnDBPool();
    private ResultSet rst;
    private Connection conn;
    private static CarreraBD CBD;

    public static CarreraBD single() {
        if (CBD == null) {
            CBD = new CarreraBD();
        }
        return CBD;
    }

    public boolean guardarCarrera(CarreraMD cr) {
        String nsql = "INSERT INTO public.\"Carreras\"(\nid_docente_coordinador, carrera_nombre, carrera_codigo, carrera_fecha_inicio, carrera_modalidad, carrera_semanas)\nVALUES (" + cr.getCoordinador().getIdDocente() + ",  '" + cr.getNombre() + "', '" + cr.getCodigo() + "', '" + cr.getFechaInicio() + "','" + cr.getModalidad() + "', " + cr.getNumSemanas() + ");";
        if (CON.executeNoSQL(nsql)) {
            JOptionPane.showMessageDialog(null, "Guardamos correctamente \n" + cr.getNombre());
            return true;
        }
        JOptionPane.showMessageDialog(null, "No se pudo guardar \n" + cr.getNombre() + "\nRevise su conexion a internet.");
        return false;
    }

    public boolean editarCarrera(CarreraMD cr) {
        String nsql = "UPDATE public.\"Carreras\" SET id_docente_coordinador=" + cr.getCoordinador().getIdDocente() + ", carrera_nombre='" + cr.getNombre() + "', carrera_codigo='" + cr.getCodigo() + "', carrera_fecha_inicio='" + cr.getFechaInicio() + "', carrera_modalidad='" + cr.getModalidad() + "', carrera_semanas = " + cr.getNumSemanas() + " WHERE id_carrera=" + cr.getId() + ";";
        if (CON.executeNoSQL(nsql)) {
            JOptionPane.showMessageDialog(null, "Editamos correctamente \n" + cr.getNombre());
            return true;
        }
        JOptionPane.showMessageDialog(null, "No se pudo editar \n" + cr.getNombre() + "\nRevise su conexion a internet.");
        return false;
    }

    public void eliminarCarrera(int idCarrera) {
        String nsql = "UPDATE public.\"Carreras\"\nSET  carrera_activo='false'\nWHERE id_carrera=" + idCarrera + ";";
        if (CON.executeNoSQL(nsql)) {
            JOptionPane.showMessageDialog(null, "Eliminamos correctamente ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CarreraMD buscar(int idCarrera) {
        CarreraMD carrera = new CarreraMD();
        String sql = "SELECT id_carrera, id_docente_coordinador, carrera_nombre, carrera_codigo, carrera_fecha_inicio, carrera_fecha_fin, carrera_modalidad, (\n\tSELECT persona_primer_nombre || '%' || \n\tpersona_segundo_nombre || '%' ||\n\tpersona_primer_apellido || '%' ||\n\tpersona_segundo_apellido || '%' ||      persona_identificacion \n    FROM public.\"Docentes\" d, public.\"Personas\" p \n    WHERE d.id_docente = id_docente_coordinador AND\n    p.id_persona = d.id_persona) AS coordinador\nFROM public.\"Carreras\" WHERE id_carrera = '" + idCarrera + "';";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                carrera.setId(rs.getInt("id_carrera"));
                DocenteMD docen = null;
                if (rs.getInt(2) != 0) {
                    String nombreC = rs.getString(8);
                    docen = new DocenteMD();
                    docen.setIdDocente(rs.getInt(2));
                    if (nombreC != null) {
                        String[] nombres = nombreC.split("%");
                        docen.setPrimerNombre(nombres[0]);
                        docen.setSegundoNombre(nombres[1]);
                        docen.setPrimerApellido(nombres[2]);
                        docen.setSegundoApellido(nombres[3]);
                        docen.setIdentificacion(nombres[4]);
                    }
                }
                carrera.setCoordinador(docen);
                carrera.setNombre(rs.getString("carrera_nombre"));
                carrera.setCodigo(rs.getString("carrera_codigo"));
                carrera.setFechaInicio(rs.getDate("carrera_fecha_inicio").toLocalDate());
                if (rs.getDate("carrera_fecha_fin") != null) {
                    carrera.setFechaFin(rs.getDate("carrera_fecha_fin").toLocalDate());
                } else {
                    carrera.setFechaFin(null);
                }
                carrera.setModalidad(rs.getString("carrera_modalidad"));
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar carreras. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return carrera;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CarreraMD buscarPorId(int idCarrera) {
        CarreraMD carrera = null;
        String sql = "SELECT id_carrera, carrera_nombre, carrera_codigo, carrera_fecha_inicio, carrera_modalidad \nFROM public.\"Carreras\" WHERE id_carrera = '" + idCarrera + "';";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                carrera = new CarreraMD();
                carrera.setId(rs.getInt("id_carrera"));
                carrera.setNombre(rs.getString("carrera_nombre"));
                carrera.setCodigo(rs.getString("carrera_codigo"));
                carrera.setFechaInicio(rs.getDate("carrera_fecha_inicio").toLocalDate());
                carrera.setModalidad(rs.getString("carrera_modalidad"));
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar carreras. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return carrera;
    }

    public ArrayList<CarreraMD> cargarCarreras() {
        String sql = "SELECT id_carrera, id_docente_coordinador, carrera_nombre,\ncarrera_codigo, carrera_fecha_inicio,\ncarrera_modalidad, carrera_semanas, (\n\tSELECT persona_primer_nombre || '%' || \n\tpersona_segundo_nombre || '%' ||\n\tpersona_primer_apellido || '%' ||\n\tpersona_segundo_apellido || '%' ||      persona_identificacion \n    FROM public.\"Docentes\" d, public.\"Personas\" p \n    WHERE d.id_docente = id_docente_coordinador AND\n    p.id_persona = d.id_persona) AS coordinador\nFROM public.\"Carreras\" c\nWHERE carrera_activo = TRUE\nORDER BY carrera_fecha_inicio;";
        return this.consultarCarrerasTbl(sql);
    }

    public ArrayList<CarreraMD> buscarCarrera(String aguja) {
        String sql = "SELECT id_carrera, id_docente_coordinador, carrera_nombre,\ncarrera_codigo, carrera_fecha_inicio,\ncarrera_modalidad, carrera_semanas, (\n\tSELECT persona_primer_nombre || '%' || \n\tpersona_segundo_nombre || '%' ||\n\tpersona_primer_apellido || '%' ||\n\tpersona_segundo_apellido || '%' ||      persona_identificacion \n    FROM public.\"Docentes\" d, public.\"Personas\" p \n    WHERE d.id_docente = id_docente_coordinador AND\n    p.id_persona = d.id_persona) AS coordinador\nFROM public.\"Carreras\" c\nWHERE carrera_activo = TRUE AND (\n\tcarrera_codigo ILIKE '%" + aguja + "%' OR\n\tcarrera_nombre ILIKE '%" + aguja + "%'\n)ORDER BY carrera_fecha_inicio;";
        return this.consultarCarrerasTbl(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<CarreraMD> consultarCarrerasTbl(String sql) {
        ArrayList<CarreraMD> carreras = new ArrayList<CarreraMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CarreraMD carrera = new CarreraMD();
                carrera.setId(rs.getInt("id_carrera"));
                DocenteMD docen = new DocenteMD();
                String nombreC = rs.getString(8);
                if (nombreC != null) {
                    String[] nombres = nombreC.split("%");
                    docen.setPrimerNombre(nombres[0]);
                    docen.setSegundoNombre(nombres[1]);
                    docen.setPrimerApellido(nombres[2]);
                    docen.setSegundoApellido(nombres[3]);
                    docen.setIdentificacion(nombres[4]);
                }
                carrera.setCoordinador(docen);
                carrera.setNombre(rs.getString("carrera_nombre"));
                carrera.setCodigo(rs.getString("carrera_codigo"));
                carrera.setFechaInicio(rs.getDate("carrera_fecha_inicio").toLocalDate());
                carrera.setModalidad(rs.getString("carrera_modalidad"));
                carrera.setNumSemanas(rs.getInt("carrera_semanas"));
                carreras.add(carrera);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar carreras. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return carreras;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CarreraMD> cargarCarrerasCmb() {
        ArrayList<CarreraMD> carreras = new ArrayList<CarreraMD>();
        String sql = "SELECT id_carrera, carrera_nombre,\ncarrera_codigo \nFROM public.\"Carreras\" \nWHERE carrera_activo = TRUE\nORDER BY carrera_fecha_inicio DESC;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                CarreraMD carrera = new CarreraMD();
                carrera.setId(rs.getInt("id_carrera"));
                carrera.setNombre(rs.getString("carrera_nombre"));
                carrera.setCodigo(rs.getString("carrera_codigo"));
                carreras.add(carrera);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar carreras. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return carreras;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<CarreraMD> cargarNumdeSemanas(int id_prd) {
        String sql = "SELECT\n\"Carreras\".carrera_semanas\nFROM\n\"Carreras\"\nINNER JOIN \"PeriodoLectivo\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera\nWHERE \"PeriodoLectivo\".id_prd_lectivo = " + id_prd + "";
        ArrayList<CarreraMD> semanas = new ArrayList<CarreraMD>();
        this.conn = this.pool.getConnection();
        this.rst = this.pool.ejecutarQuery(sql, this.conn, null);
        try {
            Object carrera;
            while (this.rst.next()) {
                carrera = new CarreraMD();
                ((CarreraMD)carrera).setNumSemanas(this.rst.getInt(1));
                semanas.add((CarreraMD)carrera);
            }
            carrera = semanas;
            return carrera;
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            this.pool.close(this.conn);
        }
        return semanas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String selectWhere(int idPeriodo) {
        String SELECT = "SELECT\n\tcarrera_nombre \nFROM\n\t\"Carreras\"\n\tINNER JOIN \"PeriodoLectivo\" ON \"Carreras\".id_carrera = \"PeriodoLectivo\".id_carrera\nWHERE\n\"PeriodoLectivo\".id_prd_lectivo = " + idPeriodo;
        String carrera = "";
        this.conn = this.pool.getConnection();
        this.rst = this.pool.ejecutarQuery(SELECT, this.conn, null);
        try {
            while (this.rst.next()) {
                carrera = this.rst.getString(1);
            }
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
        }
        finally {
            this.pool.closeStmt().close(this.rst).close(this.conn);
        }
        return carrera;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CarreraMD> findBy(String cedulaDocente) {
        String SELECT = "SELECT DISTINCT\n\t\"Carreras\".id_carrera,\n\t\"Carreras\".carrera_nombre \nFROM\n\t\"Cursos\"\n\tINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente\n\tINNER JOIN \"PeriodoLectivo\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\tINNER JOIN \"Carreras\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera \nWHERE\n\t\"Docentes\".docente_codigo = '" + CONS.USUARIO.getPersona().getIdentificacion() + "'";
        ArrayList<CarreraMD> carreras = new ArrayList<CarreraMD>();
        ConnDBPool pool = new ConnDBPool();
        Connection conn = pool.getConnection();
        ResultSet rs = pool.ejecutarQuery(SELECT, conn, null);
        try {
            while (rs.next()) {
                CarreraMD carrera = new CarreraMD();
                carrera.setId(rs.getInt("id_carrera"));
                carrera.setNombre(rs.getString("carrera_nombre"));
                carreras.add(carrera);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(CarreraBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            pool.closeStmt().close(rs).close(conn);
        }
        return carreras;
    }
}

