/*
 * Decompiled with CFR 0.152.
 */
package modelo.asistencia;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import modelo.asistencia.AsistenciaHoras;
import modelo.asistencia.AsistenciaSesionMD;
import modelo.asistencia.FechasClase;
import modelo.asistencia.NEWAsistenciaBD;

public class GenerarFechas {
    private final List<FechasClase> fechas = new ArrayList<FechasClase>();
    private final NEWAsistenciaBD ABD = NEWAsistenciaBD.single();
    private LocalDate fechaAux;
    private int diaAumentar;
    private int diaAnterior;

    public List<FechasClase> getFechasClaseCurso(int idCurso) {
        List<AsistenciaHoras> ahs = this.ABD.getDiasCurso(idCurso);
        AsistenciaSesionMD as = this.ABD.getInfoSesion(idCurso);
        this.fechaAux = as.getPrdFechaInicio();
        this.diaAumentar = 0;
        this.diaAnterior = 1;
        if (as.getDiaInicio() != 1 && as.getDiaInicio() == as.getDiaFin()) {
            this.diaAumentar = this.getDias(this.diaAnterior, as.getDiaInicio());
            this.fechaAux = this.fechaAux.plusDays(this.diaAumentar).minusDays(7L);
            this.diaAnterior = as.getDiaInicio();
            if (as.getDiaInicio() == as.getDiaFin()) {
                // empty if block
            }
        }
        while (this.fechaAux.isBefore(as.getPrdFechaFin()) || this.fechaAux.equals(as.getPrdFechaFin())) {
            ahs.forEach(d -> {
                this.diaAumentar = as.getDiaInicio() == as.getDiaFin() ? 7 : this.getDias(this.diaAnterior, d.getDia());
                this.diaAnterior = d.getDia();
                this.fechaAux = this.fechaAux.plusDays(this.diaAumentar);
                FechasClase fc = new FechasClase();
                fc.setFecha((this.fechaAux.getDayOfMonth() > 9 ? Integer.valueOf(this.fechaAux.getDayOfMonth()) : "0" + this.fechaAux.getDayOfMonth()) + "/" + (this.fechaAux.getMonthValue() > 9 ? Integer.valueOf(this.fechaAux.getMonthValue()) : "0" + this.fechaAux.getMonthValue()) + "/" + this.fechaAux.getYear());
                fc.setDia(d.getDia());
                fc.setHoras(d.getHoras());
                this.fechas.add(fc);
            });
        }
        return this.fechas;
    }

    private int getDias(int diaInicio, int diaFin) {
        int c = 0;
        boolean continua = true;
        int diaAux = diaInicio;
        while (continua) {
            if (diaFin == diaAux) {
                continua = false;
                continue;
            }
            ++c;
            if (++diaAux == 8) {
                diaAux = 1;
            }
            if (diaAux != diaFin) continue;
            continua = false;
        }
        return c;
    }
}

