/*
 * Decompiled with CFR 0.152.
 */
package modelo.alumno;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.alumno.MallaAlumnoMD;
import modelo.materia.MateriaMD;
import utils.CONBD;

public class UtilEgresadoBD
extends CONBD {
    private static UtilEgresadoBD UEBD;

    public static UtilEgresadoBD single() {
        if (UEBD == null) {
            UEBD = new UtilEgresadoBD();
        }
        return UEBD;
    }

    public List<MallaAlumnoMD> getMateriasNoPagadas(int idAlumnoCarrera) {
        String sql = "SELECT\nid_malla_alumno,\nmalla_almn_num_matricula,\nmateria_nombre,\nmateria_ciclo\nFROM public.\"MallaAlumno\" ma\nJOIN public.\"Materias\" m\nON ma.id_materia = m.id_materia\nWHERE id_almn_carrera = ? AND malla_almn_pago_pendiente = true\nORDER BY materia_ciclo;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idAlumnoCarrera);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al pasar id alumno carrera a la consulta" + e.getMessage());
        }
        return this.getMallaInfo(ps);
    }

    public List<MallaAlumnoMD> getMateriasNoCursadas(int idAlumnoCarrera) {
        String sql = "SELECT\nid_malla_alumno,\nmalla_almn_num_matricula,\nmateria_nombre,\nmateria_ciclo\nFROM public.\"MallaAlumno\" ma\nJOIN public.\"Materias\" m\nON ma.id_materia = m.id_materia\nWHERE id_almn_carrera = ?  \nAND malla_almn_estado <> 'C'\nORDER BY materia_ciclo;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idAlumnoCarrera);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al pasar id alumno carrera a la consulta" + e.getMessage());
        }
        return this.getMallaInfo(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MallaAlumnoMD> getMallaInfo(PreparedStatement ps) {
        ArrayList<MallaAlumnoMD> mas = new ArrayList<MallaAlumnoMD>();
        try {
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                MallaAlumnoMD ma = new MallaAlumnoMD();
                ma.setId(res.getInt(1));
                ma.setMallaNumMatricula(res.getInt(2));
                MateriaMD m = new MateriaMD();
                m.setNombre(res.getString(3));
                m.setCiclo(res.getInt(4));
                ma.setMateria(m);
                mas.add(ma);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al mapear las materias que no cancelar su deuda un alumno.");
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return mas;
    }
}

