/*
 * Decompiled with CFR 0.152.
 */
package modelo.alumno;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.alumno.AlumnoCarreraMD;
import modelo.alumno.Retirado;
import modelo.carrera.CarreraMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.AlumnoMD;
import utils.CONBD;

public class RetiradoBD
extends CONBD {
    private static RetiradoBD RBD;
    public static final String BASEQUERY_TBL = "SELECT\nr.id_retiro,\nfecha_retiro,\nac.id_almn_carrera,\nac.id_carrera,\nalmn_carrera_fecha_registro,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_identificacion,\ncarrera_codigo, prd_lectivo_nombre, r.id_prd_lectivo,r.motivo_retiro FROM public.\"AlumnosCarrera\" ac\nJOIN public.\"Alumnos\" a ON a.id_alumno = ac.id_alumno\nJOIN public.\"Personas\" p ON p.id_persona = a.id_persona\nJOIN public.\"Carreras\" c ON c.id_carrera = ac.id_carrera\nJOIN alumno.\"Retirados\" r ON r.id_almn_carrera = ac.id_almn_carrera JOIN public.\"PeriodoLectivo\" pl ON pl.id_prd_lectivo = r.id_prd_lectivo WHERE carrera_activo = true\nAND almn_carrera_activo = true ";

    public static RetiradoBD single() {
        if (RBD == null) {
            RBD = new RetiradoBD();
        }
        return RBD;
    }

    public int guardar(Retirado r) {
        String sql = "INSERT INTO alumno.\"Retirados\"( id_almn_carrera, id_prd_lectivo, fecha_retiro, motivo_retiro) VALUES (?, ?, ?, ?);";
        PreparedStatement ps = CON.getPSID(sql);
        try {
            ps.setInt(1, r.getAlmnCarrera().getId());
            ps.setInt(2, r.getPeriodo().getID());
            ps.setDate(3, Date.valueOf(LocalDate.now()));
            ps.setString(4, r.getMotivo());
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al guardar retirado. \n" + e.getMessage(), "Error", 0);
        }
        return CON.getIDGenerado(ps);
    }

    public boolean eliminar(int idRetirado) {
        String sql = "DELETE FROM alumno.\"Retirados\" WHERE id_retiro = ?;";
        return CON.deleteById(sql, idRetirado);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Retirado getById(int idRetiro) {
        String sql = "SELECT\nid_retiro,\nid_prd_lectivo,\nfecha_retiro,\nmotivo_retiro\nFROM alumno.\"Retirados\" \nWHERE id_retiro = ?;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        Retirado r = null;
        try {
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                r = new Retirado();
                r.setId(res.getInt(1));
                PeriodoLectivoMD pl = new PeriodoLectivoMD();
                pl.setID(res.getInt(2));
                r.setPeriodo(pl);
                r.setFechaRetiro(res.getDate(3).toLocalDate());
                r.setMotivo(res.getString(4));
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al obtener por id. \n" + e.getMessage(), "Error", 0);
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return r;
    }

    public int editar(Retirado r) {
        String sql = "UPDATE alumno.\"Retirados\" SET id_prd_lectivo=?, motivo_retiro=? WHERE id_retiro=?;";
        PreparedStatement ps = CON.getPSID(sql);
        try {
            ps.setInt(1, r.getPeriodo().getID());
            ps.setString(2, r.getMotivo());
            ps.setInt(3, r.getId());
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al guardar retirado. \n" + e.getMessage(), "Error", 0);
        }
        return CON.getIDGenerado(ps);
    }

    public List<Retirado> getAllTbl() {
        return this.getForTbl(CON.getPSPOOL(BASEQUERY_TBL));
    }

    public List<Retirado> getByCarrera(int idCarrera) {
        String sql = "SELECT\nr.id_retiro,\nfecha_retiro,\nac.id_almn_carrera,\nac.id_carrera,\nalmn_carrera_fecha_registro,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_identificacion,\ncarrera_codigo, prd_lectivo_nombre, r.id_prd_lectivo,r.motivo_retiro FROM public.\"AlumnosCarrera\" ac\nJOIN public.\"Alumnos\" a ON a.id_alumno = ac.id_alumno\nJOIN public.\"Personas\" p ON p.id_persona = a.id_persona\nJOIN public.\"Carreras\" c ON c.id_carrera = ac.id_carrera\nJOIN alumno.\"Retirados\" r ON r.id_almn_carrera = ac.id_almn_carrera JOIN public.\"PeriodoLectivo\" pl ON pl.id_prd_lectivo = r.id_prd_lectivo WHERE carrera_activo = true\nAND almn_carrera_activo = true  AND ac.id_carrera = ?";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idCarrera);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar retirado por id carrera. \n" + e.getMessage(), "Error", 0);
        }
        return this.getForTbl(ps);
    }

    public List<Retirado> getForBusqueda(String aguja) {
        String sql = "SELECT\nr.id_retiro,\nfecha_retiro,\nac.id_almn_carrera,\nac.id_carrera,\nalmn_carrera_fecha_registro,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_identificacion,\ncarrera_codigo, prd_lectivo_nombre, r.id_prd_lectivo,r.motivo_retiro FROM public.\"AlumnosCarrera\" ac\nJOIN public.\"Alumnos\" a ON a.id_alumno = ac.id_alumno\nJOIN public.\"Personas\" p ON p.id_persona = a.id_persona\nJOIN public.\"Carreras\" c ON c.id_carrera = ac.id_carrera\nJOIN alumno.\"Retirados\" r ON r.id_almn_carrera = ac.id_almn_carrera JOIN public.\"PeriodoLectivo\" pl ON pl.id_prd_lectivo = r.id_prd_lectivo WHERE carrera_activo = true\nAND almn_carrera_activo = true  AND ( persona_primer_nombre = ?  OR persona_segundo_nombre = ?  OR persona_primer_apellido = ?  OR persona_segundo_apellido = ?  OR persona_identificacion = ? ) ";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            aguja = "%" + aguja + "%";
            ps.setString(1, aguja);
            ps.setString(2, aguja);
            ps.setString(3, aguja);
            ps.setString(4, aguja);
            ps.setString(5, aguja);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar retirado por id carrera. \n" + e.getMessage(), "Error", 0);
        }
        return this.getForTbl(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Retirado> getForTbl(PreparedStatement ps) {
        ArrayList<Retirado> rs = new ArrayList<Retirado>();
        try {
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                Retirado r = new Retirado();
                r.setId(res.getInt("id_retiro"));
                r.setFechaRetiro(res.getDate("fecha_retiro").toLocalDate());
                AlumnoCarreraMD ac = new AlumnoCarreraMD();
                ac.setId(res.getInt("id_almn_carrera"));
                ac.setFechaRegistro(res.getTimestamp("almn_carrera_fecha_registro").toLocalDateTime());
                CarreraMD c = new CarreraMD();
                c.setId(res.getInt("id_carrera"));
                c.setCodigo(res.getString("carrera_codigo"));
                AlumnoMD a = new AlumnoMD();
                a.setPrimerNombre(res.getString("persona_primer_nombre"));
                a.setSegundoNombre(res.getString("persona_segundo_nombre"));
                a.setPrimerApellido(res.getString("persona_primer_apellido"));
                a.setSegundoApellido(res.getString("persona_segundo_apellido"));
                a.setIdentificacion(res.getString("persona_identificacion"));
                PeriodoLectivoMD pl = new PeriodoLectivoMD();
                pl.setNombre(res.getString("prd_lectivo_nombre"));
                pl.setID(res.getInt("id_prd_lectivo"));
                ac.setCarrera(c);
                ac.setAlumno(a);
                r.setPeriodo(pl);
                r.setAlmnCarrera(ac);
                r.setMotivo(res.getString("motivo_retiro"));
                rs.add(r);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al mapear para table los retirados\n" + e.getMessage(), "Error", 0);
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return rs;
    }
}

