/*
 * Decompiled with CFR 0.152.
 */
package modelo.alumno;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.alumno.AlumnoCarreraMD;
import modelo.alumno.MallaAlumnoMD;
import modelo.materia.MateriaMD;
import modelo.persona.AlumnoMD;
import utils.CONBD;
import utils.M;

public class MallaAlumnoBD
extends CONBD {
    private String sql = "";
    private static MallaAlumnoBD MABD;

    public static MallaAlumnoBD single() {
        if (MABD == null) {
            MABD = new MallaAlumnoBD();
        }
        return MABD;
    }

    public void ingresarNota(int idMalla, int numMatri, double nota) {
        String estado = "R";
        String nsql = "";
        if (nota >= 70.0) {
            estado = "C";
        }
        switch (numMatri) {
            case 1: {
                nsql = "UPDATE public.\"MallaAlumno\"\nSET malla_almn_nota1=" + nota + ", malla_almn_estado='" + estado + "'\nWHERE id_malla_alumno=" + idMalla + ";";
                break;
            }
            case 2: {
                nsql = "UPDATE public.\"MallaAlumno\"\nSET malla_almn_nota2=" + nota + ", malla_almn_estado='" + estado + "'\nWHERE id_malla_alumno=" + idMalla + ";";
                break;
            }
            case 3: {
                nsql = "UPDATE public.\"MallaAlumno\"\nSET malla_almn_nota3=" + nota + ", malla_almn_estado='" + estado + "'\nWHERE id_malla_alumno=" + idMalla + ";";
                break;
            }
        }
        this.guardarHistoria(idMalla, "UPDATE", "MallaAlumno");
        CON.executeNoSQL(nsql);
    }

    public boolean actualizarNota(int idMalla, double nota1, double nota2, double nota3, int numMatri, String estado) {
        String nsql = "UPDATE public.\"MallaAlumno\"\nSET  malla_almn_nota1=" + nota1 + ", malla_almn_nota2=" + nota2 + ", malla_almn_nota3=" + nota3 + ", malla_almn_estado='" + estado + "', malla_almn_num_matricula = " + numMatri + " \nWHERE id_malla_alumno=" + idMalla + ";";
        if (CON.executeNoSQL(nsql)) {
            JOptionPane.showMessageDialog(null, "Se actualizo la malla correctamente.");
            this.guardarHistoria(idMalla, "UPDATE", "MallaAlumno");
            return true;
        }
        JOptionPane.showMessageDialog(null, "No se pudo actualizar malla, \ncompruebe su conexion a internet.");
        return false;
    }

    public ArrayList<MallaAlumnoMD> cargarMallasTbl() {
        this.sql = "SELECT id_malla_alumno, ma.id_materia, ma.id_almn_carrera, malla_almn_ciclo, \nmalla_almn_num_matricula, malla_almn_nota1, malla_almn_nota2, malla_almn_nota3, \nmalla_almn_estado, persona_primer_nombre, persona_segundo_nombre, persona_segundo_apellido, persona_primer_apellido,\nmateria_nombre, persona_identificacion\nFROM public.\"MallaAlumno\" ma, public.\"AlumnosCarrera\" ac, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"Materias\" m, public.\"Carreras\" c\nWHERE ac.id_almn_carrera = ma.id_almn_carrera AND\na.id_alumno = ac.id_alumno AND \nc.id_carrera = ac.id_carrera AND \np.id_persona = a.id_persona AND\nm.id_materia = ma.id_materia AND carrera_activo = true \nORDER BY persona_primer_apellido, persona_segundo_apellido, malla_almn_ciclo;";
        return this.consultaMallasTbl(this.sql);
    }

    public ArrayList<MallaAlumnoMD> cargarMallasPorEstudiante(int idAlumnoCarrera) {
        this.sql = "SELECT id_malla_alumno, ma.id_materia, ma.id_almn_carrera, malla_almn_ciclo, \nmalla_almn_num_matricula, malla_almn_nota1, malla_almn_nota2, malla_almn_nota3, \nmalla_almn_estado, persona_primer_nombre, persona_segundo_nombre, persona_segundo_apellido, persona_primer_apellido,\nmateria_nombre, persona_identificacion,carrera_nombre\n FROM public.\"MallaAlumno\" ma, public.\"AlumnosCarrera\" ac, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"Materias\" m\njoin \"Carreras\" C on m.id_carrera = C.id_carrera WHERE ac.id_almn_carrera = ma.id_almn_carrera AND\na.id_alumno = ac.id_alumno AND \np.id_persona = a.id_persona AND\nm.id_materia = ma.id_materia AND\nac.id_almn_carrera = " + idAlumnoCarrera + " \nORDER BY malla_almn_ciclo;";
        return this.consultaMallasTbl(this.sql);
    }

    public ArrayList<MallaAlumnoMD> cargarMallaAlumnoPorEstado(int idAlumno, String estado) {
        this.sql = "SELECT id_malla_alumno, ma.id_materia, ma.id_almn_carrera, malla_almn_ciclo, \nmalla_almn_num_matricula, malla_almn_nota1, malla_almn_nota2, malla_almn_nota3, \nmalla_almn_estado, persona_primer_nombre, persona_segundo_nombre, persona_segundo_apellido, persona_primer_apellido,\nmateria_nombre, persona_identificacion\nFROM public.\"MallaAlumno\" ma, public.\"AlumnosCarrera\" ac, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"Materias\" m\nWHERE ac.id_almn_carrera = ma.id_almn_carrera AND\na.id_alumno = ac.id_alumno AND \np.id_persona = a.id_persona AND\nm.id_materia = ma.id_materia AND\nac.id_almn_carrera = " + idAlumno + "\nAND malla_almn_estado = '" + estado.charAt(0) + "' \nORDER BY malla_almn_ciclo;";
        return this.consultaMallasTbl(this.sql);
    }

    public ArrayList<MallaAlumnoMD> cargarMallaAlumnoPorCiclo(int idAlumno, int ciclo) {
        this.sql = "SELECT id_malla_alumno, ma.id_materia, ma.id_almn_carrera, malla_almn_ciclo, \nmalla_almn_num_matricula, malla_almn_nota1, malla_almn_nota2, malla_almn_nota3, \nmalla_almn_estado, persona_primer_nombre, persona_segundo_nombre, persona_segundo_apellido, persona_primer_apellido,\nmateria_nombre, persona_identificacion\nFROM public.\"MallaAlumno\" ma, public.\"AlumnosCarrera\" ac, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"Materias\" m\nWHERE ac.id_almn_carrera = ma.id_almn_carrera AND\na.id_alumno = ac.id_alumno AND \np.id_persona = a.id_persona AND\nm.id_materia = ma.id_materia AND\nac.id_almn_carrera = " + idAlumno + " AND\nmalla_almn_ciclo =" + ciclo + " \nORDER BY malla_almn_ciclo;";
        return this.consultaMallasTbl(this.sql);
    }

    public ArrayList<MallaAlumnoMD> cargarMallaAlumnoPorEstadoCiclo(int idAlumno, int ciclo, String estado) {
        this.sql = "SELECT id_malla_alumno, ma.id_materia, ma.id_almn_carrera, malla_almn_ciclo, \nmalla_almn_num_matricula, malla_almn_nota1, malla_almn_nota2, malla_almn_nota3, \nmalla_almn_estado, persona_primer_nombre, persona_segundo_nombre, persona_segundo_apellido, persona_primer_apellido,\nmateria_nombre, persona_identificacion\nFROM public.\"MallaAlumno\" ma, public.\"AlumnosCarrera\" ac, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"Materias\" m\nWHERE ac.id_almn_carrera = ma.id_almn_carrera AND\na.id_alumno = ac.id_alumno AND \np.id_persona = a.id_persona AND\nm.id_materia = ma.id_materia AND\nac.id_almn_carrera = " + idAlumno + "\nAND malla_almn_estado = '" + estado.charAt(0) + "' AND \nmalla_almn_ciclo =" + ciclo + " \nORDER BY malla_almn_ciclo;";
        return this.consultaMallasTbl(this.sql);
    }

    public ArrayList<MallaAlumnoMD> cargarMallaPorCarrera(int idCarrera) {
        this.sql = "SELECT id_malla_alumno, ma.id_materia, ma.id_almn_carrera, malla_almn_ciclo, \nmalla_almn_num_matricula, malla_almn_nota1, malla_almn_nota2, malla_almn_nota3, \nmalla_almn_estado, persona_primer_nombre, persona_segundo_nombre, persona_segundo_apellido, persona_primer_apellido,\nmateria_nombre, persona_identificacion\nFROM public.\"MallaAlumno\" ma, public.\"AlumnosCarrera\" ac, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"Materias\" m\nWHERE ac.id_almn_carrera = ma.id_almn_carrera AND\na.id_alumno = ac.id_alumno AND \np.id_persona = a.id_persona AND\nm.id_materia = ma.id_materia AND\nac.id_carrera = " + idCarrera + " \nORDER BY persona_primer_apellido, persona_segundo_apellido, malla_almn_ciclo;";
        return this.consultaMallasTbl(this.sql);
    }

    public ArrayList<MallaAlumnoMD> cargarMallaPorCarreraCiclo(int idCarrera, int ciclo) {
        this.sql = "SELECT id_malla_alumno, ma.id_materia, ma.id_almn_carrera, malla_almn_ciclo, \nmalla_almn_num_matricula, malla_almn_nota1, malla_almn_nota2, malla_almn_nota3, \nmalla_almn_estado, persona_primer_nombre, persona_segundo_nombre, persona_segundo_apellido, persona_primer_apellido,\nmateria_nombre, persona_identificacion\nFROM public.\"MallaAlumno\" ma, public.\"AlumnosCarrera\" ac, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"Materias\" m\nWHERE ac.id_almn_carrera = ma.id_almn_carrera AND\na.id_alumno = ac.id_alumno AND \np.id_persona = a.id_persona AND\nm.id_materia = ma.id_materia AND\nac.id_carrera = " + idCarrera + " AND\nmalla_almn_ciclo = " + ciclo + " \nORDER BY persona_primer_apellido, persona_segundo_apellido;";
        return this.consultaMallasTbl(this.sql);
    }

    public ArrayList<MallaAlumnoMD> cargarMallaPorCarreraEstado(int idCarrera, String estado) {
        this.sql = "SELECT id_malla_alumno, ma.id_materia, ma.id_almn_carrera, malla_almn_ciclo, \nmalla_almn_num_matricula, malla_almn_nota1, malla_almn_nota2, malla_almn_nota3, \nmalla_almn_estado, persona_primer_nombre, persona_segundo_nombre, persona_segundo_apellido, persona_primer_apellido,\nmateria_nombre, persona_identificacion\nFROM public.\"MallaAlumno\" ma, public.\"AlumnosCarrera\" ac, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"Materias\" m\nWHERE ac.id_almn_carrera = ma.id_almn_carrera AND\na.id_alumno = ac.id_alumno AND \np.id_persona = a.id_persona AND\nm.id_materia = ma.id_materia AND\nac.id_carrera = " + idCarrera + " AND\nmalla_almn_estado = '" + estado.charAt(0) + "' \nORDER BY persona_primer_apellido, persona_segundo_apellido, malla_almn_ciclo;";
        return this.consultaMallasTbl(this.sql);
    }

    public ArrayList<MallaAlumnoMD> cargarMallaPorCarreraCicloEstado(int idCarrera, int ciclo, String estado) {
        this.sql = "SELECT id_malla_alumno, ma.id_materia, ma.id_almn_carrera, malla_almn_ciclo, \nmalla_almn_num_matricula, malla_almn_nota1, malla_almn_nota2, malla_almn_nota3, \nmalla_almn_estado, persona_primer_nombre, persona_segundo_nombre, persona_segundo_apellido, persona_primer_apellido,\nmateria_nombre, persona_identificacion\nFROM public.\"MallaAlumno\" ma, public.\"AlumnosCarrera\" ac, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"Materias\" m\nWHERE ac.id_almn_carrera = ma.id_almn_carrera AND\na.id_alumno = ac.id_alumno AND \np.id_persona = a.id_persona AND\nm.id_materia = ma.id_materia AND\nac.id_carrera = " + idCarrera + " AND\nmalla_almn_ciclo = " + ciclo + " AND\nmalla_almn_estado = '" + estado.charAt(0) + "' \nORDER BY persona_primer_apellido, persona_segundo_apellido;";
        return this.consultaMallasTbl(this.sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MallaAlumnoMD buscarMateriaEstado(int idAlumnoCarrera, int idMateria) {
        String sqlc = "SELECT id_malla_alumno, id_materia, malla_almn_estado FROM public.\"MallaAlumno\" WHERE id_almn_carrera = " + idAlumnoCarrera + " AND id_materia = " + idMateria + ";";
        MallaAlumnoMD mll = new MallaAlumnoMD();
        PreparedStatement ps = CON.getPSPOOL(sqlc);
        try {
            ResultSet rs = ps.executeQuery();
            AlumnoCarreraMD a = new AlumnoCarreraMD();
            while (rs.next()) {
                a.setId(idAlumnoCarrera);
                mll.setId(rs.getInt("id_malla_alumno"));
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                mll.setEstado(rs.getString("malla_almn_estado"));
                mll.setMateria(m);
                mll.setAlumnoCarrera(a);
            }
        }
        catch (SQLException e) {
            M.errorMsg("Error al buscar materia estado. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return mll;
    }

    public ArrayList<MallaAlumnoMD> buscarMateriasAlumnoPorEstado(int idAlumnoCarrera, String estado) {
        this.sql = "SELECT id_malla_alumno, ma.id_materia, ma.id_almn_carrera, malla_almn_ciclo, \nmalla_almn_num_matricula, \nmateria_nombre, malla_almn_estado \nFROM public.\"MallaAlumno\" ma, public.\"AlumnosCarrera\" ac, public.\"Materias\" m\nWHERE ac.id_almn_carrera = ma.id_almn_carrera AND\nm.id_materia = ma.id_materia AND\nac.id_almn_carrera = " + idAlumnoCarrera + "\nAND malla_almn_estado = '" + estado.charAt(0) + "';";
        return this.consultarMallaParaEstado();
    }

    public ArrayList<MallaAlumnoMD> buscarMallaAlumnoParaEstado(int idAlumnoCarrera) {
        this.sql = "SELECT id_malla_alumno, ma.id_materia, ma.id_almn_carrera, malla_almn_ciclo, malla_almn_num_matricula, materia_nombre, malla_almn_estado FROM public.\"MallaAlumno\" ma, public.\"AlumnosCarrera\" ac, public.\"Materias\" m WHERE ac.id_almn_carrera = ma.id_almn_carrera AND m.id_materia = ma.id_materia AND ac.id_almn_carrera = " + idAlumnoCarrera + " ORDER BY malla_almn_ciclo;";
        return this.consultarMallaParaEstado();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<MallaAlumnoMD> consultarMallaParaEstado() {
        ArrayList<MallaAlumnoMD> mallas = new ArrayList<MallaAlumnoMD>();
        PreparedStatement ps = CON.getPSPOOL(this.sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                MallaAlumnoMD mll = new MallaAlumnoMD();
                mll.setId(rs.getInt("id_malla_alumno"));
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                m.setNombre(rs.getString("materia_nombre"));
                mll.setMateria(m);
                AlumnoCarreraMD a = new AlumnoCarreraMD();
                mll.setAlumnoCarrera(a);
                mll.setMallaCiclo(rs.getInt("malla_almn_ciclo"));
                mll.setMallaNumMatricula(rs.getInt("malla_almn_num_matricula"));
                mll.setEstado(rs.getString("malla_almn_estado"));
                mallas.add(mll);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudieron cargar mallas. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return mallas;
    }

    public ArrayList<MallaAlumnoMD> buscarMallaAlumno(String aguja) {
        this.sql = "SELECT id_malla_alumno, ma.id_materia, ma.id_almn_carrera, malla_almn_ciclo, \nmalla_almn_num_matricula, malla_almn_nota1, malla_almn_nota2, malla_almn_nota3, \nmalla_almn_estado, persona_primer_nombre, persona_segundo_nombre, persona_segundo_apellido, persona_primer_apellido,\nmateria_nombre, persona_identificacion,carrera_nombre \nFROM public.\"MallaAlumno\" ma, public.\"AlumnosCarrera\" ac, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"Materias\" m, public.\"Carreras\" c \nWHERE ac.id_almn_carrera = ma.id_almn_carrera AND\na.id_alumno = ac.id_alumno AND \nc.id_carrera = ac.id_carrera AND \np.id_persona = a.id_persona AND \nm.id_materia = ma.id_materia AND (\n\tpersona_primer_nombre || ' ' || persona_primer_apellido ILIKE '%" + aguja + "%' \n\tOR persona_identificacion ILIKE '%" + aguja + "%' \n) AND persona_activa = true;";
        return this.consultaMallasTbl(this.sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<MallaAlumnoMD> consultaMallasTbl(String sql) {
        ArrayList<MallaAlumnoMD> mallas = new ArrayList<MallaAlumnoMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                MallaAlumnoMD mll = new MallaAlumnoMD();
                mll.setId(rs.getInt("id_malla_alumno"));
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                m.setNombre(rs.getString("materia_nombre"));
                mll.setMateria(m);
                AlumnoCarreraMD a = new AlumnoCarreraMD();
                a.setId(rs.getInt("id_almn_carrera"));
                AlumnoMD al = new AlumnoMD();
                al.setIdentificacion(rs.getString("persona_identificacion"));
                al.setPrimerApellido(rs.getString("persona_primer_apellido"));
                al.setPrimerNombre(rs.getString("persona_primer_nombre"));
                al.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                al.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                a.setAlumno(al);
                mll.setAlumnoCarrera(a);
                mll.setMallaCiclo(rs.getInt("malla_almn_ciclo"));
                mll.setMallaNumMatricula(rs.getInt("malla_almn_num_matricula"));
                mll.setNota1(rs.getDouble("malla_almn_nota1"));
                mll.setNota2(rs.getDouble("malla_almn_nota2"));
                mll.setNota3(rs.getDouble("malla_almn_nota3"));
                mll.setEstado(rs.getString("malla_almn_estado"));
                mallas.add(mll);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudieron cargar mallas. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return mallas;
    }

    public String getSql() {
        return this.sql;
    }

    public List<List<String>> getPorCarrera(int idCarrera) {
        String sqlrep = "SELECT\npersona_identificacion,\npersona_primer_nombre || ' ' ||\npersona_segundo_nombre as \"nombre\",\npersona_primer_apellido || ' ' ||\npersona_segundo_apellido AS \"alumno\",\nmateria_nombre,\nmalla_almn_estado,\nmalla_almn_ciclo,\nmalla_almn_num_matricula,\nmalla_almn_nota1,\nmalla_almn_nota2,\nmalla_almn_nota3\n\nFROM public.\"MallaAlumno\" ma,\npublic.\"AlumnosCarrera\" ac,\npublic.\"Alumnos\" a,\npublic.\"Personas\" p,\npublic.\"Materias\" m\nWHERE ac.id_almn_carrera = ma.id_almn_carrera AND\na.id_alumno = ac.id_alumno AND\np.id_persona = a.id_persona AND\nm.id_materia = ma.id_materia AND\nac.id_carrera = " + idCarrera + "\nORDER BY\npersona_primer_apellido,\npersona_segundo_apellido,\nmalla_almn_ciclo;";
        return this.getParaReporte(sqlrep);
    }

    public List<List<String>> getPorAlumnoCarrera(int idAlmCarrera) {
        String sqlrep = "SELECT\npersona_identificacion,\npersona_primer_nombre || ' ' ||\npersona_segundo_nombre || ' ' ||\npersona_segundo_apellido || ' ' ||\npersona_primer_apellido AS \"alumno\",\nmateria_nombre,\nmalla_almn_estado,\nmalla_almn_ciclo,\nmalla_almn_num_matricula,\nmalla_almn_nota1,\nmalla_almn_nota2,\nmalla_almn_nota3\n\nFROM public.\"MallaAlumno\" ma,\npublic.\"AlumnosCarrera\" ac,\npublic.\"Alumnos\" a,\npublic.\"Personas\" p,\npublic.\"Materias\" m\nWHERE ac.id_almn_carrera = ma.id_almn_carrera AND\na.id_alumno = ac.id_alumno AND\np.id_persona = a.id_persona AND\nm.id_materia = ma.id_materia AND\nac.id_almn_carrera = " + idAlmCarrera + "\nORDER BY\npersona_primer_apellido,\npersona_segundo_apellido,\nmalla_almn_ciclo;";
        return this.getParaReporte(sqlrep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<String>> getParaReporte(String sqlrep) {
        ArrayList<List<String>> lista = new ArrayList<List<String>>();
        PreparedStatement ps = CON.getPSPOOL(sqlrep);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ArrayList<String> datos = new ArrayList<String>();
                datos.add(rs.getString(1));
                datos.add(rs.getString(3));
                datos.add(rs.getString(2));
                datos.add(rs.getString(4));
                datos.add(rs.getString(5));
                datos.add(rs.getInt(6) + "");
                datos.add(rs.getInt(7) + "");
                datos.add(rs.getDouble(8) + "");
                datos.add(rs.getDouble(9) + "");
                datos.add(rs.getDouble(10) + "");
                lista.add(datos);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No consultamos la malla del alumno por carrera." + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }
}

