/*
 * Decompiled with CFR 0.152.
 */
package modelo.alumno;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.alumno.AlumnoCarreraMD;
import modelo.alumno.Egresado;
import modelo.carrera.CarreraMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.AlumnoMD;
import utils.CONBD;
import utils.M;

public class EgresadoBD
extends CONBD {
    private static EgresadoBD EBD;
    public static final String BASEQUERY_TBLEGRESADOS = "SELECT\nid_egresado,\ne.id_almn_carrera,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_identificacion,\ncarrera_codigo,\nprd_lectivo_nombre,\nfecha_egreso,\ngraduado, trabajo_titulacion \nFROM alumno.\"Egresados\" e\nJOIN public.\"AlumnosCarrera\" ac\nON e.id_almn_carrera = ac.id_almn_carrera\nJOIN public.\"Carreras\" c\nON c.id_carrera = ac.id_carrera\nJOIN public.\"PeriodoLectivo\" pl\nON pl.id_prd_lectivo = e.id_prd_lectivo\nJOIN public.\"Alumnos\" a\nON ac.id_alumno = a.id_alumno\nJOIN public.\"Personas\" p\nON p.id_persona = a.id_persona\nWHERE graduado = false ";
    public static final String ENQUERY_TBLEGRESADOS = " ORDER BY fecha_egreso DESC;";
    public static final String BASEQUERY_TBLGRADUADOS = "SELECT\nid_egresado,\ne.id_almn_carrera,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_identificacion,\ncarrera_codigo,\nprd_lectivo_nombre,\nfecha_graduacion\nFROM alumno.\"Egresados\" e\nJOIN public.\"AlumnosCarrera\" ac\nON e.id_almn_carrera = ac.id_almn_carrera\nJOIN public.\"Carreras\" c\nON c.id_carrera = ac.id_carrera\nJOIN public.\"PeriodoLectivo\" pl\nON pl.id_prd_lectivo = e.id_prd_lectivo\nJOIN public.\"Alumnos\" a\nON ac.id_alumno = a.id_alumno\nJOIN public.\"Personas\" p\nON p.id_persona = a.id_persona\nWHERE graduado = true  ";
    public static final String ENQUERY_TBLGRADUADOS = " ORDER BY fecha_graduacion DESC;";

    public static EgresadoBD single() {
        if (EBD == null) {
            EBD = new EgresadoBD();
        }
        return EBD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PeriodoLectivoMD> getPeriodoByIdAlmnCarrera(int idAlmnCarrera) {
        ArrayList<PeriodoLectivoMD> pls = new ArrayList<PeriodoLectivoMD>();
        String sql = "SELECT\npl.id_prd_lectivo,\nprd_lectivo_nombre\nFROM public.\"PeriodoLectivo\" pl\nJOIN public.\"Matricula\" m ON pl.id_prd_lectivo = m.id_prd_lectivo\nWHERE pl.id_carrera IN (\n  SELECT id_carrera\n  FROM public.\"AlumnosCarrera\"\n  WHERE id_almn_carrera = ?\n) AND m.id_alumno = (\n  SELECT id_alumno\n  FROM public.\"AlumnosCarrera\"\n  WHERE id_almn_carrera = ?\n) ORDER BY prd_lectivo_fecha_fin DESC;";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ps.setInt(1, idAlmnCarrera);
            ps.setInt(2, idAlmnCarrera);
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                p.setID(res.getInt(1));
                p.setNombre(res.getString(2));
                pls.add(p);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al consultar ultimo periodo en el que se matriculo. \n" + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return pls;
    }

    public int guardarSinGraduacion(Egresado e) {
        String sql = "INSERT INTO alumno.\"Egresados\"(\nid_almn_carrera,\nid_prd_lectivo,\nfecha_egreso, trabajo_titulacion)\nVALUES (?, ?, ?, ?);";
        PreparedStatement ps = CON.getPSID(sql);
        try {
            ps.setInt(1, e.getAlmnCarrera().getId());
            ps.setInt(2, e.getPeriodo().getID());
            ps.setDate(3, Date.valueOf(e.getFechaEgreso()));
            ps.setBoolean(4, e.isTrabajoTitulacion());
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "Error al guardar sin graduacion.\n" + ex.getMessage());
        }
        return CON.getIDGenerado(ps);
    }

    public int editarSinGraduacion(Egresado e) {
        String sql = "UPDATE alumno.\"Egresados\" SET \n id_prd_lectivo=?,\n fecha_egreso=?,  graduado=?, trabajo_titulacion=? \n  WHERE id_egresado=?;";
        PreparedStatement ps = CON.getPSID(sql);
        try {
            ps.setInt(1, e.getPeriodo().getID());
            ps.setDate(2, Date.valueOf(e.getFechaEgreso()));
            ps.setBoolean(3, e.isGraduado());
            ps.setBoolean(4, e.isTrabajoTitulacion());
            ps.setInt(5, e.getId());
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "Error al editar sin graduacion.\n" + ex.getMessage());
        }
        return CON.getIDGenerado(ps);
    }

    public int guardarConGraduacion(Egresado e) {
        String sql = "INSERT INTO alumno.\"Egresados\"(\nid_almn_carrera,\nid_prd_lectivo,\nfecha_egreso,\ngraduado,\nfecha_graduacion,trabajo_titulacion )\nVALUES (?, ?, ?, ?, ?, ?);";
        PreparedStatement ps = CON.getPSID(sql);
        try {
            ps.setInt(1, e.getAlmnCarrera().getId());
            ps.setInt(2, e.getPeriodo().getID());
            ps.setDate(3, Date.valueOf(e.getFechaEgreso()));
            ps.setBoolean(4, e.isGraduado());
            ps.setDate(5, Date.valueOf(e.getFechaGraduacion()));
            ps.setBoolean(6, e.isTrabajoTitulacion());
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "Error al editar sin graduacion.\n" + ex.getMessage());
        }
        return CON.getIDGenerado(ps);
    }

    public int editarConGraduacion(Egresado e) {
        String sql = "UPDATE alumno.\"Egresados\" SET\nid_almn_carrera=?,\nid_prd_lectivo=?,\nfecha_egreso=?,\ngraduado=?,\nfecha_graduacion=?, trabajo_titulacion=? \n WHERE id_egresado=?;";
        PreparedStatement ps = CON.getPSID(sql);
        try {
            ps.setInt(1, e.getAlmnCarrera().getId());
            ps.setInt(2, e.getPeriodo().getID());
            ps.setDate(3, Date.valueOf(e.getFechaEgreso()));
            ps.setBoolean(4, e.isGraduado());
            ps.setDate(5, Date.valueOf(e.getFechaGraduacion()));
            ps.setBoolean(6, e.isTrabajoTitulacion());
            ps.setInt(7, e.getId());
        }
        catch (SQLException ex) {
            JOptionPane.showMessageDialog(null, "Error al editar sin graduacion.\n" + ex.getMessage());
        }
        return CON.getIDGenerado(ps);
    }

    public List<Egresado> getAllEgresados() {
        return this.getForTblEgresados(CON.getPSPOOL("SELECT\nid_egresado,\ne.id_almn_carrera,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_identificacion,\ncarrera_codigo,\nprd_lectivo_nombre,\nfecha_egreso,\ngraduado, trabajo_titulacion \nFROM alumno.\"Egresados\" e\nJOIN public.\"AlumnosCarrera\" ac\nON e.id_almn_carrera = ac.id_almn_carrera\nJOIN public.\"Carreras\" c\nON c.id_carrera = ac.id_carrera\nJOIN public.\"PeriodoLectivo\" pl\nON pl.id_prd_lectivo = e.id_prd_lectivo\nJOIN public.\"Alumnos\" a\nON ac.id_alumno = a.id_alumno\nJOIN public.\"Personas\" p\nON p.id_persona = a.id_persona\nWHERE graduado = false  ORDER BY fecha_egreso DESC;"));
    }

    public List<Egresado> getAllGraduados() {
        return this.getForTblGraduados(CON.getPSPOOL("SELECT\nid_egresado,\ne.id_almn_carrera,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_identificacion,\ncarrera_codigo,\nprd_lectivo_nombre,\nfecha_graduacion\nFROM alumno.\"Egresados\" e\nJOIN public.\"AlumnosCarrera\" ac\nON e.id_almn_carrera = ac.id_almn_carrera\nJOIN public.\"Carreras\" c\nON c.id_carrera = ac.id_carrera\nJOIN public.\"PeriodoLectivo\" pl\nON pl.id_prd_lectivo = e.id_prd_lectivo\nJOIN public.\"Alumnos\" a\nON ac.id_alumno = a.id_alumno\nJOIN public.\"Personas\" p\nON p.id_persona = a.id_persona\nWHERE graduado = true   ORDER BY fecha_graduacion DESC;"));
    }

    public boolean eliminar(int idEgresado) {
        String sql = "DELETE FROM alumno.\"Egresados\" WHERE id_egresado = ?;";
        return CON.deleteById(sql, idEgresado);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Egresado> getForTblEgresados(PreparedStatement ps) {
        ArrayList<Egresado> es = new ArrayList<Egresado>();
        try {
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                Egresado e = new Egresado();
                e.setFechaEgreso(res.getDate("fecha_egreso").toLocalDate());
                e.setId(res.getInt("id_egresado"));
                e.setGraduado(res.getBoolean("graduado"));
                e.setTrabajoTitulacion(res.getBoolean("trabajo_titulacion"));
                AlumnoCarreraMD ac = new AlumnoCarreraMD();
                ac.setId(res.getInt("id_almn_carrera"));
                AlumnoMD a = new AlumnoMD();
                a.setPrimerNombre(res.getString("persona_primer_nombre"));
                a.setSegundoNombre(res.getString("persona_segundo_nombre"));
                a.setPrimerApellido(res.getString("persona_primer_apellido"));
                a.setSegundoApellido(res.getString("persona_segundo_apellido"));
                a.setIdentificacion(res.getString("persona_identificacion"));
                ac.setAlumno(a);
                CarreraMD c = new CarreraMD();
                c.setCodigo(res.getString("carrera_codigo"));
                ac.setCarrera(c);
                PeriodoLectivoMD pl = new PeriodoLectivoMD();
                pl.setNombre(res.getString("prd_lectivo_nombre"));
                e.setAlmnCarrera(ac);
                e.setPeriodo(pl);
                es.add(e);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al mapear los egresados.\n" + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return es;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Egresado> getForTblGraduados(PreparedStatement ps) {
        ArrayList<Egresado> es = new ArrayList<Egresado>();
        try {
            ResultSet res = ps.executeQuery();
            while (res.next()) {
                Egresado e = new Egresado();
                e.setFechaGraduacion(res.getDate("fecha_graduacion").toLocalDate());
                e.setId(res.getInt("id_egresado"));
                AlumnoCarreraMD ac = new AlumnoCarreraMD();
                ac.setId(res.getInt("id_almn_carrera"));
                AlumnoMD a = new AlumnoMD();
                a.setPrimerNombre(res.getString("persona_primer_nombre"));
                a.setSegundoNombre(res.getString("persona_segundo_nombre"));
                a.setPrimerApellido(res.getString("persona_primer_apellido"));
                a.setSegundoApellido(res.getString("persona_segundo_apellido"));
                a.setIdentificacion(res.getString("persona_identificacion"));
                ac.setAlumno(a);
                CarreraMD c = new CarreraMD();
                c.setCodigo(res.getString("carrera_codigo"));
                ac.setCarrera(c);
                PeriodoLectivoMD pl = new PeriodoLectivoMD();
                pl.setNombre(res.getString("prd_lectivo_nombre"));
                e.setAlmnCarrera(ac);
                e.setPeriodo(pl);
                es.add(e);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al mapear los egresados.\n" + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return es;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getReportesEgresadosExcel(String ids) {
        ArrayList<List<String>> lista = new ArrayList<List<String>>();
        String sql = "SELECT\n'' AS \"C\u00d3DIGO DEL IST\",\n'ISTA' AS \"NOMBRE DEL INSTITUTO\",\n'AZUAY' AS \"PROVINCIA\",\ncarrera_codigo AS \"C\u00d3DIGO DE LA CARRERA\",\ncarrera_nombre AS \"CARRERA\",\ncarrera_modalidad AS \"MODALIDAD DE ESTUDIOS\",\n'' AS \"TIPO DE IDENTIFICACI\u00d3N\",\np.persona_identificacion AS \"NRO. DE IDENTIFICACI\u00d3N\",\np.persona_primer_apellido || ' ' ||\np.persona_segundo_apellido || ' ' ||\np.persona_primer_nombre || ' ' ||\np.persona_segundo_nombre AS \"APELLIDOS Y NOMBRES\",\nconsultar_pais(p.id_lugar_natal) AS \"NACIONALIDAD\",\nCASE WHEN trabajo_titulacion THEN 'SI' ELSE 'NO' END\nAS \"TRABAJO DE TITULACI\u00d3N FINALIZADO S/N\"\n\nFROM alumno.\"Egresados\" e\nJOIN public.\"AlumnosCarrera\" ac\nON ac.id_almn_carrera = e.id_almn_carrera\nJOIN public.\"Carreras\" c\nON ac.id_carrera = c.id_carrera\nJOIN public.\"Alumnos\" a\nON a.id_alumno = ac.id_alumno\nJOIN public.\"Personas\" p\nON p.id_persona = a.id_persona\nWHERE id_prd_lectivo IN (" + ids + ")";
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ArrayList<String> datos = new ArrayList<String>();
                datos.add(rs.getString(1));
                datos.add(rs.getString(2));
                datos.add(rs.getString(3));
                datos.add(rs.getString(4));
                datos.add(rs.getString(5));
                datos.add(rs.getString(6));
                datos.add(rs.getString(7));
                datos.add(rs.getString(8));
                datos.add(rs.getString(9));
                datos.add(rs.getString(10));
                datos.add(rs.getString(11));
                lista.add(datos);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No consultamos los alumnos egresados para el reportepor periodos para el reporte. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getNotasPromedioPorPeriodoDual(int idPeriodo) {
        String sql = "SELECT DISTINCT\np.persona_identificacion,\np.persona_primer_apellido,\np.persona_segundo_apellido,\np.persona_primer_nombre,\np.persona_segundo_nombre,\n\"CALCULAR_PROMEDIO_NOT_SIMILAR_TO\" (\n  ac.id_almn_carrera, '%(PTI|FASE PR\u00c1|INGL\u00c9S)%'\n) AS fase_teorica,\n\"CALCULAR_PROMEDIO_SIMILAR_TO\" (\n  ac.id_almn_carrera, '%(PTI)%'\n) AS pti,\n\"CALCULAR_PROMEDIO_SIMILAR_TO\" (\n  ac.id_almn_carrera, '%(FASE PR)%'\n) AS fase_practica\nFROM\nalumno.\"Egresados\" eg\nJOIN public.\"AlumnosCarrera\" ac ON ac.id_almn_carrera = eg.id_almn_carrera\nJOIN public.\"Alumnos\" a ON ac.id_alumno = a.id_alumno\nJOIN public.\"Personas\" p ON a.id_persona = p.id_persona\nWHERE eg.id_prd_lectivo  = " + idPeriodo + ";";
        ArrayList<List<String>> lista = new ArrayList<List<String>>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ArrayList<String> datos = new ArrayList<String>();
                datos.add(rs.getString(1));
                datos.add(rs.getString(2));
                datos.add(rs.getString(3));
                datos.add(rs.getString(4));
                datos.add(rs.getString(5));
                datos.add(rs.getDouble(6) + "");
                datos.add(rs.getDouble(7) + "");
                datos.add(rs.getDouble(8) + "");
                lista.add(datos);
            }
        }
        catch (SQLException e) {
            M.errorMsg("Notas del promedio por periodo.\n" + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getNotasPromedioPorPeriodo(int idPeriodo) {
        String sql = "SELECT DISTINCT\np.persona_identificacion,\np.persona_primer_apellido,\np.persona_segundo_apellido,\np.persona_primer_nombre,\np.persona_segundo_nombre,\n\"CALCULAR_PROMEDIO_NOT_SIMILAR_TO\" (\n  ac.id_almn_carrera, '%(PTI|FASE PR\u00c1)%'\n) AS promedio_final\nFROM\nalumno.\"Egresados\" eg\nJOIN public.\"AlumnosCarrera\" ac ON ac.id_almn_carrera = eg.id_almn_carrera\nJOIN public.\"Alumnos\" a ON ac.id_alumno = a.id_alumno\nJOIN public.\"Personas\" p ON a.id_persona = p.id_persona\nWHERE eg.id_prd_lectivo  = " + idPeriodo + " ;";
        ArrayList<List<String>> lista = new ArrayList<List<String>>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ArrayList<String> datos = new ArrayList<String>();
                datos.add(rs.getString(1));
                datos.add(rs.getString(2));
                datos.add(rs.getString(3));
                datos.add(rs.getString(4));
                datos.add(rs.getString(5));
                datos.add(rs.getDouble(6) + "");
                lista.add(datos);
            }
        }
        catch (SQLException e) {
            M.errorMsg("Notas del promedio por periodo.\n" + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getNotasPromedioPorEstudianteDual(int idEgresado) {
        String sql = "SELECT\np.persona_identificacion,\np.persona_primer_nombre,\np.persona_segundo_nombre,\np.persona_primer_apellido,\np.persona_segundo_apellido,\nma.malla_almn_ciclo,\nCOUNT(ma.malla_almn_ciclo) AS num_materias,\npromedio_malla_ciclo_not_similar_to(\n  ma.id_almn_carrera, malla_almn_ciclo, '%(PTI|FASE PR\u00c1|INGL\u00c9S)%'\n) AS fase_teorica,\npromedio_malla_ciclo_similar_to(\n  ma.id_almn_carrera, malla_almn_ciclo, '%(FASE PR)%'\n) AS fase_practica,\npromedio_malla_ciclo_similar_to(\n  ma.id_almn_carrera, malla_almn_ciclo, '%(PTI)%'\n) AS pti\nFROM alumno.\"Egresados\" eg\nJOIN public.\"AlumnosCarrera\" ac\nON ac.id_almn_carrera = eg.id_almn_carrera\nJOIN public.\"MallaAlumno\" ma\nON ma.id_almn_carrera = ac.id_almn_carrera\nJOIN public.\"Alumnos\" a\nON a.id_alumno = ac.id_alumno\nJOIN public.\"Personas\" p\nON p.id_persona = a.id_persona\nWHERE ma.malla_almn_estado = 'C'\nAND eg.id_egresado = " + idEgresado + "\nGROUP BY\nma.id_almn_carrera,\np.persona_identificacion,\np.persona_primer_nombre,\np.persona_segundo_nombre,\np.persona_primer_apellido,\np.persona_segundo_apellido,\nma.malla_almn_ciclo\nORDER BY\np.persona_primer_apellido,\np.persona_segundo_apellido,\np.persona_primer_nombre,\np.persona_segundo_nombre,\nma.malla_almn_ciclo;";
        ArrayList<List<String>> lista = new ArrayList<List<String>>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ArrayList<String> datos = new ArrayList<String>();
                datos.add(rs.getString(1));
                datos.add(rs.getString(2));
                datos.add(rs.getString(3));
                datos.add(rs.getString(4));
                datos.add(rs.getString(5));
                datos.add(rs.getInt(6) + "");
                datos.add(rs.getInt(7) + "");
                datos.add(rs.getDouble(8) + "");
                datos.add(rs.getDouble(9) + "");
                datos.add(rs.getDouble(10) + "");
                lista.add(datos);
            }
        }
        catch (SQLException e) {
            M.errorMsg("Notas del promedio por periodo.\n" + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getNotasPromedioPorEstudiante(int idEgresado) {
        String sql = "SELECT\np.persona_identificacion,\np.persona_primer_nombre,\np.persona_segundo_nombre,\np.persona_primer_apellido,\np.persona_segundo_apellido,\nma.malla_almn_ciclo,\nCOUNT(ma.malla_almn_ciclo) AS num_materias,\npromedio_malla_ciclo_not_similar_to(\n  ma.id_almn_carrera, malla_almn_ciclo, '%(PTI|FASE PR\u00c1)%'\n) AS promedio_final\nFROM alumno.\"Egresados\" eg\nJOIN public.\"AlumnosCarrera\" ac\nON ac.id_almn_carrera = eg.id_almn_carrera\nJOIN public.\"MallaAlumno\" ma\nON ma.id_almn_carrera = ac.id_almn_carrera\nJOIN public.\"Alumnos\" a\nON a.id_alumno = ac.id_alumno\nJOIN public.\"Personas\" p\nON p.id_persona = a.id_persona\nWHERE ma.malla_almn_estado = 'C'\nAND eg.id_egresado = " + idEgresado + "\nGROUP BY\nma.id_almn_carrera,\np.persona_identificacion,\np.persona_primer_nombre,\np.persona_segundo_nombre,\np.persona_primer_apellido,\np.persona_segundo_apellido,\nma.malla_almn_ciclo\nORDER BY\np.persona_primer_apellido,\np.persona_segundo_apellido,\np.persona_primer_nombre,\np.persona_segundo_nombre,\nma.malla_almn_ciclo;";
        ArrayList<List<String>> lista = new ArrayList<List<String>>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ArrayList<String> datos = new ArrayList<String>();
                datos.add(rs.getString(1));
                datos.add(rs.getString(2));
                datos.add(rs.getString(3));
                datos.add(rs.getString(4));
                datos.add(rs.getString(5));
                datos.add(rs.getInt(6) + "");
                datos.add(rs.getInt(7) + "");
                datos.add(rs.getDouble(8) + "");
                lista.add(datos);
            }
        }
        catch (SQLException e) {
            M.errorMsg("Notas del promedio por periodo.\n" + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }
}

