/*
 * Decompiled with CFR 0.152.
 */
package modelo.alumno;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import modelo.alumno.AlumnoMatriculaMD;
import modelo.carrera.CarreraMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.AlumnoMD;
import utils.CONBD;
import utils.M;

public class AlumnoMatriculaBD
extends CONBD {
    private static AlumnoMatriculaBD AMBD;
    private final String BASESQL = "SELECT\npersona_identificacion,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_correo,\npersona_celular,\npersona_telefono,\ncarrera_nombre,\ncarrera_codigo,\nprd_lectivo_nombre,\n\tSTRING_AGG(\n\t\tc.curso_nombre || '  # ' || ac.almn_curso_num_matricula || ':  ' || materia_nombre, E'\\n'\n\t) Materias\nFROM public.\"Carreras\" cr, public.\"Cursos\" c,\npublic.\"Alumnos\" a, public.\"Personas\" p,\npublic.\"Materias\" m, public.\"AlumnoCurso\" ac,\npublic.\"PeriodoLectivo\" pl\nWHERE p.id_persona = a.id_persona\nAND a.id_alumno = ac.id_alumno\nAND ac.id_curso = c.id_curso\nAND m.id_materia = c.id_materia\nAND pl.id_prd_lectivo = c.id_prd_lectivo\nAND cr.id_carrera = pl.id_carrera\nAND ac.almn_curso_activo = true\n";
    private final String FINSQL = "\nGROUP BY persona_identificacion,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_correo,\npersona_celular,\npersona_telefono,\ncarrera_nombre,\ncarrera_codigo,\nprd_lectivo_nombre\nORDER BY persona_primer_apellido, persona_segundo_apellido;";

    public static AlumnoMatriculaBD single() {
        if (AMBD == null) {
            AMBD = new AlumnoMatriculaBD();
        }
        return AMBD;
    }

    public ArrayList<AlumnoMatriculaMD> getTodos() {
        String sql = "SELECT\npersona_identificacion,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_correo,\npersona_celular,\npersona_telefono,\ncarrera_nombre,\ncarrera_codigo,\nprd_lectivo_nombre,\n\tSTRING_AGG(\n\t\tc.curso_nombre || '  # ' || ac.almn_curso_num_matricula || ':  ' || materia_nombre, E'\\n'\n\t) Materias\nFROM public.\"Carreras\" cr, public.\"Cursos\" c,\npublic.\"Alumnos\" a, public.\"Personas\" p,\npublic.\"Materias\" m, public.\"AlumnoCurso\" ac,\npublic.\"PeriodoLectivo\" pl\nWHERE p.id_persona = a.id_persona\nAND a.id_alumno = ac.id_alumno\nAND ac.id_curso = c.id_curso\nAND m.id_materia = c.id_materia\nAND pl.id_prd_lectivo = c.id_prd_lectivo\nAND cr.id_carrera = pl.id_carrera\nAND ac.almn_curso_activo = true\n\nGROUP BY persona_identificacion,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_correo,\npersona_celular,\npersona_telefono,\ncarrera_nombre,\ncarrera_codigo,\nprd_lectivo_nombre\nORDER BY persona_primer_apellido, persona_segundo_apellido;";
        return this.obtenerParaTbl(sql);
    }

    public ArrayList<AlumnoMatriculaMD> getPorPeriodo(int idPeriodo) {
        String sql = "SELECT\npersona_identificacion,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_correo,\npersona_celular,\npersona_telefono,\ncarrera_nombre,\ncarrera_codigo,\nprd_lectivo_nombre,\n\tSTRING_AGG(\n\t\tc.curso_nombre || '  # ' || ac.almn_curso_num_matricula || ':  ' || materia_nombre, E'\\n'\n\t) Materias\nFROM public.\"Carreras\" cr, public.\"Cursos\" c,\npublic.\"Alumnos\" a, public.\"Personas\" p,\npublic.\"Materias\" m, public.\"AlumnoCurso\" ac,\npublic.\"PeriodoLectivo\" pl\nWHERE p.id_persona = a.id_persona\nAND a.id_alumno = ac.id_alumno\nAND ac.id_curso = c.id_curso\nAND m.id_materia = c.id_materia\nAND pl.id_prd_lectivo = c.id_prd_lectivo\nAND cr.id_carrera = pl.id_carrera\nAND ac.almn_curso_activo = true\n AND c.id_prd_lectivo = " + idPeriodo + "\nGROUP BY persona_identificacion,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_correo,\npersona_celular,\npersona_telefono,\ncarrera_nombre,\ncarrera_codigo,\nprd_lectivo_nombre\nORDER BY persona_primer_apellido, persona_segundo_apellido;";
        return this.obtenerParaTbl(sql);
    }

    public ArrayList<AlumnoMatriculaMD> buscarPor(String aguja) {
        String sql = "SELECT\npersona_identificacion,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_correo,\npersona_celular,\npersona_telefono,\ncarrera_nombre,\ncarrera_codigo,\nprd_lectivo_nombre,\n\tSTRING_AGG(\n\t\tc.curso_nombre || '  # ' || ac.almn_curso_num_matricula || ':  ' || materia_nombre, E'\\n'\n\t) Materias\nFROM public.\"Carreras\" cr, public.\"Cursos\" c,\npublic.\"Alumnos\" a, public.\"Personas\" p,\npublic.\"Materias\" m, public.\"AlumnoCurso\" ac,\npublic.\"PeriodoLectivo\" pl\nWHERE p.id_persona = a.id_persona\nAND a.id_alumno = ac.id_alumno\nAND ac.id_curso = c.id_curso\nAND m.id_materia = c.id_materia\nAND pl.id_prd_lectivo = c.id_prd_lectivo\nAND cr.id_carrera = pl.id_carrera\nAND ac.almn_curso_activo = true\nAND (persona_identificacion ILIKE '%" + aguja + "%' OR persona_primer_nombre || persona_primer_apellido ILIKE '%" + aguja + "%' OR persona_segundo_nombre || persona_primer_apellido ILIKE '%" + aguja + "%' OR carrera_nombre ILIKE '%" + aguja + "%' )" + "\nGROUP BY persona_identificacion,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\npersona_correo,\npersona_celular,\npersona_telefono,\ncarrera_nombre,\ncarrera_codigo,\nprd_lectivo_nombre\nORDER BY persona_primer_apellido, persona_segundo_apellido;";
        return this.obtenerParaTbl(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AlumnoMatriculaMD> obtenerParaTbl(String sql) {
        ArrayList<AlumnoMatriculaMD> almnsMatri = new ArrayList<AlumnoMatriculaMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AlumnoMatriculaMD am = new AlumnoMatriculaMD();
                AlumnoMD a = new AlumnoMD();
                CarreraMD c = new CarreraMD();
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                a.setIdentificacion(rs.getString("persona_identificacion"));
                a.setPrimerNombre(rs.getString("persona_primer_nombre"));
                a.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                a.setPrimerApellido(rs.getString("persona_primer_apellido"));
                a.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                a.setCorreo(rs.getString("persona_correo"));
                a.setCelular(rs.getString("persona_celular"));
                a.setTelefono(rs.getString("persona_telefono"));
                c.setNombre(rs.getString("carrera_nombre"));
                c.setCodigo(rs.getString("carrera_codigo"));
                p.setNombre(rs.getString("prd_lectivo_nombre"));
                p.setCarrera(c);
                am.setAlumno(a);
                am.setPeriodo(p);
                am.setCursos(rs.getString(12));
                almnsMatri.add(am);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No logramos consultar " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return almnsMatri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getNumeroAlumnos(String idPrds) {
        String sql = "SELECT\ncarrera_codigo,\nprd_lectivo_nombre, (\n  SELECT COUNT(*)\n  FROM public.\"Matricula\" m\n  JOIN public.\"Alumnos\" a ON\n  a.id_alumno = m.id_alumno\n  JOIN public.\"Personas\" p ON\n  a.id_persona = p.id_persona\n  WHERE persona_activa = true AND\n  persona_sexo ILIKE '%H%' AND\n  m.id_prd_lectivo = pl.id_prd_lectivo\n) AS hombres, (\n  SELECT COUNT(*)\n  FROM public.\"Matricula\" m\n  JOIN public.\"Alumnos\" a ON\n  a.id_alumno = m.id_alumno\n  JOIN public.\"Personas\" p ON\n  a.id_persona = p.id_persona\n  WHERE persona_activa = true AND\n  persona_sexo ILIKE '%M%' AND\n  m.id_prd_lectivo = pl.id_prd_lectivo\n) AS mujeres, (\n  SELECT COUNT(*)\n  FROM public.\"Matricula\" m\n  WHERE  m.id_prd_lectivo = pl.id_prd_lectivo\n) AS total\nFROM public.\"Carreras\" c\nJOIN public.\"PeriodoLectivo\" pl ON\npl.id_carrera = c.id_carrera\nWHERE pl.id_prd_lectivo IN (\n" + idPrds + " ) GROUP BY\npl.id_prd_lectivo,\ncarrera_codigo,\nprd_lectivo_nombre\nORDER BY\nprd_lectivo_fecha_inicio DESC;";
        ArrayList<List<String>> alms = new ArrayList<List<String>>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ArrayList<String> datos = new ArrayList<String>();
                datos.add(rs.getString(1));
                datos.add(rs.getString(2));
                datos.add(rs.getInt(3) + "");
                datos.add(rs.getInt(4) + "");
                datos.add(rs.getInt(5) + "");
                alms.add(datos);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No consultamos el numero de alumnos por periodos para el reporte. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return alms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getNumeroAlumnosPorJornada(String idPrds) {
        String sql = "SELECT\ncarrera_codigo,\nprd_lectivo_nombre, (\n  SELECT\n  COUNT(DISTINCT curso_nombre)\n  FROM public.\"Cursos\" cr\n  WHERE\n  cr.id_prd_lectivo = pl.id_prd_lectivo AND\n  cr.id_jornada = 1\n) AS num_matutina, (\n  SELECT count(DISTINCT ac.id_alumno)\n  FROM public.\"AlumnoCurso\" ac\n  JOIN public.\"Alumnos\" a ON\n  a.id_alumno = ac.id_alumno\n  JOIN public.\"Personas\" p ON\n  a.id_persona = p.id_persona\n  WHERE id_curso IN (\n    SELECT id_curso\n    FROM public.\"Cursos\" cr\n    WHERE\n    cr.id_prd_lectivo = pl.id_prd_lectivo AND\n    cr.id_jornada = 1\n  ) AND persona_activa = true AND\n  persona_sexo ILIKE '%H%'\n) AS hombres_matu, (\n  SELECT count(DISTINCT ac.id_alumno)\n  FROM public.\"AlumnoCurso\" ac\n  JOIN public.\"Alumnos\" a ON\n  a.id_alumno = ac.id_alumno\n  JOIN public.\"Personas\" p ON\n  a.id_persona = p.id_persona\n  WHERE id_curso IN (\n    SELECT id_curso\n    FROM public.\"Cursos\" cr\n    WHERE\n    cr.id_prd_lectivo = pl.id_prd_lectivo AND\n    cr.id_jornada = 1\n  ) AND persona_activa = true AND\n  persona_sexo ILIKE '%M%'\n) AS mujeres_matu, (\n  SELECT\n  count(DISTINCT ac.id_alumno)\n  FROM public.\"AlumnoCurso\" ac\n  WHERE id_curso IN (\n    SELECT id_curso\n    FROM public.\"Cursos\" cr\n    WHERE\n    cr.id_prd_lectivo = pl.id_prd_lectivo AND\n    cr.id_jornada = 1\n  )\n) AS alum_matu,(\n  SELECT\n  COUNT(DISTINCT curso_nombre)\n  FROM public.\"Cursos\" cr\n  WHERE\n  cr.id_prd_lectivo = pl.id_prd_lectivo AND\n  cr.id_jornada = 2\n) AS num_vespertina, (\n  SELECT count(DISTINCT ac.id_alumno)\n  FROM public.\"AlumnoCurso\" ac\n  JOIN public.\"Alumnos\" a ON\n  a.id_alumno = ac.id_alumno\n  JOIN public.\"Personas\" p ON\n  a.id_persona = p.id_persona\n  WHERE id_curso IN (\n    SELECT id_curso\n    FROM public.\"Cursos\" cr\n    WHERE\n    cr.id_prd_lectivo = pl.id_prd_lectivo AND\n    cr.id_jornada = 2\n  ) AND persona_activa = true AND\n  persona_sexo ILIKE '%H%'\n) AS hombres_vespe, (\n  SELECT count(DISTINCT ac.id_alumno)\n  FROM public.\"AlumnoCurso\" ac\n  JOIN public.\"Alumnos\" a ON\n  a.id_alumno = ac.id_alumno\n  JOIN public.\"Personas\" p ON\n  a.id_persona = p.id_persona\n  WHERE id_curso IN (\n    SELECT id_curso\n    FROM public.\"Cursos\" cr\n    WHERE\n    cr.id_prd_lectivo = pl.id_prd_lectivo AND\n    cr.id_jornada = 2\n  ) AND persona_activa = true AND\n  persona_sexo ILIKE '%M%'\n) AS mujeres_vesp, (\n  SELECT\n  count(DISTINCT ac.id_alumno)\n  FROM public.\"AlumnoCurso\" ac\n  WHERE id_curso IN (\n    SELECT id_curso\n    FROM public.\"Cursos\" cr\n    WHERE\n    cr.id_prd_lectivo = pl.id_prd_lectivo AND\n    cr.id_jornada = 2\n  )\n) AS alum_vesp, (\n  SELECT\n  COUNT(DISTINCT curso_nombre)\n  FROM public.\"Cursos\" cr\n  WHERE\n  cr.id_prd_lectivo = pl.id_prd_lectivo AND\n  cr.id_jornada = 3\n) AS num_nocturna, (\n  SELECT count(DISTINCT ac.id_alumno)\n  FROM public.\"AlumnoCurso\" ac\n  JOIN public.\"Alumnos\" a ON\n  a.id_alumno = ac.id_alumno\n  JOIN public.\"Personas\" p ON\n  a.id_persona = p.id_persona\n  WHERE id_curso IN (\n    SELECT id_curso\n    FROM public.\"Cursos\" cr\n    WHERE\n    cr.id_prd_lectivo = pl.id_prd_lectivo AND\n    cr.id_jornada = 3\n  ) AND persona_activa = true AND\n  persona_sexo ILIKE '%H%'\n) AS hombres_noctu, (\n  SELECT count(DISTINCT ac.id_alumno)\n  FROM public.\"AlumnoCurso\" ac\n  JOIN public.\"Alumnos\" a ON\n  a.id_alumno = ac.id_alumno\n  JOIN public.\"Personas\" p ON\n  a.id_persona = p.id_persona\n  WHERE id_curso IN (\n    SELECT id_curso\n    FROM public.\"Cursos\" cr\n    WHERE\n    cr.id_prd_lectivo = pl.id_prd_lectivo AND\n    cr.id_jornada = 3\n  ) AND persona_activa = true AND\n  persona_sexo ILIKE '%M%'\n) AS mujeres_noctu, (\n  SELECT\n  count(DISTINCT ac.id_alumno)\n  FROM public.\"AlumnoCurso\" ac\n  WHERE id_curso IN (\n    SELECT id_curso\n    FROM public.\"Cursos\" cr\n    WHERE\n    cr.id_prd_lectivo = pl.id_prd_lectivo AND\n    cr.id_jornada = 3\n  )\n) AS alum_noct\nFROM public.\"Carreras\" c\nJOIN public.\"PeriodoLectivo\" pl ON\npl.id_carrera = c.id_carrera\nWHERE pl.id_prd_lectivo IN (\n" + idPrds + ") GROUP BY\npl.id_prd_lectivo,\ncarrera_codigo,\nprd_lectivo_nombre\nORDER BY\nprd_lectivo_fecha_inicio DESC;";
        ArrayList<List<String>> alms = new ArrayList<List<String>>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ArrayList<String> datos = new ArrayList<String>();
                datos.add(rs.getString(1));
                datos.add(rs.getString(2));
                datos.add(rs.getInt(3) + "");
                datos.add(rs.getInt(4) + "");
                datos.add(rs.getInt(5) + "");
                datos.add(rs.getInt(6) + "");
                datos.add(rs.getInt(7) + "");
                datos.add(rs.getInt(8) + "");
                datos.add(rs.getInt(9) + "");
                datos.add(rs.getInt(10) + "");
                datos.add(rs.getInt(11) + "");
                datos.add(rs.getInt(12) + "");
                datos.add(rs.getInt(13) + "");
                datos.add(rs.getInt(14) + "");
                alms.add(datos);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No consultamos el numero de alumnos por periodos para el reporte. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return alms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<List<String>> getPorTipoMatricula(String idsPeriodo, String tipo) {
        if (tipo == "TODAS") {
            tipo = "%";
        }
        String sql = "SELECT\npersona_identificacion,\npersona_primer_nombre,\npersona_segundo_nombre,\npersona_primer_apellido,\npersona_segundo_apellido,\nmatricula_fecha,\nmatricula_tipo\nFROM \npublic.\"Matricula\" m\nJOIN public.\"Alumnos\" a ON m.id_alumno = a.id_alumno\nJOIN public.\"Personas\" p ON p.id_persona = a.id_persona\nWHERE matricula_tipo ILIKE '%" + tipo + "%'\nAND id_prd_lectivo IN ( " + idsPeriodo + ");";
        ArrayList<List<String>> lista = new ArrayList<List<String>>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ArrayList<String> datos = new ArrayList<String>();
                datos.add(rs.getString(1));
                datos.add(rs.getString(2));
                datos.add(rs.getString(3));
                datos.add(rs.getString(4));
                datos.add(rs.getString(5));
                datos.add(rs.getDate(6).toString());
                datos.add(rs.getString(7));
                lista.add(datos);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No consultamos el numero de alumnos por periodos para el reporte. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return lista;
    }
}

