/*
 * Decompiled with CFR 0.152.
 */
package modelo.alumno;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import modelo.alumno.AlumnoCursoMD;
import modelo.alumno.AlumnoCursoRetiradoMD;
import modelo.curso.CursoMD;
import modelo.materia.MateriaMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.AlumnoMD;
import utils.CONBD;
import utils.M;

public class AlumnoCursoRetiradoBD
extends CONBD {
    private String sql;
    private String nsql;
    private static AlumnoCursoRetiradoBD ACRBD;

    public static AlumnoCursoRetiradoBD single() {
        if (ACRBD == null) {
            ACRBD = new AlumnoCursoRetiradoBD();
        }
        return ACRBD;
    }

    public void guardar(AlumnoCursoRetiradoMD acr) {
        this.nsql = "INSERT INTO public.\"AlumnoCursoRetirados\"(\nid_almn_curso, retiro_observacion)\nVALUES (" + acr.getAlumnoCurso().getId() + ",  '" + acr.getObservacion() + "');";
        if (CON.executeNoSQL(this.nsql)) {
            JOptionPane.showMessageDialog(null, "Anulada la matricula de: \n" + acr.getAlumnoCurso().getCurso().getMateria().getNombre());
        }
    }

    public boolean eliminar(int idRetirado) {
        this.nsql = "UPDATE public.\"AlumnoCursoRetirados\" \nSET retiro_activo = false \nWHERE id_retirado = " + idRetirado + ";";
        if (CON.executeNoSQL(this.nsql)) {
            JOptionPane.showMessageDialog(null, "Se elimino la anulacion. ");
            return true;
        }
        JOptionPane.showMessageDialog(null, "No se pudo eliminar, compruebe su conexion.");
        return false;
    }

    public ArrayList<AlumnoCursoRetiradoMD> cargarRetirados() {
        this.sql = "SELECT id_retirado, acr.id_almn_curso, retiro_fecha, \nretiro_observacion, ac.id_curso, materia_nombre, \nac.id_alumno, persona_identificacion, \npersona_primer_nombre, persona_primer_apellido, prd_lectivo_nombre \nFROM public.\"AlumnoCursoRetirados\" acr, \npublic.\"AlumnoCurso\" ac, public.\"Cursos\" c, \npublic.\"Materias\" m, public.\"Alumnos\" a, \npublic.\"Personas\" p, public.\"PeriodoLectivo\" pl \nWHERE ac.id_almn_curso = acr.id_almn_curso AND\nc.id_curso = ac.id_curso AND \nm.id_materia = c.id_materia AND \na.id_alumno = ac.id_alumno AND \npl.id_prd_lectivo = c.id_prd_lectivo AND \np.id_persona = a.id_persona AND \nretiro_activo = true; ";
        return this.consultarParaTbl(this.sql);
    }

    public ArrayList<AlumnoCursoRetiradoMD> cargarRetiradosEliminados() {
        this.sql = "SELECT id_retirado, acr.id_almn_curso, retiro_fecha, \nretiro_observacion, ac.id_curso, materia_nombre, \nac.id_alumno, persona_identificacion, \npersona_primer_nombre, persona_primer_apellido, prd_lectivo_nombre \nFROM public.\"AlumnoCursoRetirados\" acr, \npublic.\"AlumnoCurso\" ac, public.\"Cursos\" c, \npublic.\"Materias\" m, public.\"Alumnos\" a, \npublic.\"Personas\" p, public.\"PeriodoLectivo\" pl \nWHERE ac.id_almn_curso = acr.id_almn_curso AND\nc.id_curso = ac.id_curso AND \nm.id_materia = c.id_materia AND \na.id_alumno = ac.id_alumno AND \npl.id_prd_lectivo = c.id_prd_lectivo AND \np.id_persona = a.id_persona AND \nretiro_activo = false; ";
        return this.consultarParaTbl(this.sql);
    }

    public ArrayList<AlumnoCursoRetiradoMD> buscarRetirados(String aguja) {
        this.sql = "\tSELECT id_retirado, acr.id_almn_curso, retiro_fecha,\nretiro_observacion, ac.id_curso, materia_nombre,\nac.id_alumno, persona_identificacion,\npersona_primer_nombre, persona_primer_apellido, prd_lectivo_nombre\nFROM public.\"AlumnoCursoRetirados\" acr,\npublic.\"AlumnoCurso\" ac, public.\"Cursos\" c,\npublic.\"Materias\" m, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"PeriodoLectivo\" pl \nWHERE ac.id_almn_curso = acr.id_almn_curso AND\nc.id_curso = ac.id_curso AND\nm.id_materia = c.id_materia AND\na.id_alumno = ac.id_alumno AND \npl.id_prd_lectivo = c.id_prd_lectivo AND \np.id_persona = a.id_persona AND\nretiro_activo = true AND(\n\tpersona_identificacion ILIKE '%" + aguja + "%' OR\n\tpersona_primer_nombre || ' ' || persona_segundo_nombre\n\t|| ' ' || persona_primer_apellido || ' ' ||persona_segundo_apellido\n\tILIKE '%" + aguja + "%' OR persona_primer_nombre || ' ' || persona_primer_apellido ILIKE '%" + aguja + "%');";
        return this.consultarParaTbl(this.sql);
    }

    public ArrayList<AlumnoCursoRetiradoMD> buscarRetiradosEliminados(String aguja) {
        this.sql = "\tSELECT id_retirado, acr.id_almn_curso, retiro_fecha,\nretiro_observacion, ac.id_curso, materia_nombre,\nac.id_alumno, persona_identificacion,\npersona_primer_nombre, persona_primer_apellido, prd_lectivo_nombre\nFROM public.\"AlumnoCursoRetirados\" acr,\npublic.\"AlumnoCurso\" ac, public.\"Cursos\" c,\npublic.\"Materias\" m, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"PeriodoLectivo\" pl \nWHERE ac.id_almn_curso = acr.id_almn_curso AND\nc.id_curso = ac.id_curso AND\nm.id_materia = c.id_materia AND\na.id_alumno = ac.id_alumno AND \npl.id_prd_lectivo = c.id_prd_lectivo AND \np.id_persona = a.id_persona AND\nretiro_activo = false AND(\n\tpersona_identificacion ILIKE '%" + aguja + "%' OR\n\tpersona_primer_nombre || ' ' || persona_segundo_nombre\n\t|| ' ' || persona_primer_apellido || ' ' ||persona_segundo_apellido\n\tILIKE '%" + aguja + "%' OR persona_primer_nombre || ' ' || persona_primer_apellido ILIKE '%" + aguja + "%');";
        return this.consultarParaTbl(this.sql);
    }

    public ArrayList<AlumnoCursoRetiradoMD> cargarRetiradosPorPrdEliminados(int idPrd) {
        this.sql = "\tSELECT id_retirado, acr.id_almn_curso, retiro_fecha,\nretiro_observacion, ac.id_curso, materia_nombre,\nac.id_alumno, persona_identificacion,\npersona_primer_nombre, persona_primer_apellido, prd_lectivo_nombre \nFROM public.\"AlumnoCursoRetirados\" acr,\npublic.\"AlumnoCurso\" ac, public.\"Cursos\" c,\npublic.\"Materias\" m, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"PeriodoLectivo\" pl \nWHERE ac.id_almn_curso = acr.id_almn_curso AND\nc.id_curso = ac.id_curso AND\nm.id_materia = c.id_materia AND \na.id_alumno = ac.id_alumno AND \npl.id_prd_lectivo = c.id_prd_lectivo AND \np.id_persona = a.id_persona AND\nretiro_activo = false AND\nc.id_prd_lectivo = " + idPrd + ";";
        return this.consultarParaTbl(this.sql);
    }

    public ArrayList<AlumnoCursoRetiradoMD> cargarRetiradosPorPrd(int idPrd) {
        this.sql = "\tSELECT id_retirado, acr.id_almn_curso, retiro_fecha,\nretiro_observacion, ac.id_curso, materia_nombre,\nac.id_alumno, persona_identificacion,\npersona_primer_nombre, persona_primer_apellido, prd_lectivo_nombre \nFROM public.\"AlumnoCursoRetirados\" acr,\npublic.\"AlumnoCurso\" ac, public.\"Cursos\" c,\npublic.\"Materias\" m, public.\"Alumnos\" a,\npublic.\"Personas\" p, public.\"PeriodoLectivo\" pl \nWHERE ac.id_almn_curso = acr.id_almn_curso AND\nc.id_curso = ac.id_curso AND\nm.id_materia = c.id_materia AND \na.id_alumno = ac.id_alumno AND \npl.id_prd_lectivo = c.id_prd_lectivo AND \np.id_persona = a.id_persona AND\nretiro_activo = true AND\nc.id_prd_lectivo = " + idPrd + ";";
        return this.consultarParaTbl(this.sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<AlumnoCursoRetiradoMD> consultarParaTbl(String sql) {
        ArrayList<AlumnoCursoRetiradoMD> retirados = new ArrayList<AlumnoCursoRetiradoMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AlumnoCursoRetiradoMD r = new AlumnoCursoRetiradoMD();
                AlumnoCursoMD ac = new AlumnoCursoMD();
                AlumnoMD a = new AlumnoMD();
                CursoMD c = new CursoMD();
                MateriaMD m = new MateriaMD();
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                r.setId(rs.getInt("id_retirado"));
                ac.setId(rs.getInt("id_almn_curso"));
                r.setFecha(rs.getTimestamp("retiro_fecha").toLocalDateTime());
                r.setObservacion(rs.getString("retiro_observacion"));
                c.setId(rs.getInt("id_curso"));
                m.setNombre(rs.getString("materia_nombre"));
                a.setId_Alumno(rs.getInt("id_alumno"));
                a.setIdentificacion(rs.getString("persona_identificacion"));
                a.setPrimerNombre(rs.getString("persona_primer_nombre"));
                a.setPrimerApellido(rs.getString("persona_primer_apellido"));
                p.setNombre(rs.getString("prd_lectivo_nombre"));
                c.setMateria(m);
                c.setPeriodo(p);
                ac.setCurso(c);
                ac.setAlumno(a);
                r.setAlumnoCurso(ac);
                retirados.add(r);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudo consultar alumnos retirados." + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return retirados;
    }
}

