/*
 * Decompiled with CFR 0.152.
 */
package modelo.alumno;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import modelo.ConnDBPool;
import modelo.alumno.AlumnoCursoMD;
import modelo.curso.CursoMD;
import modelo.materia.MateriaMD;
import modelo.notas.NotasBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.AlumnoMD;
import utils.CONBD;
import utils.M;

public class AlumnoCursoBD
extends CONBD {
    private String nsqlMatri = "";
    private String nsqlMatriUpdate = "";
    private final ConnDBPool pool = new ConnDBPool();
    private Connection conn;
    private ResultSet rst;
    private static AlumnoCursoBD ACBD;

    public static AlumnoCursoBD single() {
        if (ACBD == null) {
            ACBD = new AlumnoCursoBD();
        }
        return ACBD;
    }

    public void borrarMatricula() {
        this.nsqlMatri = "";
    }

    public void agregarMatricula(int idAlmn, int idCurso, int numMatricula) {
        String nsql = "\nINSERT INTO public.\"AlumnoCurso\"(\nid_alumno, id_curso, almn_curso_num_matricula)\nVALUES (" + idAlmn + ", " + idCurso + ", " + numMatricula + ");";
        this.nsqlMatri = this.nsqlMatri + nsql;
    }

    public boolean guardarAlmnCurso() {
        return CON.executeNoSQL(this.nsqlMatri);
    }

    public void agregarUpdate(int idAlmnCurso, int idCurso) {
        String nsql = "UPDATE public.\"AlumnoCurso\"\n\tSET id_curso=" + idCurso + "\n\tWHERE id_almn_curso =" + idAlmnCurso + "; \n";
        this.nsqlMatriUpdate = this.nsqlMatriUpdate + nsql;
    }

    public boolean actualizarMatricula() {
        return CON.executeNoSQL(this.nsqlMatriUpdate);
    }

    public boolean editarNumMatricula(int idAlmnCurso, int numMatricula) {
        String nosql = "UPDATE public.\"AlumnoCurso\"\n\tSET almn_curso_num_matricula = ?\n\tWHERE id_almn_curso = ?;";
        PreparedStatement ps = CON.getPSPOOL(nosql);
        try {
            ps.setInt(1, numMatricula);
            ps.setInt(2, idAlmnCurso);
        }
        catch (SQLException e) {
            M.errorMsg("No pudimos preparar le statement en editar matricula: " + e.getMessage());
        }
        return CON.noSQLPOOL(ps);
    }

    public void borrarActualizarMatricula() {
        this.nsqlMatriUpdate = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AlumnoCursoMD> buscarCursosAlmPeriodo(int idAlm, int idPrd) {
        String sql = "SELECT id_almn_curso, c.id_curso, \nc.id_materia, materia_nombre, curso_nombre, curso_ciclo\nFROM public.\"AlumnoCurso\" ac, public.\"Cursos\" c, \npublic.\"Materias\" m \n\tWHERE c.id_curso = ac.id_curso\n\tAND m.id_materia = c.id_materia\n\tAND id_alumno = " + idAlm + " AND id_prd_lectivo = " + idPrd + "      AND (almn_curso_estado <> 'RETIRADO' OR  almn_curso_activo = true);";
        PreparedStatement ps = CON.getPSPOOL(sql);
        ArrayList<AlumnoCursoMD> cursos = new ArrayList<AlumnoCursoMD>();
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AlumnoCursoMD ac = new AlumnoCursoMD();
                ac.setId(rs.getInt("id_almn_curso"));
                CursoMD c = new CursoMD();
                c.setId(rs.getInt("id_curso"));
                MateriaMD m = new MateriaMD();
                m.setId(rs.getInt("id_materia"));
                m.setNombre(rs.getString("materia_nombre"));
                c.setMateria(m);
                c.setNombre(rs.getString("curso_nombre"));
                c.setCiclo(rs.getInt("curso_ciclo"));
                ac.setCurso(c);
                cursos.add(ac);
            }
        }
        catch (SQLException e) {
            M.errorMsg("Error al consultar por periodo. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return cursos;
    }

    public ArrayList<AlumnoCursoMD> buscarClasesAlumnoCurso(String aguja) {
        String sql = "SELECT ac.id_almn_curso, almn_curso_estado, \nac.id_curso, materia_nombre, persona_identificacion, \npersona_primer_nombre, persona_primer_apellido, prd_lectivo_nombre\nFROM public.\"AlumnoCurso\" ac, public.\"Cursos\" c, \npublic.\"Materias\" m, public.\"Alumnos\" a, \npublic.\"Personas\" p, public.\"PeriodoLectivo\" pl \nWHERE c.id_curso = ac.id_curso AND \nm.id_materia = c.id_materia AND \na.id_alumno = ac.id_alumno AND \npl.id_prd_lectivo = c.id_prd_lectivo AND \np.id_persona = a.id_persona AND(\n\tpersona_identificacion ILIKE '%" + aguja + "%' OR \n\tpersona_primer_nombre || ' ' || persona_segundo_nombre \n\t|| ' ' || persona_primer_apellido || ' ' || persona_segundo_apellido \n\tILIKE '%" + aguja + "%'  \nOR persona_primer_nombre || ' ' || persona_primer_apellido ILIKE '%" + aguja + "%') \nAND prd_lectivo_estado = true;";
        return this.consultaParaTblRetirados(sql);
    }

    public ArrayList<AlumnoCursoMD> cargarClasesAlumnoCursoPorPrd(int idPrd) {
        String sql = "SELECT ac.id_almn_curso, almn_curso_estado, \nac.id_curso, materia_nombre, persona_identificacion, \npersona_primer_nombre, persona_primer_apellido, prd_lectivo_nombre \nFROM public.\"AlumnoCurso\" ac, public.\"Cursos\" c, \npublic.\"Materias\" m, public.\"Alumnos\" a, \npublic.\"Personas\" p, public.\"PeriodoLectivo\" pl\nWHERE c.id_curso = ac.id_curso AND \nm.id_materia = c.id_materia AND \na.id_alumno = ac.id_alumno AND \npl.id_prd_lectivo = c.id_prd_lectivo AND \np.id_persona = a.id_persona AND\nc.id_prd_lectivo = " + idPrd + " \nAND prd_lectivo_estado = true;";
        return this.consultaParaTblRetirados(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<AlumnoCursoMD> consultaParaTblRetirados(String sql) {
        ArrayList<AlumnoCursoMD> almns = new ArrayList<AlumnoCursoMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AlumnoCursoMD ac = new AlumnoCursoMD();
                CursoMD c = new CursoMD();
                c.setId(rs.getInt("id_curso"));
                ac.setId(rs.getInt("id_almn_curso"));
                ac.setEstado(rs.getString("almn_curso_estado"));
                AlumnoMD a = new AlumnoMD();
                a.setPrimerNombre(rs.getString("persona_primer_nombre"));
                a.setPrimerApellido(rs.getString("persona_primer_apellido"));
                a.setIdentificacion(rs.getString("persona_identificacion"));
                MateriaMD m = new MateriaMD();
                m.setNombre(rs.getString("materia_nombre"));
                PeriodoLectivoMD p = new PeriodoLectivoMD();
                p.setNombre(rs.getString("prd_lectivo_nombre"));
                c.setPeriodo(p);
                c.setMateria(m);
                ac.setAlumno(a);
                ac.setCurso(c);
                almns.add(ac);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No se pudieron consultar las clases de un alumno " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return almns;
    }

    public ArrayList<AlumnoCursoMD> cargarAlumnosCursosPorCursoTbl(String curso, int idPrd) {
        String sql = "SELECT DISTINCT c.curso_nombre,  \npersona_primer_nombre, persona_segundo_nombre, persona_primer_apellido, \npersona_segundo_apellido, persona_identificacion\nFROM public.\"AlumnoCurso\" ac, public.\"Alumnos\" a, public.\"Personas\" p, \npublic.\"Cursos\" c\nWHERE a.id_alumno = ac.id_alumno AND \np.id_persona = a.id_persona AND\nc.curso_nombre = '" + curso + "' AND\nc.id_prd_lectivo = " + idPrd + "  AND\nac.id_curso = c.id_curso ORDER BY persona_primer_apellido;";
        return this.consultarAlmnCursosParaTblSimple(sql);
    }

    public ArrayList<AlumnoCursoMD> cargarAlumnosCursosPorCicloTbl(int ciclo, int idPrd) {
        String sql = "SELECT DISTINCT c.curso_nombre,  \npersona_primer_nombre, persona_segundo_nombre, persona_primer_apellido, \npersona_segundo_apellido, persona_identificacion\nFROM public.\"AlumnoCurso\" ac, public.\"Alumnos\" a, public.\"Personas\" p, \npublic.\"Cursos\" c\nWHERE a.id_alumno = ac.id_alumno AND \np.id_persona = a.id_persona AND\nc.curso_ciclo = " + ciclo + " AND\nc.id_prd_lectivo = " + idPrd + "  AND\nac.id_curso = c.id_curso ORDER BY persona_primer_apellido;";
        return this.consultarAlmnCursosParaTblSimple(sql);
    }

    public ArrayList<AlumnoCursoMD> cargarAlumnosCursosPorPrdTbl(int idPrd) {
        String sql = "SELECT DISTINCT c.curso_nombre,  \npersona_primer_nombre, persona_segundo_nombre, persona_primer_apellido, \npersona_segundo_apellido, persona_identificacion\nFROM public.\"AlumnoCurso\" ac, public.\"Alumnos\" a, public.\"Personas\" p, \npublic.\"Cursos\" c\nWHERE a.id_alumno = ac.id_alumno AND \np.id_persona = a.id_persona AND\nc.id_prd_lectivo = " + idPrd + "  AND\nac.id_curso = c.id_curso ORDER BY persona_primer_apellido;";
        return this.consultarAlmnCursosParaTblSimple(sql);
    }

    public ArrayList<AlumnoCursoMD> cargarAlumnosCursosTbl() {
        String sql = "SELECT DISTINCT curso_nombre, \npersona_primer_nombre, persona_primer_apellido,\npersona_identificacion\nFROM public.\"AlumnoCurso\" ac , public.\"Alumnos\" a, \npublic.\"Cursos\" c, public.\"Personas\" p, public.\"Materias\" m, public.\"Carreras\" cr \nWHERE ac.id_alumno = a.id_alumno AND\np.id_persona = a.id_persona AND\nac.id_curso = c.id_curso AND \nm.id_materia = c.id_materia AND \ncr.id_carrera = m.id_carrera AND persona_activa = true \nAND alumno_activo = true AND carrera_activo = true;";
        return this.consultarAlmnCursosParaTblSimple(sql);
    }

    public ArrayList<AlumnoCursoMD> buscarAlumnosCursosTbl(String aguja) {
        String sql = "SELECT DISTINCT curso_nombre, \npersona_primer_nombre, persona_primer_apellido,\npersona_identificacion\nFROM public.\"AlumnoCurso\" ac , public.\"Alumnos\" a, \npublic.\"Cursos\" c, public.\"Personas\" p, public.\"Materias\" m, public.\"Carreras\" cr \nWHERE ac.id_alumno = a.id_alumno AND \nm.id_materia = c.id_materia AND \ncr.id_carrera = m.id_carrera AND\np.id_persona = a.id_persona AND\nac.id_curso = c.id_curso AND\n(curso_nombre ILIKE '%" + aguja + "%' OR \npersona_primer_nombre || ' ' || persona_primer_apellido ILIKE '%" + aguja + "%'\nOR persona_identificacion ILIKE '%" + aguja + "%') AND persona_activa = true AND alumno_activo = true AND carrera_activo = true;";
        return this.consultarAlmnCursosParaTblSimple(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<AlumnoCursoMD> consultarAlmnCursosParaTblSimple(String sql) {
        ArrayList<AlumnoCursoMD> almns = new ArrayList<AlumnoCursoMD>();
        PreparedStatement ps = CON.getPSPOOL(sql);
        try {
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AlumnoCursoMD a = new AlumnoCursoMD();
                CursoMD cu = new CursoMD();
                cu.setNombre(rs.getString("curso_nombre"));
                AlumnoMD al = new AlumnoMD();
                al.setPrimerNombre(rs.getString("persona_primer_nombre"));
                al.setPrimerApellido(rs.getString("persona_primer_apellido"));
                al.setIdentificacion(rs.getString("persona_identificacion"));
                a.setAlumno(al);
                a.setCurso(cu);
                almns.add(a);
            }
        }
        catch (SQLException e) {
            M.errorMsg("No consultamos alumno curso para tabla simple. " + e.getMessage());
        }
        finally {
            CON.cerrarCONPS(ps);
        }
        return almns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AlumnoCursoMD> selectWhere(String cursoNombre, String nombreMateria, int idDocente, int idPeriodo) {
        String SELECT = "SELECT\n\"AlumnoCurso\".id_alumno,\n\"AlumnoCurso\".almn_curso_asistencia,\n\"AlumnoCurso\".almn_curso_estado,\n\"AlumnoCurso\".almn_curso_num_faltas,\n\"AlumnoCurso\".almn_curso_activo,\n\"Personas\".persona_identificacion,\n\"Personas\".persona_primer_apellido,\n\"Personas\".persona_segundo_apellido,\n\"Personas\".persona_primer_nombre,\n\"Personas\".persona_segundo_nombre,\n\"AlumnoCurso\".almn_curso_nota_final,\n\"AlumnoCurso\".id_almn_curso,\n\"AlumnoCurso\".id_curso\nFROM\n\"AlumnoCurso\"\nINNER JOIN \"Cursos\" ON \"AlumnoCurso\".id_curso = \"Cursos\".id_curso\nINNER JOIN \"PeriodoLectivo\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\nINNER JOIN \"Jornadas\" ON \"Cursos\".id_jornada = \"Jornadas\".id_jornada\nINNER JOIN \"Materias\" ON \"Cursos\".id_materia = \"Materias\".id_materia\nINNER JOIN \"Alumnos\" ON \"AlumnoCurso\".id_alumno = \"Alumnos\".id_alumno\nINNER JOIN \"Personas\" ON \"Alumnos\".id_persona = \"Personas\".id_persona\nWHERE\n\"Cursos\".id_docente = ? AND\n\"PeriodoLectivo\".id_prd_lectivo = ? AND\n\"Cursos\".curso_nombre = ? AND\n\"Materias\".materia_nombre = ? AND\n\"AlumnoCurso\".almn_curso_activo IS TRUE\nORDER BY\n\"Personas\".persona_primer_apellido, \"Personas\".persona_segundo_apellido, \n\"Personas\".persona_primer_nombre, \"Personas\".persona_segundo_nombre ASC";
        ArrayList<AlumnoCursoMD> lista = new ArrayList<AlumnoCursoMD>();
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, idDocente);
        parametros.put(2, idPeriodo);
        parametros.put(3, cursoNombre);
        parametros.put(4, nombreMateria);
        try {
            this.conn = this.pool.getConnection();
            this.rst = this.pool.ejecutarQuery(SELECT, this.conn, parametros);
            NotasBD notasBD = new NotasBD();
            System.out.println(this.pool.getStmt().toString());
            while (this.rst.next()) {
                AlumnoCursoMD alumnoCurso = new AlumnoCursoMD();
                alumnoCurso.setId(this.rst.getInt("id_almn_curso"));
                alumnoCurso.setAsistencia(this.rst.getString("almn_curso_asistencia"));
                alumnoCurso.setEstado(this.rst.getString("almn_curso_estado"));
                alumnoCurso.setNumFalta(this.rst.getInt("almn_curso_num_faltas"));
                alumnoCurso.setNotaFinal(this.rst.getDouble("almn_curso_nota_final"));
                AlumnoMD alumno = new AlumnoMD();
                alumno.setId_Alumno(this.rst.getInt("id_alumno"));
                alumno.setIdentificacion(this.rst.getString("persona_identificacion"));
                alumno.setPrimerApellido(this.rst.getString("persona_primer_apellido"));
                alumno.setSegundoApellido(this.rst.getString("persona_segundo_apellido"));
                alumno.setPrimerNombre(this.rst.getString("persona_primer_nombre"));
                alumno.setSegundoNombre(this.rst.getString("persona_segundo_nombre"));
                CursoMD c = new CursoMD();
                c.setId(this.rst.getInt("id_curso"));
                alumnoCurso.setCurso(c);
                alumnoCurso.setAlumno(alumno);
                List<NotasBD> notas = notasBD.selectWhere(alumnoCurso);
                if (notas.isEmpty()) {
                    System.out.println("\nSIN NOTAS-->" + alumno.getPrimerNombre());
                    System.out.println("" + alumnoCurso.getId());
                }
                alumnoCurso.setNotas(notas);
                lista.add(alumnoCurso);
            }
        }
        catch (SQLException e) {
            M.errorMsg("Error al consultar notas. " + e.getMessage());
        }
        finally {
            this.pool.closeStmt().close(this.rst).close(this.conn);
        }
        return lista;
    }

    public boolean editar(AlumnoCursoMD ac) {
        String UPDATE = "UPDATE \"AlumnoCurso\" \nSET \nalmn_curso_nota_final = " + ac.getNotaFinal() + ", \nalmn_curso_estado = '" + ac.getEstado() + "',\nalmn_curso_asistencia = '" + ac.getAsistencia() + "',\nalmn_curso_num_faltas = " + ac.getNumFalta() + "\nWHERE \nid_almn_curso = " + ac.getId() + ";";
        this.conn = this.pool.getConnection();
        return this.pool.ejecutar(UPDATE, this.conn, null) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AlumnoCursoMD> selectParaAsistencia(String cursoNombre, String nombreMateria, int idDocente, int idPeriodo, String fecha) {
        String SELECT = "SELECT\n\"AlumnoCurso\".id_alumno,\n\"AlumnoCurso\".almn_curso_asistencia,\n\"AlumnoCurso\".almn_curso_estado,\n\"AlumnoCurso\".almn_curso_num_faltas,\n\"AlumnoCurso\".almn_curso_activo,\n\"Personas\".persona_identificacion,\n\"Personas\".persona_primer_apellido,\n\"Personas\".persona_segundo_apellido,\n\"Personas\".persona_primer_nombre,\n\"Personas\".persona_segundo_nombre,\n\"AlumnoCurso\".almn_curso_nota_final,\n\"AlumnoCurso\".id_almn_curso,\n\"AlumnoCurso\".id_curso, \n(SELECT SUM(public.\"Asistencia\".numero_faltas) FROM public.\"Asistencia\"   WHERE public.\"Asistencia\".id_almn_curso = public.\"AlumnoCurso\".id_almn_curso AND fecha_asistencia = '" + fecha + "')FROM\n\"AlumnoCurso\"\nINNER JOIN \"Cursos\" ON \"AlumnoCurso\".id_curso = \"Cursos\".id_curso\nINNER JOIN \"PeriodoLectivo\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\nINNER JOIN \"Jornadas\" ON \"Cursos\".id_jornada = \"Jornadas\".id_jornada\nINNER JOIN \"Materias\" ON \"Cursos\".id_materia = \"Materias\".id_materia\nINNER JOIN \"Alumnos\" ON \"AlumnoCurso\".id_alumno = \"Alumnos\".id_alumno\nINNER JOIN \"Personas\" ON \"Alumnos\".id_persona = \"Personas\".id_persona\nWHERE\n\"Cursos\".id_docente = ? AND\n\"PeriodoLectivo\".id_prd_lectivo = ? AND\n\"Cursos\".curso_nombre = ? AND\n\"Materias\".materia_nombre = ? AND \n\"AlumnoCurso\".almn_curso_activo = TRUE \nORDER BY\n\"Personas\".persona_primer_apellido, \"Personas\".persona_segundo_apellido ASC";
        ArrayList<AlumnoCursoMD> lista = new ArrayList<AlumnoCursoMD>();
        HashMap<Integer, Object> parametros = new HashMap<Integer, Object>();
        parametros.put(1, idDocente);
        parametros.put(2, idPeriodo);
        parametros.put(3, cursoNombre);
        parametros.put(4, nombreMateria);
        try {
            this.conn = this.pool.getConnection();
            this.rst = this.pool.ejecutarQuery(SELECT, this.conn, parametros);
            NotasBD notasBD = new NotasBD();
            while (this.rst.next()) {
                AlumnoCursoMD alumnoCurso = new AlumnoCursoMD();
                alumnoCurso.setId(this.rst.getInt("id_almn_curso"));
                alumnoCurso.setAsistencia(this.rst.getString("almn_curso_asistencia"));
                alumnoCurso.setEstado(this.rst.getString("almn_curso_estado"));
                alumnoCurso.setNumFalta(this.rst.getInt("almn_curso_num_faltas"));
                alumnoCurso.setNotaFinal(this.rst.getDouble("almn_curso_nota_final"));
                AlumnoMD alumno = new AlumnoMD();
                alumno.setId_Alumno(this.rst.getInt("id_alumno"));
                alumno.setIdentificacion(this.rst.getString("persona_identificacion"));
                alumno.setPrimerApellido(this.rst.getString("persona_primer_apellido"));
                alumno.setSegundoApellido(this.rst.getString("persona_segundo_apellido"));
                alumno.setPrimerNombre(this.rst.getString("persona_primer_nombre"));
                alumno.setSegundoNombre(this.rst.getString("persona_segundo_nombre"));
                CursoMD c = new CursoMD();
                c.setId(this.rst.getInt("id_curso"));
                alumnoCurso.setCurso(c);
                alumnoCurso.setAlumno(alumno);
                alumnoCurso.setFaltas(this.rst.getInt(14));
                List<NotasBD> notas = notasBD.selectWhere(alumnoCurso);
                alumnoCurso.setNotas(notas);
                lista.add(alumnoCurso);
            }
        }
        catch (SQLException e) {
            M.errorMsg("Error al consultar para asistencia. " + e.getMessage());
        }
        finally {
            this.pool.closeStmt().close(this.rst).close(this.conn);
        }
        return lista;
    }
}

