/*
 * Decompiled with CFR 0.152.
 */
package modelo.PlanClases;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import modelo.EstrategiasMetodologicas.EstrategiasMetodologicasMD;
import modelo.PlanClases.PlandeClasesMD;
import modelo.PlanClases.RecursosMD;
import modelo.carrera.CarreraMD;
import modelo.curso.CursoMD;
import modelo.materia.MateriaMD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.DocenteMD;
import modelo.silabo.NEWUnidadSilaboBD;
import modelo.unidadSilabo.UnidadSilaboMD;
import utils.CONBD;

public class PlandeClasesBD
extends CONBD {
    private static PlandeClasesBD INSTANCE = null;

    public static PlandeClasesBD single() {
        if (INSTANCE == null) {
            INSTANCE = new PlandeClasesBD();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertarPlanClases(PlandeClasesMD pl) {
        String SELECT = "INSERT INTO public.\"PlandeClases\"(\n\t id_curso, id_unidad, observaciones,\n\t fecha_revision, fecha_generacion, fecha_cierre,trabajo_autonomo)\n\tVALUES (?, ?, ?, ?, ?, ?,?)";
        PreparedStatement stmt = CON.prepareStatement(SELECT);
        try {
            stmt.setInt(1, pl.getCurso().getId());
            stmt.setInt(2, pl.getUnidad().getID());
            stmt.setString(3, pl.getObservaciones());
            stmt.setDate(4, null);
            stmt.setDate(5, Date.valueOf(LocalDate.now()));
            stmt.setDate(6, null);
            stmt.setString(7, pl.getTrabajoAutonomo());
            stmt.executeUpdate();
        }
        catch (SQLException sQLException) {
        }
        finally {
            CON.close(stmt);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean editarFechageneracoion(int idpla, LocalDate fecha) {
        String SELECT = "UPDATE public.\"PlandeClases\"\n\tSET fecha_generacion=?\n\tWHERE id_plan_clases=?";
        PreparedStatement stmt = CON.prepareStatement(SELECT);
        try {
            stmt.setDate(1, Date.valueOf(fecha));
            stmt.setInt(2, idpla);
            stmt.executeUpdate();
        }
        catch (SQLException sQLException) {
        }
        finally {
            CON.close(stmt);
        }
        return true;
    }

    public static void eliminarPlanClase(int idPlan) {
        String DELETE = "delete from \"PlandeClases\" where id_plan_clases=" + idPlan;
        CON.ejecutar(DELETE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CursoMD> cursosSinPlanes(int idPlanClasesRef) {
        String SELECT = "WITH mi_info AS (\n\tSELECT\n\t\t\"Cursos\".id_prd_lectivo,\n\t\t\"Cursos\".id_docente,\n\t\t\"Cursos\".id_materia,\n\t\t\"PlandeClases\".id_unidad\n\tFROM\n\t\t\"PlandeClases\"\n\t\tINNER JOIN \"Cursos\" ON \"Cursos\".id_curso = \"PlandeClases\".id_curso \n\tWHERE\n\t\t\"PlandeClases\".id_plan_clases = " + idPlanClasesRef + " \n             AND \"Cursos\".curso_activo IS TRUE\t),\n\tmis_planes AS (\n\tSELECT\n\t\t\"Cursos\".id_prd_lectivo,\n\t\t\"Cursos\".id_docente,\n\t\t\"Cursos\".id_materia,\n\t\t\"Cursos\".curso_nombre,\n\t\t\"Cursos\".id_curso,\n\t\t\"PlandeClases\".id_unidad\n\tFROM\n\t\t\"PlandeClases\"\n\t\tINNER JOIN mi_info ON mi_info.id_unidad = \"PlandeClases\".id_unidad\n\t\tINNER JOIN \"Cursos\" ON \"Cursos\".id_materia = mi_info.id_materia \n\t\tAND \"Cursos\".id_prd_lectivo = mi_info.id_prd_lectivo\n\t\tAND \"Cursos\".id_docente = mi_info.id_docente\n\t\tAND \"Cursos\".id_curso = \"PlandeClases\".id_curso\n\t),\n\tmis_cursos AS (\n\tSELECT\n\t\t\"Cursos\".id_prd_lectivo,\n\t\t\"Cursos\".id_docente,\n\t\t\"Cursos\".id_materia,\n\t\t\"Cursos\".curso_nombre,\n\t\t\"Cursos\".id_curso, \n\t\t\"Cursos\".curso_activo \n\tFROM\n\t\t\"Cursos\"\n\t\tINNER JOIN mi_info ON mi_info.id_prd_lectivo = \"Cursos\".id_prd_lectivo \n\t\tAND mi_info.id_materia = \"Cursos\".id_materia \n\t\tAND mi_info.id_docente = \"Cursos\".id_docente\n\t)\n\tSELECT\n             mis_cursos.id_curso,\n             mis_cursos.curso_nombre\n\tFROM\n\t\tmis_cursos \n\tWHERE\n\t\tmis_cursos.id_curso NOT IN ( SELECT id_curso FROM mis_planes )             AND mis_cursos.curso_activo IS TRUE";
        ArrayList<CursoMD> lista = new ArrayList<CursoMD>();
        ResultSet rs = CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                CursoMD curso = new CursoMD();
                curso.setId(rs.getInt("id_curso"));
                curso.setNombre(rs.getString("curso_nombre"));
                lista.add(curso);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PlandeClasesBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return lista;
    }

    public boolean copiarPlabes(int idPlanRef, int idCursoCopiar) {
        String CALL = "CALL \"copiar_plan_de_clases\"(" + idPlanRef + " ," + idCursoCopiar + ")";
        return CON.ejecutar(CALL) != null;
    }

    public static void editarEstado(int id_plan, int estado) {
        String UPDATE = "UPDATE \"PlandeClases\" \nSET estado_plan = " + estado + " \nWHERE\n\tid_plan_clases = " + id_plan;
        CON.ejecutar(UPDATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PlandeClasesMD getPlanBy(int id) {
        String SELECT = "SELECT\n\t\"PlandeClases\".id_plan_clases,\n\t\"PlandeClases\".id_curso,\n\t\"PlandeClases\".id_unidad,\n\t\"PlandeClases\".observaciones,\n\t\"PlandeClases\".fecha_generacion,\n\t\"PlandeClases\".trabajo_autonomo,\n\t\"PlandeClases\".estado_plan,\n\t\"PlandeClases\".fecha_revision,\n\t\"Cursos\".curso_nombre,\n\t\"Personas\".persona_identificacion,\n\t\"Personas\".persona_primer_apellido,\n\t\"Personas\".persona_segundo_apellido,\n\t\"Personas\".persona_primer_nombre,\n\t\"Personas\".persona_segundo_nombre,\n\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\"PeriodoLectivo\".id_prd_lectivo,\n\t\"PeriodoLectivo\".prd_lectivo_estado,\n\t\"PeriodoLectivo\".prd_lectivo_activo,\n\t\"Carreras\".carrera_nombre,\n\t\"Carreras\".id_carrera,\n\t\"Materias\".materia_codigo,\n\t\"Materias\".materia_nombre,\n\t\"Materias\".id_materia,\n\t\"UnidadSilabo\".id_unidad,\n\t\"UnidadSilabo\".id_silabo,\n\t\"UnidadSilabo\".numero_unidad,\n\t\"UnidadSilabo\".objetivo_especifico_unidad,\n\t\"UnidadSilabo\".resultados_aprendizaje_unidad,\n\t\"UnidadSilabo\".contenidos_unidad,\n\t\"UnidadSilabo\".fecha_inicio_unidad,\n\t\"UnidadSilabo\".fecha_fin_unidad,\n\t\"UnidadSilabo\".horas_docencia_unidad,\n\t\"UnidadSilabo\".horas_practica_unidad,\n\t\"UnidadSilabo\".horas_autonomo_unidad,\n\t\"UnidadSilabo\".titulo_unidad \nFROM\n\t\"PlandeClases\"\n\tINNER JOIN \"Cursos\" ON \"PlandeClases\".id_curso = \"Cursos\".id_curso\n\tINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente\n\tINNER JOIN \"Personas\" ON \"Docentes\".id_persona = \"Personas\".id_persona\n\tINNER JOIN \"PeriodoLectivo\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\tINNER JOIN \"Carreras\" ON \"PeriodoLectivo\".id_carrera = \"Carreras\".id_carrera\n\tINNER JOIN \"Materias\" ON \"Cursos\".id_materia = \"Materias\".id_materia\n\tINNER JOIN \"UnidadSilabo\" ON \"PlandeClases\".id_unidad = \"UnidadSilabo\".id_unidad\nWHERE\n\"PlandeClases\".id_plan_clases = " + id + "";
        ResultSet rs = CON.ejecutarQuery(SELECT);
        PlandeClasesMD plandeClasesMD = new PlandeClasesMD();
        try {
            while (rs.next()) {
                DocenteMD docenteMD = new DocenteMD();
                docenteMD.setIdentificacion(rs.getString("persona_identificacion"));
                docenteMD.setPrimerNombre(rs.getString("persona_primer_nombre"));
                docenteMD.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                docenteMD.setPrimerApellido(rs.getString("persona_primer_apellido"));
                docenteMD.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                CarreraMD carreraMD = new CarreraMD();
                carreraMD.setId(rs.getInt("id_carrera"));
                carreraMD.setNombre(rs.getString("carrera_nombre"));
                PeriodoLectivoMD periodoLectivoMD = new PeriodoLectivoMD();
                periodoLectivoMD.setID(rs.getInt("id_prd_lectivo"));
                periodoLectivoMD.setNombre(rs.getString("prd_lectivo_nombre"));
                periodoLectivoMD.setEstado(rs.getBoolean("prd_lectivo_estado"));
                periodoLectivoMD.setActivo(rs.getBoolean("prd_lectivo_activo"));
                periodoLectivoMD.setCarrera(carreraMD);
                MateriaMD materiaMD = new MateriaMD();
                materiaMD.setId(rs.getInt("id_materia"));
                materiaMD.setNombre(rs.getString("materia_nombre"));
                materiaMD.setCodigo(rs.getString("materia_codigo"));
                CursoMD cursoMD = new CursoMD();
                cursoMD.setId(rs.getInt("id_curso"));
                cursoMD.setNombre(rs.getString("curso_nombre"));
                cursoMD.setMateria(materiaMD);
                cursoMD.setDocente(docenteMD);
                cursoMD.setPeriodo(periodoLectivoMD);
                UnidadSilaboMD unidadSilaboMD = new UnidadSilaboMD();
                unidadSilaboMD.setId(rs.getInt("id_unidad"));
                unidadSilaboMD.setNumeroUnidad(rs.getInt("numero_unidad"));
                unidadSilaboMD.setObjetivoEspecificoUnidad(rs.getString("objetivo_especifico_unidad"));
                unidadSilaboMD.setResultadosAprendizajeUnidad(rs.getString("resultados_aprendizaje_unidad"));
                unidadSilaboMD.setContenidosUnidad(rs.getString("contenidos_unidad"));
                unidadSilaboMD.setFechaInicioUnidad(rs.getDate("fecha_inicio_unidad").toLocalDate());
                unidadSilaboMD.setFechaFinUnidad(rs.getDate("fecha_fin_unidad").toLocalDate());
                unidadSilaboMD.setHorasDocenciaUnidad(rs.getDouble("horas_docencia_unidad"));
                unidadSilaboMD.setHorasPracticaUnidad(rs.getDouble("horas_practica_unidad"));
                unidadSilaboMD.setHorasAutonomoUnidad(rs.getDouble("horas_autonomo_unidad"));
                unidadSilaboMD.setTituloUnidad(rs.getString("titulo_unidad"));
                unidadSilaboMD.setEstrategias(NEWUnidadSilaboBD.getEstrategiasUnidad(rs.getInt("id_unidad")));
                plandeClasesMD = new PlandeClasesMD();
                plandeClasesMD.setID(rs.getInt("id_plan_clases"));
                plandeClasesMD.setObservaciones(rs.getString("observaciones"));
                plandeClasesMD.setTrabajoAutonomo(rs.getString("trabajo_autonomo"));
                plandeClasesMD.setEstado(rs.getInt("estado_plan"));
                plandeClasesMD.setFechaGeneracion(rs.getDate("fecha_generacion").toLocalDate());
                plandeClasesMD.setRecursos(PlandeClasesBD.getRecursosPlan(id));
                plandeClasesMD.setEstrategias(PlandeClasesBD.getEstrategiasPlan(id));
                plandeClasesMD.setCurso(cursoMD);
                plandeClasesMD.setUnidad(unidadSilaboMD);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PlandeClasesBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return plandeClasesMD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PlandeClasesMD> getPlanesCoordinadorBy(String cedulaDocente, String periodo, String jornada) {
        String SELECT = "SELECT\n\t\"Docentes\".id_docente,\n\t\"Personas\".id_persona,\n\t\"Personas\".persona_identificacion,\n\t\"Personas\".persona_primer_apellido,\n\t\"Personas\".persona_segundo_apellido,\n\t\"Personas\".persona_primer_nombre,\n\t\"Personas\".persona_segundo_nombre,\n\t\"PeriodoLectivo\".id_prd_lectivo,\n\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\"UnidadSilabo\".id_unidad,\n\t\"UnidadSilabo\".numero_unidad,\n\t\"PlandeClases\".id_plan_clases,\n\t\"PlandeClases\".fecha_generacion,\n\t\"PlandeClases\".estado_plan,\n\t\"Cursos\".id_curso,\n\t\"Cursos\".curso_nombre,\n\t\"Materias\".id_materia,\n\t\"Materias\".materia_nombre \nFROM\n\t\"PlandeClases\"\n\tINNER JOIN \"Cursos\" ON \"PlandeClases\".id_curso = \"Cursos\".id_curso\n\tINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente\n\tINNER JOIN \"Personas\" ON \"Docentes\".id_persona = \"Personas\".id_persona\n\tINNER JOIN \"PeriodoLectivo\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\tINNER JOIN \"Materias\" ON \"Cursos\".id_materia = \"Materias\".id_materia\n\tINNER JOIN \"UnidadSilabo\" ON \"PlandeClases\".id_unidad = \"UnidadSilabo\".id_unidad\n\tINNER JOIN \"Jornadas\" ON \"Cursos\".id_jornada = \"Jornadas\".id_jornada \nWHERE\n\t\"PeriodoLectivo\".prd_lectivo_nombre = '" + periodo + "' \n     AND \"Jornadas\".nombre_jornada = '" + jornada + "'\nORDER BY persona_primer_apellido, materia_nombre, \"Cursos\".curso_nombre, numero_unidad";
        ArrayList<PlandeClasesMD> lista = new ArrayList<PlandeClasesMD>();
        ResultSet rs = CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                DocenteMD docente = new DocenteMD();
                docente.setIdDocente(rs.getInt("id_docente"));
                docente.setIdentificacion(rs.getString("persona_identificacion"));
                docente.setPrimerNombre(rs.getString("persona_primer_nombre"));
                docente.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                docente.setPrimerApellido(rs.getString("persona_primer_apellido"));
                docente.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                PeriodoLectivoMD periodoLectivo = new PeriodoLectivoMD();
                periodoLectivo.setID(rs.getInt("id_prd_lectivo"));
                periodoLectivo.setNombre(rs.getString("prd_lectivo_nombre"));
                MateriaMD materiaMD = new MateriaMD();
                materiaMD.setId(rs.getInt("id_materia"));
                materiaMD.setNombre(rs.getString("materia_nombre"));
                CursoMD curso = new CursoMD();
                curso.setId(rs.getInt("id_curso"));
                curso.setPeriodo(periodoLectivo);
                curso.setDocente(docente);
                curso.setMateria(materiaMD);
                curso.setNombre(rs.getString("curso_nombre"));
                UnidadSilaboMD unidadSilaboMD = new UnidadSilaboMD();
                unidadSilaboMD.setId(rs.getInt("id_unidad"));
                unidadSilaboMD.setNumeroUnidad(rs.getInt("numero_unidad"));
                PlandeClasesMD plandeClasesMD = new PlandeClasesMD();
                plandeClasesMD.setID(rs.getInt("id_plan_clases"));
                plandeClasesMD.setEstado(rs.getInt("estado_plan"));
                plandeClasesMD.setCurso(curso);
                plandeClasesMD.setUnidad(unidadSilaboMD);
                plandeClasesMD.setFechaGeneracion(rs.getDate("fecha_generacion").toLocalDate());
                lista.add(plandeClasesMD);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PlandeClasesBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PlandeClasesMD> getPlanesSuperSu(String periodo, String jornada) {
        String SELECT = "SELECT\n\t\"Docentes\".id_docente,\n\t\"Personas\".id_persona,\n\t\"Personas\".persona_identificacion,\n\t\"Personas\".persona_primer_apellido,\n\t\"Personas\".persona_segundo_apellido,\n\t\"Personas\".persona_primer_nombre,\n\t\"Personas\".persona_segundo_nombre,\n\t\"PeriodoLectivo\".id_prd_lectivo,\n\t\"PeriodoLectivo\".prd_lectivo_nombre,\n\t\"UnidadSilabo\".id_unidad,\n\t\"UnidadSilabo\".numero_unidad,\n\t\"PlandeClases\".id_plan_clases,\n\t\"PlandeClases\".fecha_generacion,\n\t\"PlandeClases\".estado_plan,\n\t\"Cursos\".id_curso,\n\t\"Cursos\".curso_nombre,\n\t\"Materias\".id_materia,\n\t\"Materias\".materia_nombre \nFROM\n\t\"PlandeClases\"\n\tINNER JOIN \"Cursos\" ON \"PlandeClases\".id_curso = \"Cursos\".id_curso\n\tINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente\n\tINNER JOIN \"Personas\" ON \"Docentes\".id_persona = \"Personas\".id_persona\n\tINNER JOIN \"PeriodoLectivo\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\tINNER JOIN \"Materias\" ON \"Cursos\".id_materia = \"Materias\".id_materia\n\tINNER JOIN \"UnidadSilabo\" ON \"PlandeClases\".id_unidad = \"UnidadSilabo\".id_unidad\n\tINNER JOIN \"Jornadas\" ON \"Cursos\".id_jornada = \"Jornadas\".id_jornada\nWHERE\n\t\"PeriodoLectivo\".prd_lectivo_nombre = '" + periodo + "' \n     AND \"Jornadas\".nombre_jornada = '" + jornada + "'\nORDER BY persona_primer_apellido, materia_nombre, numero_unidad";
        ArrayList<PlandeClasesMD> lista = new ArrayList<PlandeClasesMD>();
        ResultSet rs = CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                DocenteMD docente = new DocenteMD();
                docente.setIdDocente(rs.getInt("id_docente"));
                docente.setIdentificacion(rs.getString("persona_identificacion"));
                docente.setPrimerNombre(rs.getString("persona_primer_nombre"));
                docente.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                docente.setPrimerApellido(rs.getString("persona_primer_apellido"));
                docente.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                PeriodoLectivoMD periodoLectivo = new PeriodoLectivoMD();
                periodoLectivo.setID(rs.getInt("id_prd_lectivo"));
                periodoLectivo.setNombre(rs.getString("prd_lectivo_nombre"));
                MateriaMD materiaMD = new MateriaMD();
                materiaMD.setId(rs.getInt("id_materia"));
                materiaMD.setNombre(rs.getString("materia_nombre"));
                CursoMD curso = new CursoMD();
                curso.setId(rs.getInt("id_curso"));
                curso.setPeriodo(periodoLectivo);
                curso.setDocente(docente);
                curso.setMateria(materiaMD);
                curso.setNombre(rs.getString("curso_nombre"));
                UnidadSilaboMD unidadSilaboMD = new UnidadSilaboMD();
                unidadSilaboMD.setId(rs.getInt("id_unidad"));
                unidadSilaboMD.setNumeroUnidad(rs.getInt("numero_unidad"));
                PlandeClasesMD plandeClasesMD = new PlandeClasesMD();
                plandeClasesMD.setID(rs.getInt("id_plan_clases"));
                plandeClasesMD.setEstado(rs.getInt("estado_plan"));
                plandeClasesMD.setCurso(curso);
                plandeClasesMD.setUnidad(unidadSilaboMD);
                plandeClasesMD.setFechaGeneracion(rs.getDate("fecha_generacion").toLocalDate());
                lista.add(plandeClasesMD);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PlandeClasesBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PlandeClasesMD> getPlanesBy(String cedulaDocente, String periodo, String jornada) {
        String SELECT = "SELECT\n     \"Docentes\".id_docente,\n     \"Personas\".id_persona,\n     \"Personas\".persona_identificacion,\n     \"Personas\".persona_primer_apellido,\n     \"Personas\".persona_segundo_apellido,\n     \"Personas\".persona_primer_nombre,\n     \"Personas\".persona_segundo_nombre,\n     \"PeriodoLectivo\".id_prd_lectivo,\n     \"PeriodoLectivo\".prd_lectivo_nombre,\n     \"UnidadSilabo\".id_unidad,\n     \"UnidadSilabo\".numero_unidad,\n     \"PlandeClases\".id_plan_clases,\n     \"PlandeClases\".fecha_generacion,\n\t\"PlandeClases\".estado_plan,\n     \"Cursos\".id_curso,\n     \"Cursos\".curso_nombre,\n     \"Materias\".id_materia,\n     \"Materias\".materia_nombre\nFROM\n\t\"PlandeClases\"\n\tINNER JOIN \"Cursos\" ON \"PlandeClases\".id_curso = \"Cursos\".id_curso\n\tINNER JOIN \"Docentes\" ON \"Cursos\".id_docente = \"Docentes\".id_docente\n\tINNER JOIN \"Personas\" ON \"Docentes\".id_persona = \"Personas\".id_persona\n\tINNER JOIN \"PeriodoLectivo\" ON \"Cursos\".id_prd_lectivo = \"PeriodoLectivo\".id_prd_lectivo\n\tINNER JOIN \"Materias\" ON \"Cursos\".id_materia = \"Materias\".id_materia\n\tINNER JOIN \"UnidadSilabo\" ON \"PlandeClases\".id_unidad = \"UnidadSilabo\".id_unidad \n     INNER JOIN \"Jornadas\" ON \"Cursos\".id_jornada = \"Jornadas\".id_jornada\nWHERE\n\t\"PeriodoLectivo\".prd_lectivo_nombre = '" + periodo + "' \n\tAND \"Docentes\".docente_codigo = '" + cedulaDocente + "' \n     AND \"Jornadas\".nombre_jornada = '" + jornada + "'\nORDER BY persona_primer_apellido, materia_nombre, numero_unidad";
        ArrayList<PlandeClasesMD> lista = new ArrayList<PlandeClasesMD>();
        ResultSet rs = CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                DocenteMD docente = new DocenteMD();
                docente.setIdDocente(rs.getInt("id_docente"));
                docente.setIdentificacion(rs.getString("persona_identificacion"));
                docente.setPrimerNombre(rs.getString("persona_primer_nombre"));
                docente.setSegundoNombre(rs.getString("persona_segundo_nombre"));
                docente.setPrimerApellido(rs.getString("persona_primer_apellido"));
                docente.setSegundoApellido(rs.getString("persona_segundo_apellido"));
                PeriodoLectivoMD periodoLectivo = new PeriodoLectivoMD();
                periodoLectivo.setID(rs.getInt("id_prd_lectivo"));
                periodoLectivo.setNombre(rs.getString("prd_lectivo_nombre"));
                MateriaMD materiaMD = new MateriaMD();
                materiaMD.setId(rs.getInt("id_materia"));
                materiaMD.setNombre(rs.getString("materia_nombre"));
                CursoMD curso = new CursoMD();
                curso.setId(rs.getInt("id_curso"));
                curso.setPeriodo(periodoLectivo);
                curso.setDocente(docente);
                curso.setMateria(materiaMD);
                curso.setNombre(rs.getString("curso_nombre"));
                UnidadSilaboMD unidadSilaboMD = new UnidadSilaboMD();
                unidadSilaboMD.setId(rs.getInt("id_unidad"));
                unidadSilaboMD.setNumeroUnidad(rs.getInt("numero_unidad"));
                PlandeClasesMD plandeClasesMD = new PlandeClasesMD();
                plandeClasesMD.setID(rs.getInt("id_plan_clases"));
                plandeClasesMD.setEstado(rs.getInt("estado_plan"));
                plandeClasesMD.setCurso(curso);
                plandeClasesMD.setUnidad(unidadSilaboMD);
                plandeClasesMD.setFechaGeneracion(rs.getDate("fecha_generacion").toLocalDate());
                lista.add(plandeClasesMD);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PlandeClasesBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return lista;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean crear(PlandeClasesMD plan) {
        if (plan.getObservaciones() == null) {
            plan.setObservaciones("");
        }
        if (plan.getTrabajoAutonomo() == null) {
            plan.setTrabajoAutonomo("");
        }
        String INSERT = "INSERT INTO \"PlandeClases\"\n    (id_curso, id_unidad, observaciones, trabajo_autonomo, estado_plan) \nVALUES(\n    " + plan.getCurso().getId() + ",\n    " + plan.getUnidad().getID() + ",\n    '" + plan.getObservaciones() + "',\n    '" + plan.getTrabajoAutonomo() + "',\n    0\n)RETURNING id_plan_clases";
        ResultSet rs = CON.ejecutarQuery(INSERT);
        try {
            while (rs.next()) {
                plan.setID(rs.getInt("id_plan_clases"));
                PlandeClasesBD.insertarRecursos(plan.getRecursos(), plan.getID());
                PlandeClasesBD.insertartEstrategias(plan.getEstrategias(), plan.getID());
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PlandeClasesBD.class.getName()).log(Level.SEVERE, null, ex);
            boolean bl = false;
            return bl;
        }
        finally {
            CON.close(rs);
        }
        return true;
    }

    public static boolean editar(PlandeClasesMD plan) {
        if (plan.getObservaciones() == null) {
            plan.setObservaciones("");
        }
        if (plan.getTrabajoAutonomo() == null) {
            plan.setTrabajoAutonomo("");
        }
        String UPDATE = "UPDATE \"PlandeClases\" \nSET trabajo_autonomo = '" + plan.getTrabajoAutonomo() + "',\nobservaciones = '" + plan.getObservaciones() + "' \nWHERE\n\t\"PlandeClases\".id_plan_clases = " + plan.getID() + "";
        CON.ejecutar(UPDATE);
        PlandeClasesBD.eliminarRecursos(plan.getID());
        PlandeClasesBD.eliminarEstrategias(plan.getID());
        PlandeClasesBD.insertarRecursos(plan.getRecursos(), plan.getID());
        PlandeClasesBD.insertartEstrategias(plan.getEstrategias(), plan.getID());
        return true;
    }

    private static boolean eliminarRecursos(int idPlan) {
        String DELETE = "DELETE FROM \"RecursosPlanClases\" WHERE \"RecursosPlanClases\".id_plan_clases = " + idPlan + "";
        return CON.ejecutar(DELETE) == null;
    }

    private static boolean eliminarEstrategias(int idPlan) {
        String DELETE = "DELETE FROM \"EstrategiasMetodologias\" WHERE \"EstrategiasMetodologias\".id_plan_de_clases = " + idPlan + "";
        return CON.ejecutar(DELETE) == null;
    }

    private static void insertarRecursos(List<RecursosMD> recursos, int idPlan) {
        recursos.forEach(obj -> CON.ejecutar(String.format("INSERT INTO \"RecursosPlanClases\"\n     (id_plan_clases, id_recurso) \nVALUES(%s, %s )", idPlan, obj.getId_recurso())));
    }

    private static void insertartEstrategias(List<EstrategiasMetodologicasMD> estrategias, int idPlan) {
        estrategias.forEach(obj -> CON.ejecutar(String.format("INSERT INTO \"EstrategiasMetodologias\"\n     (nombre_estrategia,tipo_estrategias_metodologias, id_plan_de_clases) \nVALUES('%s', '%s', %s)", obj.getNombre_estrategia(), obj.getTipo_estrategias_metodologicas(), idPlan)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RecursosMD> getRecursosPlan(int idPlan) {
        String SELECT = "SELECT\n\t\"Recursos\".id_recurso,\n\t\"Recursos\".nombre_recursos,\n\t\"Recursos\".tipo_recurso\nFROM\n\t\"Recursos\"\n\tINNER JOIN \"RecursosPlanClases\" ON \"RecursosPlanClases\".id_recurso = \"Recursos\".id_recurso \nWHERE\n\tid_plan_clases = " + idPlan + "";
        ArrayList<RecursosMD> recursos = new ArrayList<RecursosMD>();
        ResultSet rs = CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                RecursosMD recursosMD = new RecursosMD();
                recursosMD.setId_recurso(rs.getInt("id_recurso"));
                recursosMD.setNombre_recursos(rs.getString("nombre_recursos"));
                recursosMD.setTipo_recurso(rs.getString("tipo_recurso"));
                recursos.add(recursosMD);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PlandeClasesBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return recursos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<EstrategiasMetodologicasMD> getEstrategiasPlan(int idPlan) {
        String SELECT = "SELECT\n\t\"EstrategiasMetodologias\".id_estrategias_metodologias,\n\t\"EstrategiasMetodologias\".tipo_estrategias_metodologias,\n\t\"EstrategiasMetodologias\".nombre_estrategia \nFROM\n\t\"EstrategiasMetodologias\" \nWHERE\n\t\"EstrategiasMetodologias\".id_plan_de_clases =" + idPlan + "";
        ArrayList<EstrategiasMetodologicasMD> estrategias = new ArrayList<EstrategiasMetodologicasMD>();
        ResultSet rs = CON.ejecutarQuery(SELECT);
        try {
            while (rs.next()) {
                EstrategiasMetodologicasMD metodologicasMD = new EstrategiasMetodologicasMD();
                metodologicasMD.setId_estrategias_metodologicas(rs.getInt("id_estrategias_metodologias"));
                metodologicasMD.setTipo_estrategias_metodologicas(rs.getString("tipo_estrategias_metodologias"));
                metodologicasMD.setNombre_estrategia(rs.getString("nombre_estrategia"));
                estrategias.add(metodologicasMD);
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(PlandeClasesBD.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            CON.close(rs);
        }
        return estrategias;
    }
}

