/*
 * Decompiled with CFR 0.152.
 */
package modelo;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.pool.HikariPool;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.view.JasperViewer;
import utils.CONS;
import utils.M;

public class ConnDBPool {
    private static HikariConfig config;
    private static HikariDataSource ds;
    private PreparedStatement stmt;
    private ResultSet rs;
    private static ConnDBPool CONPOOL;

    public static void IniciarConexion() {
        try {
            config = new HikariConfig();
            config.setJdbcUrl(CONS.BD_URL);
            config.setUsername(CONS.getBDUser());
            config.setPassword(CONS.BD_PASS);
            config.setMaximumPoolSize(10);
            config.addDataSourceProperty("cachePrepStmts", (Object)"true");
            config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
            config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
            config.addDataSourceProperty("allowMultiQueries", (Object)"true");
            config.addDataSourceProperty("useServerPrepStmts", (Object)"true");
            ds = new HikariDataSource(config);
        }
        catch (HikariPool.PoolInitializationException e) {
            System.out.println(e.getMessage());
        }
    }

    public static ConnDBPool single() {
        if (CONPOOL == null) {
            CONPOOL = new ConnDBPool();
        }
        return CONPOOL;
    }

    public Connection getConnection() {
        try {
            return ds.getConnection();
        }
        catch (SQLException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLException ejecutar(String sql, Connection conn, Map<Integer, Object> parametros) {
        try {
            this.stmt = parametros == null ? conn.prepareStatement(sql) : this.prepararStatement(sql, conn, parametros);
            this.stmt.executeUpdate();
            SQLException sQLException = null;
            return sQLException;
        }
        catch (SQLException e) {
            Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, e);
            this.close(conn);
            SQLException sQLException = e;
            return sQLException;
        }
        finally {
            this.closeStmt().close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLException ejecutar(String sql) {
        Connection conn = this.getConnection();
        try {
            this.stmt = conn.prepareStatement(sql);
            this.stmt.executeUpdate();
            SQLException sQLException = null;
            return sQLException;
        }
        catch (SQLException e) {
            Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, e);
            this.close(conn);
            SQLException sQLException = e;
            return sQLException;
        }
        finally {
            this.closeStmt().close(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLException ejecutar(String sql, Map<Integer, Object> parametros) {
        Connection conn = this.getConnection();
        try {
            this.stmt = parametros == null ? conn.prepareStatement(sql) : this.prepararStatement(sql, conn, parametros);
            this.stmt.executeUpdate();
            SQLException sQLException = null;
            return sQLException;
        }
        catch (SQLException e) {
            Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, e);
            this.close(conn);
            SQLException sQLException = e;
            return sQLException;
        }
        finally {
            this.closeStmt().close(conn);
        }
    }

    private PreparedStatement prepararStatement(String sql, Connection conn, Map<Integer, Object> parametros) throws SQLException {
        this.stmt = conn.prepareStatement(sql);
        parametros.entrySet().stream().forEach(new Consumer<Map.Entry<Integer, Object>>(){
            int posicion = 1;

            @Override
            public void accept(Map.Entry<Integer, Object> entry) {
                try {
                    this.posicion = entry.getKey();
                    if (entry.getValue() instanceof String) {
                        ConnDBPool.this.stmt.setString(this.posicion, entry.getValue().toString());
                    } else if (entry.getValue() instanceof Integer) {
                        ConnDBPool.this.stmt.setInt(this.posicion, (Integer)entry.getValue());
                    } else if (entry.getValue() instanceof Double) {
                        ConnDBPool.this.stmt.setDouble(this.posicion, (Double)entry.getValue());
                    } else if (entry.getValue() instanceof LocalTime) {
                        ConnDBPool.this.stmt.setTime(this.posicion, Time.valueOf((LocalTime)entry.getValue()));
                    } else if (entry.getValue() instanceof LocalDate) {
                        ConnDBPool.this.stmt.setDate(this.posicion, Date.valueOf((LocalDate)entry.getValue()));
                    } else if (entry.getValue() instanceof Boolean) {
                        ConnDBPool.this.stmt.setBoolean(this.posicion, (Boolean)entry.getValue());
                    } else if (entry.getValue() instanceof Byte[]) {
                        ConnDBPool.this.stmt.setBytes(this.posicion, (byte[])entry.getValue());
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        });
        return this.stmt;
    }

    public ResultSet ejecutarQuery(String sql, Connection conn, Map<Integer, Object> parametros) {
        try {
            this.stmt = parametros == null ? conn.prepareStatement(sql) : this.prepararStatement(sql, conn, parametros);
            this.rs = this.stmt.executeQuery();
        }
        catch (SQLException e) {
            Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        return this.rs;
    }

    public ResultSet ejecutarQuery(String sql, Map<Integer, Object> parametros) {
        try {
            if (parametros != null) {
                Connection conn = this.getConnection();
                this.stmt = this.prepararStatement(sql, conn, parametros);
            } else {
                this.stmt = this.prepareStatement(sql);
            }
            this.rs = this.stmt.executeQuery();
        }
        catch (SQLException e) {
            Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        return this.rs;
    }

    public ResultSet ejecutarQuery(String sql) {
        Connection conn = this.getConnection();
        try {
            this.stmt = conn.prepareStatement(sql);
            this.rs = this.stmt.executeQuery();
        }
        catch (SQLException e) {
            Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        return this.rs;
    }

    public ConnDBPool close(Connection conn) {
        try {
            if (conn != null) {
                conn.close();
            }
        }
        catch (SQLException ex) {
            Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public ConnDBPool close(PreparedStatement stmt) {
        try {
            Connection conn = stmt.getConnection();
            stmt.close();
            conn.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public ConnDBPool close(ResultSet rs) {
        try {
            rs.close();
            Connection conex = rs.getStatement().getConnection();
            rs.getStatement().close();
            conex.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public ConnDBPool closeStmt() {
        try {
            this.stmt.close();
        }
        catch (SQLException ex) {
            Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, ex);
        }
        return this;
    }

    public PreparedStatement getStmt() {
        return this.stmt;
    }

    public PreparedStatement prepareStatement(String sql) {
        Connection conn = this.getConnection();
        try {
            return conn.prepareStatement(sql);
        }
        catch (SQLException ex) {
            Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public ResultSet ejecutarQuery(PreparedStatement stmt) {
        ResultSet rs = null;
        try {
            rs = stmt.executeQuery();
        }
        catch (SQLException ex) {
            Logger.getLogger(ConnDBPool.class.getName()).log(Level.SEVERE, null, ex);
        }
        return rs;
    }

    public ResultSet getRs() {
        return this.rs;
    }

    public void closePool() {
        if (ds != null && !ds.isClosed()) {
            ds.close();
        }
    }

    public PreparedStatement getPSPOOL(String sql) {
        try {
            if (!ds.isClosed()) {
                return this.getConnection().prepareStatement(sql);
            }
            return null;
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error de conexion con el servidor. \n" + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noSQLPOOL(PreparedStatement ps) {
        int res = 0;
        try {
            res = ps.executeUpdate();
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al ejecutar el script. \n" + e.getMessage(), "Error SQL", 0);
        }
        finally {
            this.cerrarCONPS(ps);
        }
        return res > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeNoSQL(String sql) {
        int res = 0;
        PreparedStatement ps = this.getPSPOOL(sql);
        try {
            res = ps.executeUpdate();
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al ejecutar el script. \n" + e.getMessage(), "Error SQL", 0);
        }
        finally {
            this.cerrarCONPS(ps);
        }
        return res > 0;
    }

    public PreparedStatement getPSID(String sql) {
        try {
            return this.getConnection().prepareStatement(sql, 1);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al crear el prepared statement para obtener un ID generado. " + e.getMessage(), "Error Prepared Statement", 0);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIDGenerado(PreparedStatement ps) {
        int id = 0;
        try {
            ps.executeUpdate();
            ResultSet res = ps.getGeneratedKeys();
            if (res.next()) {
                id = res.getInt(1);
            }
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al obtener el ID generado. " + e.getMessage(), "Error ID", 0);
        }
        finally {
            this.cerrarCONPS(ps);
        }
        return id;
    }

    public void cerrarCONPS(PreparedStatement ps) {
        if (ps != null) {
            try {
                ps.getConnection().close();
            }
            catch (SQLException e) {
                JOptionPane.showMessageDialog(null, "Error al cerrar conexion. \n" + e.getMessage(), "Error servidor", 0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "Error al cerrar conexion. \nNo tenemos conexion", "Error servidor", 0);
        }
    }

    public boolean deleteById(String sql, int id) {
        PreparedStatement ps = this.getPSPOOL(sql);
        try {
            ps.setInt(1, id);
        }
        catch (SQLException e) {
            JOptionPane.showMessageDialog(null, "Error al eliminar registro. \n" + e.getMessage(), "Error servidor", 0);
        }
        return this.noSQLPOOL(ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLException call(CallableStatement callStmt) {
        try {
            callStmt.execute();
            SQLException sQLException = null;
            return sQLException;
        }
        catch (SQLException e) {
            SQLException sQLException = e;
            return sQLException;
        }
        finally {
            try {
                callStmt.close();
                callStmt.getConnection().close();
            }
            catch (SQLException ex) {
                M.errorMsg("No pudimos cerrar el callable statement. " + ex.getMessage());
            }
        }
    }

    public String useINsql(List<Integer> ids, String statement) {
        String sqlIn = ids.stream().map(x -> String.valueOf(x)).collect(Collectors.joining(",", "(", ")"));
        return statement.replace("(?)", sqlIn);
    }

    public void mostrarReporte(JasperReport jr, Map parametro, String titulo) {
        new Thread(() -> {
            Connection c = this.getConnection();
            try {
                JasperPrint print = JasperFillManager.fillReport((JasperReport)jr, (Map)parametro, (Connection)c);
                JasperViewer view = new JasperViewer(print, false);
                view.setVisible(true);
                view.setTitle(titulo);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, "Error en reporte: " + ex);
            }
            finally {
                try {
                    c.close();
                }
                catch (SQLException e) {
                    JOptionPane.showMessageDialog(null, "No pudimos cerrar conexion: " + e.getMessage());
                }
            }
        }).start();
    }
}

