/*
 * Decompiled with CFR 0.152.
 */
package controlador.vistaReportes;

import controlador.Libraries.Effects;
import controlador.principal.VtnPrincipalCTR;
import controlador.vistaReportes.ReporteEstadoAlumCTR;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import modelo.carrera.CarreraBD;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.querys.Querys;
import utils.CONS;
import vista.vistaReportes.VtnEstadosR;

public class VtnEstadosCTR {
    private final VtnPrincipalCTR desktop;
    private final VtnEstadosR vista;
    private final PeriodoLectivoBD modelo;
    private final CarreraBD carrera;
    private List<PeriodoLectivoMD> periodos;
    private DefaultTableModel tabla;

    public VtnEstadosCTR(VtnPrincipalCTR desktop) {
        this.desktop = desktop;
        this.vista = new VtnEstadosR();
        this.modelo = new PeriodoLectivoBD();
        this.carrera = new CarreraBD();
    }

    public void Init() {
        Effects.addInDesktopPane(this.vista, this.desktop.getVtnPrin().getDpnlPrincipal());
        this.tabla = (DefaultTableModel)this.vista.getTbl().getModel();
        this.cargarPeriodos();
        this.InitEventos();
        this.InitPermisos();
    }

    private void InitEventos() {
        this.vista.getBtnVer().addActionListener(e -> this.btnVer(e));
        this.vista.getCmbPeriodos().addItemListener(e -> this.setCarrera());
        this.vista.getBtnReporte().addActionListener(e -> this.btnImprimir(e));
    }

    private void InitPermisos() {
        this.vista.getBtnReporte().getAccessibleContext().setAccessibleName("Asistencia-Estado-Reportes");
        CONS.activarBtns(this.vista.getBtnReporte());
    }

    private void cargarPeriodos() {
        this.periodos = this.modelo.selectIdNombreAll();
        this.periodos.stream().map(c -> c.getNombre()).forEach(this.vista.getCmbPeriodos()::addItem);
        this.setCarrera();
    }

    private void setCarrera() {
        this.vista.getLblCarrera().setText(this.carrera.selectWhere(this.getIdPeriodo()));
    }

    private void cargarTabla() {
        this.tabla.setRowCount(0);
        new Querys().selectReporteEstado(this.getIdPeriodo(), this.vista.getCmbEstado().getSelectedItem().toString()).forEach(this.tabla::addRow);
        this.vista.getLblResultados().setText(this.tabla.getDataVector().size() + " Resultados");
    }

    private int getIdPeriodo() {
        return this.periodos.stream().filter(item -> item.getNombre().equalsIgnoreCase(this.vista.getCmbPeriodos().getSelectedItem().toString())).map(c -> c.getID()).findFirst().orElse(-1);
    }

    private void btnVer(ActionEvent e) {
        this.cargarTabla();
    }

    private void btnImprimir(ActionEvent e) {
        Effects.setLoadCursor(this.vista);
        ReporteEstadoAlumCTR reportes = new ReporteEstadoAlumCTR(this.vista, this.getIdPeriodo());
        reportes.generarReporteEstadoAlumno();
        Effects.setDefaultCursor(this.vista);
    }
}

