/*
 * Decompiled with CFR 0.152.
 */
package controlador.version;

import controlador.login.LoginCTR;
import controlador.version.Descarga;
import controlador.version.Descomprime;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import modelo.version.VersionMD;
import vista.principal.VtnPrincipal;
import vista.version.VtnDitool;

public class VtnDitoolCTR {
    private final VersionMD version;
    private final VtnDitool vtnDitool;
    private final VtnPrincipal vtnPrincipal;
    private boolean aCorrecto = true;
    private final ImageIcon icono;
    private boolean cerrar = false;
    private Clip sonido;
    private final ImageIcon[] estados = new ImageIcon[]{new ImageIcon(this.getClass().getResource("/vista/img/animacion/logo.png")), new ImageIcon(this.getClass().getResource("/vista/img/animacion/logo.png")), new ImageIcon(this.getClass().getResource("/vista/img/animacion/logo.png"))};
    private final ImageIcon iconIni = new ImageIcon(this.getClass().getResource("/vista/img/animacion/logo.png"));

    public VtnDitoolCTR(VersionMD version, VtnDitool vtnPrin) {
        this.icono = new ImageIcon(this.getClass().getResource("/vista/img/update.png"));
        this.version = version;
        this.vtnDitool = vtnPrin;
        this.vtnPrincipal = null;
        this.vtnDitool.setIconImage(this.icono.getImage());
    }

    public VtnDitoolCTR(VersionMD version, VtnDitool vtnPrin, VtnPrincipal vtnPrincipal) {
        this.icono = new ImageIcon(this.getClass().getResource("/vista/img/update.png"));
        this.version = version;
        this.vtnDitool = vtnPrin;
        this.vtnPrincipal = vtnPrincipal;
        this.vtnDitool.setIconImage(this.icono.getImage());
        this.cerrarVentana();
    }

    public void iniciar() {
        this.mostrarVtn();
        this.vtnDitool.getBtnPausar().addActionListener(e -> this.clickPausar());
        this.mostrarInformacion();
        if (this.validarVersion()) {
            if (this.aCorrecto) {
                this.comprobarVersion();
            }
        } else {
            JOptionPane.showMessageDialog(this.vtnDitool, "No se an publicado versiones.");
            this.ejecutarPrograma();
        }
    }

    private void mostrarInformacion() {
        File pv = new File("version.properties");
        Properties p = new Properties();
        if (pv.exists()) {
            if (this.comprobarRequisitos(p, pv)) {
                try {
                    p.load(new FileReader(pv));
                    this.vtnDitool.getLblAutor().setText(p.getProperty("Autor"));
                    this.vtnDitool.getTxtAutor().setText(p.getProperty("Notas"));
                    this.vtnDitool.getLblNombre().setText(this.version.getNombreSinExtension(p.getProperty("Nombre")));
                    this.vtnDitool.getLblVersion().setText(p.getProperty("Version"));
                    this.vtnDitool.setTitle(this.vtnDitool.getTitle() + " " + p.getProperty("Version"));
                }
                catch (IOException e) {
                    System.out.println("No pudimos leer las propiedades de version: " + e.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(this.vtnDitool, "Su archivo de propiedades esta corrupto,\nvamos a descargar todo nuevamente.");
                this.aCorrecto = false;
                if (this.validarVersion()) {
                    this.crearVersion();
                    this.cerrarTodo();
                }
            }
        }
    }

    public void mostrarVtn() {
        this.vtnDitool.setVisible(true);
        this.vtnDitool.setLocationRelativeTo(null);
        this.vtnDitool.getLblFondo().setIcon(this.iconIni);
    }

    private void iniciarSprint() {
        new Thread(() -> {
            while (!this.cerrar) {
                for (ImageIcon estado : this.estados) {
                    this.vtnDitool.getLblFondo().setIcon(estado);
                    this.dormir(500);
                }
            }
        }).start();
    }

    public void comprobarVersion() {
        File pv = new File("version.properties");
        Properties p = new Properties();
        if (pv.exists()) {
            if (this.comprobarRequisitos(p, pv)) {
                if (this.compara(p, pv)) {
                    JOptionPane.showMessageDialog(null, "Esta instalada la ultima version del sistema.");
                    if (this.vtnPrincipal == null) {
                        this.ejecutarPrograma();
                    } else {
                        this.habilitarPrograma();
                    }
                } else {
                    this.crearVersion();
                }
            } else {
                this.crearVersion();
            }
        } else {
            this.crearVersion();
        }
        this.cerrarTodo();
    }

    public void crearVersion() {
        Object[] opt = this.vtnPrincipal == null ? new Object[]{"Actualizar", "Abrir", "Salir"} : new Object[]{"Actualizar", "Cancelar", "Salir"};
        int s = JOptionPane.showOptionDialog(this.vtnDitool, "\n!Actualizaci\u00f3n Pendiente del Sistema!\nEn esta nueva versi\u00f3n: \n" + this.version.getNotas(), "Actualizacion pendiente", 1, 1, null, opt, "Actualizar");
        switch (s) {
            case 0: {
                this.altualizarSistema();
                break;
            }
            case 1: {
                if (this.vtnPrincipal == null) {
                    this.ejecutarPrograma();
                    break;
                }
                this.habilitarPrograma();
                break;
            }
            case 2: {
                System.exit(0);
                break;
            }
            default: {
                if (this.vtnPrincipal != null) {
                    this.vtnPrincipal.setEnabled(true);
                }
                this.cerrarTodo();
            }
        }
    }

    private void altualizarSistema() {
        this.iniciarSprint();
        this.musicaDescarga();
        this.vtnDitool.getLblEstado().setText("Descargando...");
        File pv = new File("version.properties");
        Properties p = new Properties();
        Descarga descarga = new Descarga(this.version);
        if (descarga.descargar()) {
            this.crearPropiedades(p, pv);
            this.vtnDitool.getLblEstado().setText("Descargado");
            Descomprime uzip = new Descomprime(this.version);
            this.vtnDitool.getLblEstado().setText("Instalando..");
            uzip.descomprime();
        }
    }

    private boolean compara(Properties p, File bd) {
        boolean igual = true;
        String pNombre = "";
        String pVersion = "";
        try {
            p.load(new FileReader(bd));
            pNombre = p.getProperty("Nombre");
            pVersion = p.getProperty("Version");
        }
        catch (IOException e) {
            System.out.println("No pudimos leer las propiedades de version: " + e.getMessage());
        }
        if (!pNombre.equals(this.version.getNombre())) {
            igual = false;
        }
        if (!pVersion.equals(this.version.getVersion())) {
            igual = false;
        }
        return igual;
    }

    private boolean crearPropiedades(Properties p, File bd) {
        boolean creado = false;
        try {
            FileOutputStream fo = new FileOutputStream(bd);
            p.setProperty("Autor", this.version.getUsername());
            p.setProperty("Nombre", this.version.getNombre());
            p.setProperty("Version", this.version.getVersion());
            p.setProperty("Fecha", this.version.getFecha().toString());
            p.setProperty("Notas", this.version.getNotas());
            p.store(fo, "Descripcion de la version del sistema: ");
            creado = true;
        }
        catch (FileNotFoundException e) {
            System.out.println("No podemos escribir el archivo: " + e.getMessage());
        }
        catch (IOException ex) {
            System.out.println("No se pudo guardar el properties: " + ex.getMessage());
        }
        return creado;
    }

    private boolean comprobarRequisitos(Properties p, File bd) {
        boolean todas = true;
        try {
            p.load(new FileReader(bd));
            if (p.getProperty("Autor") == null) {
                todas = false;
            }
            if (p.getProperty("Fecha") == null) {
                todas = false;
            }
            if (p.getProperty("Nombre") == null) {
                todas = false;
            }
            if (p.getProperty("Notas") == null) {
                todas = false;
            }
            if (p.getProperty("Version") == null) {
                todas = false;
            }
        }
        catch (IOException e) {
            System.out.println("Error al comprobar si tiene todas las constantes:" + e.getMessage());
        }
        return todas;
    }

    private void ejecutarPrograma() {
        this.cerrarTodo();
        EventQueue.invokeLater(() -> {
            LoginCTR login = new LoginCTR();
            login.Init();
        });
    }

    private void habilitarPrograma() {
        this.cerrarTodo();
        this.vtnPrincipal.setEnabled(true);
    }

    private void cerrarTodo() {
        this.cerrar = true;
        this.vtnDitool.dispose();
    }

    private boolean validarVersion() {
        return this.version.getFecha() != null && this.version.getId() != 0 && this.version.getNombre() != null && this.version.getNotas() != null && this.version.getUrl() != null && this.version.getUsername() != null && this.version.getVersion() != null;
    }

    private void dormir(int miliSeg) {
        try {
            Thread.sleep(miliSeg);
        }
        catch (InterruptedException e) {
            System.out.println("No se durmio el hilo " + e.getMessage());
        }
    }

    private void musicaDescarga() {
        try {
            File a = new File("dancin8bits.wav");
            if (a.exists()) {
                this.sonido = AudioSystem.getClip();
                this.sonido.open(AudioSystem.getAudioInputStream(a));
                this.sonido.start();
            }
        }
        catch (LineUnavailableException e) {
            System.out.println("No pudimos encontrar el audio. " + e.getMessage());
        }
        catch (IOException | UnsupportedAudioFileException ex) {
            System.out.println("No encontramos el archivo de audio. " + ex.getMessage());
        }
    }

    private void clickPausar() {
        if (this.vtnDitool.getBtnPausar().getText().equals("Silenciar")) {
            this.vtnDitool.getBtnPausar().setText("Escuchar");
            this.pausar();
        } else {
            this.vtnDitool.getBtnPausar().setText("Silenciar");
            this.reanudar();
        }
    }

    private void pausar() {
        this.sonido.stop();
    }

    private void reanudar() {
        this.sonido.start();
    }

    private void silenciar() {
        this.sonido.close();
    }

    private void cerrarVentana() {
        this.vtnDitool.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                VtnDitoolCTR.this.vtnPrincipal.setEnabled(true);
            }
        });
    }
}

