/*
 * Decompiled with CFR 0.152.
 */
package controlador.version;

import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import controlador.version.FrmVersionCTR;
import java.awt.Frame;
import java.util.ArrayList;
import modelo.version.VersionBD;
import modelo.version.VersionMD;
import vista.principal.VtnPrincipal;
import vista.version.JDVersion;

public class JDVersionCTR
extends DVtnCTR {
    private final JDVersion jd;
    private ArrayList<VersionMD> versiones;
    private final VersionBD ver = VersionBD.single();

    public JDVersionCTR(VtnPrincipal vtnPrin, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.jd = new JDVersion((Frame)vtnPrin, false);
        this.jd.setLocationRelativeTo(vtnPrin);
        this.jd.setVisible(true);
    }

    public void iniciar() {
        this.ctrPrin.eventoJDCerrar(this.jd);
        this.formatoTbl();
        this.iniciarAcciones();
        this.cargarDatos();
    }

    private void iniciarAcciones() {
        this.jd.getBtnIngresar().addActionListener(e -> this.clickIngresar());
        this.jd.getBtnEditar().addActionListener(e -> this.clickEditar());
        this.jd.getBtnEliminar().addActionListener(e -> this.clickEliminar());
        this.jd.getCbxEliminados().addActionListener(e -> this.clickEliminados());
    }

    private void formatoTbl() {
        String[] t = new String[]{"Autor", "Nombre", "Version"};
        this.mdTbl = this.iniciarTbl(this.jd.getTblVersiones(), t);
    }

    private void clickEliminados() {
        if (this.jd.getCbxEliminados().isSelected()) {
            this.cargarEliminados();
            this.jd.getBtnEditar().setEnabled(false);
            this.jd.getBtnEliminar().setEnabled(false);
        } else {
            this.cargarDatos();
            this.jd.getBtnEditar().setEnabled(true);
            this.jd.getBtnEliminar().setEnabled(true);
        }
    }

    private void cargarEliminados() {
        this.versiones = this.ver.cargarVersionesEliminadas();
        this.llenarTbl(this.versiones);
    }

    public void cargarDatos() {
        this.versiones = this.ver.cargarVersionesActivas();
        this.llenarTbl(this.versiones);
    }

    private void llenarTbl(ArrayList<VersionMD> versiones) {
        this.mdTbl.setRowCount(0);
        if (versiones != null) {
            versiones.forEach(v -> {
                Object[] val = new Object[]{v.getNombreSinExtension(), v.getUsername(), v.getVersion()};
                this.mdTbl.addRow(val);
            });
        }
    }

    private void clickIngresar() {
        FrmVersionCTR ctr = new FrmVersionCTR(this.ctrPrin, this.ver, this);
        ctr.iniciar();
    }

    private void clickEditar() {
        this.posFila = this.jd.getTblVersiones().getSelectedRow();
        if (this.posFila >= 0) {
            FrmVersionCTR ctr = new FrmVersionCTR(this.ctrPrin, this.ver, this);
            ctr.iniciar();
            ctr.editar(this.versiones.get(this.posFila).getId());
        }
    }

    private void clickEliminar() {
        this.posFila = this.jd.getTblVersiones().getSelectedRow();
        if (this.posFila >= 0 && this.ver.eliminar(this.versiones.get(this.posFila).getId())) {
            this.cargarDatos();
        }
    }
}

