/*
 * Decompiled with CFR 0.152.
 */
package controlador.version;

import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import controlador.version.JDVersionCTR;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JOptionPane;
import modelo.validaciones.TxaVDescripcion;
import modelo.validaciones.TxtVLetrasSimple;
import modelo.validaciones.TxtVUrlZip;
import modelo.validaciones.TxtVVersion;
import modelo.validaciones.Validar;
import modelo.version.VersionBD;
import modelo.version.VersionMD;
import vista.version.FrmVersion;

public class FrmVersionCTR
extends DVtnCTR {
    private final FrmVersion frmVersion;
    private final JDVersionCTR ctrVersion;
    private final VersionBD VRBD;
    private boolean editar = false;
    private int idVersion = 0;

    public FrmVersionCTR(VtnPrincipalCTR ctrPrin, VersionBD ver, JDVersionCTR ctrVersion) {
        super(ctrPrin);
        this.ctrVersion = ctrVersion;
        this.frmVersion = new FrmVersion((Frame)ctrPrin.getVtnPrin(), false);
        this.VRBD = ver;
    }

    public void iniciar() {
        this.frmVersion.setLocationRelativeTo(null);
        this.frmVersion.setVisible(true);
        this.frmVersion.getTxtNotas().setLineWrap(true);
        this.frmVersion.getTxtNotas().setWrapStyleWord(true);
        this.iniciarAcciones();
        this.iniciarValidaciones();
    }

    private void iniciarAcciones() {
        this.frmVersion.getBtnGuardar().addActionListener(e -> this.guardar());
    }

    private void iniciarValidaciones() {
        this.frmVersion.getTxtAutor().addKeyListener(new TxtVLetrasSimple(this.frmVersion.getTxtAutor(), this.frmVersion.getLblError()));
        this.frmVersion.getTxtNombre().addKeyListener(new TxtVLetrasSimple(this.frmVersion.getTxtNombre(), this.frmVersion.getLblError()));
        this.frmVersion.getTxtUrl().addKeyListener(new TxtVUrlZip(this.frmVersion.getTxtUrl(), this.frmVersion.getLblError()));
        this.frmVersion.getTxtNotas().addKeyListener(new TxaVDescripcion(this.frmVersion.getTxtNotas(), this.frmVersion.getLblError()));
        this.frmVersion.getTxtVersion().addKeyListener(new TxtVVersion(this.frmVersion.getTxtVersion(), this.frmVersion.getLblError()));
        this.frmVersion.getTxtUrl().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FrmVersionCTR.this.agregarNombre();
            }
        });
    }

    private void agregarNombre() {
        String url = this.frmVersion.getTxtUrl().getText().trim();
        if (Validar.esUrlZip(url)) {
            String urlNombre = url.substring(url.lastIndexOf("/") + 1, url.lastIndexOf("."));
            this.frmVersion.getTxtNombre().setText(urlNombre);
        }
    }

    private void guardar() {
        VersionMD v;
        int r;
        boolean guardar = true;
        String url = this.frmVersion.getTxtUrl().getText().trim();
        String version = this.frmVersion.getTxtVersion().getText().trim();
        String nombre = this.frmVersion.getTxtNombre().getText().trim();
        String username = this.frmVersion.getTxtAutor().getText().trim();
        String notas = this.frmVersion.getTxtNotas().getText().trim();
        if (!Validar.esLetrasSimple(nombre)) {
            guardar = false;
        }
        if (!Validar.esUrlZip(url)) {
            guardar = false;
        } else {
            String urlNombre = url.substring(url.lastIndexOf("/") + 1, url.lastIndexOf("."));
            if (!urlNombre.equals(nombre)) {
                r = JOptionPane.showConfirmDialog(null, "El nombre de su proyecto no es: " + urlNombre + "\n\u00bfDesea escribirlo?");
                if (r == 0) {
                    nombre = urlNombre;
                    this.frmVersion.getTxtNombre().setText(nombre);
                } else {
                    guardar = false;
                }
            }
        }
        if (!Validar.esVersion(version)) {
            guardar = false;
        }
        if (!Validar.esLetrasSimple(username)) {
            guardar = false;
        }
        if (!Validar.esDescripcion(notas)) {
            guardar = false;
        }
        if (guardar && !this.editar && (v = this.VRBD.existeVersion(nombre + ".zip", version)) != null && v.getUsername() != null) {
            JOptionPane.showMessageDialog(this.frmVersion, "Ya existe esta version fue publicada por: " + v.getUsername());
            guardar = false;
        }
        if (guardar) {
            r = JOptionPane.showConfirmDialog(this.frmVersion, "Se guardara: \nAutor: " + username + "\nProyecto: " + nombre + "\nVersion: " + version + "\nURL: \n" + url + "\nNotas: \n" + notas + "\n\u00bfSeguro que quiere continuar?");
            if (r == 0) {
                boolean completo;
                VersionMD ver = new VersionMD();
                ver.setNombre(nombre + ".zip");
                ver.setNotas(notas);
                ver.setUrl(url);
                ver.setUsername(username);
                ver.setVersion(version);
                if (this.editar) {
                    ver.setId(this.idVersion);
                    completo = this.VRBD.editar(ver);
                } else {
                    completo = this.VRBD.guardar(ver);
                }
                if (completo) {
                    this.frmVersion.dispose();
                    this.ctrVersion.cargarDatos();
                }
            }
        } else {
            JOptionPane.showMessageDialog(null, "Revise su formulario contiene errores.");
        }
    }

    public void editar(int idVersion) {
        this.idVersion = idVersion;
        this.editar = true;
        VersionMD v = this.VRBD.consultarVersion(idVersion);
        if (v != null) {
            this.frmVersion.getTxtAutor().setText(v.getUsername());
            this.frmVersion.getTxtNombre().setText(v.getNombreSinExtension());
            this.frmVersion.getTxtNotas().setText(v.getNotas());
            this.frmVersion.getTxtUrl().setText(v.getUrl());
            this.frmVersion.getTxtVersion().setText(v.getVersion());
        } else {
            JOptionPane.showMessageDialog(this.frmVersion, "No se puede editar, no se encontro el registro.");
            this.editar = false;
        }
    }
}

