/*
 * Decompiled with CFR 0.152.
 */
package controlador.version;

import java.io.File;
import javax.swing.JOptionPane;
import modelo.version.VersionMD;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import utils.CONS;

public class Descomprime {
    private final VersionMD version;
    private boolean segIntento = false;

    public Descomprime(VersionMD version) {
        this.version = version;
    }

    public void descomprime() {
        File zipFile = new File(this.version.getNombre());
        try {
            ZipFile zf = new ZipFile(zipFile);
            zf.extractAll(CONS.getDir());
            this.eliminarZip(zipFile);
        }
        catch (ZipException ex) {
            System.out.println("No salio bien debemos informarlo: " + ex.getMessage());
            if (!this.segIntento) {
                this.errorAlDescromprimir();
            }
            this.errorPermiso();
        }
    }

    private void errorAlDescromprimir() {
        int r = JOptionPane.showConfirmDialog(null, "No pudimos guardar el archivo. \n\u00bfDesea intentarlo de nuevo?");
        if (r == 0) {
            this.segIntento = true;
            this.descomprime();
        }
    }

    private void errorPermiso() {
        JOptionPane.showMessageDialog(null, "Tuvimos incovenientes la instalar el sistema, \ndebera hacerlo de forma manual. \nIndicaciones: \n1. Debera extraer el .zip que se encuentra en \n" + CONS.getDir() + "\n2. Ahora solo incie el sistema.");
    }

    private void eliminarZip(File zipFile) {
        if (zipFile.delete()) {
            JOptionPane.showMessageDialog(null, "Actualizamos todo de forma correcta.\nVuelva a abrir el programa.");
            System.exit(0);
        }
    }
}

