/*
 * Decompiled with CFR 0.152.
 */
package controlador.usuario.forms;

import controlador.Libraries.Effects;
import controlador.Libraries.Validaciones;
import controlador.usuario.VtnUsuarioCTR;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import modelo.persona.PersonaBD;
import modelo.persona.PersonaMD;
import modelo.usuario.UsuarioBD;
import modelo.usuario.UsuarioMD;
import vista.principal.VtnPrincipal;
import vista.usuario.FrmUsuario;

public abstract class AbstracForm {
    protected final VtnPrincipal desktop;
    protected FrmUsuario vista;
    protected UsuarioMD modelo;
    protected VtnUsuarioCTR vtnPadre;
    private List<UsuarioMD> usuarios;
    protected Map<String, PersonaMD> listaPersonas;
    private final PersonaBD personaBD;

    public AbstracForm(VtnPrincipal desktop, VtnUsuarioCTR vtnPadre) {
        this.desktop = desktop;
        this.vtnPadre = vtnPadre;
        this.vista = new FrmUsuario();
        this.personaBD = new PersonaBD();
    }

    public synchronized void Init() {
        Effects.addInDesktopPane(this.vista, this.desktop.getDpnlPrincipal());
        this.InitEventos();
        this.activarFormulario(false);
        this.listaPersonas = this.personaBD.selectAll();
        this.cargarComoPersonas();
        this.activarFormulario(true);
    }

    public List<UsuarioMD> getUsuarios() {
        return this.usuarios;
    }

    public void setUsuarios(List<UsuarioMD> usuarios) {
        this.usuarios = usuarios;
    }

    private void InitEventos() {
        this.vista.getTxtUsername().addKeyListener(Validaciones.validarSoloLetrasYnumeros());
        this.vista.getTxtPassword().addKeyListener(Validaciones.validarSoloLetrasYnumeros());
        this.vista.getTxtBuscarPer().addKeyListener(Validaciones.validarNumeros());
        this.vista.getTxtBuscarPer().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AbstracForm.this.vista.getCmbPersona().setSelectedItem(AbstracForm.this.buscarPersona(AbstracForm.this.vista.getTxtBuscarPer().getText()).getKey());
                }
            }
        });
        this.vista.getBtnBuscarPer().addActionListener(e -> this.vista.getCmbPersona().setSelectedItem(this.buscarPersona(this.vista.getTxtBuscarPer().getText()).getKey()));
        this.vista.getBtnResetear().addActionListener(e -> this.resetForm());
        this.vista.getBtnCancelar().addActionListener(e -> this.vista.dispose());
        this.vista.getBtnGuardar().addActionListener(e -> this.guardar());
        this.vista.getTxtBuscarPer().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String cedula = AbstracForm.this.vista.getTxtBuscarPer().getText();
                AbstracForm.this.vista.getTxtUsername().setText(cedula);
            }
        });
        this.vista.getChxSuperUser().addActionListener(this::chxIsSuperUser);
    }

    private void cargarComoPersonas() {
        this.listaPersonas.entrySet().stream().map(c -> (String)c.getKey()).forEach(this.vista.getCmbPersona()::addItem);
    }

    private void resetForm() {
        if (!this.vista.getTxtUsername().getText().equals("ROOT")) {
            this.vista.getTxtUsername().setText("");
        }
        this.vista.getTxtPassword().setText("");
        this.vista.getTxtBuscarPer().setText("");
        this.vista.getCmbPersona().setSelectedIndex(0);
    }

    private void activarFormulario(boolean estado) {
        this.vista.getTxtUsername().setEnabled(estado);
        this.vista.getTxtPassword().setEnabled(estado);
        this.vista.getCmbPersona().setEnabled(estado);
        this.vista.getTxtBuscarPer().setEnabled(estado);
        this.vista.getBtnResetear().setEnabled(estado);
        this.vista.getBtnGuardar().setEnabled(estado);
    }

    protected UsuarioMD getObj() {
        this.modelo = new UsuarioBD();
        this.modelo.setUsername(this.vista.getTxtUsername().getText());
        this.modelo.setPassword(this.vista.getTxtPassword().getText());
        this.modelo.setPersona((PersonaMD)this.listaPersonas.entrySet().stream().filter(entry -> ((String)entry.getKey()).contains(this.vista.getCmbPersona().getSelectedItem().toString())).findAny().get().getValue());
        this.modelo.setEstado(true);
        this.modelo.setIsSuperUser(this.vista.getChxSuperUser().isSelected());
        return this.modelo;
    }

    private Map.Entry<String, PersonaMD> buscarPersona(String aguja) {
        return this.listaPersonas.entrySet().stream().filter(entry -> ((PersonaMD)entry.getValue()).getIdentificacion().contains(aguja)).findAny().get();
    }

    protected boolean validarFormulario() {
        if (!this.vista.getTxtUsername().getText().isEmpty()) {
            if (!this.vista.getTxtPassword().getText().isEmpty()) {
                return true;
            }
            JOptionPane.showMessageDialog(this.vista, "INGRESE UNA CONTRASE\u00d1A");
        } else {
            JOptionPane.showMessageDialog(this.vista, "INGRESE UN NOMBRE DE USUARIO");
        }
        return false;
    }

    public abstract void guardar();

    private void chxIsSuperUser(ActionEvent e) {
        this.modelo.setIsSuperUser(this.vista.getChxSuperUser().isSelected());
    }
}

