/*
 * Decompiled with CFR 0.152.
 */
package controlador.usuario;

import controlador.Libraries.Effects;
import controlador.usuario.Roles.forms.FrmAsignarRolCTR;
import controlador.usuario.forms.FrmUsuarioAdd;
import controlador.usuario.forms.FrmUsuarioUpdt;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.usuario.RolesDelUsuarioBD;
import modelo.usuario.UsuarioBD;
import modelo.usuario.UsuarioMD;
import utils.CONS;
import vista.principal.VtnPrincipal;
import vista.usuario.FrmAsignarRoles;
import vista.usuario.VtnUsuario;

public class VtnUsuarioCTR {
    private final VtnPrincipal desktop;
    private final VtnUsuario vista;
    private UsuarioBD modelo;
    private static List<UsuarioMD> listaUsuarios;
    private static DefaultTableModel tablaUsuarios;
    private boolean cargar = true;

    public VtnUsuarioCTR(VtnPrincipal desktop) {
        this.desktop = desktop;
        this.vista = new VtnUsuario();
    }

    public VtnUsuario getVista() {
        return this.vista;
    }

    public synchronized void Init() {
        Effects.addInDesktopPane(this.vista, this.desktop.getDpnlPrincipal());
        tablaUsuarios = (DefaultTableModel)this.vista.getTblUsuario().getModel();
        listaUsuarios = CONS.USUARIO.selectAll();
        this.cargarTabla(listaUsuarios);
        this.InitEventos();
        this.InitPermisos();
    }

    private void InitEventos() {
        this.vista.getBtnIngresar().addActionListener(e -> {
            FrmUsuarioAdd form = new FrmUsuarioAdd(this.desktop, this);
            form.Init();
            form.setUsuarios(listaUsuarios);
        });
        this.vista.getBtnEliminar().addActionListener(e -> this.btnEliminar(e));
        this.vista.getBtnEditar().addActionListener(e -> this.btnEditar(e));
        this.vista.getBtnActualizar().addActionListener(e -> {
            listaUsuarios = CONS.USUARIO.selectAll();
            this.cargarTabla(listaUsuarios);
        });
        this.vista.getBtnAsignarRoles().addActionListener(e -> this.btnAsignarRoles(e));
        this.vista.getBtnVerRoles().addActionListener(e -> this.btnVerRoles(e));
        this.vista.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VtnUsuarioCTR.this.cargarTablaFilter(VtnUsuarioCTR.this.vista.getTxtBuscar().getText());
            }
        });
    }

    public void cargarTabla(List<UsuarioMD> lista) {
        if (this.cargar) {
            new Thread(() -> {
                tablaUsuarios.setRowCount(0);
                this.vista.getTxtBuscar().setEnabled(false);
                this.cargar = false;
                Effects.setLoadCursor(this.vista);
                lista.stream().forEach(VtnUsuarioCTR::agregarFila);
                this.vista.getLblResultados().setText(lista.size() + " Registros");
                Effects.setDefaultCursor(this.vista);
                this.vista.getTxtBuscar().setEnabled(true);
                this.cargar = true;
            }).start();
        } else {
            JOptionPane.showMessageDialog(this.vista, "YA HAY UNA CARGA DE UNA TABLA PENDIENTE");
        }
    }

    private void cargarTablaFilter(String Aguja) {
        tablaUsuarios.setRowCount(0);
        List<UsuarioMD> listaTemporal = listaUsuarios.stream().filter(item -> item.getUsername().toUpperCase().contains(Aguja.toUpperCase()) || item.getPersona().getIdentificacion().toUpperCase().contains(Aguja.toUpperCase()) || item.getPersona().getPrimerApellido().toUpperCase().contains(Aguja.toUpperCase()) || item.getPersona().getSegundoApellido().toUpperCase().contains(Aguja.toUpperCase()) || item.getPersona().getPrimerNombre().toUpperCase().contains(Aguja.toUpperCase()) || item.getPersona().getSegundoNombre().toUpperCase().contains(Aguja.toUpperCase())).collect(Collectors.toList());
        listaTemporal.forEach(VtnUsuarioCTR::agregarFila);
        this.vista.getLblResultados().setText(listaTemporal.size() + " Registros");
    }

    private static void agregarFila(UsuarioMD obj) {
        tablaUsuarios.addRow(new Object[]{tablaUsuarios.getDataVector().size() + 1, obj.getUsername(), obj.getPersona().getIdentificacion(), obj.getPersona().getPrimerApellido(), obj.getPersona().getSegundoApellido(), obj.getPersona().getPrimerNombre(), obj.getPersona().getSegundoNombre()});
    }

    public UsuarioBD getModelo() {
        return this.modelo;
    }

    public void setModelo(int fila) {
        this.modelo = null;
        String username = (String)this.vista.getTblUsuario().getValueAt(fila, 1);
        this.modelo = new UsuarioBD(listaUsuarios.stream().filter(item -> item.getUsername().equals(username)).findAny().get());
    }

    private void btnEliminar(ActionEvent e) {
        int fila = this.vista.getTblUsuario().getSelectedRow();
        if (fila != -1) {
            String Username = (String)this.vista.getTblUsuario().getValueAt(fila, 1);
            if (Username.equals("ROOT")) {
                JOptionPane.showMessageDialog(this.vista, "NO SE PUEDE ELIMINAR AL USUARIO ROOT!!!");
            } else {
                int opcion = JOptionPane.showConfirmDialog(this.vista, "ESTA SEGURO DE BORRAR AL USUARIO\n" + Username);
                if (opcion == 0) {
                    if (this.modelo == null) {
                        this.modelo = new UsuarioBD();
                    }
                    this.modelo.cambiarEstado(Username, false);
                    listaUsuarios = this.modelo.selectAll();
                    this.cargarTabla(listaUsuarios);
                } else {
                    JOptionPane.showMessageDialog(this.vista, "HA DECIDIDO NO BORRAR AL USUARIO!!");
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.vista, "SELECCIONE UNA FILA!!!");
        }
    }

    private void btnEditar(ActionEvent e) {
        int fila = this.vista.getTblUsuario().getSelectedRow();
        if (fila != -1) {
            this.setModelo(fila);
            FrmUsuarioUpdt form = new FrmUsuarioUpdt(this.desktop, this);
            form.Init();
            form.setModelo(this.getModelo());
            form.setUsuarios(listaUsuarios);
        } else {
            JOptionPane.showMessageDialog(this.vista, "SELECCIONE UNA FILA!!");
        }
    }

    private void btnAsignarRoles(ActionEvent e) {
        int fila = this.vista.getTblUsuario().getSelectedRow();
        if (fila == -1) {
            JOptionPane.showMessageDialog(this.vista, "SELECCIONE UNA FILA!!");
        } else {
            this.setModelo(fila);
            if (this.getModelo().getUsername().equals("ROOT")) {
                JOptionPane.showMessageDialog(this.vista, "NO SE PUEDE EDITAR LOS PERMISOS DEL USUARIO ROOT!");
            } else {
                FrmAsignarRolCTR form = new FrmAsignarRolCTR(this.desktop, new FrmAsignarRoles(), new RolesDelUsuarioBD(), this.modelo, "Asignar");
                form.Init();
            }
        }
    }

    private void btnVerRoles(ActionEvent e) {
        int fila = this.vista.getTblUsuario().getSelectedRow();
        if (fila == -1) {
            JOptionPane.showMessageDialog(this.vista, "SELECCIONE UNA FILA!!");
        } else {
            this.setModelo(fila);
            FrmAsignarRolCTR form = new FrmAsignarRolCTR(this.desktop, new FrmAsignarRoles(), new RolesDelUsuarioBD(), this.getModelo(), "Consultar");
            form.Init();
        }
    }

    private void InitPermisos() {
        this.vista.getBtnIngresar().getAccessibleContext().setAccessibleName("Usuarios-Ingresar");
        this.vista.getBtnActualizar().getAccessibleContext().setAccessibleName("Usuarios-Actualizar");
        this.vista.getBtnEditar().getAccessibleContext().setAccessibleName("Usuarios-Editar");
        this.vista.getBtnAsignarRoles().getAccessibleContext().setAccessibleName("Usuarios-Asignar Roles");
        this.vista.getBtnEliminar().getAccessibleContext().setAccessibleName("Usuarios-Eliminar");
        this.vista.getBtnVerRoles().getAccessibleContext().setAccessibleName("Usuarios-Ver Roles");
        CONS.activarBtns(this.vista.getBtnIngresar(), this.vista.getBtnActualizar(), this.vista.getBtnEditar(), this.vista.getBtnAsignarRoles(), this.vista.getBtnEliminar(), this.vista.getBtnVerRoles());
    }
}

