/*
 * Decompiled with CFR 0.152.
 */
package controlador.usuario;

import controlador.Libraries.Effects;
import controlador.Libraries.ImgLib;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import modelo.usuario.UsuarioBD;
import modelo.usuario.UsuarioMD;
import utils.CONS;
import vista.usuario.VtnPerfilUsuario;

public class VtnPerfilUsuarioCTR {
    private VtnPerfilUsuario vista;
    private final UsuarioBD CONN = UsuarioBD.single();
    private UsuarioMD modelo;
    private VtnPrincipalCTR desktop;

    public VtnPerfilUsuarioCTR(VtnPrincipalCTR desktop) {
        this.vista = new VtnPerfilUsuario();
        this.modelo = CONS.USUARIO;
        this.desktop = desktop;
    }

    public VtnPerfilUsuarioCTR() {
    }

    public void Init() {
        Effects.addInDesktopPane(this.vista, this.desktop.getVtnPrin().getDpnlPrincipal());
        this.vista.getLblUsername().setText(this.modelo.getUsername());
        this.vista.getLblNombres().setText(this.modelo.getPersona().getPrimerNombre() + "  " + this.modelo.getPersona().getSegundoNombre());
        this.vista.getLblApellidos().setText(this.modelo.getPersona().getPrimerApellido() + "  " + this.modelo.getPersona().getSegundoApellido());
        this.vista.getLblRol().setText(CONS.ROL.getNombre());
        ImgLib.setImageInLabel(CONS.USUARIO.getPersona().getFoto(), this.vista.getLblFoto());
        this.InitEventos();
    }

    private void InitEventos() {
        this.vista.getBtnCancelar().addActionListener(e -> this.vista.dispose());
        this.vista.getBtnGuardar().addActionListener(e -> this.btnGuardarActionPerformance(e));
        this.vista.getBtnCambiarContrasena().addActionListener(e -> this.btnCambiarContrasenaActionPerformance(e));
        this.vista.getBtnPermisos().addActionListener(e -> CONS.refreshPermisos());
    }

    private void btnCambiarContrasenaActionPerformance(ActionEvent e) {
        this.vista.getTxtContrasena().setEnabled(true);
        this.vista.getTxtContrasena().setBorder(BorderFactory.createLineBorder(Color.BLUE, 1));
    }

    private void btnGuardarActionPerformance(ActionEvent e) {
        String password = this.vista.getTxtContrasena().getText();
        this.modelo.setPassword(password);
        if (this.vista.getTxtContrasena().getText().isEmpty()) {
            JOptionPane.showMessageDialog(this.vista, "Campo Vacio...");
        } else if (password.length() < 4) {
            JOptionPane.showMessageDialog(this.vista, "La contrase\u00f1a debe ser mayor o igual a 4 caracteres");
        } else if (this.CONN.editar(this.modelo, this.modelo.getUsername())) {
            JOptionPane.showMessageDialog(this.vista, "Contrase\u00f1a Editada correctamente");
            this.vista.getTxtContrasena().setText("");
            this.vista.getTxtContrasena().setBorder(BorderFactory.createLineBorder(Color.GRAY));
            this.vista.getTxtContrasena().setEnabled(false);
        }
    }
}

