/*
 * Decompiled with CFR 0.152.
 */
package controlador.usuario;

import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import modelo.estilo.TblEstilo;
import modelo.usuario.HistorialUsuarioBD;
import modelo.usuario.HistorialUsuarioMD;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import vista.usuario.VtnHistorialUsuarios;

public class VtnHistorialUserCTR
extends DVtnCTR {
    private final VtnHistorialUsuarios vtnH;
    private final HistorialUsuarioBD HUBD = HistorialUsuarioBD.single();
    private ArrayList<HistorialUsuarioMD> historial;
    private ArrayList<String> tablas;
    private ArrayList<String> acciones;
    private ArrayList<String> usuarios;
    private ArrayList<String> fechaIni;
    private ArrayList<String> fechaFin;
    private int posTbl;
    private int posAcc;
    private int posUser;
    private int posFI;
    private int posFF;
    private String b;
    private String sql;

    public VtnHistorialUserCTR(VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnH = new VtnHistorialUsuarios();
    }

    public void iniciar() {
        this.cargarCmbAcciones();
        this.cargarCmbUsuarios();
        this.cargarCmbTablas();
        this.cargarCmbFechas();
        String[] titulo = new String[]{"Usuario", "Tabla", "Acci\u00f3n", "PK", "Fecha"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.vtnH.getTblHistorial().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.vtnH.getTblHistorial());
        TblEstilo.columnaMedida(this.vtnH.getTblHistorial(), 2, 80);
        TblEstilo.columnaMedida(this.vtnH.getTblHistorial(), 3, 50);
        this.cargarHistorialHoy();
        this.vtnH.getCmbUsers().addActionListener(e -> this.clickCmbUsers());
        this.vtnH.getCmbTablas().addActionListener(e -> this.clickCmbTbl());
        this.vtnH.getCmbAccion().addActionListener(e -> this.clickCmbAccion());
        this.vtnH.getCmbFechaIni().addActionListener(e -> this.clickFechaIni());
        this.vtnH.getCmbFechaFin().addActionListener(e -> this.clickFechaFin());
        this.vtnH.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VtnHistorialUserCTR.this.b = VtnHistorialUserCTR.this.vtnH.getTxtBuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    VtnHistorialUserCTR.this.buscar(VtnHistorialUserCTR.this.b);
                } else if (VtnHistorialUserCTR.this.b.length() == 0) {
                    VtnHistorialUserCTR.this.cargarHistorialHoy();
                }
            }
        });
        this.vtnH.getBtnBuscar().addActionListener(e -> this.buscar(this.vtnH.getTxtBuscar().getText().trim()));
        this.vtnH.getBtnReporte().addActionListener(e -> this.llamaReporteHistorialUser());
        this.ctrPrin.agregarVtn(this.vtnH);
        this.InitPermisos();
    }

    private void buscar(String b) {
        if (Validar.esLetrasYNumeros(b)) {
            this.historial = this.HUBD.buscar(b);
            this.llenarTbl(this.historial);
        } else {
            this.mdTbl.setRowCount(0);
        }
    }

    private void clickFechaIni() {
        this.posFI = this.vtnH.getCmbFechaIni().getSelectedIndex();
        if (this.posFI > 0) {
            this.llenarCmbFechaFin();
        } else {
            this.vtnH.getCmbFechaFin().removeAllItems();
        }
        this.cmbCombinados();
    }

    private void clickFechaFin() {
        this.posFF = this.vtnH.getCmbFechaFin().getSelectedIndex();
        this.cmbCombinados();
    }

    private void clickCmbUsers() {
        this.posUser = this.vtnH.getCmbUsers().getSelectedIndex();
        this.cmbCombinados();
    }

    private void clickCmbAccion() {
        this.posAcc = this.vtnH.getCmbAccion().getSelectedIndex();
        this.cmbCombinados();
    }

    private void clickCmbTbl() {
        this.posTbl = this.vtnH.getCmbTablas().getSelectedIndex();
        this.cmbCombinados();
    }

    private void cargarHistorialHoy() {
        this.historial = this.HUBD.cargarHistorialHoy();
        this.llenarTbl(this.historial);
        this.sql = this.HUBD.getSql();
    }

    private void cargarCmbFechas() {
        this.fechaIni = this.HUBD.cargarFechas();
        this.llenarCmbFechaIni(this.fechaIni);
    }

    private void llenarCmbFechaFin() {
        this.vtnH.getCmbFechaFin().removeAllItems();
        this.fechaFin = new ArrayList();
        for (int i = 0; i < this.fechaIni.size(); ++i) {
            if (this.fechaIni.get(i).compareTo(this.fechaIni.get(this.posFI - 1)) <= 0) continue;
            this.fechaFin.add(this.fechaIni.get(i));
        }
        this.fechaFin.remove(this.fechaIni.get(this.posFI - 1));
        if (!this.fechaFin.isEmpty()) {
            this.vtnH.getCmbFechaFin().addItem("Seleccione");
            this.fechaFin.forEach(f -> this.vtnH.getCmbFechaFin().addItem((String)f));
            this.vtnH.getCmbFechaFin().setSelectedIndex(0);
        }
    }

    private void llenarCmbFechaIni(ArrayList<String> fechas) {
        this.vtnH.getCmbFechaIni().removeAllItems();
        if (!fechas.isEmpty()) {
            this.vtnH.getCmbFechaIni().addItem("Seleccione");
            fechas.forEach(f -> this.vtnH.getCmbFechaIni().addItem((String)f));
            this.vtnH.getCmbFechaIni().setSelectedIndex(0);
        }
    }

    private void cargarCmbTablas() {
        this.tablas = this.HUBD.cargarTablas();
        this.llenarCmbTablas(this.tablas);
    }

    private void llenarCmbTablas(ArrayList<String> tablas) {
        this.vtnH.getCmbTablas().removeAllItems();
        if (!tablas.isEmpty()) {
            this.vtnH.getCmbTablas().addItem("Seleccione");
            tablas.forEach(t -> this.vtnH.getCmbTablas().addItem((String)t));
            this.vtnH.getCmbTablas().setSelectedIndex(0);
        }
    }

    private void cargarCmbUsuarios() {
        this.usuarios = this.HUBD.cargarUsuarios();
        this.llenarCmbUsuarios(this.usuarios);
    }

    private void llenarCmbUsuarios(ArrayList<String> usuarios) {
        this.vtnH.getCmbUsers().removeAllItems();
        if (!usuarios.isEmpty()) {
            this.vtnH.getCmbUsers().addItem("Seleccione");
            usuarios.forEach(u -> this.vtnH.getCmbUsers().addItem((String)u));
            this.vtnH.getCmbUsers().setSelectedIndex(0);
        }
    }

    private void cargarCmbAcciones() {
        this.acciones = this.HUBD.cargarAcciones();
        this.llenarCmbAcciones(this.acciones);
    }

    private void llenarCmbAcciones(ArrayList<String> acciones) {
        this.vtnH.getCmbAccion().removeAllItems();
        if (acciones != null) {
            this.vtnH.getCmbAccion().addItem("Seleccione");
            acciones.forEach(a -> this.vtnH.getCmbAccion().addItem((String)a));
            this.vtnH.getCmbAccion().setSelectedIndex(0);
        }
    }

    private void cmbCombinados() {
        this.historial = new ArrayList();
        if (this.posUser > 0 && this.posFI > 0 && this.posFF > 0 && this.posTbl > 0 && this.posAcc > 0) {
            this.historial = this.HUBD.cargarHistorialUserTablaAccionEntreFechas(this.usuarios.get(this.posUser - 1), this.tablas.get(this.posTbl - 1), this.acciones.get(this.posAcc - 1), this.fechaIni.get(this.posFI - 1), this.fechaFin.get(this.posFF - 1));
        } else if (this.posUser > 0 && this.posFI > 0 && this.posAcc > 0 && this.posTbl > 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialUserTablaAccionPorFecha(this.usuarios.get(this.posUser - 1), this.tablas.get(this.posTbl - 1), this.acciones.get(this.posAcc - 1), this.fechaIni.get(this.posFI - 1));
        } else if (this.posUser > 0 && this.posAcc > 0 && this.posTbl > 0 && this.posFI == 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialUserTablaAccion(this.usuarios.get(this.posUser - 1), this.tablas.get(this.posTbl - 1), this.acciones.get(this.posAcc - 1));
        } else if (this.posUser > 0 && this.posTbl > 0 && this.posAcc == 0 && this.posFI == 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialUserTabla(this.usuarios.get(this.posUser - 1), this.tablas.get(this.posTbl - 1));
        } else if (this.posUser > 0 && this.posTbl == 0 && this.posAcc == 0 && this.posFI == 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialUser(this.usuarios.get(this.posUser - 1));
        } else if (this.posUser > 0 && this.posTbl == 0 && this.posAcc > 0 && this.posFI == 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialUserAccion(this.usuarios.get(this.posUser - 1), this.acciones.get(this.posAcc - 1));
        } else if (this.posUser > 0 && this.posTbl == 0 && this.posAcc == 0 && this.posFI > 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialUserPorFecha(this.usuarios.get(this.posUser - 1), this.fechaIni.get(this.posFI - 1));
        } else if (this.posUser > 0 && this.posTbl == 0 && this.posAcc == 0 && this.posFI > 0 && this.posFF > 0) {
            this.historial = this.HUBD.cargarHistorialUserEntreFechas(this.usuarios.get(this.posUser - 1), this.fechaIni.get(this.posFI - 1), this.fechaFin.get(this.posFF - 1));
        } else if (this.posUser > 0 && this.posTbl > 0 && this.posAcc == 0 && this.posFI > 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialUserTablaPorFecha(this.usuarios.get(this.posUser - 1), this.tablas.get(this.posTbl - 1), this.fechaIni.get(this.posFI - 1));
        } else if (this.posUser > 0 && this.posTbl > 0 && this.posAcc == 0 && this.posFI > 0 && this.posFF > 0) {
            this.historial = this.HUBD.cargarHistorialUserTablaEntreFechas(this.usuarios.get(this.posUser - 1), this.tablas.get(this.posTbl - 1), this.fechaIni.get(this.posFI - 1), this.fechaFin.get(this.posFF - 1));
        } else if (this.posUser > 0 && this.posTbl == 0 && this.posAcc > 0 && this.posFI == 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialUserAccion(this.usuarios.get(this.posUser - 1), this.acciones.get(this.posAcc - 1));
        } else if (this.posUser > 0 && this.posTbl == 0 && this.posAcc > 0 && this.posFI > 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialUserAccionPorFecha(this.usuarios.get(this.posUser - 1), this.acciones.get(this.posAcc - 1), this.fechaIni.get(this.posFI - 1));
        } else if (this.posUser > 0 && this.posTbl == 0 && this.posAcc > 0 && this.posFI > 0 && this.posFF > 0) {
            this.historial = this.HUBD.cargarHistorialUserAccionEntreFechas(this.usuarios.get(this.posUser - 1), this.acciones.get(this.posAcc - 1), this.fechaIni.get(this.posFI - 1), this.fechaFin.get(this.posFF - 1));
        } else if (this.posUser == 0 && this.posTbl > 0 && this.posAcc == 0 && this.posFI == 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialTbl(this.tablas.get(this.posTbl - 1));
        } else if (this.posUser == 0 && this.posTbl > 0 && this.posAcc > 0 && this.posFI == 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialTblAccion(this.tablas.get(this.posTbl - 1), this.acciones.get(this.posAcc - 1));
        } else if (this.posUser == 0 && this.posTbl > 0 && this.posAcc > 0 && this.posFI > 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialTblAccionPoFecha(this.tablas.get(this.posTbl - 1), this.acciones.get(this.posAcc - 1), this.fechaIni.get(this.posFI - 1));
        } else if (this.posUser == 0 && this.posTbl > 0 && this.posAcc > 0 && this.posFI > 0 && this.posFF > 0) {
            this.historial = this.HUBD.cargarHistorialTblAccionEntreFecha(this.tablas.get(this.posTbl - 1), this.acciones.get(this.posAcc - 1), this.fechaIni.get(this.posFI - 1), this.fechaFin.get(this.posFF - 1));
        } else if (this.posUser == 0 && this.posTbl == 0 && this.posAcc > 0 && this.posFI == 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialAccion(this.acciones.get(this.posAcc - 1));
        } else if (this.posUser == 0 && this.posTbl == 0 && this.posAcc > 0 && this.posFI > 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialAccionPorFecha(this.acciones.get(this.posAcc - 1), this.fechaIni.get(this.posFI - 1));
        } else if (this.posUser == 0 && this.posTbl == 0 && this.posAcc > 0 && this.posFI > 0 && this.posFF > 0) {
            this.historial = this.HUBD.cargarHistorialAccionEntreFechas(this.acciones.get(this.posAcc - 1), this.fechaIni.get(this.posFI - 1), this.fechaFin.get(this.posFF - 1));
        } else if (this.posUser == 0 && this.posTbl == 0 && this.posAcc == 0 && this.posFI > 0 && this.posFF == 0) {
            this.historial = this.HUBD.cargarHistorialFecha(this.fechaIni.get(this.posFI - 1));
        } else if (this.posUser == 0 && this.posTbl == 0 && this.posAcc == 0 && this.posFI > 0 && this.posFF > 0) {
            this.historial = this.HUBD.cargarHistorialEntreFechas(this.fechaIni.get(this.posFI - 1), this.fechaFin.get(this.posFF - 1));
        } else {
            this.cargarHistorialHoy();
        }
        this.sql = this.HUBD.getSql();
        this.llenarTbl(this.historial);
    }

    private void llenarTbl(ArrayList<HistorialUsuarioMD> historial) {
        this.mdTbl.setRowCount(0);
        if (!historial.isEmpty()) {
            historial.forEach(h -> {
                Object[] v = new Object[]{h.getUsername(), h.getNombreTbl(), h.getTipoAccion(), h.getPkTbl(), h.getFechaAccion()};
                this.mdTbl.addRow(v);
            });
            this.vtnH.getLblResultados().setText(historial.size() + " Resultados obtenidos.");
        }
        this.vtnH.getLblResultados().setText(historial.size() + " Resultados obtenidos.");
    }

    private void llamaReporteHistorialUser() {
        String path = "./src/vista/reportes/repHistorialUser.jasper";
        try {
            HashMap<String, String> parametro = new HashMap<String, String>();
            parametro.put("consulta", this.sql);
            JasperReport jr = (JasperReport)JRLoader.loadObjectFromFile((String)path);
            CON.mostrarReporte(jr, parametro, "Reporte de Hisotorial Usuario");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(this.vtnH, "Error: " + ex.getMessage());
        }
    }

    private void InitPermisos() {
        this.vtnH.getBtnReporte().getAccessibleContext().setAccessibleName("Historial-Usuarios-Reporte");
        CONS.activarBtns(this.vtnH.getBtnReporte());
    }
}

