/*
 * Decompiled with CFR 0.152.
 */
package controlador.usuario.Roles.forms;

import controlador.Libraries.Effects;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.usuario.RolBD;
import modelo.usuario.RolesDelUsuarioBD;
import modelo.usuario.UsuarioBD;
import modelo.usuario.UsuarioMD;
import vista.principal.VtnPrincipal;
import vista.usuario.FrmAsignarRoles;

public class FrmAsignarRolCTR {
    private final UsuarioBD USUARIO_CONN = UsuarioBD.single();
    private final VtnPrincipal desktop;
    private final FrmAsignarRoles vista;
    private final RolesDelUsuarioBD modelo;
    private final UsuarioMD usuario;
    private final String Funcion;
    private List<RolBD> rolesDisponibles;
    private List<RolBD> rolesDados;
    private List<RolesDelUsuarioBD> listaBorrar;
    private DefaultTableModel tablaDisponibles;
    private DefaultTableModel tablaDados;
    private final RolBD rolBD = new RolBD();

    public FrmAsignarRolCTR(VtnPrincipal desktop, FrmAsignarRoles vista, RolesDelUsuarioBD modelo2, UsuarioMD usuario, String Funcion) {
        this.desktop = desktop;
        this.vista = vista;
        this.modelo = modelo2;
        this.usuario = usuario;
        this.Funcion = Funcion;
    }

    public void Init() {
        this.rolesDisponibles = this.rolBD.selectAll();
        this.rolesDados = new ArrayList<RolBD>();
        this.tablaDisponibles = (DefaultTableModel)this.vista.getTabRolesDisp().getModel();
        this.tablaDados = (DefaultTableModel)this.vista.getTabRolesDad().getModel();
        this.InitEventos();
        this.InitFuncion();
        this.vista.getLblUsuario().setText(this.usuario.getUsername());
        try {
            Effects.centerFrame(this.vista, this.desktop.getDpnlPrincipal());
            this.desktop.getDpnlPrincipal().add(this.vista);
            this.vista.show();
            this.vista.setSelected(true);
        }
        catch (PropertyVetoException ex) {
            Logger.getLogger(FrmAsignarRolCTR.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void InitEventos() {
        this.vista.getBtnDarTodos().addActionListener(e -> this.btnDarTodos(e));
        this.vista.getBtnQuitarTodos().addActionListener(e -> this.btnQuitarTodos(e));
        this.vista.getBtnDarUno().addActionListener(e -> this.btnDarDarUno(e));
        this.vista.getBtnQuitarUno().addActionListener(e -> this.btnQuitarUno(e));
        this.vista.getBtnGuardar().addActionListener(e -> this.btnGuardar(e));
        this.vista.getBtnCancelar().addActionListener(e -> this.btnCancelar(e));
        this.vista.getBtnReset().addActionListener(e -> this.btnReset(e));
    }

    private void InitFuncion() {
        switch (this.Funcion) {
            case "Asignar": {
                this.activarBtns(true);
                this.setRolesEnListas();
                this.cargarTabla(this.rolesDados, this.tablaDados);
                this.cargarTabla(this.rolesDisponibles, this.tablaDisponibles);
                break;
            }
            case "Asignar-Roles-Usuario": {
                this.cargarTabla(this.rolesDisponibles, this.tablaDisponibles);
                this.activarBtns(true);
                break;
            }
            case "Consultar": {
                this.setRolesEnListas();
                this.cargarTabla(this.rolesDados, this.tablaDados);
                this.cargarTabla(this.rolesDisponibles, this.tablaDisponibles);
                this.activarBtns(false);
                break;
            }
        }
    }

    private void setRolesEnListas() {
        this.rolesDados = this.rolBD.SelectWhereUSUARIOusername(this.usuario.getUsername());
        this.validacion();
        ArrayList<RolBD> listaTemporal = new ArrayList<RolBD>(this.rolesDisponibles);
        listaTemporal.forEach(rolMD -> this.rolesDados.stream().filter(rolesDado -> rolMD.getNombre().toLowerCase().equals(rolesDado.getNombre().toLowerCase())).forEachOrdered(_item -> this.rolesDisponibles.remove(rolMD)));
    }

    private void activarBtns(boolean estado) {
        this.vista.getBtnDarTodos().setEnabled(estado);
        this.vista.getBtnDarUno().setEnabled(estado);
        this.vista.getBtnQuitarTodos().setEnabled(estado);
        this.vista.getBtnQuitarUno().setEnabled(estado);
        this.vista.getBtnReset().setEnabled(estado);
    }

    private void cargarTabla(List<RolBD> lista, DefaultTableModel tabla) {
        tabla.setRowCount(0);
        lista.stream().forEach(obj -> this.agregarFila((RolBD)obj, tabla));
    }

    private void agregarFila(RolBD obj, DefaultTableModel tabla) {
        tabla.addRow(new Object[]{obj.getNombre()});
    }

    private void moverTodos(List<RolBD> listaAgregar, List<RolBD> listaQuitar, DefaultTableModel tablaAgregar, DefaultTableModel tablaQuitar) {
        ArrayList<RolBD> listaTemporal = new ArrayList<RolBD>(listaQuitar);
        listaTemporal.stream().forEach(obj -> {
            listaAgregar.add((RolBD)obj);
            listaQuitar.remove(obj);
        });
        listaTemporal = null;
        tablaQuitar.setRowCount(0);
        this.cargarTabla(listaAgregar, tablaAgregar);
        this.vista.getTxtBuscar().setText("");
        this.vista.getTxtBuscarDados().setText("");
    }

    private void moverUno(String permiso, List<RolBD> listaAgregar, List<RolBD> listaQuitar, DefaultTableModel tablaAgregar, DefaultTableModel tablaQuitar, boolean isArray) {
        ArrayList<RolBD> listaTemporal = new ArrayList<RolBD>(listaQuitar);
        listaTemporal.stream().filter(item -> item.getNombre().equals(permiso)).collect(Collectors.toList()).forEach(obj -> {
            this.agregarFila((RolBD)obj, tablaAgregar);
            listaAgregar.add((RolBD)obj);
            listaQuitar.remove(obj);
        });
        listaTemporal = null;
        if (!isArray) {
            this.cargarTabla(listaAgregar, tablaAgregar);
            this.cargarTabla(listaQuitar, tablaQuitar);
        }
        this.vista.getTxtBuscar().setText("");
        this.vista.getTxtBuscarDados().setText("");
    }

    private void validacion() {
        if (this.rolesDados.size() > 0) {
            this.vista.getBtnGuardar().setEnabled(true);
        } else {
            this.vista.getBtnGuardar().setEnabled(false);
        }
    }

    private void guardarUsuario() {
        Map<String, Object> context = this.USUARIO_CONN.insertar(this.usuario);
        if (((Boolean)context.get("value")).booleanValue()) {
            JOptionPane.showMessageDialog(this.vista, "SE HA GUARDADO AL USUARIO \n" + this.usuario.getUsername());
        } else {
            JOptionPane.showMessageDialog(this.vista, context.get("error"));
        }
    }

    private void EditarRoles() {
        this.listaBorrar = new ArrayList<RolesDelUsuarioBD>();
        ArrayList<RolBD> listaTemporal = new ArrayList<RolBD>(this.rolBD.selectAll());
        listaTemporal.stream().forEach(obj -> this.listaBorrar.add(new RolesDelUsuarioBD(0, obj.getId(), this.usuario.getUsername())));
        this.listaBorrar.stream().forEach(obj -> obj.eliminarWhere(obj.getIdRol(), this.usuario.getUsername()));
        this.rolesDados.stream().forEach(obj -> {
            this.modelo.setUsername(this.usuario.getUsername());
            this.modelo.setIdRol(obj.getId());
            this.modelo.insertar();
        });
        this.vista.dispose();
    }

    private void btnDarTodos(ActionEvent e) {
        this.moverTodos(this.rolesDados, this.rolesDisponibles, this.tablaDados, this.tablaDisponibles);
        this.validacion();
    }

    private void btnQuitarTodos(ActionEvent e) {
        this.moverTodos(this.rolesDisponibles, this.rolesDados, this.tablaDisponibles, this.tablaDados);
        this.validacion();
    }

    private void btnDarDarUno(ActionEvent e) {
        int[] filas = this.vista.getTabRolesDisp().getSelectedRows();
        if (filas.length > 0) {
            for (int g : filas) {
                String rol = (String)this.vista.getTabRolesDisp().getValueAt(g, 0);
                this.moverUno(rol, this.rolesDados, this.rolesDisponibles, this.tablaDados, this.tablaDisponibles, true);
            }
            this.cargarTabla(this.rolesDados, this.tablaDados);
            this.cargarTabla(this.rolesDisponibles, this.tablaDisponibles);
        } else if (filas.length == 0 && this.tablaDisponibles.getDataVector().size() > 0) {
            String rol = (String)this.vista.getTabRolesDisp().getValueAt(0, 0);
            this.moverUno(rol, this.rolesDados, this.rolesDisponibles, this.tablaDados, this.tablaDisponibles, false);
        }
        this.validacion();
    }

    private void btnQuitarUno(ActionEvent e) {
        int[] filas = this.vista.getTabRolesDad().getSelectedRows();
        if (filas.length > 0) {
            for (int g : filas) {
                String rol = (String)this.vista.getTabRolesDad().getValueAt(g, 0);
                this.moverUno(rol, this.rolesDisponibles, this.rolesDados, this.tablaDisponibles, this.tablaDados, true);
            }
            this.cargarTabla(this.rolesDados, this.tablaDados);
            this.cargarTabla(this.rolesDisponibles, this.tablaDisponibles);
        } else if (filas.length == 0 && this.tablaDados.getDataVector().size() > 0) {
            String rol = (String)this.vista.getTabRolesDad().getValueAt(0, 0);
            this.moverUno(rol, this.rolesDisponibles, this.rolesDados, this.tablaDisponibles, this.tablaDados, false);
        }
        this.validacion();
    }

    private void btnGuardar(ActionEvent e) {
        if (this.Funcion.equals("Asignar-Roles-Usuario")) {
            this.guardarUsuario();
            this.EditarRoles();
        } else if (this.Funcion.equals("Asignar")) {
            this.EditarRoles();
        }
    }

    private void btnCancelar(ActionEvent e) {
        this.vista.dispose();
    }

    private void btnReset(ActionEvent e) {
        this.moverTodos(this.rolesDisponibles, this.rolesDados, this.tablaDisponibles, this.tablaDados);
        this.validacion();
    }
}

