/*
 * Decompiled with CFR 0.152.
 */
package controlador.usuario.Roles;

import controlador.Libraries.Effects;
import controlador.accesos.FrmAccesosAddCTR;
import controlador.principal.VtnPrincipalCTR;
import controlador.usuario.Roles.forms.FrmRolAdd;
import controlador.usuario.Roles.forms.FrmRolEdit;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.usuario.RolBD;
import modelo.usuario.RolMD;
import utils.CONS;
import vista.usuario.VtnRol;

public class VtnRolCTR {
    private final VtnPrincipalCTR desktop;
    private final VtnRol vista;
    private final RolBD modelo;
    private List<RolBD> listaRoles;
    private static DefaultTableModel tabla;
    private boolean cargarTabla = true;

    public VtnRolCTR(VtnPrincipalCTR desktop) {
        this.desktop = desktop;
        this.vista = new VtnRol();
        this.modelo = new RolBD();
    }

    public VtnRol getVista() {
        return this.vista;
    }

    public void Init() {
        Effects.addInDesktopPane(this.vista, this.desktop.getVtnPrin().getDpnlPrincipal());
        this.vista.setTitle("Lista de Roles");
        tabla = (DefaultTableModel)this.vista.getTabRoles().getModel();
        this.InitEventos();
        this.InitPermisos();
        this.cargarTabla();
    }

    private void InitEventos() {
        this.vista.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VtnRolCTR.this.cargarTablaFilter(VtnRolCTR.this.vista.getTxtBuscar().getText());
            }
        });
        this.vista.getBtnEditarPermisos().addActionListener(e -> this.btnEditarPermisos(e));
        this.vista.getBtnIngresar().addActionListener(e -> new FrmRolAdd(this.desktop, this).Init());
        this.vista.getBtnEditar().addActionListener(e -> this.btnEditar(e));
    }

    private void InitPermisos() {
        this.vista.getBtnIngresar().getAccessibleContext().setAccessibleName("Roles-Usuarios-Ingresar");
        this.vista.getBtnActualizar().getAccessibleContext().setAccessibleName("Roles-Usuarios-Actualizar");
        this.vista.getBtnEditar().getAccessibleContext().setAccessibleName("Roles-Usuarios-Editar");
        this.vista.getBtnVerPermisos().getAccessibleContext().setAccessibleName("Roles-Usuarios-Ver Permisos");
        this.vista.getBtnEliminar().getAccessibleContext().setAccessibleName("Roles-Usuarios-Eliminar");
        this.vista.getBtnEditarPermisos().getAccessibleContext().setAccessibleName("Roles-Usuarios-Editar Permisos");
        CONS.activarBtns(this.vista.getBtnIngresar(), this.vista.getBtnActualizar(), this.vista.getBtnEditar(), this.vista.getBtnVerPermisos(), this.vista.getBtnEliminar(), this.vista.getBtnEditarPermisos());
    }

    public void cargarTabla() {
        tabla.setRowCount(0);
        if (this.cargarTabla) {
            tabla.setRowCount(0);
            this.vista.getTxtBuscar().setEnabled(false);
            Effects.setLoadCursor(this.vista);
            this.cargarTabla = false;
            this.listaRoles = this.modelo.selectAll();
            this.listaRoles.stream().forEach(this.agregarFilas());
            this.cargarTabla = true;
            Effects.setDefaultCursor(this.vista);
            this.vista.getTxtBuscar().setEnabled(true);
        } else {
            JOptionPane.showMessageDialog(this.vista, "YA HAY UNA CARGA PENDIENTE!!");
        }
    }

    private Consumer<RolMD> agregarFilas() {
        return obj -> {
            tabla.addRow(new Object[]{tabla.getDataVector().size() + 1, obj.getId(), obj.getNombre()});
            this.vista.getLblResultados().setText(tabla.getDataVector().size() + " Resultados");
        };
    }

    private void cargarTablaFilter(String Aguja) {
        tabla.setRowCount(0);
        this.listaRoles.stream().filter(item -> item.getNombre().toLowerCase().contains(Aguja.toLowerCase())).sorted((item1, item2) -> item1.getNombre().compareTo(item2.getNombre())).collect(Collectors.toList()).forEach(this.agregarFilas());
    }

    private List<RolBD> getSeleccionados() {
        ArrayList<RolBD> lista = new ArrayList<RolBD>();
        int[] rows = this.vista.getTabRoles().getSelectedRows();
        IntStream.of(rows).forEach(i -> {
            int id = (Integer)this.vista.getTabRoles().getValueAt(i, 1);
            lista.add(this.listaRoles.stream().filter(item -> item.getId() == id).findFirst().get());
        });
        return lista;
    }

    private void btnEditarPermisos(ActionEvent e) {
        List<RolBD> listaSeleccionados = this.getSeleccionados();
        if (!listaSeleccionados.isEmpty()) {
            listaSeleccionados.forEach(obj -> {
                FrmAccesosAddCTR form = new FrmAccesosAddCTR(this.desktop);
                form.setRol((RolBD)obj);
                form.Init();
            });
        } else {
            Effects.setTextInLabel(this.vista.getLblEstado(), "SELECCIONE UN ROL!!", CONS.ERROR_COLOR, 2);
        }
    }

    private void btnEditar(ActionEvent e) {
        List<RolBD> listaSeleccionados = this.getSeleccionados();
        if (!listaSeleccionados.isEmpty()) {
            listaSeleccionados.forEach(obj -> {
                FrmRolEdit form = new FrmRolEdit(this.desktop, this);
                form.setModelo((RolBD)obj);
                form.Init();
            });
        } else {
            Effects.setTextInLabel(this.vista.getLblEstado(), "SELECCIONE UN ROL!!", CONS.ERROR_COLOR, 2);
        }
    }
}

