/*
 * Decompiled with CFR 0.152.
 */
package controlador.ube;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.curso.CursoBD;
import modelo.jornada.JornadaBD;
import modelo.jornada.JornadaMD;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import vista.ube.VtnReporteNumAlumno;

public class VtnReporteNumAlumnoCTR
extends DCTR {
    private final VtnReporteNumAlumno vtn;
    private ArrayList<CarreraMD> carreras;
    private ArrayList<PeriodoLectivoMD> periodos;
    private ArrayList<Integer> ciclos;
    private List<JornadaMD> jornadas;

    public VtnReporteNumAlumnoCTR(VtnPrincipalCTR ctrPrin, VtnReporteNumAlumno vtn) {
        super(ctrPrin);
        this.vtn = vtn;
    }

    public void iniciar() {
        this.inicarCmbs();
        this.ctrPrin.agregarVtn(this.vtn);
        this.vtn.getBtnPorCarrera().addActionListener(e -> this.reportePorCarrera());
        this.vtn.getBtnPorJornada().addActionListener(e -> this.reporteCarreraJornada());
        this.vtn.getBtnPorPeriodo().addActionListener(e -> this.reportePeriodo());
    }

    private void inicarCmbs() {
        this.inicarCmbCarrera();
        this.iniciarCmbPeriodo();
        this.iniciarCmbJornada();
        this.iniciarCmbCiclo();
    }

    private void inicarCmbCarrera() {
        CarreraBD CBD = CarreraBD.single();
        this.carreras = CBD.cargarCarrerasCmb();
        this.iniciarCmb(this.vtn.getCmbCarrera());
        this.carreras.forEach(c -> this.vtn.getCmbCarrera().addItem(c.getCodigo()));
        this.vtn.getCmbCarrera().addActionListener(e -> this.clickCarrera());
    }

    private void clickCarrera() {
        int sel = this.vtn.getCmbCarrera().getSelectedIndex();
        PeriodoLectivoBD PBD = PeriodoLectivoBD.single();
        if (sel > 0) {
            this.periodos = (ArrayList)PBD.llenarPeriodosxCarreras(this.carreras.get(sel - 1).getId());
            this.llenarCmbPeriodo(this.periodos);
        }
    }

    private void clickPeriodo() {
        int sel = this.vtn.getCmbPeriodo().getSelectedIndex();
        if (sel > 0) {
            CursoBD MBD = CursoBD.single();
            this.ciclos = MBD.cargarCiclosPorPeriodo(this.periodos.get(sel - 1).getCarrera().getId());
            this.llenarCmbCiclos(this.ciclos);
        }
    }

    private void llenarCmbCiclos(ArrayList<Integer> ciclos) {
        this.iniciarCmb(this.vtn.getCmbCiclo());
        ciclos.forEach(c -> this.vtn.getCmbCiclo().addItem(c + ""));
    }

    private void iniciarCmbPeriodo() {
        this.iniciarCmb(this.vtn.getCmbPeriodo());
        this.vtn.getCmbCiclo().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VtnReporteNumAlumnoCTR.this.clickPeriodo();
            }
        });
    }

    private void iniciarCmbCiclo() {
        this.iniciarCmb(this.vtn.getCmbCiclo());
    }

    private void iniciarCmbJornada() {
        JornadaBD JBD = JornadaBD.single();
        this.jornadas = JBD.cargarJornadas();
        if (this.jornadas != null) {
            this.iniciarCmb(this.vtn.getCmbJornada());
            this.jornadas.forEach(j -> this.vtn.getCmbJornada().addItem(j.getNombre()));
        }
    }

    private void llenarCmbPeriodo(ArrayList<PeriodoLectivoMD> periodos) {
        this.iniciarCmb(this.vtn.getCmbPeriodo());
        periodos.forEach(p -> this.vtn.getCmbPeriodo().addItem(p.getNombre()));
    }

    private void iniciarCmb(JComboBox cmb) {
        cmb.removeAllItems();
        cmb.addItem("Seleccione");
    }

    private void reportePorCarrera() {
        int posCarrera = this.vtn.getCmbCarrera().getSelectedIndex();
        if (posCarrera > 0) {
            try {
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/ube/UBE/UBE-principal.jasper"));
                HashMap<String, Integer> parametro = new HashMap<String, Integer>();
                parametro.put("id_carrera", this.carreras.get(posCarrera - 1).getId());
                CON.mostrarReporte(jr, parametro, "N\u00famero de alumnos por carrera");
            }
            catch (JRException ex) {
                System.out.println("Error reporte: " + ex.getMessage());
            }
        } else {
            JOptionPane.showMessageDialog(this.vtn, "Debe seleccionar una carrera");
        }
    }

    private void reporteCarreraJornada() {
        int posCarrera = this.vtn.getCmbCarrera().getSelectedIndex();
        int posJornada = this.vtn.getCmbJornada().getSelectedIndex();
        if (posCarrera > 0 && posJornada > 0) {
            try {
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/ube/UBE/alumnos_por_jornada.jasper"));
                HashMap<String, Integer> parametro = new HashMap<String, Integer>();
                parametro.put("id_carrera", this.carreras.get(posCarrera - 1).getId());
                parametro.put("id_jornada", this.jornadas.get(posJornada - 1).getId());
                CON.mostrarReporte(jr, parametro, "N\u00famero de alumnos por jornada");
            }
            catch (JRException ex) {
                System.out.println("Error con el reporte por carrera y jornada. " + ex.getMessage());
            }
        } else {
            JOptionPane.showMessageDialog(this.vtn, "Debe seleccionar una carrera y una jornada.");
        }
    }

    private void reportePeriodo() {
        int posPeriodo = this.vtn.getCmbPeriodo().getSelectedIndex();
        if (posPeriodo > 0) {
            try {
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/ube/UBE/num_alumnos_periodo.jasper"));
                HashMap<String, Integer> parametro = new HashMap<String, Integer>();
                parametro.put("id_periodo", this.periodos.get(posPeriodo - 1).getID());
                CON.mostrarReporte(jr, parametro, "N\u00famero de alumnos por jornada");
            }
            catch (JRException ex) {
                System.out.println("Error con el reporte por carrera y jornada. " + ex.getMessage());
            }
        } else {
            JOptionPane.showMessageDialog(this.vtn, "Debe seleccionar un periodo.");
        }
    }
}

