/*
 * Decompiled with CFR 0.152.
 */
package controlador.ube;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.swing.table.DefaultTableModel;
import modelo.reporte.FichasBD;
import utils.ToExcel;
import vista.ube.VtnAlumnosSinResponderFS;

public class VtnAlumnosSinResponderFSCTR
extends DCTR {
    private DefaultTableModel mdTbl;
    private final VtnAlumnosSinResponderFS VTN = new VtnAlumnosSinResponderFS();
    private final FichasBD FBD = FichasBD.single();
    private List<List<String>> fichas;
    private List<List<String>> todasFichas;
    private String periodosCmb = "";

    public VtnAlumnosSinResponderFSCTR(VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
    }

    public void iniciar() {
        this.iniciarTbl();
        this.cargarDatos();
        this.clickCmbPeriodo();
        this.VTN.getBtnExportarExcel().addActionListener(e -> this.exportarExcel());
        this.ctrPrin.agregarVtn(this.VTN);
        this.listenerTxtBuscarLocal(this.VTN.getTxtBuscar(), this.VTN.getBtnBuscar(), this.buscarFun());
    }

    private void clickCmbPeriodo() {
        this.VTN.getCmbPeriodo().addActionListener(e -> {
            if (!this.VTN.getCmbPeriodo().getSelectedItem().toString().equals("Seleccione")) {
                this.buscar(this.VTN.getCmbPeriodo().getSelectedItem().toString());
            }
        });
    }

    private Function<String, Void> buscarFun() {
        return t -> {
            this.buscar(t.toUpperCase().trim());
            return null;
        };
    }

    private void buscar(String aguja) {
        this.fichas = new ArrayList<List<String>>();
        this.todasFichas.forEach(tf -> {
            if (((String)tf.get(0)).contains(aguja) || ((String)tf.get(1)).contains(aguja) || ((String)tf.get(2)).contains(aguja) || ((String)tf.get(3)).contains(aguja)) {
                this.fichas.add((List<String>)tf);
            }
        });
        this.llenatTbl(this.fichas);
    }

    private void cargarDatos() {
        this.fichas = this.FBD.getFichasSinResponder();
        this.todasFichas = this.fichas;
        this.VTN.getCmbPeriodo().removeAllItems();
        this.VTN.getCmbPeriodo().addItem("Seleccione");
        this.llenatTbl(this.fichas);
    }

    private void llenatTbl(List<List<String>> fichas) {
        this.mdTbl.setRowCount(0);
        fichas.forEach(r -> {
            this.mdTbl.addRow(r.toArray());
            if (!this.periodosCmb.contains((CharSequence)r.get(3))) {
                this.periodosCmb = this.periodosCmb + (String)r.get(3);
                this.VTN.getCmbPeriodo().addItem((String)r.get(3));
            }
        });
        this.VTN.getLblResultados().setText(fichas.size() + " Resultados obtenidos.");
    }

    private void iniciarTbl() {
        String[] titulo = new String[]{"IDENTIFICACI\u00d3N", "ALUMNO", "CORREO", "PERIODO", "FECHA INGRESO", "FECHA ULTIMA MODIFICACION"};
        this.mdTbl = this.iniciarTbl(this.VTN.getTblAlumnos(), titulo);
    }

    private void exportarExcel() {
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("IDENTIFICACI\u00d3N");
        cols.add("ALUMNO");
        cols.add("CORREO");
        cols.add("FECHA INGRESO");
        cols.add("FECHA ULTIMA MODIFICACION");
        ToExcel excel = new ToExcel();
        excel.exportarExcel(cols, this.fichas, "NOMBRE");
    }
}

